/*
 * Decompiled with CFR 0.152.
 */
package net.a5ho9999.signalerts.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import net.a5ho9999.signalerts.SignAlerts;
import net.a5ho9999.signalerts.data.DisplayMode;
import net.a5ho9999.signalerts.handlers.SignAlertAreaManager;

public class SignAlertConfig {
    private int version = 3;
    private String displayMode = "ACTION_BAR";
    private boolean titleDisplay = true;
    private int maxAreaRadius = 100;
    private boolean allowDarkText = false;
    private boolean waxedRequired = true;
    private boolean glowingBeams = false;

    public void save() {
        try {
            File configFile = new File("config/signalerts.json");
            boolean ignored = configFile.getParentFile().mkdirs();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            FileWriter writer = new FileWriter(configFile);
            gson.toJson((Object)this, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (Exception e) {
            SignAlerts.LOGGER.info("Failed to save general config: {}", (Object)String.valueOf(e));
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public DisplayMode getDisplayMode() {
        try {
            return DisplayMode.valueOf(this.displayMode);
        }
        catch (IllegalArgumentException e) {
            return DisplayMode.ACTION_BAR;
        }
    }

    public void setDisplayMode(DisplayMode mode) {
        this.displayMode = mode.name();
    }

    public void setDisplayMode(String mode) {
        try {
            DisplayMode.valueOf(mode);
            this.displayMode = mode;
        }
        catch (IllegalArgumentException e) {
            SignAlerts.LOGGER.warn("Invalid display mode '{}', resetting to ACTION_BAR", (Object)mode);
            this.displayMode = "ACTION_BAR";
        }
    }

    public boolean isTitleDisplay() {
        return this.titleDisplay;
    }

    public void setTitleDisplay(boolean titleDisplay) {
        this.titleDisplay = titleDisplay;
    }

    public int getMaxAreaRadius() {
        return this.maxAreaRadius;
    }

    public void setMaxAreaRadius(int radius) {
        this.maxAreaRadius = Math.max(SignAlertAreaManager.getMinRadius(), Math.min(radius, SignAlertAreaManager.getHardMaxRadius()));
    }

    public boolean shouldAllowDarkText() {
        return this.allowDarkText;
    }

    public void setAllowDarkText(boolean allowDarkText) {
        this.allowDarkText = allowDarkText;
    }

    public boolean isWaxedRequired() {
        return this.waxedRequired;
    }

    public void setWaxedRequired(boolean allowDarkText) {
        this.waxedRequired = allowDarkText;
    }

    public boolean isGlowingBeamsAllowed() {
        return this.glowingBeams;
    }

    public void setGlowingBeams(boolean allowGlowBeams) {
        this.glowingBeams = allowGlowBeams;
    }

    public void checkVersion() {
        int currentVersion;
        int oldVersion = this.getVersion();
        if (oldVersion != (currentVersion = new SignAlertConfig().getVersion())) {
            this.setVersionChanges(oldVersion);
        }
    }

    private void setVersionChanges(int oldVersion) {
        if (oldVersion < 1) {
            ++oldVersion;
        }
        if (oldVersion < 2) {
            ++oldVersion;
            this.setAllowDarkText(false);
        }
        if (oldVersion < 3) {
            ++oldVersion;
            this.setWaxedRequired(true);
            this.setGlowingBeams(false);
        }
        this.setVersion(oldVersion);
        this.save();
    }

    public void validate() throws IOException {
        try {
            this.setDisplayMode(this.displayMode);
            this.setTitleDisplay(this.titleDisplay);
            this.setMaxAreaRadius(this.maxAreaRadius);
            this.setAllowDarkText(this.allowDarkText);
            this.setWaxedRequired(this.waxedRequired);
            this.setGlowingBeams(this.glowingBeams);
            this.save();
        }
        catch (Exception ex) {
            SignAlerts.LOGGER.info("Failed to validate and save config - {}", (Object)String.valueOf(ex));
            throw new IOException("Config validation failed", ex);
        }
    }
}

