/*
 * Decompiled with CFR 0.152.
 */
package net.a5ho9999.signalerts.events;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import net.a5ho9999.signalerts.SignAlerts;
import net.a5ho9999.signalerts.handlers.SignAlertAreaManager;
import net.a5ho9999.signalerts.handlers.SignAlertAreaTickHandler;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;

public class AreaSignAlertWorldEvents {
    private final SignAlertAreaTickHandler tickHandler;
    private final Map<class_3218, Set<class_1923>> scannedChunks = new HashMap<class_3218, Set<class_1923>>();
    private final Map<class_3218, CopyOnWriteArrayList<class_2338>> pendingSigns = new HashMap<class_3218, CopyOnWriteArrayList<class_2338>>();
    private final Map<class_3218, Map<class_2338, Integer>> signCheckAttempts = new HashMap<class_3218, Map<class_2338, Integer>>();
    private static final int MAX_CHECK_ATTEMPTS = 60;
    private static final int PLAYER_SCAN_RADIUS = 64;

    public AreaSignAlertWorldEvents(SignAlertAreaTickHandler tickHandler) {
        this.tickHandler = tickHandler;
    }

    public void scanWorldSpawn(class_3218 world) {
        class_2338 spawnPos = world.method_74854().method_74897();
        class_1923 spawnChunk = new class_1923(spawnPos);
        int radius = 2;
        int signCount = 0;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                class_1923 chunkPos = new class_1923(spawnChunk.field_9181 + dx, spawnChunk.field_9180 + dz);
                class_2818 chunk = world.method_14178().method_21730(chunkPos.field_9181, chunkPos.field_9180);
                if (chunk == null) continue;
                signCount += this.scanChunk(world, chunk);
            }
        }
        SignAlerts.LOGGER.info("Scanned spawn area in {} and found {} area signs", (Object)world.method_27983().method_29177(), (Object)signCount);
    }

    public void scanPlayerLoadedChunks(class_3222 player) {
        class_3218 world = player.method_51469();
        class_1923 playerChunk = player.method_31476();
        int viewDistance = world.method_8503().method_3760().method_14568();
        int signCount = 0;
        int newChunkCount = 0;
        for (int dx = -viewDistance; dx <= viewDistance; ++dx) {
            for (int dz = -viewDistance; dz <= viewDistance; ++dz) {
                class_2818 chunk;
                class_1923 chunkPos = new class_1923(playerChunk.field_9181 + dx, playerChunk.field_9180 + dz);
                if (this.hasScannedChunk(world, chunkPos) || (chunk = world.method_14178().method_21730(chunkPos.field_9181, chunkPos.field_9180)) == null) continue;
                signCount += this.scanChunk(world, chunk);
                this.markChunkScanned(world, chunkPos);
                ++newChunkCount;
            }
        }
        SignAlerts.LOGGER.info("Scanned {} new chunks for {} and found {} area signs", new Object[]{newChunkCount, player.method_5477().getString(), signCount});
    }

    public void scanAroundPlayers(class_3218 world) {
        SignAlertAreaManager manager = this.tickHandler.getOrCreateManager(world);
        for (class_3222 player : world.method_18456()) {
            class_2338 playerPos = player.method_24515();
            class_1923 playerChunk = new class_1923(playerPos);
            int chunkRadius = 5;
            for (int dx = -chunkRadius; dx <= chunkRadius; ++dx) {
                for (int dz = -chunkRadius; dz <= chunkRadius; ++dz) {
                    class_1923 chunkPos = new class_1923(playerChunk.field_9181 + dx, playerChunk.field_9180 + dz);
                    class_2818 chunk = world.method_14178().method_21730(chunkPos.field_9181, chunkPos.field_9180);
                    if (chunk == null) continue;
                    for (class_2338 pos : chunk.method_12021()) {
                        class_2586 blockEntity;
                        if (!pos.method_19771((class_2382)playerPos, 64.0) || !((blockEntity = chunk.method_8321(pos)) instanceof class_2625)) continue;
                        class_2625 signEntity = (class_2625)blockEntity;
                        class_2680 state = blockEntity.method_11010();
                        if (!state.method_26164(class_3481.field_41282) && !state.method_26164(class_3481.field_15472) && !state.method_26164(class_3481.field_15492) || SignAlerts.CONFIG.isWaxedRequired() && !signEntity.method_49855()) continue;
                        manager.checkAndRegisterSign(pos);
                    }
                }
            }
        }
    }

    public void processPendingSigns(class_3218 world) {
        CopyOnWriteArrayList<class_2338> pending = this.pendingSigns.get(world);
        if (pending == null || pending.isEmpty()) {
            return;
        }
        Map attempts = this.signCheckAttempts.computeIfAbsent(world, k -> new HashMap());
        SignAlertAreaManager manager = this.tickHandler.getOrCreateManager(world);
        for (class_2338 pos : pending) {
            class_1923 chunkPos = new class_1923(pos);
            if (!world.method_8393(chunkPos.field_9181, chunkPos.field_9180)) continue;
            class_2586 blockEntity = world.method_8321(pos);
            if (!(blockEntity instanceof class_2625)) {
                pending.remove(pos);
                attempts.remove(pos);
                continue;
            }
            class_2625 signEntity = (class_2625)blockEntity;
            if (SignAlerts.CONFIG.isWaxedRequired() && signEntity.method_49855()) {
                manager.checkAndRegisterSign(pos);
                pending.remove(pos);
                attempts.remove(pos);
                continue;
            }
            int attemptsLeft = attempts.getOrDefault(pos, 60) - 1;
            if (attemptsLeft <= 0) {
                pending.remove(pos);
                attempts.remove(pos);
                continue;
            }
            attempts.put(pos, attemptsLeft);
        }
    }

    public void queueSignCheck(class_3218 world, class_2338 pos) {
        this.pendingSigns.computeIfAbsent(world, k -> new CopyOnWriteArrayList()).add(pos.method_10062());
        this.signCheckAttempts.computeIfAbsent(world, k -> new HashMap()).put(pos.method_10062(), 60);
    }

    public void removeFromQueue(class_3218 world, class_2338 pos) {
        Map<class_2338, Integer> attempts;
        CopyOnWriteArrayList<class_2338> pending = this.pendingSigns.get(world);
        if (pending != null) {
            pending.remove(pos);
        }
        if ((attempts = this.signCheckAttempts.get(world)) != null) {
            attempts.remove(pos);
        }
    }

    private int scanChunk(class_3218 world, class_2818 chunk) {
        SignAlertAreaManager manager = this.tickHandler.getOrCreateManager(world);
        int count = 0;
        for (class_2338 pos : chunk.method_12021()) {
            class_2625 signEntity;
            class_2586 blockEntity = chunk.method_8321(pos);
            if (!(blockEntity instanceof class_2625) || !(signEntity = (class_2625)blockEntity).method_49855()) continue;
            manager.checkAndRegisterSign(pos);
            ++count;
        }
        return count;
    }

    private boolean hasScannedChunk(class_3218 world, class_1923 chunkPos) {
        Set<class_1923> scanned = this.scannedChunks.get(world);
        return scanned != null && scanned.contains(chunkPos);
    }

    private void markChunkScanned(class_3218 world, class_1923 chunkPos) {
        this.scannedChunks.computeIfAbsent(world, k -> new HashSet()).add(chunkPos);
    }
}

