/*
 * Decompiled with CFR 0.152.
 */
package net.a5ho9999.signalerts.handlers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.a5ho9999.signalerts.SignAlerts;
import net.a5ho9999.signalerts.data.DisplayMode;
import net.a5ho9999.signalerts.data.PlayerAreaState;
import net.a5ho9999.signalerts.data.SignAreaAlert;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_1767;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_5905;
import org.jetbrains.annotations.Nullable;

public class PlayerAlertAreaTracker {
    private final Map<UUID, PlayerAreaState> playerCurrentArea = new HashMap<UUID, PlayerAreaState>();
    private final Map<UUID, class_3213> playerBossBars = new HashMap<UUID, class_3213>();
    private final Map<UUID, Boolean> playerVisibility = new HashMap<UUID, Boolean>();

    public void updatePlayerArea(class_3222 player, @Nullable SignAreaAlert newArea) {
        PlayerAreaState newState;
        String newAreaKey;
        UUID playerId = player.method_5667();
        PlayerAreaState currentState = this.playerCurrentArea.get(playerId);
        String string = newAreaKey = newArea != null ? newArea.areaName() : null;
        if (currentState == null && newAreaKey == null) {
            return;
        }
        PlayerAreaState playerAreaState = newState = newArea != null ? new PlayerAreaState(newAreaKey, newArea.displayText(), newArea.dyeColor()) : null;
        if (currentState != null && newState != null && currentState.areaKey().equals(newState.areaKey()) && !currentState.hasSameProperties(newState)) {
            if (this.isVisibleForPlayer(playerId)) {
                this.sendUpdateMessage(player, newArea);
            }
            this.playerCurrentArea.put(playerId, newState);
            return;
        }
        if (currentState != null && currentState.areaKey().equals(newAreaKey)) {
            return;
        }
        if (!this.isVisibleForPlayer(playerId)) {
            if (newAreaKey != null) {
                this.playerCurrentArea.put(playerId, new PlayerAreaState(newAreaKey, newArea.displayText(), newArea.dyeColor()));
            } else {
                this.playerCurrentArea.remove(playerId);
            }
            return;
        }
        if (currentState != null) {
            this.sendLeavingMessage(player, currentState.displayText(), currentState.dyeColor());
        }
        if (newAreaKey != null) {
            this.sendEnteringMessage(player, newArea);
            this.playerCurrentArea.put(playerId, new PlayerAreaState(newAreaKey, newArea.displayText(), newArea.dyeColor()));
        } else {
            this.playerCurrentArea.remove(playerId);
        }
    }

    public void clearPlayer(UUID playerId) {
        this.playerCurrentArea.remove(playerId);
        class_3213 bossBar = this.playerBossBars.remove(playerId);
        if (bossBar != null) {
            bossBar.method_14094();
        }
    }

    public void setDisplayMode(DisplayMode mode) {
        SignAlerts.CONFIG.setDisplayMode(mode);
        SignAlerts.CONFIG.save();
    }

    public void setTitleDisplay(boolean asMainTitle) {
        SignAlerts.CONFIG.setTitleDisplay(asMainTitle);
        SignAlerts.CONFIG.save();
    }

    public void setPlayerVisibility(UUID playerId, boolean visible) {
        if (visible) {
            this.playerVisibility.remove(playerId);
        } else {
            this.playerVisibility.put(playerId, false);
        }
    }

    public boolean isVisibleForPlayer(UUID playerId) {
        return this.playerVisibility.getOrDefault(playerId, true);
    }

    public Map<UUID, Boolean> getPlayerVisibilityMap() {
        return new HashMap<UUID, Boolean>(this.playerVisibility);
    }

    public void loadPlayerVisibility(Map<UUID, Boolean> visibility) {
        this.playerVisibility.clear();
        this.playerVisibility.putAll(visibility);
    }

    private void sendEnteringMessage(class_3222 player, SignAreaAlert areaSign) {
        class_2561 areaName = areaSign.displayText();
        class_1767 dyeColor = areaSign.dyeColor();
        class_124 colorFormatting = dyeColor != null ? this.getFormattingForDyeColor(dyeColor) : class_124.field_1054;
        class_5250 coloredAreaName = areaName.method_27661().method_27692(colorFormatting);
        switch (SignAlerts.CONFIG.getDisplayMode()) {
            case ACTION_BAR: {
                this.sendActionBarMessage(player, (class_2561)class_2561.method_43470((String)"Entering ").method_27692(class_124.field_1065).method_10852((class_2561)coloredAreaName));
                break;
            }
            case TITLE: {
                this.sendTitleMessage(player, (class_2561)class_2561.method_43470((String)"Entering ").method_27692(class_124.field_1065).method_10852((class_2561)coloredAreaName));
                break;
            }
            case BOSS_BAR: {
                this.sendBossBarMessage(player, (class_2561)coloredAreaName, true);
            }
        }
    }

    private void sendLeavingMessage(class_3222 player, class_2561 areaName, class_1767 dyeColor) {
        class_124 colorFormatting = dyeColor != null ? this.getFormattingForDyeColor(dyeColor) : class_124.field_1063;
        class_5250 coloredAreaName = areaName.method_27661().method_27692(colorFormatting);
        class_5250 title = class_2561.method_43470((String)"Leaving ").method_27692(class_124.field_1080).method_10852((class_2561)coloredAreaName);
        switch (SignAlerts.CONFIG.getDisplayMode()) {
            case ACTION_BAR: {
                this.sendActionBarMessage(player, (class_2561)title);
                break;
            }
            case TITLE: {
                this.sendTitleMessage(player, (class_2561)title);
                break;
            }
            case BOSS_BAR: {
                this.sendBossBarMessage(player, (class_2561)title, false);
            }
        }
    }

    private void sendUpdateMessage(class_3222 player, SignAreaAlert areaSign) {
        class_2561 areaName = areaSign.displayText();
        class_1767 dyeColor = areaSign.dyeColor();
        class_124 colorFormatting = dyeColor != null ? this.getFormattingForDyeColor(dyeColor) : class_124.field_1054;
        class_5250 coloredAreaName = areaName.method_27661().method_27692(colorFormatting);
        switch (SignAlerts.CONFIG.getDisplayMode()) {
            case ACTION_BAR: {
                this.sendActionBarMessage(player, (class_2561)class_2561.method_43470((String)"Now in ").method_27692(class_124.field_1075).method_10852((class_2561)coloredAreaName));
                break;
            }
            case TITLE: {
                this.sendTitleMessage(player, (class_2561)class_2561.method_43470((String)"Now in ").method_27692(class_124.field_1075).method_10852((class_2561)coloredAreaName));
                break;
            }
            case BOSS_BAR: {
                this.sendBossBarMessage(player, (class_2561)coloredAreaName, true);
            }
        }
    }

    private void sendActionBarMessage(class_3222 player, class_2561 message) {
        player.method_7353(message, true);
    }

    private void sendTitleMessage(class_3222 player, class_2561 message) {
        if (SignAlerts.CONFIG.isTitleDisplay()) {
            player.field_13987.method_14364((class_2596)new class_5904(message));
            player.field_13987.method_14364((class_2596)new class_5903((class_2561)class_2561.method_43473()));
        } else {
            player.field_13987.method_14364((class_2596)new class_5904((class_2561)class_2561.method_43473()));
            player.field_13987.method_14364((class_2596)new class_5903(message));
        }
        player.field_13987.method_14364((class_2596)new class_5905(10, 40, 10));
    }

    private void sendBossBarMessage(class_3222 player, class_2561 message, boolean entering) {
        UUID playerId = player.method_5667();
        class_3213 existingBar = this.playerBossBars.get(playerId);
        if (existingBar != null) {
            existingBar.method_14094();
            this.playerBossBars.remove(playerId);
        }
        if (entering) {
            class_1259.class_1260 color = class_1259.class_1260.field_5785;
            class_3213 bossBar = new class_3213(message, color, class_1259.class_1261.field_5795);
            bossBar.method_14088(player);
            bossBar.method_5408(1.0f);
            this.playerBossBars.put(playerId, bossBar);
        }
    }

    public void clear() {
        this.playerCurrentArea.clear();
        for (class_3213 bossBar : this.playerBossBars.values()) {
            bossBar.method_14094();
        }
        this.playerBossBars.clear();
    }

    private class_124 getFormattingForDyeColor(class_1767 dyeColor) {
        return switch (dyeColor) {
            default -> throw new MatchException(null, null);
            case class_1767.field_7952 -> class_124.field_1068;
            case class_1767.field_7946, class_1767.field_7957 -> class_124.field_1065;
            case class_1767.field_7958, class_1767.field_7954 -> class_124.field_1076;
            case class_1767.field_7951 -> class_124.field_1078;
            case class_1767.field_7947 -> class_124.field_1054;
            case class_1767.field_7961 -> class_124.field_1060;
            case class_1767.field_7967 -> class_124.field_1080;
            case class_1767.field_7955 -> class_124.field_1062;
            case class_1767.field_7945 -> class_124.field_1064;
            case class_1767.field_7966 -> class_124.field_1058;
            case class_1767.field_7942 -> class_124.field_1077;
            case class_1767.field_7964 -> class_124.field_1061;
            case class_1767.field_7944 -> {
                if (SignAlerts.CONFIG.shouldAllowDarkText()) {
                    yield class_124.field_1063;
                }
                yield class_124.field_1068;
            }
            case class_1767.field_7963 -> SignAlerts.CONFIG.shouldAllowDarkText() ? class_124.field_1074 : class_124.field_1068;
        };
    }
}

