/*
 * Decompiled with CFR 0.152.
 */
package net.a5ho9999.signalerts.handlers;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.a5ho9999.signalerts.SignAlerts;
import net.a5ho9999.signalerts.data.SignAreaAlert;
import net.a5ho9999.signalerts.handlers.SignAreaBeamManager;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_8242;
import org.jetbrains.annotations.Nullable;

public class SignAlertAreaManager {
    private static final Pattern AREA_PATTERN = Pattern.compile("^\\[Area\\s+(\\d+)\\]$", 2);
    private static final int HARD_MAX_RADIUS = 500;
    private static final int MIN_RADIUS = 1;
    private final Map<class_2338, SignAreaAlert> areaSigns = new HashMap<class_2338, SignAreaAlert>();
    private final class_3218 world;
    private final SignAreaBeamManager beamManager;

    public SignAlertAreaManager(class_3218 world) {
        this.world = world;
        this.beamManager = new SignAreaBeamManager(world);
    }

    public void tick() {
        this.beamManager.tick();
    }

    public void checkAndRegisterSign(class_2338 pos) {
        class_2586 class_25862 = this.world.method_8321(pos);
        if (!(class_25862 instanceof class_2625)) {
            return;
        }
        class_2625 signEntity = (class_2625)class_25862;
        if (SignAlerts.CONFIG.isWaxedRequired() && !signEntity.method_49855()) {
            this.unregisterSign(pos, true);
            this.unregisterSign(pos, false);
            return;
        }
        this.checkAndRegisterSide(signEntity, pos, true);
        this.checkAndRegisterSide(signEntity, pos, false);
    }

    private void checkAndRegisterSide(class_2625 signEntity, class_2338 pos, boolean front) {
        class_2338 key = this.createKey(pos, front);
        class_8242 text = signEntity.method_49843(front);
        class_2561 firstLine = text.method_49859(0, false);
        String firstLineStr = firstLine.getString().trim();
        Matcher matcher = AREA_PATTERN.matcher(firstLineStr);
        if (!matcher.matches()) {
            this.unregisterSign(pos, front);
            return;
        }
        int originalRadius = Integer.parseInt(matcher.group(1));
        int effectiveRadius = this.clampRadius(originalRadius);
        StringBuilder displayBuilder = new StringBuilder();
        for (int i = 1; i < 4; ++i) {
            String line = text.method_49859(i, false).getString().trim();
            if (line.isEmpty()) continue;
            if (!displayBuilder.isEmpty()) {
                displayBuilder.append(" ");
            }
            displayBuilder.append(line);
        }
        String displayString = displayBuilder.toString();
        if (displayString.isEmpty()) {
            displayString = "Area";
        }
        class_5250 displayText = class_2561.method_43470((String)displayString);
        String areaKey = pos.method_23854() + (front ? "_front" : "_back");
        class_1767 dyeColor = text.method_49872();
        SignAreaAlert areaSign = new SignAreaAlert(pos, areaKey, (class_2561)displayText, originalRadius, front, effectiveRadius, dyeColor);
        SignAreaAlert existing = this.areaSigns.get(key);
        if (existing != null && existing.equals(areaSign)) {
            return;
        }
        this.areaSigns.put(key, areaSign);
        boolean hasGlowInk = signEntity.method_49843(true).method_49856();
        this.beamManager.updateBeaconsForArea(areaSign, hasGlowInk);
    }

    public void notifyPlayersInArea(SignAreaAlert area) {
        this.world.method_18456().forEach(player -> {
            if (area.isInArea(player.method_24515())) {
                SignAlerts.getTickHandler().getPlayerTracker().updatePlayerArea((class_3222)player, area);
            }
        });
    }

    private int clampRadius(int radius) {
        int maxRadius = Math.min(SignAlerts.CONFIG.getMaxAreaRadius(), 500);
        return Math.max(1, Math.min(radius, maxRadius));
    }

    public void recalculateRadius() {
        for (SignAreaAlert sign : this.areaSigns.values()) {
            int newEffectiveRadius = this.clampRadius(sign.originalRadius());
            sign.updateEffectiveRadius(newEffectiveRadius);
        }
    }

    public void unregisterSign(class_2338 pos, boolean front) {
        class_2338 key = this.createKey(pos, front);
        SignAreaAlert removed = this.areaSigns.remove(key);
        if (removed != null) {
            this.beamManager.updateBeaconsForArea(removed, false);
        }
    }

    @Nullable
    public SignAreaAlert getAreaAtPosition(class_2338 pos) {
        SignAreaAlert closestArea = null;
        double closestDistance = Double.MAX_VALUE;
        for (SignAreaAlert area : this.areaSigns.values()) {
            double distance;
            if (!area.isInArea(pos) || !((distance = area.signPos().method_10262((class_2382)pos)) < closestDistance)) continue;
            closestDistance = distance;
            closestArea = area;
        }
        return closestArea;
    }

    public Collection<SignAreaAlert> getAllAreas() {
        return this.areaSigns.values();
    }

    private class_2338 createKey(class_2338 pos, boolean front) {
        return front ? pos : pos.method_10086(256);
    }

    public void clear() {
        this.beamManager.clear();
        this.areaSigns.clear();
    }

    public static int getHardMaxRadius() {
        return 500;
    }

    public static int getMinRadius() {
        return 1;
    }

    public SignAreaBeamManager getBeamManager() {
        return this.beamManager;
    }
}

