/*
 * Decompiled with CFR 0.152.
 */
package net.a5ho9999.signalerts.handlers;

import java.util.HashMap;
import java.util.Map;
import net.a5ho9999.signalerts.SignAlerts;
import net.a5ho9999.signalerts.data.SignAreaAlert;
import net.a5ho9999.signalerts.handlers.PlayerAlertAreaTracker;
import net.a5ho9999.signalerts.handlers.SignAlertAreaManager;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class SignAlertAreaTickHandler
implements ServerTickEvents.EndTick {
    private static final int CHECK_INTERVAL = 20;
    private int tickCounter = 0;
    private final Map<class_3218, SignAlertAreaManager> areaManagers = new HashMap<class_3218, SignAlertAreaManager>();
    private final PlayerAlertAreaTracker playerTracker = new PlayerAlertAreaTracker();

    public void onEndTick(MinecraftServer server) {
        ++this.tickCounter;
        if (this.tickCounter >= 20) {
            this.tickCounter = 0;
            this.checkAllPlayers(server);
        }
        if (SignAlerts.CONFIG.isGlowingBeamsAllowed()) {
            for (SignAlertAreaManager manager : this.areaManagers.values()) {
                manager.tick();
            }
        }
    }

    private void checkAllPlayers(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            class_3218 world = player.method_51469().method_8410();
            SignAlertAreaManager manager = this.getOrCreateManager(world);
            class_2338 playerPos = player.method_24515();
            SignAreaAlert currentArea = manager.getAreaAtPosition(playerPos);
            this.playerTracker.updatePlayerArea(player, currentArea);
        }
    }

    public SignAlertAreaManager getOrCreateManager(class_3218 world) {
        return this.areaManagers.computeIfAbsent(world, SignAlertAreaManager::new);
    }

    public PlayerAlertAreaTracker getPlayerTracker() {
        return this.playerTracker;
    }

    public void refreshAllAreaSigns() {
        for (SignAlertAreaManager manager : this.areaManagers.values()) {
            manager.recalculateRadius();
        }
    }

    public void cleanup() {
        this.areaManagers.values().forEach(SignAlertAreaManager::clear);
        this.areaManagers.clear();
        this.playerTracker.clear();
    }
}

