/*
 * Decompiled with CFR 0.152.
 */
package net.a5ho9999.signalerts.handlers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.a5ho9999.signalerts.data.ParticleBeamData;
import net.a5ho9999.signalerts.data.SignAreaAlert;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2675;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class SignAreaBeamManager {
    private final class_3218 world;
    private final Map<SignAreaAlert, Set<ParticleBeamData>> activeBeams = new HashMap<SignAreaAlert, Set<ParticleBeamData>>();
    private final Map<UUID, Boolean> playerBeamVisibility = new HashMap<UUID, Boolean>();
    private int tickCounter = 0;
    private static final int BEAM_RENDER_DISTANCE = 128;
    private static final double FOV_CHECK_THRESHOLD = 0.6;

    public SignAreaBeamManager(class_3218 world) {
        this.world = world;
    }

    public void setPlayerBeamVisibility(UUID playerId, boolean visible) {
        if (visible) {
            this.playerBeamVisibility.remove(playerId);
        } else {
            this.playerBeamVisibility.put(playerId, false);
        }
    }

    public boolean isBeamVisibleForPlayer(UUID playerId) {
        return this.playerBeamVisibility.getOrDefault(playerId, true);
    }

    public Map<UUID, Boolean> getPlayerBeamVisibilityMap() {
        return new HashMap<UUID, Boolean>(this.playerBeamVisibility);
    }

    public void loadPlayerBeamVisibility(Map<UUID, Boolean> visibility) {
        this.playerBeamVisibility.clear();
        this.playerBeamVisibility.putAll(visibility);
    }

    public void updateBeaconsForArea(SignAreaAlert area, boolean hasGlowInk) {
        if (!hasGlowInk) {
            this.activeBeams.remove(area);
            return;
        }
        Set<ParticleBeamData> beamData = this.calculateBeamData(area);
        this.activeBeams.put(area, beamData);
    }

    private Set<ParticleBeamData> calculateBeamData(SignAreaAlert area) {
        HashSet<ParticleBeamData> beamData = new HashSet<ParticleBeamData>();
        class_2338 signPos = area.signPos();
        int radius = area.effectiveRadius();
        int color = this.getColorFromDye(area.dyeColor());
        beamData.add(new ParticleBeamData(signPos.method_10079(class_2350.field_11043, radius), color));
        beamData.add(new ParticleBeamData(signPos.method_10079(class_2350.field_11035, radius), color));
        beamData.add(new ParticleBeamData(signPos.method_10079(class_2350.field_11034, radius), color));
        beamData.add(new ParticleBeamData(signPos.method_10079(class_2350.field_11039, radius), color));
        return beamData;
    }

    private int getColorFromDye(class_1767 dyeColor) {
        if (dyeColor == null) {
            return 0xFFFFFF;
        }
        return switch (dyeColor) {
            default -> throw new MatchException(null, null);
            case class_1767.field_7952 -> 0xF0F0F0;
            case class_1767.field_7946 -> 15759360;
            case class_1767.field_7958 -> 13061821;
            case class_1767.field_7951 -> 3847130;
            case class_1767.field_7947 -> 16701501;
            case class_1767.field_7961 -> 8439583;
            case class_1767.field_7954 -> 15961002;
            case class_1767.field_7944 -> 4673362;
            case class_1767.field_7967 -> 0x9D9D97;
            case class_1767.field_7955 -> 1481884;
            case class_1767.field_7945 -> 8991416;
            case class_1767.field_7966 -> 3949738;
            case class_1767.field_7957 -> 8606770;
            case class_1767.field_7942 -> 6192150;
            case class_1767.field_7964 -> 11546150;
            case class_1767.field_7963 -> 0x1D1D21;
        };
    }

    public void tick() {
        ++this.tickCounter;
        if (this.tickCounter % 12 != 0) {
            return;
        }
        for (Set<ParticleBeamData> beamDataSet : this.activeBeams.values()) {
            for (ParticleBeamData beamData : beamDataSet) {
                this.spawnBeamParticles(beamData.pos(), beamData.color());
            }
        }
    }

    private boolean isPositionInPlayerFOV(class_3222 player, class_243 particlePos) {
        class_243 toParticle;
        class_243 playerPos = player.method_33571();
        class_243 playerLook = player.method_5720();
        double dotProduct = playerLook.method_1026(toParticle = particlePos.method_1020(playerPos).method_1029());
        return !(dotProduct > 0.6);
    }

    private boolean isPositionBlocked(class_2338 pos) {
        return !this.world.method_8320(pos).method_26215() && this.world.method_8320(pos).method_26225();
    }

    private void spawnBeamParticles(class_2338 pos, int color) {
        int minY = this.world.method_31607();
        int maxY = this.world.method_31600();
        double centerX = (double)pos.method_10263() + 0.5;
        double centerZ = (double)pos.method_10260() + 0.5;
        class_2390 dustEffect = new class_2390(color, 1.0f);
        for (class_3222 player : this.world.method_18456()) {
            double y;
            class_243 beamCenter;
            UUID playerId = player.method_5667();
            if (!this.isBeamVisibleForPlayer(playerId) || !player.method_24515().method_19771((class_2382)pos, 128.0) || this.isPositionInPlayerFOV(player, beamCenter = new class_243(centerX, player.method_23320(), centerZ))) continue;
            for (y = (double)minY; y <= (double)maxY; y += 0.5) {
                class_2338 checkPos = class_2338.method_49637((double)centerX, (double)y, (double)centerZ);
                if (this.isPositionBlocked(checkPos)) continue;
                class_243 particlePos = new class_243(centerX, y, centerZ);
                if ((int)y % 8 == 0 && this.isPositionInPlayerFOV(player, particlePos)) continue;
                player.field_13987.method_14364((class_2596)new class_2675((class_2394)dustEffect, true, false, centerX, y, centerZ, 0.0f, 0.0f, 0.0f, 0.0f, 1));
            }
            for (y = (double)minY; y <= (double)maxY; y += 2.0) {
                for (int i = 0; i < 8; ++i) {
                    class_243 particlePos;
                    double offsetZ;
                    double particleZ;
                    double particleY = y + (double)i / 8.0 * 2.0;
                    if (particleY > (double)maxY) continue;
                    double spiralRotation = y * 0.3 + (double)this.tickCounter * 0.05;
                    double angle = (double)i / 8.0 * Math.PI * 2.0 + spiralRotation;
                    double radius = 0.25;
                    double offsetX = Math.cos(angle) * radius;
                    double particleX = centerX + offsetX;
                    class_2338 checkPos = class_2338.method_49637((double)particleX, (double)particleY, (double)(particleZ = centerZ + (offsetZ = Math.sin(angle) * radius)));
                    if (this.isPositionBlocked(checkPos) || this.isPositionInPlayerFOV(player, particlePos = new class_243(particleX, particleY, particleZ))) continue;
                    player.field_13987.method_14364((class_2596)new class_2675((class_2394)dustEffect, false, false, particleX, particleY, particleZ, 0.0f, 0.0f, 0.0f, 0.0f, 1));
                }
            }
        }
    }

    public void clear() {
        this.activeBeams.clear();
    }
}

