/*
 * Decompiled with CFR 0.152.
 */
package net.mgstudios.hand_pistons.item;

import net.mgstudios.hand_pistons.util.Identifier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class HandPiston
extends Item {
    public HandPiston() {
        super(new Item.Properties().stacksTo(1).setId(Identifier.getResourceKey("hand_piston")));
    }

    boolean canJump(Player player, BlockPos position) {
        BlockPos playerPos = player.blockPosition();
        return player.onGround() && position.getX() - playerPos.getX() <= 1 && position.getZ() - playerPos.getZ() <= 1;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext useOnContext) {
        Direction direction = useOnContext.getClickedFace().getOpposite();
        BlockPos position = useOnContext.getClickedPos();
        Player player = useOnContext.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (player.isShiftKeyDown() && direction == Direction.DOWN) {
            if (this.canJump(player, position)) {
                Vec3 deltaMovement = player.getDeltaMovement();
                useOnContext.getLevel().playSound((Entity)useOnContext.getPlayer(), (double)position.getX(), (double)position.getY(), (double)position.getZ(), SoundEvents.PISTON_EXTEND, SoundSource.BLOCKS);
                if (deltaMovement.x < 1.0 && deltaMovement.z < 1.0) {
                    player.setDeltaMovement(0.0, 1.0, 0.0);
                } else {
                    player.setDeltaMovement(deltaMovement.x(), 1.0, deltaMovement.y());
                }
            }
            return InteractionResult.CONSUME;
        }
        if (useOnContext.getHand() == InteractionHand.MAIN_HAND) {
            int X = 0;
            int Y = 0;
            int Z = 0;
            switch (direction) {
                case DOWN: {
                    Y = -1;
                    break;
                }
                case UP: {
                    Y = 1;
                    break;
                }
                case WEST: {
                    X = -1;
                    break;
                }
                case EAST: {
                    X = 1;
                    break;
                }
                case NORTH: {
                    Z = -1;
                    break;
                }
                case SOUTH: {
                    Z = 1;
                }
            }
            this.moveBlock(X, Y, Z, useOnContext);
        }
        return InteractionResult.CONSUME;
    }

    private void moveBlock(int X, int Y, int Z, UseOnContext useOnContext) {
        Level level = useOnContext.getLevel();
        BlockPos oldPosition = useOnContext.getClickedPos();
        BlockPos newPosition = BlockPos.containing((double)(oldPosition.getX() + X), (double)(oldPosition.getY() + Y), (double)(oldPosition.getZ() + Z));
        BlockState block = level.getBlockState(oldPosition);
        BlockState block1 = level.getBlockState(newPosition);
        if ((block1.isAir() || block1.getBlock() instanceof LiquidBlock) && !(block.getBlock() instanceof BedBlock) && !block.is(Blocks.CHEST)) {
            if (!block.canSurvive((LevelReader)level, newPosition)) {
                return;
            }
            level.setBlockAndUpdate(oldPosition, Blocks.AIR.defaultBlockState());
            level.setBlockAndUpdate(newPosition, block);
            level.playSound((Entity)useOnContext.getPlayer(), (double)oldPosition.getX(), (double)oldPosition.getY(), (double)oldPosition.getZ(), SoundEvents.PISTON_EXTEND, SoundSource.BLOCKS);
        }
    }
}

