/*
 * Decompiled with CFR 0.152.
 */
package net.mgstudios.hand_pistons.item;

import net.mgstudios.hand_pistons.util.Identifier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class StickyHandPiston
extends Item {
    public StickyHandPiston() {
        super(new Item.Properties().stacksTo(1).setId(Identifier.getResourceKey("sticky_hand_piston")));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext useOnContext) {
        Direction direction = useOnContext.getClickedFace().getOpposite();
        if (useOnContext.getPlayer() == null) {
            return InteractionResult.FAIL;
        }
        if (useOnContext.getHand() == InteractionHand.MAIN_HAND) {
            int X = 0;
            int Y = 0;
            int Z = 0;
            switch (direction) {
                case DOWN: {
                    Y = -1;
                    break;
                }
                case UP: {
                    Y = 1;
                    break;
                }
                case WEST: {
                    X = -1;
                    break;
                }
                case EAST: {
                    X = 1;
                    break;
                }
                case NORTH: {
                    Z = -1;
                    break;
                }
                case SOUTH: {
                    Z = 1;
                }
            }
            if (useOnContext.getPlayer().isShiftKeyDown()) {
                this.moveBlock(-X, -Y, -Z, useOnContext);
            } else {
                this.moveBlock(X, Y, Z, useOnContext);
            }
        }
        return InteractionResult.CONSUME;
    }

    private void moveBlock(int X, int Y, int Z, UseOnContext useOnContext) {
        Level level = useOnContext.getLevel();
        BlockPos oldPosition = useOnContext.getClickedPos();
        BlockPos newPosition = BlockPos.containing((double)(oldPosition.getX() + X), (double)(oldPosition.getY() + Y), (double)(oldPosition.getZ() + Z));
        BlockState block = level.getBlockState(oldPosition);
        BlockState block1 = level.getBlockState(newPosition);
        if ((block1.isAir() || block1.getBlock() instanceof LiquidBlock) && !(block.getBlock() instanceof BedBlock) && !block.is(Blocks.CHEST)) {
            if (!block.canSurvive((LevelReader)level, newPosition)) {
                return;
            }
            if (newPosition.equals((Object)useOnContext.getPlayer().blockPosition())) {
                return;
            }
            level.setBlockAndUpdate(oldPosition, Blocks.AIR.defaultBlockState());
            level.setBlockAndUpdate(newPosition, block);
            level.playSound((Entity)useOnContext.getPlayer(), (double)oldPosition.getX(), (double)oldPosition.getY(), (double)oldPosition.getZ(), SoundEvents.PISTON_EXTEND, SoundSource.BLOCKS);
        }
    }
}

