/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.maledicta.blocks;

import de.melanx.maledicta.ModConfig;
import de.melanx.maledicta.api.MaledictusAuferoEvent;
import de.melanx.maledicta.capabilities.EnergyCollector;
import de.melanx.maledicta.lightning.ColoredLightningBoltEntity;
import de.melanx.maledicta.network.ModNetwork;
import de.melanx.maledicta.registration.ModDataComponentTypes;
import de.melanx.maledicta.registration.ModEntities;
import de.melanx.maledicta.util.Util;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.lang3.tuple.Pair;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.registration.Registerable;
import org.moddingx.libx.registration.RegistrationContext;

public class MaledictusAufero
extends LightningRodBlock
implements Registerable {
    protected final ModX mod;
    private final Item item;

    public MaledictusAufero(ModX mod, BlockBehaviour.Properties properties, Item.Properties itemProperties) {
        super(properties);
        this.mod = mod;
        this.item = new BlockItem((Block)this, itemProperties);
    }

    public void onLightningStrike(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos) {
        level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
        level.updateNeighborsAt(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()), (Block)this);
        level.scheduleTick(pos, (Block)this, 5);
        level.levelEvent(3002, pos, ((Direction)state.getValue((Property)FACING)).getAxis().ordinal());
        ArrayList<ItemEntity> items = new ArrayList<ItemEntity>(level.getEntitiesOfClass(ItemEntity.class, MaledictusAufero.expandBox(new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), 3.0)).stream().filter(item -> Util.isEnchantable(item.getItem())).toList());
        HolderLookup.RegistryLookup enchantmentRegistryLookup = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        List<ItemEntity> cursedItems = items.stream().filter(item -> item.getItem().getAllEnchantments(enchantmentRegistryLookup).entrySet().stream().anyMatch(entry -> ((Holder)entry.getKey()).is(EnchantmentTags.CURSE))).toList();
        if (((MaledictusAuferoEvent)NeoForge.EVENT_BUS.post((Event)new MaledictusAuferoEvent(level, state, pos, items, cursedItems))).isCanceled()) {
            return;
        }
        if (ModConfig.onlyTransferCurses) {
            if (cursedItems.isEmpty()) {
                return;
            }
            HashSet<UUID> alreadyUsed = new HashSet<UUID>();
            HashSet<UUID> hasLightning = new HashSet<UUID>();
            while (true) {
                Optional<ItemEntity> opt2;
                ItemEntity first = null;
                ItemEntity second = null;
                Optional<ItemEntity> opt1 = items.stream().filter(item -> !alreadyUsed.contains(item.getUUID())).findAny();
                if (opt1.isPresent()) {
                    first = opt1.get();
                    alreadyUsed.add(opt1.get().getUUID());
                }
                if ((opt2 = items.stream().filter(item -> !alreadyUsed.contains(item.getUUID())).findAny()).isPresent()) {
                    second = opt2.get();
                    alreadyUsed.add(opt2.get().getUUID());
                }
                if (first == null || second == null) break;
                hasLightning.add(first.getUUID());
                hasLightning.add(second.getUUID());
                LeveledEnchantment firstCurse = this.getRandomCurse(first.getItem(), level.random, (HolderLookup.RegistryLookup<Enchantment>)enchantmentRegistryLookup);
                LeveledEnchantment secondCurse = this.getRandomCurse(second.getItem(), level.random, (HolderLookup.RegistryLookup<Enchantment>)enchantmentRegistryLookup);
                boolean enchantFirst = false;
                boolean enchantSecond = false;
                if (secondCurse != null) {
                    boolean bl = enchantFirst = first.getItem().getEnchantmentLevel(secondCurse.enchantment) == 0 && first.getItem().supportsEnchantment(secondCurse.enchantment);
                }
                if (firstCurse != null) {
                    boolean bl = enchantSecond = second.getItem().getEnchantmentLevel(firstCurse.enchantment) == 0 && second.getItem().supportsEnchantment(firstCurse.enchantment);
                }
                if (!enchantFirst && !enchantSecond) continue;
                if (enchantFirst) {
                    Util.unenchant(second.getItem(), secondCurse.enchantment);
                    first.getItem().enchant(secondCurse.enchantment, secondCurse.level);
                }
                if (enchantSecond) {
                    Util.unenchant(first.getItem(), firstCurse.enchantment);
                    second.getItem().enchant(firstCurse.enchantment, firstCurse.level);
                }
                this.summonLightning(level, first.position());
                this.summonLightning(level, second.position());
                ModNetwork.updateItemEnchantments(first);
                ModNetwork.updateItemEnchantments(second);
            }
            this.handleNegativeEnergy(level, hasLightning, items);
            return;
        }
        HashSet<UUID> hasLightning = new HashSet<UUID>();
        HashSet collectedCurses = new HashSet();
        cursedItems.forEach(item -> {
            LeveledEnchantment randomCurse = this.getRandomCurse(item.getItem(), level.random, (HolderLookup.RegistryLookup<Enchantment>)enchantmentRegistryLookup);
            if (randomCurse != null) {
                collectedCurses.add(Pair.of((Object)item.getUUID(), (Object)randomCurse));
                Util.unenchant(item.getItem(), randomCurse.enchantment);
                ModNetwork.updateItemEnchantments(item);
                hasLightning.add(item.getUUID());
                this.summonLightning(level, item.position());
            }
        });
        collectedCurses.forEach(curse -> {
            ItemEntity randomItem = (ItemEntity)items.get(level.random.nextInt(items.size()));
            if (randomItem.getUUID() != curse.getLeft() && randomItem.getItem().supportsEnchantment(((LeveledEnchantment)curse.getValue()).enchantment) && randomItem.getItem().getEnchantmentLevel(((LeveledEnchantment)curse.getValue()).enchantment) < 1) {
                randomItem.getItem().enchant(((LeveledEnchantment)curse.getValue()).enchantment, ((LeveledEnchantment)curse.getValue()).level);
                ModNetwork.updateItemEnchantments(randomItem);
            }
            items.remove(randomItem);
        });
        this.handleNegativeEnergy(level, hasLightning, items);
    }

    private LeveledEnchantment getRandomCurse(ItemStack stack, RandomSource random, HolderLookup.RegistryLookup<Enchantment> enchantmentRegistryLookup) {
        ItemEnchantments allEnchantments = stack.getAllEnchantments(enchantmentRegistryLookup);
        Object2IntOpenHashMap curses = allEnchantments.entrySet().stream().filter(entry -> ((Holder)entry.getKey()).is(EnchantmentTags.CURSE)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum, Object2IntOpenHashMap::new));
        if (curses.isEmpty()) {
            return null;
        }
        int randomIndex = random.nextInt(curses.size());
        Holder randomCurse = (Holder)curses.keySet().stream().toList().get(randomIndex);
        return new LeveledEnchantment((Holder<Enchantment>)randomCurse, curses.getInt((Object)randomCurse));
    }

    private void handleNegativeEnergy(Level level, Set<UUID> noLightning, List<ItemEntity> items) {
        if (ModConfig.NegativeEnergy.enabled) {
            for (ItemEntity item : items) {
                ItemStack stack = item.getItem();
                if (!stack.has(ModDataComponentTypes.energyCollector)) continue;
                EnergyCollector energyCollector = (EnergyCollector)stack.getOrDefault(ModDataComponentTypes.energyCollector, (Object)EnergyCollector.EMPTY);
                energyCollector.setEnergy(energyCollector.negativeEnergy().get() / 2.0);
                ModNetwork.updateItemEnchantments(item);
                if (noLightning.contains(item.getUUID())) continue;
                ColoredLightningBoltEntity lightning = (ColoredLightningBoltEntity)ModEntities.lightningBolt.create(level);
                lightning.setVisualOnly(true);
                lightning.moveTo(item.position());
                lightning.setColor(65280);
                level.addFreshEntity((Entity)lightning);
            }
        }
    }

    private void summonLightning(Level level, Vec3 pos) {
        ColoredLightningBoltEntity lightning = (ColoredLightningBoltEntity)ModEntities.lightningBolt.create(level);
        lightning.setVisualOnly(true);
        lightning.moveTo(pos);
        lightning.setColor(6882805);
        level.addFreshEntity((Entity)lightning);
    }

    public static AABB expandBox(Vec3 center, double radius) {
        return new AABB(center.x - radius, center.y - radius, center.z - radius, center.x + radius, center.y + radius, center.z + radius);
    }

    public void registerAdditional(RegistrationContext ctx, Registerable.EntryCollector builder) {
        builder.register(Registries.ITEM, (Object)this.item);
    }

    record LeveledEnchantment(Holder<Enchantment> enchantment, int level) {
    }
}

