/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.maledicta.capabilities;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.melanx.maledicta.util.Chance;
import net.minecraft.util.Mth;

public class EnergyCollector {
    public static final Codec<EnergyCollector> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Chance.CODEC.fieldOf("chance").forGetter(EnergyCollector::negativeEnergy), (App)Codec.INT.fieldOf("purification_processes").forGetter(EnergyCollector::purificationProcesses)).apply((Applicative)instance, EnergyCollector::new));
    public static final EnergyCollector EMPTY = new EnergyCollector(new Chance(0.0), 0);
    private Chance negativeEnergy;
    private int purificationProcesses;

    public EnergyCollector(Chance negativeEnergy, int purificationProcesses) {
        this.negativeEnergy = negativeEnergy;
        this.purificationProcesses = purificationProcesses;
    }

    public Chance negativeEnergy() {
        return this.negativeEnergy;
    }

    private int purificationProcesses() {
        return this.purificationProcesses;
    }

    public void addEnergy(double addition) {
        if (addition >= 0.0) {
            this.negativeEnergy.set(Mth.clamp((double)(this.negativeEnergy.get() + addition), (double)0.0, (double)100.0));
        }
    }

    public void removeEnergy(double subtraction) {
        if (subtraction >= 0.0) {
            this.negativeEnergy.set(Mth.clamp((double)(this.negativeEnergy.get() - subtraction), (double)0.0, (double)100.0));
        }
    }

    public void setEnergy(double energy) {
        this.negativeEnergy = new Chance(energy);
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

