/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.maledicta.network;

import de.melanx.maledicta.Maledicta;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import org.moddingx.libx.network.PacketHandler;

public class UpdateItemEnchantments
extends PacketHandler<Message> {
    public static final CustomPacketPayload.Type<Message> TYPE = new CustomPacketPayload.Type(Maledicta.getInstance().resource("update_item_enchantments"));

    public UpdateItemEnchantments() {
        super(TYPE, PacketFlow.CLIENTBOUND, Message.CODEC, HandlerThread.MAIN);
    }

    public void handle(Message msg, IPayloadContext ctx) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        Entity item = level.getEntity(msg.id);
        if (item instanceof ItemEntity) {
            ItemEntity entity = (ItemEntity)item;
            entity.setItem(msg.stack());
        }
    }

    public record Message(int id, ItemStack stack) implements CustomPacketPayload
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, Message> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, Message::id, (StreamCodec)ItemStack.STREAM_CODEC, Message::stack, Message::new);

        @Nonnull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

