/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.maledicta.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import net.minecraft.util.RandomSource;

public class Chance {
    public static final Codec<Chance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.optionalFieldOf("value", (Object)0.0).forGetter(Chance::get)).apply((Applicative)instance, Chance::new));
    private static final RandomSource random = RandomSource.create((long)"SpookyJam2022".hashCode());
    private double value;

    public Chance(double value) {
        if (value < 0.0 || value > 1.0) {
            throw new IllegalStateException("Chance cannot be greater than 1 or lower than 0. Yours is " + value);
        }
        this.value = value;
    }

    public boolean test() {
        return random.nextDouble() <= this.value;
    }

    public void set(double value) {
        if (value < 0.0 || value > 1.0) {
            throw new IllegalStateException("Chance cannot be greater than 1 or lower than 0. Yours is " + value);
        }
        this.value = value;
    }

    public double get() {
        return this.value;
    }

    public String toString() {
        DecimalFormat format = new DecimalFormat("#.###");
        return format.format(this.value * 100.0);
    }
}

