/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.maledicta.util;

import de.melanx.maledicta.Maledicta;
import de.melanx.maledicta.api.ApplyItemCurseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class Util {
    public static final int LIGHTNING_COLOR = 6882805;

    public static void unenchant(ItemStack stack, Holder<Enchantment> enchantment) {
        ItemEnchantments enchantments = stack.getTagEnchantments();
        if (enchantments.isEmpty()) {
            return;
        }
        EnchantmentHelper.updateEnchantments((ItemStack)stack, enchantmentMap -> enchantmentMap.removeIf(entry -> Objects.equals(entry.getKey(), enchantment.getKey())));
    }

    public static boolean isEnchantable(ItemStack stack) {
        return stack.getMaxStackSize() == 1 && stack.isDamageableItem();
    }

    public static boolean tryToApplyCurse(Player player, ItemStack stack) {
        Registry enchantments = player.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        List<Holder.Reference> possibleEnchantments = enchantments.holders().filter(enchantmentReference -> enchantmentReference.is(EnchantmentTags.CURSE) && stack.supportsEnchantment((Holder)enchantmentReference)).toList();
        if (possibleEnchantments.isEmpty()) {
            return false;
        }
        RandomSource random = RandomSource.create();
        Holder<Enchantment> enchantment = (Holder<Enchantment>)possibleEnchantments.get(random.nextInt(possibleEnchantments.size()));
        ApplyItemCurseEvent event = new ApplyItemCurseEvent(player, stack, enchantment);
        if (((ApplyItemCurseEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
            return false;
        }
        enchantment = event.getEnchantment();
        if (enchantment == null) {
            return false;
        }
        if ((event.isForced() || stack.supportsEnchantment(enchantment)) && stack.getEnchantmentLevel(enchantment) <= 0) {
            stack.enchant(enchantment, Objects.requireNonNull((Enchantment)enchantments.get(enchantment.getKey())).getMaxLevel());
            return true;
        }
        return false;
    }

    public static void mixEnchantments(ItemStack stack, RegistryAccess registryAccess) {
        RandomSource random = RandomSource.create();
        HolderLookup.RegistryLookup enchantments = registryAccess.lookupOrThrow(Registries.ENCHANTMENT);
        List<Object> allEnchantments = new ArrayList(stack.getAllEnchantments(enchantments).entrySet());
        ItemEnchantments.Mutable futureEnchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        ArrayList possibleEnchantments = new ArrayList(enchantments.listElements().toList());
        allEnchantments = allEnchantments.stream().sorted(Comparator.comparing(entry -> !((Holder)entry.getKey()).is(EnchantmentTags.CURSE))).toList();
        allEnchantments.forEach(entry -> {
            block3: {
                Holder potentialEnchantment;
                Holder enchantment = (Holder)entry.getKey();
                int level = (Integer)entry.getValue();
                if (enchantment.is(EnchantmentTags.CURSE)) {
                    futureEnchantments.set(enchantment, level);
                    possibleEnchantments.remove(enchantment);
                    return;
                }
                do {
                    if (possibleEnchantments.isEmpty()) {
                        futureEnchantments.set(enchantment, level);
                        break block3;
                    }
                    potentialEnchantment = (Holder)possibleEnchantments.get(random.nextInt(possibleEnchantments.size()));
                    possibleEnchantments.remove(potentialEnchantment);
                } while (!stack.supportsEnchantment(potentialEnchantment) || futureEnchantments.getLevel(potentialEnchantment) != 0);
                futureEnchantments.set(potentialEnchantment, potentialEnchantment.is(EnchantmentTags.CURSE) ? 1 : level);
            }
        });
        EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)futureEnchantments.toImmutable());
        if (futureEnchantments.keySet().size() != allEnchantments.size()) {
            Maledicta.getInstance().logger.warn("It seems like enchantments were deleted on {}, previous enchantments: {}", (Object)stack, allEnchantments);
        }
    }

    public static boolean hasEnchantmentInHand(LivingEntity entity, Holder<Enchantment> enchantment) {
        return entity.getItemInHand(InteractionHand.MAIN_HAND).getEnchantmentLevel(enchantment) >= 1 || entity.getItemInHand(InteractionHand.OFF_HAND).getEnchantmentLevel(enchantment) >= 1;
    }
}

