/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.models.layers;

import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.client.ClientPlatform;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.client.models.visages.PlayerLikeModel;
import net.hydra.jojomod.entity.visages.JojoNPC;
import net.hydra.jojomod.event.index.ShapeShifts;
import net.hydra.jojomod.event.powers.StandUserClient;
import net.hydra.jojomod.event.powers.TimeStop;
import net.hydra.jojomod.item.MaskItem;
import net.hydra.jojomod.networking.ModPacketHandler;
import net.hydra.jojomod.util.config.ConfigManager;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1092;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1768;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4057;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5455;
import net.minecraft.class_572;
import net.minecraft.class_8053;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Unique;

public class HumanoidLikeArmorLayer<T extends JojoNPC, M extends PlayerLikeModel<T>, A extends class_572<T>>
extends class_3887<T, M> {
    private static final Map<String, class_2960> ARMOR_LOCATION_CACHE = Maps.newHashMap();
    private final A innerModel;
    private final A outerModel;
    private final class_1059 armorTrimAtlas;
    @Unique
    public int roundabout$ArmorPhase;
    @Unique
    public boolean roundabout$ModifyEntity;
    @Unique
    @Nullable
    public class_1799 roundabout$RenderChest;
    @Unique
    @Nullable
    public class_1799 roundabout$RenderLegs;
    @Unique
    @Nullable
    public class_1799 roundabout$RenderBoots;
    @Unique
    @Nullable
    public class_1799 roundabout$RenderHead;

    public HumanoidLikeArmorLayer(class_3883<T, M> $$0, A $$1, A $$2, class_1092 $$3) {
        super($$0);
        this.innerModel = $$1;
        this.outerModel = $$2;
        this.armorTrimAtlas = $$3.method_24153(class_4722.field_42071);
    }

    public void render(class_4587 $$0, class_4597 $$1, int $$2, T $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9) {
        this.roundabout$ArmorPhase = 0;
        if (((JojoNPC)((Object)$$3)).host != null) {
            class_1792 class_17922;
            IPlayerEntity ipe = (IPlayerEntity)((JojoNPC)((Object)$$3)).host;
            if (ShapeShifts.getShiftFromByte(ipe.roundabout$getShapeShift()) == ShapeShifts.EERIE) {
                return;
            }
            StandUserClient userclient = (StandUserClient)$$3;
            boolean bl = this.roundabout$ModifyEntity = ((TimeStop)$$3.method_37908()).CanTimeStopEntity((class_1297)$$3) || ClientUtil.getScreenFreeze();
            if (this.roundabout$ModifyEntity) {
                if (userclient.roundabout$getRoundaboutRenderChest() == null) {
                    userclient.roundabout$setRoundaboutRenderChest($$3.method_6118(class_1304.field_6174).method_7972());
                }
                if (userclient.roundabout$getRoundaboutRenderLegs() == null) {
                    userclient.roundabout$setRoundaboutRenderLegs($$3.method_6118(class_1304.field_6172).method_7972());
                }
                if (userclient.roundabout$getRoundaboutRenderBoots() == null) {
                    userclient.roundabout$setRoundaboutRenderBoots($$3.method_6118(class_1304.field_6166).method_7972());
                }
                if (userclient.roundabout$getRoundaboutRenderHead() == null) {
                    userclient.roundabout$setRoundaboutRenderHead($$3.method_6118(class_1304.field_6169).method_7972());
                }
                this.roundabout$RenderChest = userclient.roundabout$getRoundaboutRenderChest();
                this.roundabout$RenderLegs = userclient.roundabout$getRoundaboutRenderLegs();
                this.roundabout$RenderBoots = userclient.roundabout$getRoundaboutRenderBoots();
                this.roundabout$RenderHead = userclient.roundabout$getRoundaboutRenderHead();
            } else {
                if (userclient.roundabout$getRoundaboutRenderChest() != null) {
                    userclient.roundabout$setRoundaboutRenderChest(null);
                }
                if (userclient.roundabout$getRoundaboutRenderLegs() != null) {
                    userclient.roundabout$setRoundaboutRenderLegs(null);
                }
                if (userclient.roundabout$getRoundaboutRenderBoots() != null) {
                    userclient.roundabout$setRoundaboutRenderBoots(null);
                }
                if (userclient.roundabout$getRoundaboutRenderHead() != null) {
                    userclient.roundabout$setRoundaboutRenderHead(null);
                }
            }
            if (!((IPlayerEntity)((JojoNPC)((Object)$$3)).host).roundabout$getMaskSlot().method_7960() && (class_17922 = ((IPlayerEntity)((JojoNPC)((Object)$$3)).host).roundabout$getMaskSlot().method_7909()) instanceof MaskItem) {
                MaskItem ME = (MaskItem)class_17922;
                if (!ME.visageData.rendersArmor()) {
                    return;
                }
            }
        } else {
            this.roundabout$ModifyEntity = false;
        }
        if (ConfigManager.getClientConfig().renderArmorOnPlayerCloneAbilities.booleanValue()) {
            this.renderArmorPiece($$0, $$1, $$3, class_1304.field_6174, $$2, this.getArmorModel(class_1304.field_6174));
            this.renderArmorPiece($$0, $$1, $$3, class_1304.field_6172, $$2, this.getArmorModel(class_1304.field_6172));
            this.renderArmorPiece($$0, $$1, $$3, class_1304.field_6166, $$2, this.getArmorModel(class_1304.field_6166));
            this.renderArmorPiece($$0, $$1, $$3, class_1304.field_6169, $$2, this.getArmorModel(class_1304.field_6169));
        }
    }

    private void renderArmorPiece(class_4587 $$0, class_4597 $$1, T entity, class_1304 slot, int $$4, A model) {
        class_1738 armorItem;
        class_1799 itemStack = this.store(entity.method_6118(slot));
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof class_1738 && (armorItem = (class_1738)class_17922).method_7685() == slot) {
            ((PlayerLikeModel)this.method_17165()).copyPropertiesTo2(model);
            this.setPartVisibility(model, slot);
            class_3879 model2 = ClientPlatform.PLATFORM_ACCESS_CLIENT.getArmorModelHook(entity, itemStack, slot, model);
            Object usethis = model;
            if (model2 != null) {
                usethis = model2;
            }
            boolean flag = this.usesInnerModel(slot);
            if (Objects.equals(ModPacketHandler.PLATFORM_ACCESS.getPlatformName(), "Forge") && armorItem instanceof class_1768) {
                int i = ((class_1768)armorItem).method_7800(itemStack);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                this.renderModel($$0, $$1, $$4, armorItem, (class_3879)usethis, flag, f, f1, f2, null, (class_1297)entity, itemStack, slot);
            } else if (armorItem instanceof class_4057) {
                class_4057 $$10 = (class_4057)armorItem;
                int $$11 = $$10.method_7800(itemStack);
                float $$12 = (float)($$11 >> 16 & 0xFF) / 255.0f;
                float $$13 = (float)($$11 >> 8 & 0xFF) / 255.0f;
                float $$14 = (float)($$11 & 0xFF) / 255.0f;
                this.renderModel($$0, $$1, $$4, armorItem, (class_3879)usethis, flag, $$12, $$13, $$14, null, (class_1297)entity, itemStack, slot);
                this.renderModel($$0, $$1, $$4, armorItem, (class_3879)usethis, flag, 1.0f, 1.0f, 1.0f, "overlay", (class_1297)entity, itemStack, slot);
            } else {
                this.renderModel($$0, $$1, $$4, armorItem, (class_3879)usethis, flag, 1.0f, 1.0f, 1.0f, null, (class_1297)entity, itemStack, slot);
            }
            class_8053.method_48428((class_5455)entity.method_37908().method_30349(), (class_1799)itemStack).ifPresent($$6x -> this.renderTrim(armorItem.method_7686(), $$0, $$1, $$4, (class_8053)$$6x, model, flag));
            if (itemStack.method_7958()) {
                this.renderGlint($$0, $$1, $$4, model);
            }
        }
    }

    public class_1799 store(class_1799 stack) {
        if (this.roundabout$ModifyEntity) {
            ++this.roundabout$ArmorPhase;
            if (this.roundabout$ArmorPhase == 1) {
                if (this.roundabout$RenderChest != null) {
                    return this.roundabout$RenderChest;
                }
            } else if (this.roundabout$ArmorPhase == 2) {
                if (this.roundabout$RenderLegs != null) {
                    return this.roundabout$RenderLegs;
                }
            } else if (this.roundabout$ArmorPhase == 3) {
                if (this.roundabout$RenderBoots != null) {
                    return this.roundabout$RenderBoots;
                }
            } else if (this.roundabout$RenderHead != null) {
                return this.roundabout$RenderHead;
            }
            return stack;
        }
        return stack;
    }

    protected void setPartVisibility(A $$0, class_1304 $$1) {
        $$0.method_2805(false);
        switch ($$1) {
            case field_6169: {
                ((class_572)$$0).field_3398.field_3665 = true;
                ((class_572)$$0).field_3394.field_3665 = true;
                break;
            }
            case field_6174: {
                ((class_572)$$0).field_3391.field_3665 = true;
                ((class_572)$$0).field_3401.field_3665 = true;
                ((class_572)$$0).field_27433.field_3665 = true;
                break;
            }
            case field_6172: {
                ((class_572)$$0).field_3391.field_3665 = true;
                ((class_572)$$0).field_3392.field_3665 = true;
                ((class_572)$$0).field_3397.field_3665 = true;
                break;
            }
            case field_6166: {
                ((class_572)$$0).field_3392.field_3665 = true;
                ((class_572)$$0).field_3397.field_3665 = true;
            }
        }
    }

    private void renderModel(class_4587 $$0, class_4597 $$1, int $$2, class_1738 $$3, class_3879 $$4, boolean $$5, float $$6, float $$7, float $$8, @javax.annotation.Nullable String $$9, class_1297 ent, class_1799 stack, class_1304 slot) {
        if (Objects.equals(ModPacketHandler.PLATFORM_ACCESS.getPlatformName(), "Forge")) {
            class_2960 rl = this.getArmorResource(ent, stack, slot, $$9);
            if (rl != null) {
                this.renderModel($$0, $$1, $$2, $$3, $$4, $$5, $$6, $$7, $$8, rl);
            } else {
                class_4588 $$10 = $$1.getBuffer(class_1921.method_25448((class_2960)this.getArmorLocation($$3, $$5, $$9)));
                $$4.method_2828($$0, $$10, $$2, class_4608.field_21444, $$6, $$7, $$8, 1.0f);
            }
        } else {
            class_4588 $$10 = $$1.getBuffer(class_1921.method_25448((class_2960)this.getArmorLocation($$3, $$5, $$9)));
            $$4.method_2828($$0, $$10, $$2, class_4608.field_21444, $$6, $$7, $$8, 1.0f);
        }
    }

    private void renderModel(class_4587 p_289664_, class_4597 p_289689_, int p_289681_, class_1738 p_289650_, class_3879 p_289658_, boolean p_289668_, float p_289678_, float p_289674_, float p_289693_, class_2960 armorResource) {
        class_4588 vertexconsumer = p_289689_.getBuffer(class_1921.method_25448((class_2960)armorResource));
        p_289658_.method_2828(p_289664_, vertexconsumer, p_289681_, class_4608.field_21444, p_289678_, p_289674_, p_289693_, 1.0f);
    }

    private void renderTrim(class_1741 $$0, class_4587 $$1, class_4597 $$2, int $$3, class_8053 $$4, A $$5, boolean $$6) {
        class_1058 $$7 = this.armorTrimAtlas.method_4608($$6 ? $$4.method_48434($$0) : $$4.method_48436($$0));
        class_4588 $$8 = $$7.method_24108($$2.getBuffer(class_4722.method_48480()));
        $$5.method_2828($$1, $$8, $$3, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderGlint(class_4587 $$0, class_4597 $$1, int $$2, A $$3) {
        $$3.method_2828($$0, $$1.getBuffer(class_1921.method_27949()), $$2, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private A getArmorModel(class_1304 $$0) {
        return this.usesInnerModel($$0) ? this.innerModel : this.outerModel;
    }

    private boolean usesInnerModel(class_1304 $$0) {
        return $$0 == class_1304.field_6172;
    }

    private class_2960 getArmorLocation(class_1738 $$0, boolean $$1, @javax.annotation.Nullable String $$2) {
        String $$3 = "textures/models/armor/" + $$0.method_7686().method_7694() + "_layer_" + ($$1 ? 2 : 1) + (String)($$2 == null ? "" : "_" + $$2) + ".png";
        return ARMOR_LOCATION_CACHE.computeIfAbsent($$3, class_2960::new);
    }

    public class_2960 getArmorResource(class_1297 entity, class_1799 stack, class_1304 slot, @javax.annotation.Nullable String type) {
        class_1738 item = (class_1738)stack.method_7909();
        String texture = item.method_7686().method_7694();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.usesInnerModel(slot) ? 2 : 1, type == null ? "" : String.format(Locale.ROOT, "_%s", type));
        class_2960 resourcelocation = ARMOR_LOCATION_CACHE.get(s1 = ClientPlatform.PLATFORM_ACCESS_CLIENT.getArmorTexture(entity, stack, s1, slot, type));
        if (resourcelocation == null && s1 != null) {
            resourcelocation = new class_2960(s1);
            ARMOR_LOCATION_CACHE.put(s1, resourcelocation);
        }
        return resourcelocation;
    }
}

