/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.projectile;

import net.hydra.jojomod.block.FleshBlock;
import net.hydra.jojomod.block.ModBlocks;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.util.gravity.GravityAPI;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3857;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class FleshPileEntity
extends class_3857 {
    protected static final class_2940<Integer> FLESH_COUNT = class_2945.method_12791(FleshPileEntity.class, (class_2941)class_2943.field_13327);

    public FleshPileEntity(class_1299<? extends class_3857> $$0, class_1937 $$1) {
        super($$0, $$1);
    }

    protected void method_5693() {
        if (!this.field_6011.method_51696(FLESH_COUNT)) {
            super.method_5693();
            this.field_6011.method_12784(FLESH_COUNT, (Object)0);
        }
    }

    public void setFleshCount(int amount) {
        this.field_6011.method_12778(FLESH_COUNT, (Object)amount);
    }

    public int getFleshCount() {
        return (Integer)this.field_6011.method_12789(FLESH_COUNT);
    }

    public FleshPileEntity(class_1309 living, class_1937 $$1, int amount) {
        super(ModEntities.FLESH_PILE, living, $$1);
        this.setFleshCount(amount);
    }

    public FleshPileEntity(class_1937 level, double d0, double d1, double d2, int amount) {
        super(ModEntities.FLESH_PILE, d0, d1, d2, level);
        this.setFleshCount(amount);
    }

    protected class_1792 method_16942() {
        return ModBlocks.FLESH_BLOCK.method_8389();
    }

    protected void method_24920(class_3965 $$0) {
        super.method_24920($$0);
        if (!this.method_37908().field_9236) {
            ((class_3218)this.method_37908()).method_14199((class_2394)new class_2388(class_2398.field_11217, ModBlocks.FLESH_BLOCK.method_9564()), (double)this.method_23312().method_10263() + 0.5, (double)this.method_23312().method_10264() + 0.5, (double)this.method_23312().method_10260() + 0.5, 15, 0.4, 0.4, 0.25, 0.4);
            this.method_5783(class_3417.field_14737, 1.0f, 1.5f);
            this.placeFlesh($$0.method_17777(), this.getFleshCount() != 0 ? this.getFleshCount() : 4);
            this.method_31472();
        }
    }

    protected void method_7454(class_3966 $$0) {
        class_1297 entity = $$0.method_17782();
        if (entity instanceof class_1309) {
            class_1309 LE = (class_1309)entity;
            LE.method_6092(new class_1293(class_1294.field_5909, this.getFleshCount() > 10 ? 70 : 50, 1));
        }
    }

    public boolean[] isValidLocation(class_2338 pos, int offsetX, int offsetY, int offsetZ, int level) {
        class_2338 blk = new class_2338(pos.method_10263() + offsetX, pos.method_10264() + offsetY, pos.method_10260() + offsetZ);
        class_2680 check = this.method_37908().method_8320(blk);
        boolean[] info = new boolean[]{false, check.method_27852(ModBlocks.FLESH_BLOCK) && (Integer)check.method_11654((class_2769)FleshBlock.LAYERS) + level <= 4};
        if (this.method_37908().method_22347(blk)) {
            class_2338 $$8 = blk.method_10074();
            class_2680 b = this.method_37908().method_8320($$8);
            info[0] = b.method_26206((class_1922)this.method_37908(), $$8, class_2350.field_11036) || b.method_27852(ModBlocks.FLESH_BLOCK) && (Integer)b.method_11654((class_2769)FleshBlock.LAYERS) == 4;
        }
        return info;
    }

    public boolean[] checkHeights(class_2338 pos, int offsetX, int offsetZ, int level) {
        boolean[] info = new boolean[]{false, false};
        for (int i = -1; i < 3; ++i) {
            boolean[] result = this.isValidLocation(pos, offsetX, i, offsetZ, level);
            if (!result[0] && !result[1]) continue;
            info = result;
        }
        return info;
    }

    public void setGoo(class_2338 pos, int offsetX, int offsetZ, int level) {
        class_2338 blockPos = null;
        boolean replace = false;
        for (int i = -1; i < 3; ++i) {
            boolean[] result = this.isValidLocation(pos, offsetX, i, offsetZ, level);
            if (!result[0] && !result[1]) continue;
            replace = result[1];
            blockPos = new class_2338(pos.method_10263() + offsetX, pos.method_10264() + i, pos.method_10260() + offsetZ);
        }
        if (blockPos != null) {
            class_2680 n = (class_2680)ModBlocks.FLESH_BLOCK.method_9564().method_11657((class_2769)ModBlocks.FLESH_LAYER, (Comparable)Integer.valueOf(level));
            if (replace) {
                n = (class_2680)ModBlocks.FLESH_BLOCK.method_9564().method_11657((class_2769)ModBlocks.FLESH_LAYER, (Comparable)Integer.valueOf(level + (Integer)this.method_37908().method_8320(blockPos).method_11654((class_2769)FleshBlock.LAYERS)));
            }
            this.method_37908().method_8501(new class_2338(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()), n);
        }
    }

    public void placeFlesh(class_2338 pos, int amount) {
        int x;
        int[][] array = new int[][]{{0, 0, 0}, {0, 1, 0}, {0, 0, 0}};
        if (--amount > 10) {
            array = new int[][]{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 1, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}};
        }
        if (!this.method_37908().method_8320(pos.method_10084()).method_27852(class_2246.field_10124)) {
            array[array.length / 2][array.length / 2] = -1;
            ++amount;
        }
        for (int x2 = 0; x2 < array.length; ++x2) {
            for (int y = 0; y < array[0].length; ++y) {
                boolean[] result = this.checkHeights(pos, x2 - 1, y - 1, array[x2][y]);
                if (result[0] || result[1]) continue;
                array[x2][y] = -1;
            }
        }
        for (int i = 0; i < amount; ++i) {
            x = (int)(Math.random() * (double)array.length);
            int y = (int)(Math.random() * (double)array.length);
            for (int n = 0; array[x][y] == -1 && n <= 10; ++n) {
                x = (int)(Math.random() * (double)array.length);
                y = (int)(Math.random() * (double)array.length);
            }
            if (array[x][y] == -1) continue;
            int[] nArray = array[x];
            int n = y;
            nArray[n] = nArray[n] + 1;
        }
        boolean zeroSpots = true;
        for (x = 0; x < array.length; ++x) {
            for (int y = 0; y < array.length; ++y) {
                if (array[x][y] == -1) continue;
                zeroSpots = false;
                break;
            }
            if (!zeroSpots) break;
        }
        if (zeroSpots) {
            this.method_5775(new class_1799((class_1935)ModBlocks.FLESH_BLOCK, this.getFleshCount()));
            return;
        }
        for (x = 0; x < array.length; ++x) {
            for (int y = 0; y < array[0].length; ++y) {
                if (array[x][y] <= 0) continue;
                this.setGoo(pos, x - array.length / 2, y - array.length / 2, class_3532.method_15340((int)0, (int)array[x][y], (int)4));
            }
        }
    }

    public void shootWithVariance(double $$0, double $$1, double $$2, float $$3, float $$4) {
        class_243 $$5 = new class_243($$0, $$1, $$2).method_1029().method_1031(this.field_5974.method_43385(0.0, 0.13 * (double)$$4), this.field_5974.method_43385(0.0, 0.13 * (double)$$4), this.field_5974.method_43385(0.0, 0.13 * (double)$$4)).method_1021((double)$$3);
        this.method_18799($$5);
        double $$6 = $$5.method_37267();
        this.method_36456((float)(class_3532.method_15349((double)$$5.field_1352, (double)$$5.field_1350) * 180.0 / 3.1415927410125732));
        this.method_36457((float)(class_3532.method_15349((double)$$5.field_1351, (double)$$6) * 180.0 / 3.1415927410125732));
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
    }

    public void shootFromRotationWithVariance(class_1297 $$0, float $$1, float $$2, float $$3, float $$4, float $$5) {
        class_2350 gravityDirection = GravityAPI.getGravityDirection($$0);
        if (gravityDirection != class_2350.field_11033) {
            class_241 vecMagic = RotationUtil.rotPlayerToWorld($$0.method_36454(), $$0.method_36455(), gravityDirection);
            $$1 = vecMagic.field_1342;
            $$2 = vecMagic.field_1343;
        }
        float $$6 = -class_3532.method_15374((float)($$2 * ((float)Math.PI / 180))) * class_3532.method_15362((float)($$1 * ((float)Math.PI / 180)));
        float $$7 = -class_3532.method_15374((float)(($$1 + $$3) * ((float)Math.PI / 180)));
        float $$8 = class_3532.method_15362((float)($$2 * ((float)Math.PI / 180))) * class_3532.method_15362((float)($$1 * ((float)Math.PI / 180)));
        this.shootWithVariance($$6, $$7, $$8, $$4, $$5);
        class_243 $$9 = $$0.method_18798();
        this.method_18799(this.method_18798().method_1031($$9.field_1352, $$0.method_24828() ? 0.0 : $$9.field_1351, $$9.field_1350));
    }
}

