/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.models.stand.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.hydra.jojomod.client.models.layers.ModEntityRendererClient;
import net.hydra.jojomod.client.models.stand.D4CModel;
import net.hydra.jojomod.client.models.stand.renderers.StandRenderer;
import net.hydra.jojomod.entity.stand.D4CEntity;
import net.hydra.jojomod.event.powers.StandUser;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class D4CRenderer
extends StandRenderer<D4CEntity> {
    private static final ResourceLocation MANGA_SKIN = new ResourceLocation("roundabout", "textures/stand/d4c/manga.png");
    private static final ResourceLocation WONDER_FESTIVAL = new ResourceLocation("roundabout", "textures/stand/d4c/wonder_festival.png");
    private static final ResourceLocation PROMO = new ResourceLocation("roundabout", "textures/stand/d4c/promo.png");
    private static final ResourceLocation PROMO_L = new ResourceLocation("roundabout", "textures/stand/d4c/promo_l.png");
    private static final ResourceLocation SPECIAL = new ResourceLocation("roundabout", "textures/stand/d4c/special.png");
    private static final ResourceLocation GRAND = new ResourceLocation("roundabout", "textures/stand/d4c/grand.png");

    public D4CRenderer(EntityRendererProvider.Context context) {
        super(context, new D4CModel(context.m_174023_(ModEntityRendererClient.D4C_LAYER)), 0.0f);
    }

    @Override
    public ResourceLocation getTextureLocation(D4CEntity entity) {
        return switch (entity.getSkin()) {
            case 0 -> MANGA_SKIN;
            case 1 -> WONDER_FESTIVAL;
            case 2 -> PROMO;
            case 3 -> PROMO_L;
            case 4 -> SPECIAL;
            case 5 -> GRAND;
            default -> MANGA_SKIN;
        };
    }

    @Override
    public void render(D4CEntity mobEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        if (mobEntity.getUser() != null && ((StandUser)mobEntity.getUser()).roundabout$isParallelRunning() && mobEntity.getUser() != Minecraft.m_91087_().f_91074_) {
            return;
        }
        float factor = 0.5f + mobEntity.getSizePercent() / 2.0f;
        if (mobEntity.m_6162_()) {
            matrixStack.m_85841_(0.5f * factor, 0.5f * factor, 0.5f * factor);
        } else {
            matrixStack.m_85841_(0.87f * factor, 0.87f * factor, 0.87f * factor);
        }
        super.render(mobEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }

    @Override
    @Nullable
    protected RenderType getRenderType(D4CEntity entity, boolean showBody, boolean translucent, boolean showOutline) {
        return super.getRenderType(entity, showBody, true, showOutline);
    }

    @Override
    public float getStandOpacity(D4CEntity entity) {
        float base = super.getStandOpacity(entity);
        if (!entity.hasUser()) {
            return base;
        }
        if (((StandUser)entity.getUser()).roundabout$isParallelRunning()) {
            return base / 2.0f;
        }
        return base;
    }
}

