/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.mixin.time_stop;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.hydra.jojomod.access.IParticleAccess;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.event.powers.TimeStop;
import net.hydra.jojomod.mixin.access.AccessParticle;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ItemPickupParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.Vec3i;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ParticleEngine.class})
public class TimeStopParticleEngine {
    @Shadow
    @Final
    private static List<ParticleRenderType> f_107288_;
    @Shadow
    @Final
    private TextureManager f_107291_;
    @Shadow
    protected ClientLevel f_107287_;
    @Shadow
    @Final
    private Map<ParticleRenderType, Queue<Particle>> f_107289_;

    @ModifyVariable(method={"add(Lnet/minecraft/client/particle/Particle;)V"}, at=@At(value="HEAD"))
    private Particle roundaboutMarkParticleTS(Particle $$0) {
        if ($$0 != null && this.f_107287_ != null && ((TimeStop)this.f_107287_).inTimeStopRange(new Vec3i((int)((AccessParticle)$$0).roundabout$getX(), (int)((AccessParticle)$$0).roundabout$getY(), (int)((AccessParticle)$$0).roundabout$getZ()))) {
            ((IParticleAccess)$$0).roundabout$setRoundaboutIsTimeStopCreated(true);
        }
        return $$0;
    }

    @Inject(method={"tickParticle"}, at={@At(value="HEAD")}, cancellable=true)
    void doNotTickParticleWhenTimeStopped(Particle particle, CallbackInfo ci) {
        AccessParticle particle1 = (AccessParticle)particle;
        if (!(particle instanceof ItemPickupParticle) && particle1 != null && !((IParticleAccess)((Object)particle1)).roundabout$getRoundaboutIsTimeStopCreated() && ((TimeStop)this.f_107287_).inTimeStopRange(new Vec3i((int)particle1.roundabout$getX(), (int)particle1.roundabout$getY(), (int)particle1.roundabout$getZ()))) {
            particle1.roundabout$setPrevX(particle1.roundabout$getX());
            particle1.roundabout$setPrevY(particle1.roundabout$getY());
            particle1.roundabout$setPrevZ(particle1.roundabout$getZ());
            ci.cancel();
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void doNotDeltaTickParticlesWhenTimeIsStopped(PoseStack $$0, MultiBufferSource.BufferSource $$1, LightTexture $$2, Camera $$3, float $$4, CallbackInfo ci) {
        if (!((TimeStop)this.f_107287_).getTimeStoppingEntities().isEmpty()) {
            $$2.m_109896_();
            RenderSystem.enableDepthTest();
            PoseStack $$5 = RenderSystem.getModelViewStack();
            ClientUtil.pushPoseAndCooperate($$5, 17);
            $$5.m_252931_($$0.m_85850_().m_252922_());
            RenderSystem.applyModelViewMatrix();
            for (ParticleRenderType $$6 : f_107288_) {
                Iterable $$7 = this.f_107289_.get($$6);
                if ($$7 == null) continue;
                RenderSystem.setShader(GameRenderer::m_172829_);
                Tesselator $$8 = Tesselator.m_85913_();
                BufferBuilder $$9 = $$8.m_85915_();
                $$6.m_6505_($$9, this.f_107291_);
                for (Particle $$10 : $$7) {
                    try {
                        AccessParticle particle1 = (AccessParticle)$$10;
                        float tickDeltaFixed = $$4;
                        if (particle1 != null && !((IParticleAccess)((Object)particle1)).roundabout$getRoundaboutIsTimeStopCreated() && !($$10 instanceof ItemPickupParticle)) {
                            Vec3i range = new Vec3i((int)particle1.roundabout$getX(), (int)particle1.roundabout$getY(), (int)particle1.roundabout$getZ());
                            if (((TimeStop)this.f_107287_).inTimeStopRange(range)) {
                                tickDeltaFixed = ((IParticleAccess)((Object)particle1)).roundabout$getPreTSTick();
                            } else {
                                ((IParticleAccess)((Object)particle1)).roundabout$setPreTSTick();
                            }
                        }
                        $$10.m_5744_((VertexConsumer)$$9, $$3, tickDeltaFixed);
                    }
                    catch (Throwable var17) {
                        CrashReport $$12 = CrashReport.m_127521_((Throwable)var17, (String)"Rendering Particle");
                        CrashReportCategory $$13 = $$12.m_127514_("Particle being rendered");
                        $$13.m_128165_("Particle", () -> ((Particle)$$10).toString());
                        $$13.m_128165_("Particle Type", $$6::toString);
                        throw new ReportedException($$12);
                    }
                }
                $$6.m_6294_($$8);
            }
            ClientUtil.popPoseAndCooperate($$5, 17);
            RenderSystem.applyModelViewMatrix();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            $$2.m_109891_();
            ci.cancel();
        }
    }
}

