/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.stand.powers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.AbilityIconInstance;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.elements.PowerContext;
import net.hydra.jojomod.stand.powers.presets.NewPunchingStand;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;

public class PowersDiverDown
extends NewPunchingStand {
    public float standReach = 5.0f;

    public void tryToDashClient() {
        if (this.vaultOrFallBraceFails()) {
            this.dash();
        }
    }

    @Override
    public void powerActivate(PowerContext context) {
        switch (context) {
            case SKILL_3_NORMAL: {
                this.tryToDashClient();
            }
        }
    }

    @Override
    public void renderIcons(GuiGraphics context, int x, int y) {
        this.setSkillIcon(context, x, y, 1, StandIcons.LOCKED, (byte)0);
        this.setSkillIcon(context, x, y, 2, StandIcons.LOCKED, (byte)1);
        if (this.isHoldingSneak()) {
            this.setSkillIcon(context, x, y, 3, StandIcons.DIVER_DOWN_ZIP, (byte)2);
        } else {
            this.setSkillIcon(context, x, y, 3, StandIcons.DODGE, (byte)6);
        }
        if (this.canVault()) {
            this.setSkillIcon(context, x, y, 3, StandIcons.DIVER_DOWN_VAULT, (byte)6);
        }
        this.setSkillIcon(context, x, y, 4, StandIcons.DIVER_SELECTION, (byte)3);
    }

    @Override
    public List<AbilityIconInstance> drawGUIIcons(GuiGraphics context, float delta, int mouseX, int mouseY, int leftPos, int topPos, byte level, boolean bypas) {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 96, topPos + 99, 0, "ability.roundabout.dodge", "instruction.roundabout.press_skill", StandIcons.DODGE, 3, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 115, topPos + 99, 0, "ability.roundabout.vault", "instruction.roundabout.press_skill_air", StandIcons.DIVER_DOWN_VAULT, 3, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 134, topPos + 99, 0, "ability.roundabout.diver_zip", "instruction.roundabout.press_skill_crouch", StandIcons.DIVER_DOWN_ZIP, 3, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 80, 0, "ability.roundabout.diver_selection", "instruction.roundabout.press_skill", StandIcons.DIVER_SELECTION, 4, level, bypas));
        return $$1;
    }

    @Override
    public Component getSkinName(byte skinId) {
        switch (skinId) {
            case 0: {
                return Component.m_237115_((String)"skins.roundabout.diver_down.base");
            }
            case 1: {
                return Component.m_237115_((String)"skins.roundabout.diver_down.lavadiver");
            }
            case 2: {
                return Component.m_237115_((String)"skins.roundabout.diver_down.reddiver");
            }
            case 3: {
                return Component.m_237115_((String)"skins.roundabout.diver_down.orangediver");
            }
            case 4: {
                return Component.m_237115_((String)"skins.roundabout.diver_down.treasurediver");
            }
            case 5: {
                return Component.m_237115_((String)"skins.roundabout.diver_down.birthdaydiver");
            }
            case 6: {
                return Component.m_237115_((String)"skins.roundabout.diver_down.firediver");
            }
        }
        return Component.m_237115_((String)"skins.roundabout.diver_down.base");
    }

    @Override
    public List<Byte> getSkinList() {
        return Arrays.asList((byte)0, (byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6);
    }

    public PowersDiverDown(LivingEntity self) {
        super(self);
    }

    @Override
    protected Byte getSummonSound() {
        return (byte)18;
    }

    @Override
    public SoundEvent getSoundFromByte(byte soundChoice) {
        switch (soundChoice) {
            case 18: {
                return ModSounds.SUMMON_DIVER_DOWN_EVENT;
            }
        }
        return super.getSoundFromByte(soundChoice);
    }

    @Override
    public boolean canSummonStand() {
        return true;
    }

    @Override
    public boolean isMiningStand() {
        return true;
    }

    @Override
    public StandPowers generateStandPowers(LivingEntity entity) {
        return new PowersDiverDown(entity);
    }

    @Override
    public int getMaxGuardPoints() {
        return 15;
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        return super.tryPower(move, forced);
    }

    @Override
    public StandEntity getNewStandEntity() {
        return (StandEntity)ModEntities.DIVER_DOWN.m_20615_(this.getSelf().m_9236_());
    }

    @Override
    public boolean isWip() {
        return true;
    }

    @Override
    public Component ifWipListDevStatus() {
        return Component.m_237115_((String)"roundabout.dev_status.ongoing").m_130940_(ChatFormatting.AQUA);
    }

    @Override
    public Component ifWipListDev() {
        return Component.m_237113_((String)"MrInkyTech").m_130940_(ChatFormatting.YELLOW);
    }
}

