/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.models.corpses.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.hydra.jojomod.client.models.corpses.FallenSkeletonModel;
import net.hydra.jojomod.entity.corpses.FallenSkeleton;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class FallenSkeletonRenderer
extends HumanoidMobRenderer<FallenSkeleton, FallenSkeletonModel<FallenSkeleton>> {
    private static final ResourceLocation SKELETON_LOCATION = new ResourceLocation("textures/entity/skeleton/skeleton.png");
    public static final ResourceLocation FALLEN_SKELETON_LOCATION = new ResourceLocation("roundabout", "textures/entity/justice_corpses/justice_skeleton.png");
    public static final ResourceLocation FALLEN_SKELETON_LOCATION_2 = new ResourceLocation("roundabout", "textures/entity/justice_corpses/justice_skeleton_holes.png");
    public static final ResourceLocation FALLEN_SKELETON_LOCATION_B = new ResourceLocation("roundabout", "textures/entity/justice_corpses/justice_skeleton_blue.png");
    public static final ResourceLocation FALLEN_SKELETON_LOCATION_G = new ResourceLocation("roundabout", "textures/entity/justice_corpses/justice_skeleton_green.png");
    public static final ResourceLocation FALLEN_SKELETON_LOCATION_R = new ResourceLocation("roundabout", "textures/entity/justice_corpses/justice_skeleton_red.png");

    public FallenSkeletonRenderer(EntityRendererProvider.Context $$0) {
        this($$0, ModelLayers.f_171236_, ModelLayers.f_171238_, ModelLayers.f_171239_);
    }

    public ResourceLocation getTextureLocation(FallenSkeleton var1) {
        if (var1.getTurned()) {
            if (var1.getActivated()) {
                byte bt = var1.getJusticeTeamColor();
                if (bt == 1) {
                    return FALLEN_SKELETON_LOCATION_B;
                }
                if (bt == 2) {
                    return FALLEN_SKELETON_LOCATION_R;
                }
                if (bt == 3) {
                    return FALLEN_SKELETON_LOCATION_G;
                }
                if (bt == 4) {
                    return SKELETON_LOCATION;
                }
            }
            return FALLEN_SKELETON_LOCATION_2;
        }
        return FALLEN_SKELETON_LOCATION;
    }

    protected FallenSkeletonRenderer(EntityRendererProvider.Context $$0, FallenSkeletonModel<FallenSkeleton> $$1, FallenSkeletonModel<FallenSkeleton> $$2, FallenSkeletonModel<FallenSkeleton> $$3) {
        super($$0, $$1, 0.5f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, $$2, $$3, $$0.m_266367_()));
    }

    public FallenSkeletonRenderer(EntityRendererProvider.Context $$0, ModelLayerLocation $$1, ModelLayerLocation $$2, ModelLayerLocation $$3) {
        this($$0, new FallenSkeletonModel<FallenSkeleton>($$0.m_174023_($$1)), new FallenSkeletonModel<FallenSkeleton>($$0.m_174023_($$2)), new FallenSkeletonModel<FallenSkeleton>($$0.m_174023_($$3)));
    }

    protected void setupRotations(FallenSkeleton FM, PoseStack pose, float $$2, float $$3, float $$4) {
        super.m_7523_((LivingEntity)FM, pose, $$2, $$3, $$4);
        int tickTock = FM.ticksThroughPhases;
        if (FM.getPhasesFull()) {
            tickTock = 10;
            FM.ticksThroughPhases = 10;
        }
        float yes = Math.min(10.0f, (float)tickTock + $$4);
        if (FM.getActivated()) {
            yes = Math.max(0.0f, (float)tickTock - $$4);
        }
        float $$5 = yes / 10.0f;
        pose.m_252781_(Axis.f_252529_.m_252977_($$5 * 90.0f));
        pose.m_85837_(0.0, (double)(-$$5) * (0.5 * (double)FM.m_20206_()), -((double)$$5 * 0.15));
    }
}

