/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.models.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.hydra.jojomod.access.IEntityAndData;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.client.ModStrayModels;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.event.powers.TimeStop;
import net.hydra.jojomod.item.AnubisItem;
import net.hydra.jojomod.stand.powers.PowersAnubis;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Quaternionf;

public class AnubisLayer<T extends LivingEntity, A extends HumanoidModel<T>>
extends RenderLayer<T, A> {
    private final EntityRenderDispatcher dispatcher;
    float scale = 1.0f;

    public AnubisLayer(EntityRendererProvider.Context context, LivingEntityRenderer<T, A> livingEntityRenderer) {
        super(livingEntityRenderer);
        this.dispatcher = context.m_174022_();
    }

    public static HumanoidArm shouldRender(LivingEntity entity) {
        StandUser user = (StandUser)entity;
        if (entity.m_21205_().m_41720_() instanceof AnubisItem || entity.m_21206_().m_41720_() instanceof AnubisItem || user.roundabout$isPossessed() || user.roundabout$getStandPowers() instanceof PowersAnubis && user.roundabout$getActive() || user.roundabout$getAnubisVanishTicks() > 0) {
            return entity.m_5737_();
        }
        return null;
    }

    public static boolean isSheathed(LivingEntity entity) {
        StandUser user = (StandUser)entity;
        if (entity.m_21205_().m_41720_() instanceof AnubisItem && !user.roundabout$isPossessed()) {
            return user.roundabout$getStandPowers() instanceof PowersAnubis && !user.roundabout$getActive() || !(user.roundabout$getStandPowers() instanceof PowersAnubis);
        }
        return false;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float var5, float var6, float var7, float partialTicks, float var9, float var10) {
        if (((IEntityAndData)entity).roundabout$getTrueInvisibility() > -1 && !ClientUtil.checkIfClientCanSeeInvisAchtung()) {
            return;
        }
        if (!entity.m_20145_() && entity != null && AnubisLayer.shouldRender(entity) != null) {
            ClientUtil.pushPoseAndCooperate(poseStack, 25);
            StandUser SU = (StandUser)entity;
            if (AnubisLayer.shouldRender(entity) == HumanoidArm.RIGHT) {
                ((HumanoidModel)this.m_117386_()).f_102811_.m_104299_(poseStack);
                poseStack.m_85837_(-0.075, 0.9, 0.0);
                if (!AnubisLayer.isSheathed(entity)) {
                    poseStack.m_85837_(0.0, 0.2, 0.0);
                }
                poseStack.m_272245_(new Quaternionf().fromAxisAngleDeg(1.0f, 0.0f, 0.0f, AnubisLayer.isSheathed(entity) ? 90.0f : -90.0f), 0.0f, 0.0f, 0.0f);
                poseStack.m_272245_(new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, -90.0f), 0.0f, 0.0f, 0.0f);
                if (AnubisLayer.isSheathed(entity)) {
                    poseStack.m_85837_(1.0, -0.6, -0.025);
                }
            } else {
                ((HumanoidModel)this.m_117386_()).f_102812_.m_104299_(poseStack);
                poseStack.m_272245_(new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, AnubisLayer.isSheathed(entity) ? -90.0f : 90.0f), 0.0f, 0.0f, 0.0f);
                poseStack.m_272245_(new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, 1.0f, -90.0f), 0.0f, 0.0f, 0.0f);
                if (AnubisLayer.isSheathed(entity)) {
                    poseStack.m_85837_(0.1, -0.7, -0.025);
                }
            }
            poseStack.m_85837_(-0.25, 0.5, 0.05);
            AnubisLayer.renderAnubis(poseStack, bufferSource, packedLight, entity, partialTicks);
            ClientUtil.popPoseAndCooperate(poseStack, 25);
            ClientUtil.pushPoseAndCooperate(poseStack, 47);
            if (SU.roundabout$isPossessed()) {
                this.renderHumanoidAnubis(poseStack, bufferSource, packedLight, (LivingEntity)entity, partialTicks, 0.6f);
            } else {
                StandPowers standPowers = SU.roundabout$getStandPowers();
                if (standPowers instanceof PowersAnubis) {
                    PowersAnubis AP = (PowersAnubis)standPowers;
                    if (SU.roundabout$getActive() && SU.roundabout$getIdlePos() == 1) {
                        this.renderHumanoidAnubis(poseStack, bufferSource, packedLight, (LivingEntity)entity, partialTicks, (float)SU.roundabout$getAnubisVanishTicks() / 10.0f * 0.7f);
                    }
                }
            }
            ClientUtil.popPoseAndCooperate(poseStack, 47);
        }
    }

    public static void renderOutOfContext(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, LivingEntity entity, float partialTicks, ModelPart handarm) {
        if (!entity.m_20145_() && entity != null && AnubisLayer.shouldRender(entity) != null) {
            StandUser user = (StandUser)entity;
            ClientUtil.pushPoseAndCooperate(poseStack, 48);
            handarm.m_104299_(poseStack);
            poseStack.m_85837_(0.0, 0.9, 0.0);
            if (AnubisLayer.shouldRender(entity) == HumanoidArm.RIGHT) {
                poseStack.m_252880_(0.0f, 0.0f, 0.0f);
                if (AnubisLayer.isSheathed(entity)) {
                    poseStack.m_272245_(new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, 1.0f, 200.0f), 0.0f, 0.0f, 0.0f);
                    poseStack.m_272245_(new Quaternionf().fromAxisAngleDeg(1.0f, 0.0f, 0.0f, 30.0f), 0.0f, 0.0f, 0.0f);
                    poseStack.m_85837_(0.5, 0.35, 0.0);
                } else {
                    poseStack.m_272245_(new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, 1.0f, 20.0f), 0.0f, 0.0f, 0.0f);
                    poseStack.m_272245_(new Quaternionf().fromAxisAngleDeg(1.0f, 0.0f, 0.0f, -20.0f), 0.0f, 0.0f, 0.0f);
                }
            } else {
                poseStack.m_85837_(0.2, 0.0, 0.0);
                poseStack.m_272245_(new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, 180.0f), 0.0f, 0.0f, 0.0f);
                poseStack.m_272245_(new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, 1.0f, 45.0f), 0.0f, 0.0f, 0.0f);
                poseStack.m_272245_(new Quaternionf().fromAxisAngleDeg(1.0f, 0.0f, 0.0f, AnubisLayer.isSheathed(entity) ? 225.0f : 45.0f), 0.0f, 0.0f, 0.0f);
                if (AnubisLayer.isSheathed(entity)) {
                    poseStack.m_85837_(0.0, 0.1, 0.0);
                } else {
                    poseStack.m_85837_(0.3, -0.4, -0.05);
                }
            }
            AnubisLayer.renderAnubis(poseStack, bufferSource, packedLight, entity, partialTicks);
            ClientUtil.popPoseAndCooperate(poseStack, 48);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void renderAnubis(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, LivingEntity entity, float partialTicks) {
        float heyFull;
        StandUser user;
        block9: {
            int heyTicks;
            block8: {
                user = (StandUser)entity;
                boolean hasHeyYaOut = user.roundabout$getActive() && user.roundabout$getStandPowers() instanceof PowersAnubis;
                heyTicks = user.roundabout$getAnubisVanishTicks();
                heyFull = 0.0f;
                float fixedPartial = partialTicks - (float)((int)partialTicks);
                if (((TimeStop)entity.m_9236_()).CanTimeStopEntity((Entity)entity)) {
                    fixedPartial = 0.0f;
                }
                if (hasHeyYaOut) {
                    heyFull = (float)heyTicks + fixedPartial;
                    heyFull = Math.min(heyFull / 10.0f, 1.0f);
                } else {
                    heyFull = (float)heyTicks - fixedPartial;
                    heyFull = Math.max(heyFull / 10.0f, 0.0f);
                }
                boolean skin = false;
                if (user.roundabout$isPossessed()) {
                    ModStrayModels.ANUBIS.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, 1.0f, 1.0f, 1.0f, 1.0f, (byte)1);
                    return;
                }
                StandPowers standPowers = user.roundabout$getStandPowers();
                if (!(standPowers instanceof PowersAnubis)) break block8;
                PowersAnubis PA = (PowersAnubis)standPowers;
                if (user.roundabout$getActive()) break block9;
            }
            if (heyTicks == 0) {
                if (!(entity.m_21205_().m_41720_() instanceof AnubisItem)) return;
                if (user.roundabout$getEffectiveCombatMode()) return;
                ModStrayModels.ANUBIS.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, 1.0f, 1.0f, 1.0f, 1.0f, (byte)0);
                return;
            }
        }
        ModStrayModels.ANUBIS.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, 1.0f, 1.0f, 1.0f, heyFull, user.roundabout$getStandSkin());
    }

    public void renderHumanoidAnubis(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, LivingEntity entity, float partialTicks, float alpha) {
        ((HumanoidModel)this.m_117386_()).f_102810_.m_104299_(poseStack);
        poseStack.m_85837_(-0.55, -0.1, 0.5);
        poseStack.m_272245_(new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, -15.0f), 0.0f, 0.0f, 0.0f);
        ModStrayModels.ANUBIS_HUMAN.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, 1.0f, 1.0f, 1.0f, alpha);
    }
}

