/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.models.layers;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import net.hydra.jojomod.access.IEntityAndData;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.util.gravity.GravityAPI;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public class BigBubbleLayer<T extends LivingEntity, A extends EntityModel<T>>
extends RenderLayer<T, A> {
    private static final Map<String, ResourceLocation> ARMOR_LOCATION_CACHE = Maps.newHashMap();
    private final EntityRenderDispatcher dispatcher;
    float scale = 1.0f;
    private static final ResourceLocation TEXTURE = new ResourceLocation("roundabout", "textures/stand/soft_and_wet/projectiles/large_bubble.png");

    public BigBubbleLayer(EntityRendererProvider.Context context, LivingEntityRenderer<T, A> livingEntityRenderer) {
        super(livingEntityRenderer);
        this.dispatcher = context.m_174022_();
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T entity, float var5, float var6, float var7, float partialTicks, float var9, float var10) {
        if (ClientUtil.canSeeStands(ClientUtil.getPlayer()) && ((StandUser)entity).roundabout$isBubbleEncased() && ((IEntityAndData)entity).roundabout$getExclusiveLayers()) {
            ClientUtil.pushPoseAndCooperate(poseStack, 22);
            float height = entity.m_6972_((Pose)Pose.STANDING).f_20378_;
            float width = entity.m_6972_((Pose)Pose.STANDING).f_20377_;
            if (ClientUtil.savedPose != null) {
                poseStack.m_85850_().m_252922_().set((Matrix4fc)ClientUtil.savedPose);
            }
            poseStack.m_252880_(0.0f, height * 0.69f, 0.0f);
            poseStack.m_85841_(this.scale, this.scale, this.scale);
            Direction gravityDirection = GravityAPI.getGravityDirection(entity);
            if (gravityDirection != Direction.DOWN) {
                poseStack.m_252781_(RotationUtil.getWorldRotationQuaternion(gravityDirection));
                poseStack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
            } else {
                poseStack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
            }
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            Vector3f normal = Minecraft.m_91087_().f_91063_.m_109153_().m_253058_();
            normal.normalize();
            Vector3f coursecorrect = new Vector3f(0.577f, 0.577f, 0.577f);
            if (normal.y > 0.0f) {
                coursecorrect = new Vector3f(0.01f, 1.0f, 0.01f);
            }
            float size = Math.max(height, width) * 0.75f;
            Matrix4f matrix = poseStack.m_85850_().m_252922_();
            VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)TEXTURE));
            vertexConsumer.m_252986_(matrix, -size, -size, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(coursecorrect.x, coursecorrect.y, coursecorrect.z).m_5752_();
            vertexConsumer.m_252986_(matrix, size, -size, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(coursecorrect.x, coursecorrect.y, coursecorrect.z).m_5752_();
            vertexConsumer.m_252986_(matrix, size, size, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(coursecorrect.x, coursecorrect.y, coursecorrect.z).m_5752_();
            vertexConsumer.m_252986_(matrix, -size, size, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(coursecorrect.x, coursecorrect.y, coursecorrect.z).m_5752_();
            ClientUtil.popPoseAndCooperate(poseStack, 22);
        }
    }
}

