/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.models.visages.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.client.models.layers.HumanoidLikeArmorLayer;
import net.hydra.jojomod.client.models.layers.ModEntityRendererClient;
import net.hydra.jojomod.client.models.visages.PlayerLikeModel;
import net.hydra.jojomod.client.models.visages.PlayerModifiedModel;
import net.hydra.jojomod.client.models.visages.renderers.PlayerLikeRenderer;
import net.hydra.jojomod.entity.visages.JojoNPC;
import net.hydra.jojomod.entity.visages.JojoNPCPlayer;
import net.hydra.jojomod.entity.visages.mobs.PlayerModifiedNPC;
import net.hydra.jojomod.item.ModificationMaskItem;
import net.hydra.jojomod.util.config.ConfigManager;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector3f;

public class PlayerModifiedRenderer<T extends JojoNPC>
extends PlayerLikeRenderer<JojoNPCPlayer> {
    private static final ResourceLocation STEVE_SKIN = new ResourceLocation("roundabout", "textures/entity/visage/steve.png");

    public PlayerModifiedRenderer(EntityRendererProvider.Context context) {
        super(context, new PlayerModifiedModel(context.m_174023_(ModEntityRendererClient.MODIFIED_LAYER)), 0.0f);
        if (ConfigManager.getClientConfig().renderArmorOnPlayerCloneAbilities.booleanValue()) {
            this.m_115326_(new HumanoidLikeArmorLayer(this, new HumanoidArmorModel(context.m_174023_(ModelLayers.f_171164_)), new HumanoidArmorModel(context.m_174023_(ModelLayers.f_171165_)), context.m_266367_()));
        }
    }

    @Override
    public void render(JojoNPCPlayer mobEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        Player player = mobEntity.host;
        if (player instanceof AbstractClientPlayer) {
            AbstractClientPlayer AP = (AbstractClientPlayer)player;
            if (mobEntity instanceof PlayerModifiedNPC) {
                PlayerModifiedNPC pmn = (PlayerModifiedNPC)mobEntity;
                ItemStack stack = ((IPlayerEntity)AP).roundabout$getMaskSlot();
                if (stack != null && !stack.m_41619_() && stack.m_41720_() instanceof ModificationMaskItem && !pmn.isDisplay) {
                    pmn.height = stack.m_41698_("modifications").m_128451_("height");
                    pmn.width = stack.m_41698_("modifications").m_128451_("width");
                    pmn.faceSize = stack.m_41698_("modifications").m_128451_("head");
                    pmn.chestType = stack.m_41698_("modifications").m_128451_("chest");
                }
                matrixStack.m_85841_(0.798f + (float)pmn.width * 0.001f, 0.7f + (float)pmn.height * 0.001f, 0.798f + (float)pmn.width * 0.001f);
                super.render(mobEntity, f, g, matrixStack, vertexConsumerProvider, i);
            }
        }
    }

    @Override
    public ResourceLocation getTextureLocation(JojoNPC entity) {
        if (entity instanceof JojoNPCPlayer) {
            JojoNPCPlayer jnp = (JojoNPCPlayer)entity;
            Player player = jnp.host;
            if (player instanceof AbstractClientPlayer) {
                AbstractClientPlayer AP = (AbstractClientPlayer)player;
                return ((AbstractClientPlayer)jnp.host).m_108560_();
            }
        }
        return STEVE_SKIN;
    }

    @Override
    public void setModelProperties(JojoNPCPlayer $$0) {
        super.setModelProperties($$0);
        Player player = $$0.host;
        if (player instanceof AbstractClientPlayer) {
            AbstractClientPlayer AP = (AbstractClientPlayer)player;
            if ($$0 instanceof PlayerModifiedNPC) {
                PlayerModifiedNPC pmn = (PlayerModifiedNPC)$$0;
                PlayerLikeModel $$1 = (PlayerLikeModel)this.m_7200_();
                float yeah = (float)((double)0.73f + (double)pmn.faceSize * 0.002);
                $$1.head.m_253072_(new Vector3f(yeah, yeah, yeah));
            }
        }
    }
}

