/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.corpses;

import java.util.Collection;
import net.hydra.jojomod.entity.corpses.FallenMob;
import net.hydra.jojomod.entity.goals.CorpseMeleeAttackGoal;
import net.hydra.jojomod.entity.goals.SwellGoalFallen;
import net.hydra.jojomod.event.powers.StandUser;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class FallenCreeper
extends FallenMob
implements PowerableMob {
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.m_135353_(FallenCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_IS_POWERED = SynchedEntityData.m_135353_(FallenCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_IGNITED = SynchedEntityData.m_135353_(FallenCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int oldSwell;
    private int swell;
    private int maxSwell = 30;
    private int explosionRadius = 3;
    private int droppedSkulls;

    public FallenCreeper(EntityType<? extends PathfinderMob> $$0, Level $$1) {
        super($$0, $$1);
    }

    @Override
    public String getData() {
        return "creeper";
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new SwellGoalFallen(this));
        this.f_21345_.m_25352_(3, (Goal)new CorpseMeleeAttackGoal(this, 1.0, false));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.addBehaviourGoals();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22277_, 48.0);
    }

    @Override
    protected void m_8097_() {
        if (!this.f_19804_.m_285897_(DATA_SWELL_DIR)) {
            super.m_8097_();
            this.f_19804_.m_135372_(DATA_SWELL_DIR, (Object)-1);
            this.f_19804_.m_135372_(DATA_IS_POWERED, (Object)false);
            this.f_19804_.m_135372_(DATA_IS_IGNITED, (Object)false);
        }
    }

    public boolean m_7090_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_POWERED);
    }

    public float getSwelling(float $$0) {
        return Mth.m_14179_((float)$$0, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    public int getSwellDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_SWELL_DIR);
    }

    public void setSwellDir(int $$0) {
        this.f_19804_.m_135381_(DATA_SWELL_DIR, (Object)$$0);
    }

    public void m_8038_(ServerLevel $$0, LightningBolt $$1) {
        super.m_8038_($$0, $$1);
        this.f_19804_.m_135381_(DATA_IS_POWERED, (Object)true);
    }

    protected InteractionResult m_6071_(Player $$0, InteractionHand $$1) {
        ItemStack $$2 = $$0.m_21120_($$1);
        if ($$2.m_204117_(ItemTags.f_262757_)) {
            SoundEvent $$3 = $$2.m_150930_(Items.f_42613_) ? SoundEvents.f_11874_ : SoundEvents.f_11942_;
            this.m_9236_().m_6263_($$0, this.m_20185_(), this.m_20186_(), this.m_20189_(), $$3, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.4f + 0.8f);
            if (!this.m_9236_().f_46443_) {
                this.ignite();
                if (!$$2.m_41763_()) {
                    $$2.m_41774_(1);
                } else {
                    $$2.m_41622_(1, (LivingEntity)$$0, $$1x -> $$1x.m_21190_($$1));
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_($$0, $$1);
    }

    private void explodeCreeper() {
        if (!this.m_9236_().f_46443_) {
            float $$0 = this.m_7090_() ? 2.0f : 1.0f;
            this.f_20890_ = true;
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)this.explosionRadius * $$0, Level.ExplosionInteraction.MOB);
            this.m_146870_();
            this.spawnLingeringCloud();
        }
    }

    private void spawnLingeringCloud() {
        Collection $$0 = this.m_21220_();
        if (!$$0.isEmpty()) {
            AreaEffectCloud $$1 = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            $$1.m_19712_(2.5f);
            $$1.m_19732_(-0.5f);
            $$1.m_19740_(10);
            $$1.m_19734_($$1.m_19748_() / 2);
            $$1.m_19738_(-$$1.m_19743_() / (float)$$1.m_19748_());
            for (MobEffectInstance $$2 : $$0) {
                $$1.m_19716_(new MobEffectInstance($$2));
            }
            this.m_9236_().m_7967_((Entity)$$1);
        }
    }

    @Override
    public void m_8119_() {
        if (((StandUser)((Object)this)).roundabout$isDazed() || !((StandUser)((Object)this)).roundabout$getStandDisc().m_41619_() && ((StandUser)((Object)this)).roundabout$getStandPowers().disableMobAiAttack()) {
            if (this.m_6084_()) {
                this.oldSwell = this.swell;
            }
            --this.swell;
            if (this.swell < 0) {
                this.swell = 0;
            }
            super.m_8119_();
            return;
        }
        if (this.m_6084_()) {
            int $$0;
            this.oldSwell = this.swell;
            if (this.isIgnited()) {
                this.setSwellDir(1);
            }
            if (($$0 = this.getSwellDir()) > 0 && this.swell == 0) {
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
                this.m_146850_(GameEvent.f_157776_);
            }
            this.swell += $$0;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explodeCreeper();
            }
        }
        super.m_8119_();
    }

    @Override
    public boolean m_7327_(Entity p_32281_) {
        return true;
    }

    @Override
    public void m_7380_(CompoundTag $$0) {
        super.m_7380_($$0);
        if (((Boolean)this.f_19804_.m_135370_(DATA_IS_POWERED)).booleanValue()) {
            $$0.m_128379_("powered", true);
        }
        $$0.m_128376_("Fuse", (short)this.maxSwell);
        $$0.m_128344_("ExplosionRadius", (byte)this.explosionRadius);
        $$0.m_128379_("ignited", this.isIgnited());
    }

    @Override
    public void m_7378_(CompoundTag $$0) {
        super.m_7378_($$0);
        this.f_19804_.m_135381_(DATA_IS_POWERED, (Object)$$0.m_128471_("powered"));
        if ($$0.m_128425_("Fuse", 99)) {
            this.maxSwell = $$0.m_128448_("Fuse");
        }
        if ($$0.m_128425_("ExplosionRadius", 99)) {
            this.explosionRadius = $$0.m_128445_("ExplosionRadius");
        }
        if ($$0.m_128471_("ignited")) {
            this.ignite();
        }
    }

    public int m_6056_() {
        return this.m_5448_() == null ? 3 : 3 + (int)(this.m_21223_() - 1.0f);
    }

    public boolean m_142535_(float $$0, float $$1, DamageSource $$2) {
        boolean $$3 = super.m_142535_($$0, $$1, $$2);
        this.swell += (int)($$0 * 1.5f);
        if (this.swell > this.maxSwell - 5) {
            this.swell = this.maxSwell - 5;
        }
        return $$3;
    }

    protected SoundEvent m_7975_(DamageSource $$0) {
        if (this.getActivated()) {
            return SoundEvents.f_11836_;
        }
        return super.m_7975_($$0);
    }

    protected SoundEvent m_5592_() {
        if (this.getActivated()) {
            return SoundEvents.f_11835_;
        }
        return super.m_5592_();
    }

    public boolean isIgnited() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_IGNITED);
    }

    public void ignite() {
        this.f_19804_.m_135381_(DATA_IS_IGNITED, (Object)true);
    }
}

