/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.goals;

import java.util.EnumSet;
import net.hydra.jojomod.entity.corpses.FallenMob;
import net.hydra.jojomod.event.index.Tactics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class CorpseFollowCommanderGoal
extends Goal {
    public static final int TELEPORT_WHEN_DISTANCE_IS = 12;
    private static final int MIN_HORIZONTAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 2;
    private static final int MAX_HORIZONTAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 3;
    private static final int MAX_VERTICAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 1;
    private final FallenMob fallenMob;
    private LivingEntity owner;
    private final LevelReader level;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;
    private final boolean canFly;

    public CorpseFollowCommanderGoal(FallenMob $$0, double $$1, float $$2, float $$3, boolean $$4) {
        this.fallenMob = $$0;
        this.level = $$0.m_9236_();
        this.speedModifier = $$1;
        this.navigation = $$0.m_21573_();
        this.startDistance = $$2;
        this.stopDistance = $$3;
        this.canFly = $$4;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!($$0.m_21573_() instanceof GroundPathNavigation) && !($$0.m_21573_() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean m_8036_() {
        LivingEntity $$0 = null;
        Entity entity = this.fallenMob.controller;
        if (entity instanceof LivingEntity) {
            LivingEntity LE;
            $$0 = LE = (LivingEntity)entity;
        }
        if ($$0 == null) {
            return false;
        }
        if ($$0.m_5833_()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        if (this.fallenMob.m_20280_((Entity)$$0) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = $$0;
        return this.fallenMob.getMovementTactic() == Tactics.FOLLOW.id;
    }

    public boolean m_8045_() {
        if (this.navigation.m_26571_()) {
            return false;
        }
        return this.unableToMove() ? false : !(this.fallenMob.m_20280_((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    private boolean unableToMove() {
        return this.fallenMob.m_20159_() || this.fallenMob.m_21523_();
    }

    public void m_8056_() {
        this.navigation.m_26573_();
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.fallenMob.m_21439_(BlockPathTypes.WATER);
        this.fallenMob.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigation.m_26573_();
        this.fallenMob.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.fallenMob.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.fallenMob.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            this.navigation.m_5624_((Entity)this.owner, this.speedModifier);
        }
    }

    private void teleportToOwner() {
        BlockPos $$0 = this.owner.m_20183_();
        for (int $$1 = 0; $$1 < 10; ++$$1) {
            int $$2 = this.randomIntInclusive(-3, 3);
            int $$3 = this.randomIntInclusive(-1, 1);
            int $$4 = this.randomIntInclusive(-3, 3);
            boolean $$5 = this.maybeTeleportTo($$0.m_123341_() + $$2, $$0.m_123342_() + $$3, $$0.m_123343_() + $$4);
            if (!$$5) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int $$0, int $$1, int $$2) {
        if (Math.abs((double)$$0 - this.owner.m_20185_()) < 2.0 && Math.abs((double)$$2 - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos($$0, $$1, $$2))) {
            return false;
        }
        this.fallenMob.m_7678_((double)$$0 + 0.5, $$1, (double)$$2 + 0.5, this.fallenMob.m_146908_(), this.fallenMob.m_146909_());
        this.navigation.m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos $$0) {
        BlockPathTypes $$1 = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)$$0.m_122032_());
        if ($$1 != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState $$2 = this.level.m_8055_($$0.m_7495_());
        if (!this.canFly && $$2.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos $$3 = $$0.m_121996_((Vec3i)this.fallenMob.m_20183_());
        return this.level.m_45756_((Entity)this.fallenMob, this.fallenMob.m_20191_().m_82338_($$3));
    }

    private int randomIntInclusive(int $$0, int $$1) {
        return this.fallenMob.m_217043_().m_188503_($$1 - $$0 + 1) + $$0;
    }
}

