/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.projectile;

import net.hydra.jojomod.block.FleshBlock;
import net.hydra.jojomod.block.ModBlocks;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.util.gravity.GravityAPI;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class FleshPileEntity
extends ThrowableItemProjectile {
    protected static final EntityDataAccessor<Integer> FLESH_COUNT = SynchedEntityData.m_135353_(FleshPileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public FleshPileEntity(EntityType<? extends ThrowableItemProjectile> $$0, Level $$1) {
        super($$0, $$1);
    }

    protected void m_8097_() {
        if (!this.f_19804_.m_285897_(FLESH_COUNT)) {
            super.m_8097_();
            this.f_19804_.m_135372_(FLESH_COUNT, (Object)0);
        }
    }

    public void setFleshCount(int amount) {
        this.f_19804_.m_135381_(FLESH_COUNT, (Object)amount);
    }

    public int getFleshCount() {
        return (Integer)this.f_19804_.m_135370_(FLESH_COUNT);
    }

    public FleshPileEntity(LivingEntity living, Level $$1, int amount) {
        super(ModEntities.FLESH_PILE, living, $$1);
        this.setFleshCount(amount);
    }

    public FleshPileEntity(Level level, double d0, double d1, double d2, int amount) {
        super(ModEntities.FLESH_PILE, d0, d1, d2, level);
        this.setFleshCount(amount);
    }

    protected Item m_7881_() {
        return ModBlocks.FLESH_BLOCK.m_5456_();
    }

    protected void m_8060_(BlockHitResult $$0) {
        super.m_8060_($$0);
        if (!this.m_9236_().f_46443_) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ModBlocks.FLESH_BLOCK.m_49966_()), (double)this.m_20097_().m_123341_() + 0.5, (double)this.m_20097_().m_123342_() + 0.5, (double)this.m_20097_().m_123343_() + 0.5, 15, 0.4, 0.4, 0.25, 0.4);
            this.m_5496_(SoundEvents.f_11917_, 1.0f, 1.5f);
            this.placeFlesh($$0.m_82425_(), this.getFleshCount() != 0 ? this.getFleshCount() : 4);
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult $$0) {
        Entity entity = $$0.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity LE = (LivingEntity)entity;
            LE.m_7292_(new MobEffectInstance(MobEffects.f_19597_, this.getFleshCount() > 10 ? 70 : 50, 1));
        }
    }

    public boolean[] isValidLocation(BlockPos pos, int offsetX, int offsetY, int offsetZ, int level) {
        BlockPos blk = new BlockPos(pos.m_123341_() + offsetX, pos.m_123342_() + offsetY, pos.m_123343_() + offsetZ);
        BlockState check = this.m_9236_().m_8055_(blk);
        boolean[] info = new boolean[]{false, check.m_60713_(ModBlocks.FLESH_BLOCK) && (Integer)check.m_61143_((Property)FleshBlock.LAYERS) + level <= 4};
        if (this.m_9236_().m_46859_(blk)) {
            BlockPos $$8 = blk.m_7495_();
            BlockState b = this.m_9236_().m_8055_($$8);
            info[0] = b.m_60783_((BlockGetter)this.m_9236_(), $$8, Direction.UP) || b.m_60713_(ModBlocks.FLESH_BLOCK) && (Integer)b.m_61143_((Property)FleshBlock.LAYERS) == 4;
        }
        return info;
    }

    public boolean[] checkHeights(BlockPos pos, int offsetX, int offsetZ, int level) {
        boolean[] info = new boolean[]{false, false};
        for (int i = -1; i < 3; ++i) {
            boolean[] result = this.isValidLocation(pos, offsetX, i, offsetZ, level);
            if (!result[0] && !result[1]) continue;
            info = result;
        }
        return info;
    }

    public void setGoo(BlockPos pos, int offsetX, int offsetZ, int level) {
        BlockPos blockPos = null;
        boolean replace = false;
        for (int i = -1; i < 3; ++i) {
            boolean[] result = this.isValidLocation(pos, offsetX, i, offsetZ, level);
            if (!result[0] && !result[1]) continue;
            replace = result[1];
            blockPos = new BlockPos(pos.m_123341_() + offsetX, pos.m_123342_() + i, pos.m_123343_() + offsetZ);
        }
        if (blockPos != null) {
            BlockState n = (BlockState)ModBlocks.FLESH_BLOCK.m_49966_().m_61124_((Property)ModBlocks.FLESH_LAYER, (Comparable)Integer.valueOf(level));
            if (replace) {
                n = (BlockState)ModBlocks.FLESH_BLOCK.m_49966_().m_61124_((Property)ModBlocks.FLESH_LAYER, (Comparable)Integer.valueOf(level + (Integer)this.m_9236_().m_8055_(blockPos).m_61143_((Property)FleshBlock.LAYERS)));
            }
            this.m_9236_().m_46597_(new BlockPos(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()), n);
        }
    }

    public void placeFlesh(BlockPos pos, int amount) {
        int x;
        int[][] array = new int[][]{{0, 0, 0}, {0, 1, 0}, {0, 0, 0}};
        if (--amount > 10) {
            array = new int[][]{{0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 1, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}};
        }
        if (!this.m_9236_().m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50016_)) {
            array[array.length / 2][array.length / 2] = -1;
            ++amount;
        }
        for (int x2 = 0; x2 < array.length; ++x2) {
            for (int y = 0; y < array[0].length; ++y) {
                boolean[] result = this.checkHeights(pos, x2 - 1, y - 1, array[x2][y]);
                if (result[0] || result[1]) continue;
                array[x2][y] = -1;
            }
        }
        for (int i = 0; i < amount; ++i) {
            x = (int)(Math.random() * (double)array.length);
            int y = (int)(Math.random() * (double)array.length);
            for (int n = 0; array[x][y] == -1 && n <= 10; ++n) {
                x = (int)(Math.random() * (double)array.length);
                y = (int)(Math.random() * (double)array.length);
            }
            if (array[x][y] == -1) continue;
            int[] nArray = array[x];
            int n = y;
            nArray[n] = nArray[n] + 1;
        }
        boolean zeroSpots = true;
        for (x = 0; x < array.length; ++x) {
            for (int y = 0; y < array.length; ++y) {
                if (array[x][y] == -1) continue;
                zeroSpots = false;
                break;
            }
            if (!zeroSpots) break;
        }
        if (zeroSpots) {
            this.m_19983_(new ItemStack((ItemLike)ModBlocks.FLESH_BLOCK, this.getFleshCount()));
            return;
        }
        for (x = 0; x < array.length; ++x) {
            for (int y = 0; y < array[0].length; ++y) {
                if (array[x][y] <= 0) continue;
                this.setGoo(pos, x - array.length / 2, y - array.length / 2, Mth.m_14045_((int)0, (int)array[x][y], (int)4));
            }
        }
    }

    public void shootWithVariance(double $$0, double $$1, double $$2, float $$3, float $$4) {
        Vec3 $$5 = new Vec3($$0, $$1, $$2).m_82541_().m_82520_(this.f_19796_.m_216328_(0.0, 0.13 * (double)$$4), this.f_19796_.m_216328_(0.0, 0.13 * (double)$$4), this.f_19796_.m_216328_(0.0, 0.13 * (double)$$4)).m_82490_((double)$$3);
        this.m_20256_($$5);
        double $$6 = $$5.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)$$5.f_82479_, (double)$$5.f_82481_) * 180.0 / 3.1415927410125732));
        this.m_146926_((float)(Mth.m_14136_((double)$$5.f_82480_, (double)$$6) * 180.0 / 3.1415927410125732));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public void shootFromRotationWithVariance(Entity $$0, float $$1, float $$2, float $$3, float $$4, float $$5) {
        Direction gravityDirection = GravityAPI.getGravityDirection($$0);
        if (gravityDirection != Direction.DOWN) {
            Vec2 vecMagic = RotationUtil.rotPlayerToWorld($$0.m_146908_(), $$0.m_146909_(), gravityDirection);
            $$1 = vecMagic.f_82471_;
            $$2 = vecMagic.f_82470_;
        }
        float $$6 = -Mth.m_14031_((float)($$2 * ((float)Math.PI / 180))) * Mth.m_14089_((float)($$1 * ((float)Math.PI / 180)));
        float $$7 = -Mth.m_14031_((float)(($$1 + $$3) * ((float)Math.PI / 180)));
        float $$8 = Mth.m_14089_((float)($$2 * ((float)Math.PI / 180))) * Mth.m_14089_((float)($$1 * ((float)Math.PI / 180)));
        this.shootWithVariance($$6, $$7, $$8, $$4, $$5);
        Vec3 $$9 = $$0.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_($$9.f_82479_, $$0.m_20096_() ? 0.0 : $$9.f_82480_, $$9.f_82481_));
    }
}

