/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.event;

import java.util.Set;
import net.hydra.jojomod.access.IAbstractArrowAccess;
import net.hydra.jojomod.access.ICreeper;
import net.hydra.jojomod.access.IEntityAndData;
import net.hydra.jojomod.access.IGravityEntity;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.event.SavedSecondAbstractArrow;
import net.hydra.jojomod.event.SavedSecondCreeper;
import net.hydra.jojomod.event.SavedSecondLiving;
import net.hydra.jojomod.event.SavedSecondPlayer;
import net.hydra.jojomod.event.SavedSecondTNT;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class SavedSecond {
    public float headYRotation;
    public Vec2 rotationVec;
    public Vec3 position;
    public Vec3 deltaMovement;
    public boolean hasHadParticle = false;
    public Entity isTickingParticles = null;
    public Direction gravityDirection = Direction.DOWN;
    public float fallDistance = 0.0f;
    public ResourceKey<DimensionType> dimensionTypeId = null;

    public SavedSecond(float headYRotation, Vec2 rotationVec, Vec3 position, Vec3 deltaMovement, float fallDistance, ResourceKey<DimensionType> dimensionId, Direction gravityDirection) {
        this.headYRotation = headYRotation;
        this.rotationVec = new Vec2(rotationVec.f_82470_, rotationVec.f_82471_);
        this.position = new Vec3(position.f_82479_, position.f_82480_, position.f_82481_);
        this.deltaMovement = new Vec3(deltaMovement.f_82479_, deltaMovement.f_82480_, deltaMovement.f_82481_);
        this.fallDistance = fallDistance;
        this.dimensionTypeId = dimensionId;
    }

    public static SavedSecond saveEntitySecond(Entity ent) {
        if (ent instanceof Player) {
            Player PL = (Player)ent;
            return new SavedSecondPlayer(PL.m_6080_(), PL.m_20155_(), PL.m_20318_(1.0f), PL.m_20184_(), ent.f_19789_, (ResourceKey<DimensionType>)ent.m_9236_().m_220362_(), ((IGravityEntity)ent).roundabout$getGravityDirection(), PL.m_21220_(), PL.m_21223_(), PL.m_20094_(), ((StandUser)PL).roundabout$getRemainingFireTicks(), ((StandUser)PL).roundabout$getOnStandFire(), ((StandUser)PL).roundabout$getGasolineTime(), PL.m_20146_(), ((StandUser)PL).roundabout$getLocacacaCurse(), ((StandUser)PL).roundabout$getLeapTicks(), ((StandUser)PL).roundabout$getBubbleEncased(), PL.m_36324_().m_38702_(), PL.m_36324_().m_38722_(), PL.m_36324_().m_150380_());
        }
        if (ent instanceof Creeper) {
            Creeper CE = (Creeper)ent;
            return new SavedSecondCreeper(CE.m_6080_(), CE.m_20155_(), CE.m_20318_(1.0f), CE.m_20184_(), ent.f_19789_, (ResourceKey<DimensionType>)ent.m_9236_().m_220362_(), ((IGravityEntity)ent).roundabout$getGravityDirection(), CE.m_21220_(), CE.m_21223_(), CE.m_20094_(), ((StandUser)CE).roundabout$getRemainingFireTicks(), ((StandUser)CE).roundabout$getOnStandFire(), ((StandUser)CE).roundabout$getGasolineTime(), CE.m_20146_(), ((StandUser)CE).roundabout$getLocacacaCurse(), ((StandUser)CE).roundabout$getLeapTicks(), ((StandUser)CE).roundabout$getBubbleEncased(), ((ICreeper)CE).roundabout$getSwell());
        }
        if (ent instanceof PrimedTnt) {
            PrimedTnt TN = (PrimedTnt)ent;
            return new SavedSecondTNT(TN.m_6080_(), TN.m_20155_(), TN.m_20318_(1.0f), TN.m_20184_(), ent.f_19789_, (ResourceKey<DimensionType>)ent.m_9236_().m_220362_(), ((IGravityEntity)ent).roundabout$getGravityDirection(), TN.m_32100_());
        }
        if (ent instanceof LivingEntity) {
            LivingEntity LE = (LivingEntity)ent;
            return new SavedSecondLiving(LE.m_6080_(), LE.m_20155_(), LE.m_20318_(1.0f), LE.m_20184_(), ent.f_19789_, (ResourceKey<DimensionType>)ent.m_9236_().m_220362_(), ((IGravityEntity)ent).roundabout$getGravityDirection(), LE.m_21220_(), LE.m_21223_(), LE.m_20094_(), ((StandUser)LE).roundabout$getRemainingFireTicks(), ((StandUser)LE).roundabout$getOnStandFire(), ((StandUser)LE).roundabout$getGasolineTime(), LE.m_20146_(), ((StandUser)LE).roundabout$getLocacacaCurse(), ((StandUser)LE).roundabout$getLeapTicks(), ((StandUser)LE).roundabout$getBubbleEncased());
        }
        if (ent instanceof AbstractArrow) {
            AbstractArrow LE = (AbstractArrow)ent;
            return new SavedSecondAbstractArrow(LE.m_6080_(), LE.m_20155_(), LE.m_20318_(1.0f), LE.m_20184_(), ent.f_19789_, (ResourceKey<DimensionType>)ent.m_9236_().m_220362_(), ((IGravityEntity)ent).roundabout$getGravityDirection(), ((IAbstractArrowAccess)LE).roundabout$GetInGround());
        }
        if (ent != null) {
            return new SavedSecond(ent.m_6080_(), ent.m_20155_(), ent.m_20318_(1.0f), ent.m_20184_(), ent.f_19789_, (ResourceKey<DimensionType>)ent.m_9236_().m_220362_(), ((IGravityEntity)ent).roundabout$getGravityDirection());
        }
        return null;
    }

    public void loadTime(Entity ent) {
        if (ent == null || this.dimensionTypeId != ent.m_9236_().m_220362_()) {
            return;
        }
        boolean canBeRepositioned = true;
        boolean suffocationBlocker = ClientNetworking.getAppropriateConfig().mandomSettings.timeRewindStopsSuffocation;
        if (suffocationBlocker && !SavedSecond.canTeleportTo(ent.m_9236_(), this.position, ent)) {
            canBeRepositioned = false;
        }
        if (canBeRepositioned && (ent.m_20202_() == null || !MainUtil.canRewindInTime(ent.m_20202_(), ent))) {
            ent.m_5616_(this.headYRotation);
            ent.m_146926_(this.rotationVec.f_82470_);
            ent.m_146922_(this.rotationVec.f_82471_);
            ent.m_264318_((ServerLevel)ent.m_9236_(), this.position.f_82479_, this.position.f_82480_, this.position.f_82481_, Set.of(RelativeMovement.X, RelativeMovement.Y, RelativeMovement.Z), this.headYRotation, this.rotationVec.f_82470_);
            ent.f_19864_ = true;
            ent.m_20256_(this.deltaMovement);
            ent.f_19812_ = true;
            ent.f_19789_ = this.fallDistance;
        }
        ((IEntityAndData)ent).roundabout$resetSecondQueue();
    }

    public static boolean canTeleportTo(Level level, Vec3 targetPos, Entity entity) {
        double height;
        double width = entity.m_20205_();
        AABB targetBox = new AABB(targetPos.f_82479_ - width / 2.0, targetPos.f_82480_, targetPos.f_82481_ - width / 2.0, targetPos.f_82479_ + width / 2.0, targetPos.f_82480_ + (height = (double)entity.m_20206_()), targetPos.f_82481_ + width / 2.0);
        if (!level.m_45756_(entity, targetBox)) {
            return false;
        }
        boolean deviousStratBlocker = ClientNetworking.getAppropriateConfig().mandomSettings.timeRewindStopsDeviousStrategies;
        if (deviousStratBlocker) {
            for (BlockPos pos : BlockPos.m_121976_((int)Mth.m_14107_((double)targetBox.f_82288_), (int)Mth.m_14107_((double)targetBox.f_82289_), (int)Mth.m_14107_((double)targetBox.f_82290_), (int)Mth.m_14107_((double)targetBox.f_82291_), (int)Mth.m_14107_((double)targetBox.f_82292_), (int)Mth.m_14107_((double)targetBox.f_82293_))) {
                BlockState state = level.m_8055_(pos);
                Block block = state.m_60734_();
                if (block == Blocks.f_50033_ || block == Blocks.f_49991_) {
                    return false;
                }
                if (block != Blocks.f_50083_ && block != Blocks.f_50128_) continue;
                return false;
            }
        }
        return true;
    }
}

