/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.fates.powers;

import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.access.AccessFateFoodData;
import net.hydra.jojomod.access.IGravityEntity;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.event.ModEffects;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.fates.FatePowers;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.util.C2SPacketUtil;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.S2CPacketUtil;
import net.hydra.jojomod.util.config.ClientConfig;
import net.hydra.jojomod.util.config.ConfigManager;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class VampiricFate
extends FatePowers {
    public static final byte BLOOD_SUCK = 27;
    public static final byte BLOOD_SPEED = 28;
    public static final byte BLOOD_REGEN = 29;
    public static final byte WALL_WALK = 30;
    public Direction wallWalkDirection = Direction.DOWN;
    public float walkDistLast = 0.0f;
    public int speedActivated = 0;
    public int justFlippedTicks = 0;
    public final float bloodSpread = 3.0f;
    public final int duration = 100;
    public int mercyTicks = 0;
    public Entity bloodSuckingTarget = null;
    public float sunkRegen = 0.0f;
    public BlockState saveState = null;

    public VampiricFate(LivingEntity self) {
        super(self);
    }

    public VampiricFate() {
    }

    public Direction getWallWalkDirection() {
        return this.wallWalkDirection;
    }

    public void setWallWalkDirection(Direction dir) {
        this.wallWalkDirection = dir;
    }

    public void wallLatch() {
        Roundabout.LOGGER.info("2");
        if (this.canLatchOntoWall() && this.canWallWalkConfig()) {
            Roundabout.LOGGER.info("3");
            this.setCooldown((byte)12, 10);
            if (!this.self.m_9236_().m_5776_()) {
                if (this.saveState != null) {
                    this.self.m_9236_().m_5594_(null, this.self.m_20183_(), this.saveState.m_60827_().m_56775_(), SoundSource.PLAYERS, 1.0f, 0.9f);
                    this.blockBreakParticles(this.saveState.m_60734_(), new Vec3(this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_()));
                }
                this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.VAMPIRE_WALL_GRIP_EVENT, SoundSource.PLAYERS, 2.0f, 1.0f);
                Direction gd = RotationUtil.getRealFacingDirection2(this.self);
                this.setWallWalkDirection(gd);
                ((IGravityEntity)this.self).roundabout$setGravityDirection(gd);
                this.justFlippedTicks = 7;
            }
        }
    }

    public void blockBreakParticles(Block block, Vec3 pos) {
        if (!this.self.m_9236_().m_5776_()) {
            ((ServerLevel)this.self.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block.m_49966_()), pos.f_82479_, pos.f_82480_, pos.f_82481_, 100, 0.2, 0.2, 0.2, 0.5);
        }
    }

    public boolean isFast() {
        return this.speedActivated > 0;
    }

    public int getSpeedActivated() {
        return this.speedActivated;
    }

    public void setSpeedActivated(int sped) {
        this.speedActivated = sped;
    }

    @Override
    public void tickPower() {
        this.tickBloodSuck();
        this.tickSpeed();
        this.tickBloodRegen();
        super.tickPower();
        if (this.self.m_9236_().m_5776_()) {
            if (this.isPlantedInWall() && !this.getStandUserSelf().rdbt$getJumping() && !this.self.m_20096_() && this.self.m_20184_().f_82480_ < 0.0) {
                this.self.m_20256_(this.self.m_20184_().m_82520_(0.0, -0.14, 0.0));
            }
        } else {
            if (this.self.m_6069_()) {
                this.setWallWalkDirection(this.getIntendedDirection());
            }
            if (this.isPlantedInWall()) {
                if (this.justFlippedTicks > 0) {
                    --this.justFlippedTicks;
                } else {
                    boolean isOnValidBlock;
                    Vec3 newVec = new Vec3(0.0, -0.2, 0.0);
                    Vec3 newVec2 = new Vec3(0.0, -1.0, 0.0);
                    Vec3 newVec4 = new Vec3(0.0, -0.5, 0.0);
                    Vec3 newVec5 = new Vec3(0.0, -1.1, 0.0);
                    newVec = RotationUtil.vecPlayerToWorld(newVec, ((IGravityEntity)this.self).roundabout$getGravityDirection());
                    BlockPos pos = BlockPos.m_274446_((Position)this.self.m_20318_(1.0f).m_82549_(newVec));
                    newVec2 = RotationUtil.vecPlayerToWorld(newVec2, ((IGravityEntity)this.self).roundabout$getGravityDirection());
                    BlockPos pos2 = BlockPos.m_274446_((Position)this.self.m_20318_(1.0f).m_82549_(newVec2));
                    newVec4 = RotationUtil.vecPlayerToWorld(newVec4, ((IGravityEntity)this.self).roundabout$getGravityDirection());
                    BlockPos pos4 = BlockPos.m_274446_((Position)this.self.m_20318_(1.0f).m_82549_(newVec4));
                    newVec5 = RotationUtil.vecPlayerToWorld(newVec5, ((IGravityEntity)this.self).roundabout$getGravityDirection());
                    BlockPos pos5 = BlockPos.m_274446_((Position)this.self.m_20318_(1.0f).m_82549_(newVec5));
                    BlockState state1 = this.self.m_9236_().m_8055_(pos);
                    BlockState state2 = this.self.m_9236_().m_8055_(pos2);
                    BlockState state4 = this.self.m_9236_().m_8055_(pos4);
                    BlockState state5 = this.self.m_9236_().m_8055_(pos5);
                    boolean bl = isOnValidBlock = MainUtil.isBlockWalkableSimplified(state1) && MainUtil.isBlockWalkableSimplified(state4);
                    this.mercyTicks = this.self.m_20096_() && MainUtil.isBlockWalkableSimplified(this.self.m_20075_()) && isOnValidBlock ? 5 : (MainUtil.isBlockWalkable(this.self.m_9236_().m_8055_(pos)) || MainUtil.isBlockWalkable(this.self.m_9236_().m_8055_(pos2)) || MainUtil.isBlockWalkable(this.self.m_9236_().m_8055_(pos4)) || MainUtil.isBlockWalkable(this.self.m_9236_().m_8055_(pos5)) ? --this.mercyTicks : 0);
                    if (this.self.m_5803_() || (!this.self.m_20096_() || !isOnValidBlock) && this.mercyTicks <= 0 || this.self.m_20201_() != this.self) {
                        this.wallWalkDirection = this.getIntendedDirection();
                        ((IGravityEntity)this.self).roundabout$setGravityDirection(this.wallWalkDirection);
                        this.setWallWalkDirection(this.wallWalkDirection);
                    }
                }
            } else {
                this.setWallWalkDirection(this.getIntendedDirection());
            }
        }
    }

    public Direction getIntendedDirection() {
        Direction rightAxis = Direction.DOWN;
        MobEffectInstance mi = this.self.m_21124_(ModEffects.GRAVITY_FLIP);
        if (mi != null) {
            if (mi.m_19564_() == 0) {
                rightAxis = Direction.NORTH;
            }
            if (mi.m_19564_() == 1) {
                rightAxis = Direction.SOUTH;
            }
            if (mi.m_19564_() == 2) {
                rightAxis = Direction.EAST;
            }
            if (mi.m_19564_() == 3) {
                rightAxis = Direction.WEST;
            }
            if (mi.m_19564_() == 4) {
                rightAxis = Direction.UP;
            }
        }
        return rightAxis;
    }

    public void tickBloodRegen() {
        if (!this.self.m_9236_().m_5776_() && this.getActivePower() == 29) {
            Player PE;
            LivingEntity livingEntity = this.self;
            if (livingEntity instanceof Player && !(PE = (Player)livingEntity).m_7500_()) {
                PE.m_36324_().m_38705_(0);
            }
            float spreadX = (float)(Math.random() * 3.0 - 1.5);
            float spreadY = (float)(Math.random() * 3.0 - 1.5);
            float spreadZ = (float)(Math.random() * 3.0 - 1.5);
            Vec3 shotPos = new Vec3((double)spreadX, (double)spreadY, (double)spreadZ);
            Vec3 spawnPos = shotPos.m_82549_(this.self.m_20299_(1.0f));
            shotPos = shotPos.m_82559_(new Vec3(-1.0, -1.0, -1.0));
            ((ServerLevel)this.getSelf().m_9236_()).m_8767_((ParticleOptions)ModParticles.BLOOD_MIST, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, 0, shotPos.f_82479_, shotPos.f_82480_, shotPos.f_82481_, 0.03);
            float healthBack = this.sunkRegen / 100.0f * 0.9f;
            float health = this.self.m_21223_();
            float maxHealth = this.self.m_21233_();
            if (health < maxHealth) {
                if ((health += healthBack) < maxHealth) {
                    this.self.m_21153_(health);
                } else {
                    this.self.m_21153_(maxHealth);
                }
            }
            if (this.attackTimeDuring > 100 || this.self.m_21223_() >= maxHealth) {
                this.xTryPower((byte)0, true);
                this.stopSoundsIfNearby((byte)-6, 100.0, false);
                this.self.m_9236_().m_6263_(null, this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_(), ModSounds.BLOOD_REGEN_FINISH_EVENT, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public void tickSpeed() {
        if (this.isFast()) {
            LivingEntity livingEntity;
            this.setSpeedActivated(this.getSpeedActivated() - 1);
            if (!this.isFast() && (livingEntity = this.self) instanceof Player) {
                Player pl = (Player)livingEntity;
                if (this.self.m_9236_().m_5776_()) {
                    C2SPacketUtil.trySingleBytePacket((byte)32);
                } else {
                    S2CPacketUtil.sendGenericIntToClientPacket(pl, (byte)9, 0);
                }
            }
        }
    }

    public boolean isOnWrongAxis() {
        if (this.self.m_9236_().m_5776_()) {
            return ClientUtil.getDirectionRight(this.self);
        }
        Direction rightAxis = Direction.DOWN;
        MobEffectInstance mi = this.self.m_21124_(ModEffects.GRAVITY_FLIP);
        if (mi != null) {
            if (mi.m_19564_() == 0) {
                rightAxis = Direction.NORTH;
            }
            if (mi.m_19564_() == 1) {
                rightAxis = Direction.SOUTH;
            }
            if (mi.m_19564_() == 2) {
                rightAxis = Direction.EAST;
            }
            if (mi.m_19564_() == 3) {
                rightAxis = Direction.WEST;
            }
            if (mi.m_19564_() == 4) {
                rightAxis = Direction.UP;
            }
        }
        return ((IGravityEntity)this.self).roundabout$getGravityDirection() != rightAxis;
    }

    public void tickBloodSuck() {
        if (!this.self.m_9236_().m_5776_()) {
            Entity TE;
            if (this.self.m_6117_() && (this.bloodSuckingTarget != null || this.getActivePower() == 27)) {
                this.bloodSuckingTarget = null;
                this.xTryPower((byte)0, true);
            }
            if (this.bloodSuckingTarget != null && (TE = this.getTargetEntity(this.self, 3.0f, 15.0f)) != null && MainUtil.canDrinkBloodFair(TE, (Entity)this.self) && this.self.f_20916_ <= 0 && this.bloodSuckingTarget.m_7306_(TE)) {
                if (TE instanceof LivingEntity) {
                    LivingEntity LE = (LivingEntity)TE;
                    ((StandUser)LE).roundabout$setDazed((byte)3);
                    LE.m_20334_(0.0, (double)-0.1f, 0.0);
                }
                if (this.self.f_19797_ % 2 == 0) {
                    double random = Math.random() * 0.8 - 0.4;
                    double random2 = Math.random() * 0.8 - 0.4;
                    double random3 = Math.random() * 0.8 - 0.4;
                    SimpleParticleType particle = ModParticles.BLOOD;
                    if (MainUtil.hasBlueBlood(TE)) {
                        particle = ModParticles.BLUE_BLOOD;
                    }
                    ((ServerLevel)this.self.m_9236_()).m_8767_((ParticleOptions)particle, TE.m_20185_() + random, TE.m_20186_() + (double)TE.m_20192_() + random2, TE.m_20189_() + random3, 0, this.self.m_20185_() - TE.m_20185_(), this.self.m_20186_() - TE.m_20186_() + (double)TE.m_20192_(), this.self.m_20189_() - TE.m_20189_(), 0.08);
                }
            }
            if (this.getActivePower() == 27) {
                if (this.attackTimeDuring == 0 || this.attackTimeDuring == 5) {
                    this.self.m_9236_().m_6263_(null, this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_(), ModSounds.BLOOD_SUCK_EVENT, SoundSource.PLAYERS, 1.0f, 0.95f + (float)(Math.random() * 0.1));
                }
                if (this.attackTimeDuring >= 20) {
                    this.finishSucking();
                    this.bloodSuckingTarget = null;
                }
            }
        } else {
            Entity TE;
            if (!(this.bloodSuckingTarget == null || (TE = this.getTargetEntity(this.self, 3.0f, 15.0f)) != null && MainUtil.canDrinkBloodFair(TE, (Entity)this.self) && this.self.f_20916_ <= 0 && this.bloodSuckingTarget.m_7306_(TE))) {
                this.xTryPower((byte)0, true);
                C2SPacketUtil.cancelSuckingPacket();
                this.bloodSuckingTarget = null;
            }
            if (this.getActivePower() == 27 && this.attackTimeDuring >= 20 && this.isPacketPlayer() && this.attackTimeDuring == 20) {
                C2SPacketUtil.finishSuckingPacket();
            }
        }
    }

    public void packetFinish() {
        if (this.getActivePower() == 27) {
            this.finishSucking();
        }
    }

    public void packetCancel() {
        if (this.getActivePower() == 27) {
            this.xTryPower((byte)0, true);
        }
        this.bloodSuckingTarget = null;
    }

    public boolean canUseBloodSpeed() {
        Player PE;
        LivingEntity livingEntity = this.self;
        return livingEntity instanceof Player && (PE = (Player)livingEntity).m_36324_().m_38702_() >= 10 && !this.isFast() && this.getActivePower() != 29;
    }

    public boolean canUseRegen() {
        Player PE;
        LivingEntity livingEntity = this.self;
        return livingEntity instanceof Player && (PE = (Player)livingEntity).m_36324_().m_38702_() >= 1 && !this.isFast() && this.getActivePower() != 29;
    }

    public void regenClient() {
        if (this.canUseRegen() && !this.onCooldown((byte)15)) {
            this.tryPowerPacket((byte)29);
        }
    }

    public void bloodSpeedClient() {
        if (this.canLatchOntoWall() && this.canWallWalkConfig()) {
            this.doWallLatchClient();
        } else if (this.canUseBloodSpeed() && !this.onCooldown((byte)15)) {
            this.tryPowerPacket((byte)28);
        }
    }

    public void dashOrWallWalk() {
        if (this.canLatchOntoWall() && this.canWallWalkConfig()) {
            this.doWallLatchClient();
        } else if (!this.isPlantedInWall()) {
            this.dash();
        }
    }

    public void doWallLatchClient() {
        if (!this.onCooldown((byte)12)) {
            Roundabout.LOGGER.info("0");
            this.tryPower(30, true);
            this.tryPowerPacket((byte)30);
        }
    }

    public void bloodRegen() {
        if (this.canUseRegen()) {
            Player PE;
            LivingEntity livingEntity = this.self;
            if (livingEntity instanceof Player && !(PE = (Player)livingEntity).m_7500_()) {
                int foodLevel = PE.m_36324_().m_38702_();
                this.sunkRegen = foodLevel;
                PE.m_36324_().m_38705_(0);
            }
            this.setAttackTimeDuring(0);
            this.setActivePower((byte)29);
            this.playSoundsIfNearby((byte)-6, 100.0, true);
        }
    }

    public void bloodSpeed() {
        if (this.canUseBloodSpeed()) {
            Player PE;
            LivingEntity livingEntity = this.self;
            if (livingEntity instanceof Player && !(PE = (Player)livingEntity).m_7500_()) {
                int foodLevel = PE.m_36324_().m_38702_();
                PE.m_36324_().m_38705_(foodLevel - 10);
            }
            this.setFast();
            this.self.m_9236_().m_6263_(null, this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_(), ModSounds.BLOOD_SPEED_EVENT, SoundSource.PLAYERS, 1.0f, 0.95f + (float)(Math.random() * 0.1));
        }
    }

    public boolean isVisionOn() {
        ClientConfig clientConfig = ConfigManager.getClientConfig();
        if (clientConfig != null && clientConfig.dynamicSettings != null) {
            return clientConfig.dynamicSettings.vampireVisionMode;
        }
        return true;
    }

    @Override
    public boolean interceptAttack() {
        return this.getActivePower() == 27;
    }

    public void clientChangeVision() {
        ClientConfig clientConfig = ConfigManager.getClientConfig();
        if (clientConfig != null && clientConfig.dynamicSettings != null) {
            clientConfig.dynamicSettings.vampireVisionMode = clientConfig.dynamicSettings.vampireVisionMode == false;
            ConfigManager.saveClientConfig();
        }
    }

    public boolean isPlantedInWall() {
        return this.isOnWrongAxis();
    }

    public boolean forceBlock() {
        return !MainUtil.isBlockWalkableSimplified(this.self.m_9236_().m_8055_(this.self.m_20097_()));
    }

    public boolean canLatchOntoWall() {
        BlockState bs;
        if (this.onCooldown((byte)1) || this.self.m_6069_()) {
            return false;
        }
        if (this.forceBlock()) {
            return false;
        }
        if (this.self.m_20096_() && !this.isPlantedInWall() || !this.self.m_20096_() && this.isPlantedInWall()) {
            return false;
        }
        Vec3 mpos = this.self.m_20318_(1.0f);
        Direction gravdir = ((IGravityEntity)this.self).roundabout$getGravityDirection();
        switch (gravdir) {
            case DOWN: {
                mpos = mpos.m_82520_(0.0, (double)0.1f, 0.0);
                break;
            }
            case UP: {
                mpos = mpos.m_82520_(0.0, (double)-0.1f, 0.0);
                break;
            }
            case NORTH: {
                mpos = mpos.m_82520_(0.0, 0.0, (double)0.1f);
                break;
            }
            case SOUTH: {
                mpos = mpos.m_82520_(0.0, 0.0, (double)-0.1f);
                break;
            }
            case WEST: {
                mpos = mpos.m_82520_((double)0.1f, 0.0, 0.0);
                break;
            }
            case EAST: {
                mpos = mpos.m_82520_((double)-0.1f, 0.0, 0.0);
            }
        }
        BlockPos pos1 = BlockPos.m_274446_((Position)mpos);
        Direction rd = RotationUtil.getRealFacingDirection2(this.self);
        if (rd == gravdir) {
            return false;
        }
        pos1 = pos1.m_121945_(RotationUtil.getRealFacingDirection2(this.self));
        this.saveState = bs = this.self.m_9236_().m_8055_(pos1);
        return MainUtil.isBlockWalkable(bs);
    }

    public void finishSucking() {
        LivingEntity livingEntity;
        if (this.bloodSuckingTarget != null && (livingEntity = this.self) instanceof Player) {
            Entity entity;
            Player pl = (Player)livingEntity;
            boolean canDrainGood = MainUtil.canDrinkBloodCrit(this.bloodSuckingTarget, (Entity)this.self);
            DamageSource sauce = ModDamageTypes.of(this.self.m_9236_(), ModDamageTypes.BLOOD_DRAIN);
            if (this.bloodSuckingTarget.m_6469_(sauce, this.getSuckDamage()) && (entity = this.bloodSuckingTarget) instanceof LivingEntity) {
                LivingEntity LE = (LivingEntity)entity;
                if (canDrainGood) {
                    if (pl.m_36391_(false)) {
                        pl.m_36324_().m_38707_(6, 1.0f);
                    } else if (((AccessFateFoodData)pl.m_36324_()).rdbt$getRealSaturation() < 7.0f) {
                        pl.m_36324_().m_38707_(6, 0.5f);
                    } else {
                        pl.m_36324_().m_38707_(6, 0.0f);
                    }
                    this.self.m_9236_().m_6263_(null, this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_(), ModSounds.BLOOD_SUCK_DRAIN_EVENT, SoundSource.PLAYERS, 1.0f, 1.4f + (float)(Math.random() * 0.1));
                    this.self.m_9236_().m_6263_(null, this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_(), SoundEvents.f_12313_, SoundSource.PLAYERS, 1.0f, 1.0f + (float)(Math.random() * 0.1));
                    boolean $$23 = true;
                    ((ServerLevel)this.self.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123797_, this.bloodSuckingTarget.m_146892_().f_82479_, this.bloodSuckingTarget.m_146892_().f_82480_, this.bloodSuckingTarget.m_146892_().f_82481_, 15, 0.2, 0.2, 0.2, 0.0);
                } else {
                    this.self.m_9236_().m_6263_(null, this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_(), ModSounds.BLOOD_SUCK_DRAIN_EVENT, SoundSource.PLAYERS, 1.0f, 1.4f + (float)(Math.random() * 0.1));
                    pl.m_36324_().m_38707_(2, 0.0f);
                }
                MainUtil.makeBleed(this.bloodSuckingTarget, 0, 200, null);
            }
            this.bloodSuckingTarget = null;
            this.xTryPower((byte)0, true);
        }
    }

    public void suckBlood() {
        Entity TE;
        if (!this.onCooldown((byte)11) && (TE = this.getTargetEntity(this.self, 3.0f, 15.0f)) != null && MainUtil.canDrinkBloodFair(TE, (Entity)this.self) && this.getActivePower() != 29) {
            this.setActivePower((byte)27);
            this.self.m_6858_(false);
            this.tryIntPowerPacket((byte)27, TE.m_19879_());
            this.bloodSuckingTarget = TE;
            this.attackTimeDuring = 0;
            this.setCooldown((byte)11, 44);
        }
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        if (this.activePower == 27 && move != 27 && !this.self.m_9236_().m_5776_()) {
            super.setPlayerPos2((byte)0);
        }
        return super.tryPower(move, forced);
    }

    @Override
    public float getJumpDamageMult() {
        return 0.5f;
    }

    @Override
    public boolean tryIntPower(int move, boolean forced, int chargeTime) {
        if (move == 27) {
            this.bloodSuckingTarget = this.self.m_9236_().m_6815_(chargeTime);
            this.setActivePower((byte)27);
            this.self.m_6858_(false);
            if (!this.self.m_9236_().m_5776_()) {
                super.setPlayerPos2((byte)1);
            }
            this.attackTimeDuring = 0;
            if (this.bloodSuckingTarget != null) {
                this.bloodSuckingTarget.m_20256_(Vec3.f_82478_);
            }
        }
        return super.tryIntPower(move, forced, chargeTime);
    }

    @Override
    public float inputSpeedModifiers(float basis) {
        if (this.isPlantedInWall()) {
            basis *= 0.5f;
        }
        if (this.getActivePower() == 27) {
            basis *= 0.2f;
        } else if (this.getActivePower() == 29) {
            basis *= 0.1f;
        } else if (this.isFast()) {
            basis *= 2.0f;
        }
        return basis;
    }

    public void setFast() {
        this.speedActivated = 120;
        if (!this.self.m_9236_().m_5776_()) {
            LivingEntity livingEntity = this.self;
            if (livingEntity instanceof Player) {
                Player pl = (Player)livingEntity;
                S2CPacketUtil.sendGenericIntToClientPacket(pl, (byte)9, this.speedActivated);
            }
            this.speedActivated += 60;
        }
    }

    @Override
    public float zoomMod() {
        if (this.getActivePower() == 27) {
            return 0.6f;
        }
        if (this.isFast()) {
            return 1.1f;
        }
        return 1.0f;
    }

    @Override
    public boolean setPowerOther(int move, int lastMove) {
        if (move == 28) {
            this.bloodSpeed();
        } else if (move == 29) {
            this.bloodRegen();
        }
        return super.setPowerOther(move, lastMove);
    }

    @Override
    public void renderAttackHud(GuiGraphics context, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
        Entity TE;
        StandUser standUser = (StandUser)playerEntity;
        boolean standOn = standUser.roundabout$getActive();
        int j = scaledHeight / 2 - 7 - 4;
        int k = scaledWidth / 2 - 8 - 1;
        if (!standOn && (TE = this.getTargetEntity((LivingEntity)playerEntity, 3.0f, 15.0f)) != null && MainUtil.canDrinkBloodFair(TE, (Entity)this.self)) {
            LivingEntity LE;
            if (this.getActivePower() == 27) {
                int test = (int)(0.85f * (float)Mth.m_14045_((int)this.attackTimeDuring, (int)0, (int)20));
                context.m_280218_(StandIcons.JOJO_ICONS, k, j, 192, 36, 17, 8);
                context.m_280218_(StandIcons.JOJO_ICONS, k, j, 192, 44, 17 - test, 8);
            } else if (TE instanceof LivingEntity && (LE = (LivingEntity)TE).m_21223_() - this.getSuckDamage() <= 0.0f) {
                context.m_280218_(StandIcons.JOJO_ICONS, k, j, 192, 52, 17, 8);
            } else {
                context.m_280218_(StandIcons.JOJO_ICONS, k, j, 192, 44, 17, 8);
            }
        }
    }

    public float getSuckDamage() {
        return 4.0f;
    }

    @Override
    public boolean cancelSprintJump() {
        return this.getActivePower() == 27 || this.getActivePower() == 29;
    }

    @Override
    public boolean cancelSprint() {
        return this.getActivePower() == 27 || this.getActivePower() == 29;
    }

    @Override
    public boolean cancelSprintParticles() {
        return this.getActivePower() == 27 || this.getActivePower() == 29 || this.isPlantedInWall();
    }

    @Override
    public boolean cancelJump() {
        return this.getActivePower() == 29;
    }

    @Override
    public boolean isAttackIneptVisually(byte activeP, int slot) {
        Entity TE = this.getUserData(this.self).roundabout$getStandPowers().getTargetEntity(this.self, 3.0f, 15.0f);
        if (slot == 2 && !MainUtil.canDrinkBloodFair(TE, (Entity)this.self) && !this.isHoldingSneak()) {
            return true;
        }
        return super.isAttackIneptVisually(activeP, slot);
    }

    public boolean canWallWalkConfig() {
        return ClientNetworking.getAppropriateConfig().walkingHeartSettings.enableWallWalking;
    }

    @Override
    public ResourceLocation getIconYes(int slot) {
        if ((slot == 2 || slot == 3) && this.isHoldingSneak()) {
            return StandIcons.SQUARE_ICON_BLOOD;
        }
        return StandIcons.SQUARE_ICON;
    }
}

