/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.item;

import java.util.List;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.stand.powers.PowersD4C;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.zetalasis.world.DynamicWorld;
import org.jetbrains.annotations.Nullable;

public class InterdimensionalKeyItem
extends Item {
    public static final String LINKED_DIM_KEY = "LinkedDimension";
    private static final ResourceLocation EMPTY = new ResourceLocation("roundabout", "empty");

    public static ResourceLocation getLinkedDimension(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_(LINKED_DIM_KEY)) {
            return ResourceLocation.m_135820_((String)tag.m_128461_(LINKED_DIM_KEY));
        }
        return EMPTY;
    }

    public static void setLinkedDimension(ItemStack stack, ResourceLocation dimension) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_(LINKED_DIM_KEY, dimension.toString());
    }

    public static boolean isLinked(ItemStack stack) {
        return !InterdimensionalKeyItem.getLinkedDimension(stack).equals((Object)EMPTY);
    }

    public InterdimensionalKeyItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        if (InterdimensionalKeyItem.isLinked(player.m_21120_(hand))) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        StandPowers standPowers = ((StandUser)player).roundabout$getStandPowers();
        if (standPowers instanceof PowersD4C) {
            PowersD4C d4c = (PowersD4C)standPowers;
            if (!DynamicWorld.isWorldDynamic(level)) {
                return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
            }
            InterdimensionalKeyItem.setLinkedDimension(player.m_21120_(hand), level.m_46472_().m_135782_());
            player.m_5661_((Component)Component.m_237115_((String)"item.roundabout.interdimensional_key.success"), true);
            return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
        }
        player.m_5661_((Component)Component.m_237115_((String)"item.roundabout.interdimensional_key.error"), true);
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> hoverText, TooltipFlag tooltipFlag) {
        hoverText.add((Component)(InterdimensionalKeyItem.isLinked(stack) ? Component.m_237115_((String)"item.roundabout.interdimensional_key.linked") : Component.m_237115_((String)"item.roundabout.interdimensional_key.unlinked")));
        if (tooltipFlag.m_7050_()) {
            hoverText.add((Component)Component.m_237113_((String)("\u00a78\u00a7o" + InterdimensionalKeyItem.getLinkedDimension(stack).toString() + "\u00a7r")));
        }
        super.m_7373_(stack, level, hoverText, tooltipFlag);
    }
}

