/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.item;

import java.util.List;
import javax.annotation.Nullable;
import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.entity.projectile.RoundaboutBulletEntity;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.item.FirearmItem;
import net.hydra.jojomod.item.SnubnoseAmmoItem;
import net.hydra.jojomod.sound.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.Level;

public class SnubnoseRevolverItem
extends FirearmItem
implements Vanishable {
    private static final String AMMO_COUNT_TAG = "AmmoCount";
    int maxAmmo = 6;

    public SnubnoseRevolverItem(Item.Properties $$0) {
        super($$0);
    }

    public boolean m_8120_(ItemStack p_41456_) {
        return false;
    }

    private int getAmmo(ItemStack stack) {
        return stack.m_41784_().m_128451_(AMMO_COUNT_TAG);
    }

    private void setAmmo(ItemStack stack, int count) {
        stack.m_41784_().m_128405_(AMMO_COUNT_TAG, count);
    }

    public UseAnim m_6164_(ItemStack $$0) {
        return UseAnim.BOW;
    }

    private boolean hasSnubnoseAmmo(Player player) {
        Inventory inv = player.m_150109_();
        for (ItemStack stack : inv.f_35974_) {
            if (!(stack.m_41720_() instanceof SnubnoseAmmoItem) || stack.m_41613_() <= 0) continue;
            return true;
        }
        for (ItemStack stack : inv.f_35976_) {
            if (!(stack.m_41720_() instanceof SnubnoseAmmoItem) || stack.m_41613_() <= 0) continue;
            return true;
        }
        return player.m_7500_();
    }

    private int consumeSnubnoseAmmo(Player player, int amount) {
        int remove;
        ItemStack stack;
        int i;
        Inventory inv = player.m_150109_();
        int consumed = 0;
        for (i = 0; i < inv.f_35974_.size() && amount > 0; ++i) {
            stack = (ItemStack)inv.f_35974_.get(i);
            if (!(stack.m_41720_() instanceof SnubnoseAmmoItem)) continue;
            remove = Math.min(stack.m_41613_(), amount);
            stack.m_41774_(remove);
            consumed += remove;
            if ((amount -= remove) <= 0) break;
        }
        for (i = 0; i < inv.f_35976_.size() && amount > 0; ++i) {
            stack = (ItemStack)inv.f_35976_.get(i);
            if (!(stack.m_41720_() instanceof SnubnoseAmmoItem)) continue;
            remove = Math.min(stack.m_41613_(), amount);
            stack.m_41774_(remove);
            consumed += remove;
            if ((amount -= remove) <= 0) break;
        }
        if (player.m_7500_()) {
            return this.maxAmmo;
        }
        return consumed;
    }

    @Override
    public void fireBullet(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (this.getAmmo(itemStack) > 0) {
            if (!player.m_7500_()) {
                this.setAmmo(itemStack, this.getAmmo(itemStack) - 1);
            }
            Player livingEntity = player;
            RoundaboutBulletEntity $$7 = new RoundaboutBulletEntity(level, (LivingEntity)livingEntity);
            $$7.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 4.0f, 0.0f);
            level.m_7967_((Entity)$$7);
            level.m_6269_(null, (Entity)player, ModSounds.SNUBNOSE_FIRE_EVENT, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (livingEntity != null && ((StandUser)livingEntity).roundabout$isBubbleEncased()) {
                StandUser SE = (StandUser)livingEntity;
                if (!level.m_5776_()) {
                    SE.roundabout$setBubbleEncased((byte)0);
                    level.m_5594_(null, livingEntity.m_20183_(), ModSounds.BUBBLE_POP_EVENT, SoundSource.PLAYERS, 2.0f, (float)(0.98 + Math.random() * 0.04));
                    ((ServerLevel)level).m_8767_((ParticleOptions)ModParticles.BUBBLE_POP, livingEntity.m_20185_(), livingEntity.m_20186_() + (double)livingEntity.m_20206_() * 0.5, livingEntity.m_20189_(), 5, 0.25, 0.25, 0.25, 0.025);
                }
            }
            player.m_36335_().m_41524_((Item)this, 5);
        } else {
            level.m_6269_(null, (Entity)player, ModSounds.SNUBNOSE_DRY_FIRE_EVENT, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer SP = (ServerPlayer)player;
                SP.m_5661_((Component)Component.m_237115_((String)"text.roundabout.out_of_bullets").m_130940_(ChatFormatting.LIGHT_PURPLE), true);
            }
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        super.m_7203_(level, player, hand);
        ItemStack itemStack = player.m_21120_(hand);
        if (!(itemStack.m_41720_() instanceof SnubnoseRevolverItem)) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        if (player.m_21211_() != itemStack) {
            if (player.m_6047_() && this.hasSnubnoseAmmo(player) && this.getAmmo(itemStack) != this.maxAmmo || player.m_6047_() && player.m_7500_()) {
                int currentAmmo = this.getAmmo(itemStack);
                int ammoNeeded = this.maxAmmo - currentAmmo;
                int ammoLoaded = this.consumeSnubnoseAmmo(player, ammoNeeded);
                if (ammoLoaded > 0) {
                    if (player.m_7500_()) {
                        this.setAmmo(itemStack, this.maxAmmo);
                    } else {
                        this.setAmmo(itemStack, currentAmmo + ammoLoaded);
                        player.m_36335_().m_41524_((Item)this, 60);
                    }
                    level.m_6269_(null, (Entity)player, ModSounds.SNUBNOSE_RELOAD_EVENT, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            } else {
                Roundabout.LOGGER.info("Started using gun");
                player.m_6672_(hand);
            }
        }
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        int ammo = this.getAmmo(stack);
        tooltip.add((Component)Component.m_237113_((String)("Ammo: " + ammo + " / " + this.maxAmmo)).m_130940_(ChatFormatting.GRAY));
    }
}

