/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.mixin.forge;

import net.hydra.jojomod.util.gravity.GravityAPI;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.client.renderer.ScreenEffectRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ScreenEffectRenderer.class})
public class ForgeScreenEffectRenderer {
    @Inject(method={"getOverlayBlock(Lnet/minecraft/world/entity/player/Player;)Lorg/apache/commons/lang3/tuple/Pair;"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void roundabout$getOverlayBlock(Player player, CallbackInfoReturnable<Pair<BlockState, BlockPos>> cir) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)player);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        Vector3f multipliers = RotationUtil.vecPlayerToWorld(player.m_20205_() * 0.8f, 0.1f, player.m_20205_() * 0.8f, gravityDirection);
        for (int i = 0; i < 8; ++i) {
            double d0 = player.m_20185_() + (double)(((float)((i >> 0) % 2) - 0.5f) * multipliers.x());
            double d1 = player.m_20188_() + (double)(((float)((i >> 1) % 2) - 0.5f) * multipliers.y());
            double d2 = player.m_20189_() + (double)(((float)((i >> 2) % 2) - 0.5f) * multipliers.z());
            blockpos$mutableblockpos.m_122169_(d0, d1, d2);
            BlockState blockstate = player.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos);
            if (blockstate.m_60799_() == RenderShape.INVISIBLE || !blockstate.m_60831_((BlockGetter)player.m_9236_(), (BlockPos)blockpos$mutableblockpos)) continue;
            cir.setReturnValue((Object)Pair.of((Object)blockstate, (Object)blockpos$mutableblockpos.m_7949_()));
        }
        cir.setReturnValue(null);
    }
}

