/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.mixin.gravity;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.List;
import java.util.Objects;
import net.hydra.jojomod.access.IClientEntity;
import net.hydra.jojomod.access.IFatePlayer;
import net.hydra.jojomod.access.IGravityEntity;
import net.hydra.jojomod.entity.projectile.CinderellaVisageDisplayEntity;
import net.hydra.jojomod.entity.projectile.CrossfireHurricaneEntity;
import net.hydra.jojomod.entity.stand.FollowingStandEntity;
import net.hydra.jojomod.event.ModEffects;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.fates.powers.VampiricFate;
import net.hydra.jojomod.networking.ModPacketHandler;
import net.hydra.jojomod.stand.powers.PowersWalkingHeart;
import net.hydra.jojomod.util.GEntityTags;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.RotationAnimation;
import net.hydra.jojomod.util.RotationParameters;
import net.hydra.jojomod.util.gravity.GravityAPI;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={Entity.class}, priority=100)
public abstract class GravityEntityMixin
implements IGravityEntity {
    @Shadow
    public boolean f_185931_;
    @Shadow
    public boolean f_19863_;
    @Shadow
    public boolean f_19862_;
    @Shadow
    public boolean f_201939_;
    @Shadow
    public float f_19788_;
    @Shadow
    public float f_19867_;
    @Shadow
    public float f_19787_;
    @Shadow
    public double f_19792_;
    @Shadow
    public double f_19791_;
    @Shadow
    public double f_19790_;
    @Shadow
    public int f_19797_;
    @Unique
    private static final EntityDataAccessor<Direction> ROUNDABOUT$GRAVITY_DIRECTION = SynchedEntityData.m_135353_(Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    @Unique
    private static boolean rdbdt$taggedForFlip;
    @Unique
    private boolean roundabout$initialized = false;
    @Unique
    private Direction roundabout$prevGravityDirection = Direction.DOWN;
    @Unique
    private double roundabout$prevGravityStrength = 1.0;
    @Unique
    Direction roundabout$baseGravityDirection = Direction.DOWN;
    @Unique
    private static double roundabout$baseGravityStrength;
    @Nullable
    RotationParameters roundabout$currentRotationParameters = RotationParameters.getDefault();
    @Unique
    private double roundabout$currGravityStrength = 1.0;
    @Unique
    private double roundabout$currentEffectPriority = Double.MIN_VALUE;
    @Unique
    private long roundabout$lastUpdateTickCount = 0L;
    public int rdbt$noSuffocateTicks = 0;
    @Shadow
    private Vec3 f_19825_;
    @Shadow
    private EntityDimensions f_19815_;
    @Shadow
    private float f_19816_;
    @Shadow
    public double f_19854_;
    @Shadow
    public double f_19855_;
    @Shadow
    public double f_19856_;
    @Shadow
    public Level f_19853_;
    @Shadow
    public boolean f_19794_;
    @Shadow
    @Final
    protected RandomSource f_19796_;
    @Shadow
    public float f_19789_;
    @Shadow
    @Final
    protected SynchedEntityData f_19804_;
    @Shadow
    private boolean f_19861_;
    @Shadow
    private float f_19793_;
    @Shadow
    protected Object2DoubleMap<TagKey<Fluid>> f_19799_;

    @Shadow
    public abstract boolean m_20077_();

    @Shadow
    @Deprecated
    public abstract BlockPos m_216999_();

    @Shadow
    protected abstract boolean m_196406_(Vec3 var1);

    @Shadow
    public abstract Vec3 m_20156_();

    @Shadow
    public abstract float m_20205_();

    @Shadow
    public abstract Vec3 m_20318_(float var1);

    @Shadow
    public abstract Vec2 m_20155_();

    @Shadow
    @Nullable
    public abstract LivingEntity m_6688_();

    @Shadow
    public abstract boolean m_6109_();

    @Shadow
    public abstract double m_6048_();

    @Shadow
    public abstract boolean m_20363_(Entity var1);

    @Shadow
    public abstract boolean m_20096_();

    @Shadow
    protected abstract boolean m_285776_(BlockState var1);

    @Shadow
    public abstract BlockPos m_20097_();

    @Shadow
    protected abstract Vec3 m_20272_(Vec3 var1);

    @Shadow
    public abstract void m_146884_(Vec3 var1);

    @Shadow
    protected abstract AABB m_142242_();

    @Shadow
    public abstract void m_20011_(AABB var1);

    @Shadow
    @Nullable
    public abstract Entity m_20202_();

    @Override
    @Unique
    public Direction roundabout$getGravityDirection() {
        if (this.f_19804_.m_285897_(ROUNDABOUT$GRAVITY_DIRECTION)) {
            return (Direction)this.m_20088_().m_135370_(ROUNDABOUT$GRAVITY_DIRECTION);
        }
        return Direction.DOWN;
    }

    @Override
    @Unique
    public void roundabout$setBaseGravityDirection(Direction gravityDirection) {
        if (!this.roundabout$canChangeGravity()) {
            return;
        }
        if (this.roundabout$baseGravityDirection != gravityDirection) {
            this.roundabout$baseGravityDirection = gravityDirection;
            this.roundabout$updateGravityStatus();
        }
    }

    @Override
    @Unique
    public int roundabout$getSuffocationTicks() {
        return this.rdbt$noSuffocateTicks;
    }

    @Override
    @Unique
    public void roundabout$setGravityDirection(Direction direction) {
        if (this.f_19804_.m_285897_(ROUNDABOUT$GRAVITY_DIRECTION)) {
            this.m_20088_().m_135381_(ROUNDABOUT$GRAVITY_DIRECTION, (Object)direction);
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V"}, at={@At(value="TAIL")})
    public void roundabout$init(EntityType $$0, Level $$1, CallbackInfo ci) {
        if (!((Entity)this).m_20088_().m_285897_(ROUNDABOUT$GRAVITY_DIRECTION)) {
            ((Entity)this).m_20088_().m_135372_(ROUNDABOUT$GRAVITY_DIRECTION, (Object)Direction.DOWN);
        }
    }

    @Override
    @Unique
    public void rdbdt$setTaggedForFlip(boolean flip) {
        rdbdt$taggedForFlip = flip;
    }

    @Override
    @Unique
    public double roundabout$getGravityStrength() {
        return this.roundabout$currGravityStrength;
    }

    @Override
    @Unique
    public void roundabout$setGravityStrength(double str) {
        this.roundabout$currGravityStrength = str;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void roundabout$tickGrav(CallbackInfo ci) {
        if (!this.roundabout$canChangeGravity()) {
            return;
        }
        this.roundabout$updateGravityStatus();
        this.roundabout$applyGravityChange();
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void roundabout$tickGravTail(CallbackInfo ci) {
        if (!this.roundabout$canChangeGravity()) {
            return;
        }
        this.roundabout$updateGravityStatus();
        this.roundabout$applyGravityChange();
        if (this.rdbt$noSuffocateTicks > 0) {
            --this.rdbt$noSuffocateTicks;
        }
    }

    @Override
    @Unique
    public void roundabout$applyGravityChange() {
        if (!this.roundabout$canChangeGravity()) {
            return;
        }
        if (this.roundabout$currentRotationParameters == null) {
            this.roundabout$currentRotationParameters = RotationParameters.getDefault();
        }
        if (this.roundabout$prevGravityDirection != this.roundabout$getGravityDirection()) {
            this.roundabout$applyGravityDirectionChange(this.roundabout$prevGravityDirection, this.roundabout$getGravityDirection(), this.roundabout$currentRotationParameters, false);
            this.roundabout$prevGravityDirection = this.roundabout$getGravityDirection();
        }
        if (Math.abs(this.roundabout$currGravityStrength - this.roundabout$prevGravityStrength) > 1.0E-4) {
            this.roundabout$prevGravityStrength = this.roundabout$currGravityStrength;
        }
    }

    @Override
    @Unique
    public boolean roundabout$canChangeGravity() {
        return GEntityTags.canChangeGravity((Entity)this);
    }

    @Unique
    public void roundabout$applyGravityDirectionChange(Direction oldGravity, Direction newGravity, RotationParameters rotationParameters, boolean isInitialization) {
        this.m_20011_(this.m_142242_());
        if (isInitialization) {
            return;
        }
        this.f_19789_ = 0.0f;
        long timeMs = this.m_9236_().m_46467_() * 50L;
        Vec3 relativeRotationCenter = GravityEntityMixin.roundabout$getLocalRotationCenter((Entity)this, oldGravity, newGravity, rotationParameters);
        Vec3 oldPos = this.m_20182_();
        Vec3 oldLastTickPos = new Vec3(this.f_19790_, this.f_19791_, this.f_19792_);
        Vec3 rotationCenter = oldPos.m_82549_(RotationUtil.vecPlayerToWorld(relativeRotationCenter, oldGravity));
        Vec3 newPos = rotationCenter.m_82546_(RotationUtil.vecPlayerToWorld(relativeRotationCenter, newGravity));
        Vec3 posTranslation = newPos.m_82546_(oldPos);
        Vec3 newLastTickPos = oldLastTickPos.m_82549_(posTranslation);
        this.m_146884_(newPos);
        this.f_19854_ = newLastTickPos.f_82479_;
        this.f_19855_ = newLastTickPos.f_82480_;
        this.f_19856_ = newLastTickPos.f_82481_;
        this.f_19790_ = newLastTickPos.f_82479_;
        this.f_19791_ = newLastTickPos.f_82480_;
        this.f_19792_ = newLastTickPos.f_82481_;
        this.roundabout$adjustEntityPosition(oldGravity, newGravity, this.m_20191_());
        if (this.m_9236_().m_5776_()) {
            RotationAnimation ani = ((IClientEntity)((Object)this)).roundabout$getGravityAnimation();
            Validate.notNull((Object)ani, (String)"gravity animation is null", (Object[])new Object[0]);
            int rotationTimeMS = rotationParameters.rotationTimeMS();
            ani.startRotationAnimation(newGravity, oldGravity, rotationTimeMS, (Entity)this, timeMs, rotationParameters.rotateView(), relativeRotationCenter);
        }
        Vec3 revGrav = new Vec3(0.0, 0.002, 0.0);
        Vec3 revGrav2 = new Vec3(0.0, 0.002, 0.0);
        revGrav = RotationUtil.vecPlayerToWorld(revGrav, oldGravity);
        revGrav2 = RotationUtil.vecPlayerToWorld(revGrav2, oldGravity);
        this.m_20256_(this.m_20184_().m_82520_(revGrav.f_82479_, revGrav.f_82480_, revGrav.f_82481_));
        Vec3 realWorldVelocity = GravityEntityMixin.roundabout$getRealWorldVelocity((Entity)this, oldGravity);
        this.m_20256_(new Vec3(0.0, 0.0, 0.0));
        this.rdbt$noSuffocateTicks = 20;
        Vec3 yes = this.m_20318_(1.0f).m_82549_(revGrav2);
        BlockPos bpos = new BlockPos((int)yes.f_82479_, (int)yes.f_82480_, (int)yes.f_82481_);
        if (!this.f_19853_.m_8055_(bpos).m_280296_()) {
            this.m_146884_(yes);
        }
    }

    @Unique
    private void roundabout$adjustEntityPosition(Direction oldGravity, Direction newGravity, AABB entityBoundingBox) {
        Entity ent = (Entity)this;
        if (ent instanceof AreaEffectCloud || ent instanceof AbstractArrow || ent instanceof EndCrystal) {
            return;
        }
        Direction movingDirection = oldGravity.m_122424_();
        Iterable collisions = ent.m_9236_().m_186431_(ent, entityBoundingBox.m_82400_(-0.01));
        AABB totalCollisionBox = null;
        for (VoxelShape collision : collisions) {
            if (collision.m_83281_()) continue;
            AABB boundingBox = collision.m_83215_();
            if (totalCollisionBox == null) {
                totalCollisionBox = boundingBox;
                continue;
            }
            totalCollisionBox = totalCollisionBox.m_82367_(boundingBox);
        }
        if (totalCollisionBox != null) {
            Vec3 positionAdjustmentOffset = GravityEntityMixin.roundabout$getPositionAdjustmentOffset(entityBoundingBox, totalCollisionBox, movingDirection);
            ent.m_146884_(ent.m_20182_().m_82549_(positionAdjustmentOffset));
        }
    }

    @Unique
    private static Vec3 roundabout$getPositionAdjustmentOffset(AABB entityBoundingBox, AABB nearbyCollisionUnion, Direction movingDirection) {
        Direction.Axis axis = movingDirection.m_122434_();
        double offset = 0.0;
        if (movingDirection.m_122421_() == Direction.AxisDirection.POSITIVE) {
            double pushed;
            double pushing = nearbyCollisionUnion.m_82374_(axis);
            if (pushing > (pushed = entityBoundingBox.m_82340_(axis))) {
                offset = pushing - pushed;
            }
        } else {
            double pushed;
            double pushing = nearbyCollisionUnion.m_82340_(axis);
            if (pushing < (pushed = entityBoundingBox.m_82374_(axis))) {
                offset = pushed - pushing;
            }
        }
        return new Vec3(movingDirection.m_253071_()).m_82490_(offset);
    }

    @Unique
    @NotNull
    private static Vec3 roundabout$getLocalRotationCenter(Entity entity, Direction oldGravity, Direction newGravity, RotationParameters rotationParameters) {
        if (entity instanceof EndCrystal) {
            return new Vec3(0.0, -0.5, 0.0);
        }
        EntityDimensions dimensions = entity.m_6972_(entity.m_20089_());
        if (newGravity.m_122424_() == oldGravity) {
            return new Vec3(0.0, (double)(dimensions.f_20378_ / 2.0f), 0.0);
        }
        return Vec3.f_82478_;
    }

    @Unique
    private static Vec3 roundabout$getRealWorldVelocity(Entity entity, Direction prevGravityDirection) {
        if (entity.m_6109_()) {
            return new Vec3(entity.m_20185_() - entity.f_19854_, entity.m_20186_() - entity.f_19855_, entity.m_20189_() - entity.f_19856_);
        }
        return RotationUtil.vecPlayerToWorld(entity.m_20184_(), prevGravityDirection);
    }

    @Unique
    public Entity rdbt$this() {
        return (Entity)this;
    }

    @Override
    @Unique
    public void roundabout$updateGravityStatus() {
        Direction oldGravityDirection = this.roundabout$getGravityDirection();
        double oldGravityStrength = this.roundabout$currGravityStrength;
        if (!this.f_19853_.m_5776_()) {
            Entity vehicle = this.m_20202_();
            if (vehicle != null) {
                this.roundabout$setGravityDirection(GravityAPI.getGravityDirection(vehicle));
                this.roundabout$currGravityStrength = GravityAPI.getGravityStrength(vehicle);
            } else {
                FollowingStandEntity SE;
                Entity entity = this.rdbt$this();
                if (entity instanceof FollowingStandEntity && (SE = (FollowingStandEntity)entity).getFollowingAggressive() != null) {
                    this.roundabout$setGravityDirection(GravityAPI.getGravityDirection((Entity)SE.getFollowingAggressive()));
                    this.roundabout$currGravityStrength = GravityAPI.getGravityStrength((Entity)SE.getFollowingAggressive());
                } else {
                    CinderellaVisageDisplayEntity CD;
                    entity = this.rdbt$this();
                    if (entity instanceof CinderellaVisageDisplayEntity && (CD = (CinderellaVisageDisplayEntity)entity).getStandUser() != null) {
                        this.roundabout$setGravityDirection(GravityAPI.getGravityDirection((Entity)CD.getStandUser()));
                        this.roundabout$currGravityStrength = GravityAPI.getGravityStrength((Entity)CD.getStandUser());
                    } else {
                        CrossfireHurricaneEntity CD2;
                        entity = this.rdbt$this();
                        if (entity instanceof CrossfireHurricaneEntity && (CD2 = (CrossfireHurricaneEntity)entity).getUser() != null && CD2.getCrossNumber() != 7) {
                            this.roundabout$setGravityDirection(GravityAPI.getGravityDirection((Entity)CD2.getUser()));
                            this.roundabout$currGravityStrength = GravityAPI.getGravityStrength((Entity)CD2.getUser());
                        } else {
                            LivingEntity LE;
                            entity = this.rdbt$this();
                            if (entity instanceof LivingEntity && (LE = (LivingEntity)entity).m_5803_()) {
                                this.roundabout$setGravityDirection(Direction.DOWN);
                            } else if (!this.f_19853_.m_5776_()) {
                                PowersWalkingHeart PW;
                                LivingEntity LE2;
                                Direction dr = Direction.DOWN;
                                Object object = this.rdbt$this();
                                if (object instanceof LivingEntity && (object = ((StandUser)(LE2 = (LivingEntity)object)).roundabout$getStandPowers()) instanceof PowersWalkingHeart && (PW = (PowersWalkingHeart)object).hasExtendedHeelsForWalking()) {
                                    dr = PW.getHeelDirection();
                                } else {
                                    VampiricFate VP;
                                    Player pl;
                                    object = this.rdbt$this();
                                    if (object instanceof Player && (object = ((IFatePlayer)(pl = (Player)object)).rdbt$getFatePowers()) instanceof VampiricFate && (VP = (VampiricFate)object).getWallWalkDirection() != VP.getIntendedDirection()) {
                                        dr = VP.getWallWalkDirection();
                                    } else {
                                        MobEffectInstance mi;
                                        LivingEntity LE3;
                                        object = this.rdbt$this();
                                        if (object instanceof LivingEntity && (LE3 = (LivingEntity)object).m_21023_(ModEffects.GRAVITY_FLIP) && (mi = LE3.m_21124_(ModEffects.GRAVITY_FLIP)) != null) {
                                            if (mi.m_19564_() == 0) {
                                                dr = Direction.NORTH;
                                            }
                                            if (mi.m_19564_() == 1) {
                                                dr = Direction.SOUTH;
                                            }
                                            if (mi.m_19564_() == 2) {
                                                dr = Direction.EAST;
                                            }
                                            if (mi.m_19564_() == 3) {
                                                dr = Direction.WEST;
                                            }
                                            if (mi.m_19564_() == 4) {
                                                dr = Direction.UP;
                                            }
                                        }
                                    }
                                }
                                this.roundabout$setGravityDirection(dr);
                            }
                        }
                    }
                }
            }
            if (this.roundabout$isReadyToResetGravity()) {
                this.roundabout$setGravityDirection(this.roundabout$baseGravityDirection);
                this.roundabout$currGravityStrength = roundabout$baseGravityStrength;
                if (this.roundabout$currentEffectPriority == Double.MIN_VALUE) {
                    this.roundabout$currentRotationParameters = RotationParameters.getDefault();
                }
            }
            this.roundabout$lastUpdateTickCount = this.f_19797_;
        }
    }

    @Unique
    public boolean roundabout$isReadyToResetGravity() {
        return false;
    }

    @Inject(method={"makeBoundingBox()Lnet/minecraft/world/phys/AABB;"}, at={@At(value="RETURN")}, cancellable=true)
    private void inject_calculateBoundingBox(CallbackInfoReturnable<AABB> cir) {
        Entity entity = (Entity)this;
        if (entity instanceof Projectile) {
            return;
        }
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        AABB box = ((AABB)cir.getReturnValue()).m_82383_(this.f_19825_.m_82548_());
        if (gravityDirection.m_122421_() == Direction.AxisDirection.POSITIVE) {
            box = box.m_82386_(0.0, -1.0E-6, 0.0);
        }
        cir.setReturnValue((Object)RotationUtil.boxPlayerToWorld(box, gravityDirection).m_82383_(this.f_19825_));
    }

    @Inject(method={"calculateViewVector(FF)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="RETURN")}, cancellable=true)
    private void inject_getRotationVector(CallbackInfoReturnable<Vec3> cir) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        cir.setReturnValue((Object)RotationUtil.vecPlayerToWorld((Vec3)cir.getReturnValue(), gravityDirection));
    }

    @Inject(method={"getBlockPosBelowThatAffectsMyMovement()Lnet/minecraft/core/BlockPos;"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_getVelocityAffectingPos(CallbackInfoReturnable<BlockPos> cir) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        cir.setReturnValue((Object)BlockPos.m_274446_((Position)this.f_19825_.m_82549_(Vec3.m_82528_((Vec3i)gravityDirection.m_122436_()).m_82490_(0.5000001))));
    }

    @Inject(method={"getEyePosition()Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_getEyePos(CallbackInfoReturnable<Vec3> cir) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        cir.setReturnValue((Object)RotationUtil.vecPlayerToWorld(0.0, (double)this.f_19816_, 0.0, gravityDirection).m_82549_(this.f_19825_));
    }

    @Inject(method={"getEyePosition(F)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_getCameraPosVec(float tickDelta, CallbackInfoReturnable<Vec3> cir) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        Vec3 vec3d = RotationUtil.vecPlayerToWorld(0.0, (double)this.f_19816_, 0.0, gravityDirection);
        double d = Mth.m_14139_((double)tickDelta, (double)this.f_19854_, (double)this.m_20185_()) + vec3d.f_82479_;
        double e = Mth.m_14139_((double)tickDelta, (double)this.f_19855_, (double)this.m_20186_()) + vec3d.f_82480_;
        double f = Mth.m_14139_((double)tickDelta, (double)this.f_19856_, (double)this.m_20189_()) + vec3d.f_82481_;
        cir.setReturnValue((Object)new Vec3(d, e, f));
    }

    @Inject(method={"getLightLevelDependentMagicValue()F"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_getBrightnessAtFEyes(CallbackInfoReturnable<Float> cir) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        cir.setReturnValue((Object)Float.valueOf(this.f_19853_.m_151577_(this.m_146903_(), this.m_146907_()) ? this.f_19853_.m_220417_(BlockPos.m_274446_((Position)this.m_146892_())) : 0.0f));
    }

    @ModifyVariable(method={"move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private Vec3 modify_move_Vec3d_0_0(Vec3 vec3d) {
        Player PE;
        Entity entity;
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (rdbdt$taggedForFlip) {
            rdbdt$taggedForFlip = false;
            vec3d = RotationUtil.vecWorldToPlayer(vec3d, gravityDirection).m_82520_(0.0, -0.012, 0.0);
        } else if (gravityDirection != Direction.DOWN && (entity = this.rdbt$this()) instanceof Player && !(PE = (Player)entity).m_21255_() && !PE.m_150110_().f_35935_ && !PE.m_5833_()) {
            vec3d = vec3d.m_82520_(0.0, -0.012, 0.0);
        }
        if (gravityDirection == Direction.DOWN) {
            return vec3d;
        }
        return RotationUtil.vecPlayerToWorld(vec3d, gravityDirection);
    }

    @ModifyVariable(method={"move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;pop()V", ordinal=0), ordinal=0, argsOnly=true)
    private Vec3 modify_move_Vec3d_0_1(Vec3 vec3d) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return vec3d;
        }
        return RotationUtil.vecWorldToPlayer(vec3d, gravityDirection);
    }

    @ModifyVariable(method={"move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;pop()V", ordinal=0), ordinal=1)
    private Vec3 modify_move_Vec3d_1(Vec3 vec3d) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return vec3d;
        }
        return RotationUtil.vecWorldToPlayer(vec3d, gravityDirection);
    }

    @ModifyVariable(method={"move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="STORE"), ordinal=1, argsOnly=false)
    private BlockPos rdbt$move(BlockPos bpos) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return bpos;
        }
        return this.m_216999_();
    }

    @Inject(method={"move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="INVOKE", target="Ljava/lang/Math;sqrt(D)D", ordinal=0, shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void rdbt$stepsProperly(MoverType $$0, Vec3 $$1, CallbackInfo ci, Vec3 $$2, double $$3, boolean $$5, boolean $$6, BlockPos $$7, BlockState $$8, Block $$10, Entity.MovementEmission $$11, double $$12, double $$13, double $$14, BlockPos $$15, BlockState $$16) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        Vec3 collide = $$2;
        Vec3 collide2 = $$2;
        BlockPos bpos = this.m_20097_();
        BlockState bstate = this.m_9236_().m_8055_(bpos);
        double leng = 0.0;
        leng = Math.sqrt(collide.f_82479_ * collide.f_82479_ + collide.f_82481_ * collide.f_82481_);
        this.f_19787_ = this.f_19867_ + (float)leng * 0.6f;
        this.f_19788_ -= (float)Math.sqrt($$12 * $$12 + $$13 * $$13 + $$14 * $$14) * 0.6f;
        boolean $$17 = this.m_285776_(bstate);
        if (!$$17) {
            if (gravityDirection == Direction.NORTH || gravityDirection == Direction.SOUTH) {
                collide2 = new Vec3(collide.f_82479_, collide.f_82480_, 0.0);
            }
            if (gravityDirection == Direction.EAST || gravityDirection == Direction.WEST) {
                collide2 = new Vec3(0.0, collide.f_82480_, collide.f_82481_);
            }
        }
        this.f_19788_ += (float)Math.sqrt(collide2.f_82479_ * collide2.f_82479_ + collide2.f_82480_ * collide2.f_82480_ + collide2.f_82481_ * collide2.f_82481_) * 0.6f;
    }

    @Inject(method={"saveWithoutId(Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/nbt/CompoundTag;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V", shift=At.Shift.AFTER)})
    public void roundabout$addAdditionalSaveData(CompoundTag $$0, CallbackInfoReturnable<CompoundTag> cir) {
        CompoundTag compoundtag = $$0.m_128469_("roundabout");
        compoundtag.m_128344_("GravityDirection", MainUtil.getByteFromDirection(this.roundabout$getGravityDirection()));
    }

    @Inject(method={"load(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V", shift=At.Shift.AFTER)})
    public void roundabout$readAdditionalSaveData(CompoundTag $$0, CallbackInfo ci) {
        Player PL;
        LivingEntity LE;
        Object object;
        Direction gd = MainUtil.getDirectionFromByte($$0.m_128469_("roundabout").m_128445_("GravityDirection"));
        this.roundabout$setGravityDirection(gd);
        if (gd != Direction.DOWN && (object = this.rdbt$this()) instanceof LivingEntity && (object = ((StandUser)(LE = (LivingEntity)object)).roundabout$getStandPowers()) instanceof PowersWalkingHeart) {
            PowersWalkingHeart PW = (PowersWalkingHeart)object;
            PW.setHeelDirection(gd);
            PW.toggleSpikes(true);
        } else if (gd != Direction.DOWN && (object = this.rdbt$this()) instanceof Player && (object = ((IFatePlayer)(PL = (Player)object)).rdbt$getFatePowers()) instanceof VampiricFate) {
            VampiricFate VP = (VampiricFate)object;
            VP.setWallWalkDirection(gd);
        }
    }

    @Inject(method={"positionRider(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity$MoveFunction;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void rdbt$positionRider(Entity $$0, Entity.MoveFunction $$1, CallbackInfo ci) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        ci.cancel();
        if (this.m_20363_($$0)) {
            double $$2 = this.m_6048_() + $$0.m_6049_();
            Vec3 transform = RotationUtil.vecPlayerToWorld(0.0, $$2, 0.0, gravityDirection);
            $$1.m_20372_($$0, this.m_20185_() + transform.f_82479_, this.m_20186_() + transform.f_82480_, this.m_20189_() + transform.f_82481_);
        }
    }

    @Inject(method={"getOnPosLegacy()Lnet/minecraft/core/BlockPos;"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_getLandingPos(CallbackInfoReturnable<BlockPos> cir) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        BlockPos blockPos = BlockPos.m_274446_((Position)RotationUtil.vecPlayerToWorld(0.0, (double)-0.2f, 0.0, gravityDirection).m_82549_(this.f_19825_));
        cir.setReturnValue((Object)blockPos);
    }

    @Inject(method={"collide"}, at={@At(value="HEAD")}, cancellable=true)
    private void rdbt$collide(Vec3 $$0, CallbackInfoReturnable<Vec3> cir) {
        boolean $$7;
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        AABB $$1 = this.m_20191_();
        $$0 = RotationUtil.vecWorldToPlayer($$0, gravityDirection);
        List $$2 = this.m_9236_().m_183134_(this.rdbt$this(), $$1.m_82369_($$0));
        Vec3 $$3 = $$0.m_82556_() == 0.0 ? $$0 : GravityEntityMixin.m_198894_(this.rdbt$this(), $$0, $$1, this.m_9236_(), $$2);
        boolean $$4 = $$0.f_82479_ != $$3.f_82479_;
        boolean $$5 = $$0.f_82480_ != $$3.f_82480_;
        boolean $$6 = $$0.f_82481_ != $$3.f_82481_;
        boolean bl = $$7 = this.m_20096_() || $$5 && $$0.f_82480_ < 0.0;
        if (this.m_274421_() > 0.0f && $$7 && ($$4 || $$6)) {
            Vec3 rotate2;
            Vec3 $$8 = GravityEntityMixin.m_198894_(this.rdbt$this(), new Vec3($$0.f_82479_, (double)this.m_274421_(), $$0.f_82481_), $$1, this.m_9236_(), $$2);
            Vec3 rotate = new Vec3($$0.f_82479_, 0.0, $$0.f_82481_);
            rotate = RotationUtil.vecPlayerToWorld(rotate, GravityAPI.getGravityDirection((Entity)this));
            Vec3 $$9 = GravityEntityMixin.m_198894_(this.rdbt$this(), new Vec3(0.0, (double)this.m_274421_(), 0.0), $$1.m_82363_(rotate.f_82479_, rotate.f_82480_, rotate.f_82481_), this.m_9236_(), $$2);
            if ($$9.f_82480_ < (double)this.m_274421_()) {
                rotate2 = $$9;
                rotate2 = RotationUtil.vecPlayerToWorld(rotate2, GravityAPI.getGravityDirection((Entity)this));
                Vec3 $$10 = GravityEntityMixin.m_198894_(this.rdbt$this(), new Vec3($$0.f_82479_, 0.0, $$0.f_82481_), $$1.m_82383_(rotate2), this.m_9236_(), $$2).m_82549_($$9);
                if ($$10.m_165925_() > $$8.m_165925_()) {
                    $$8 = $$10;
                }
            }
            if ($$8.m_165925_() > $$3.m_165925_()) {
                rotate2 = $$8;
                rotate2 = RotationUtil.vecPlayerToWorld(rotate2, GravityAPI.getGravityDirection((Entity)this));
                Vec3 retrn = $$8.m_82549_(GravityEntityMixin.m_198894_(this.rdbt$this(), new Vec3(0.0, -$$8.f_82480_ + $$0.f_82480_, 0.0), $$1.m_82383_(rotate2), this.m_9236_(), $$2));
                cir.setReturnValue((Object)RotationUtil.vecPlayerToWorld(retrn, gravityDirection));
                return;
            }
        }
        Vec3 retrn = $$3;
        cir.setReturnValue((Object)RotationUtil.vecPlayerToWorld(retrn, gravityDirection));
    }

    @Inject(method={"collideBoundingBox(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Lnet/minecraft/world/level/Level;Ljava/util/List;)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void roundabout$collideBoundingBox(@Nullable Entity entity, Vec3 movement, AABB entityBoundingBox, Level $$3, List<VoxelShape> collisions, CallbackInfoReturnable<Vec3> cir) {
        boolean $$7;
        if (entity == null) {
            return;
        }
        Direction gravityDirection = GravityAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        movement = RotationUtil.vecPlayerToWorld(movement, gravityDirection);
        ImmutableList.Builder $$5 = ImmutableList.builderWithExpectedSize((int)(collisions.size() + 1));
        if (!collisions.isEmpty()) {
            $$5.addAll(collisions);
        }
        WorldBorder $$6 = $$3.m_6857_();
        boolean bl = $$7 = entity != null && $$6.m_187566_(entity, entityBoundingBox.m_82369_(movement));
        if ($$7) {
            $$5.add((Object)$$6.m_61946_());
        }
        $$5.addAll($$3.m_186434_(entity, entityBoundingBox.m_82369_(movement)));
        cir.setReturnValue((Object)RotationUtil.vecWorldToPlayer(GravityEntityMixin.rdbt$collideWithShapesGrav(movement, entityBoundingBox, (List<VoxelShape>)$$5.build(), entity), gravityDirection));
    }

    @Unique
    private static Vec3 rdbt$collideWithShapesGrav(Vec3 movement, AABB entityBoundingBox, List<VoxelShape> collisions, Entity entity) {
        boolean isZLargerThanX;
        Direction gravityDirection;
        if (entity == null || (gravityDirection = GravityAPI.getGravityDirection(entity)) == Direction.DOWN) {
            return GravityEntityMixin.m_198900_(movement, entityBoundingBox, collisions);
        }
        Vec3 playerMovement = RotationUtil.vecWorldToPlayer(movement, gravityDirection);
        double playerMovementX = playerMovement.f_82479_;
        double playerMovementY = playerMovement.f_82480_;
        double playerMovementZ = playerMovement.f_82481_;
        Direction directionX = RotationUtil.dirPlayerToWorld(Direction.EAST, gravityDirection);
        Direction directionY = RotationUtil.dirPlayerToWorld(Direction.UP, gravityDirection);
        Direction directionZ = RotationUtil.dirPlayerToWorld(Direction.SOUTH, gravityDirection);
        if (playerMovementY != 0.0 && (playerMovementY = Shapes.m_193135_((Direction.Axis)directionY.m_122434_(), (AABB)entityBoundingBox, collisions, (double)(playerMovementY * (double)directionY.m_122421_().m_122540_())) * (double)directionY.m_122421_().m_122540_()) != 0.0) {
            entityBoundingBox = entityBoundingBox.m_82383_(RotationUtil.vecPlayerToWorld(0.0, playerMovementY, 0.0, gravityDirection));
        }
        boolean bl = isZLargerThanX = Math.abs(playerMovementX) < Math.abs(playerMovementZ);
        if (isZLargerThanX && playerMovementZ != 0.0 && (playerMovementZ = Shapes.m_193135_((Direction.Axis)directionZ.m_122434_(), (AABB)entityBoundingBox, collisions, (double)(playerMovementZ * (double)directionZ.m_122421_().m_122540_())) * (double)directionZ.m_122421_().m_122540_()) != 0.0) {
            entityBoundingBox = entityBoundingBox.m_82383_(RotationUtil.vecPlayerToWorld(0.0, 0.0, playerMovementZ, gravityDirection));
        }
        if (playerMovementX != 0.0) {
            playerMovementX = Shapes.m_193135_((Direction.Axis)directionX.m_122434_(), (AABB)entityBoundingBox, collisions, (double)(playerMovementX * (double)directionX.m_122421_().m_122540_())) * (double)directionX.m_122421_().m_122540_();
            if (!isZLargerThanX && playerMovementX != 0.0) {
                entityBoundingBox = entityBoundingBox.m_82383_(RotationUtil.vecPlayerToWorld(playerMovementX, 0.0, 0.0, gravityDirection));
            }
        }
        if (!isZLargerThanX && playerMovementZ != 0.0) {
            playerMovementZ = Shapes.m_193135_((Direction.Axis)directionZ.m_122434_(), (AABB)entityBoundingBox, collisions, (double)(playerMovementZ * (double)directionZ.m_122421_().m_122540_())) * (double)directionZ.m_122421_().m_122540_();
        }
        return RotationUtil.vecPlayerToWorld(playerMovementX, playerMovementY, playerMovementZ, gravityDirection);
    }

    @Inject(method={"isInWall"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$isInWall(CallbackInfoReturnable<Boolean> cir) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        if (this.f_19794_) {
            cir.setReturnValue((Object)false);
        } else {
            float $$0 = this.f_19815_.f_20377_ * 0.8f;
            Vec3 rotate = new Vec3((double)$$0, 1.0E-6, (double)$$0);
            rotate = RotationUtil.vecPlayerToWorld(rotate, GravityAPI.getGravityDirection((Entity)this));
            AABB $$1 = AABB.m_165882_((Vec3)this.m_146892_(), (double)rotate.f_82479_, (double)rotate.f_82480_, (double)rotate.f_82481_);
            cir.setReturnValue((Object)BlockPos.m_121921_((AABB)$$1).anyMatch($$1x -> {
                BlockState $$2 = this.m_9236_().m_8055_($$1x);
                return !$$2.m_60795_() && $$2.m_60828_((BlockGetter)this.m_9236_(), $$1x) && Shapes.m_83157_((VoxelShape)$$2.m_60812_((BlockGetter)this.m_9236_(), $$1x).m_83216_((double)$$1x.m_123341_(), (double)$$1x.m_123342_(), (double)$$1x.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)$$1), (BooleanOp)BooleanOp.f_82689_);
            }));
        }
    }

    @Inject(method={"getForward"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$getForward(CallbackInfoReturnable<Vec3> cir) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        cir.setReturnValue((Object)RotationUtil.vecPlayerToWorld(Vec3.m_82503_((Vec2)this.m_20155_()), gravityDirection));
    }

    @Inject(method={"getDirection"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$getDirection(CallbackInfoReturnable<Direction> cir) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        cir.setReturnValue((Object)Direction.m_122364_((double)RotationUtil.rotPlayerToWorld((float)this.m_146908_(), (float)this.m_146909_(), (Direction)gravityDirection).f_82470_));
    }

    @Inject(method={"getBoundingBoxForPose(Lnet/minecraft/world/entity/Pose;)Lnet/minecraft/world/phys/AABB;"}, at={@At(value="RETURN")}, cancellable=true)
    private void inject_calculateBoundsForPose(Pose pos, CallbackInfoReturnable<AABB> cir) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        AABB box = ((AABB)cir.getReturnValue()).m_82383_(this.f_19825_.m_82548_());
        box = box.m_82400_(-0.01);
        cir.setReturnValue((Object)RotationUtil.boxPlayerToWorld(box, gravityDirection).m_82383_(this.f_19825_));
    }

    @Inject(method={"spawnSprintParticle()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_spawnSprintingParticles(CallbackInfo ci) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        ci.cancel();
        Vec3 floorPos = this.m_20182_().m_82546_(RotationUtil.vecPlayerToWorld(0.0, (double)0.2f, 0.0, gravityDirection));
        BlockPos blockPos = BlockPos.m_274446_((Position)floorPos);
        BlockState blockState = this.f_19853_.m_8055_(blockPos);
        if (blockState.m_60799_() != RenderShape.INVISIBLE) {
            Vec3 particlePos = this.m_20182_().m_82549_(RotationUtil.vecPlayerToWorld((this.f_19796_.m_188500_() - 0.5) * (double)this.f_19815_.f_20377_, 0.1, (this.f_19796_.m_188500_() - 0.5) * (double)this.f_19815_.f_20377_, gravityDirection));
            Vec3 playerVelocity = this.m_20184_();
            Vec3 particleVelocity = RotationUtil.vecPlayerToWorld(playerVelocity.f_82479_ * -4.0, 1.5, playerVelocity.f_82481_ * -4.0, gravityDirection);
            this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, particleVelocity.f_82479_, particleVelocity.f_82480_, particleVelocity.f_82481_);
        }
    }

    @Inject(method={"onAboveBubbleCol(Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$onAboveBubbleCol(boolean $$0, CallbackInfo ci) {
        PowersWalkingHeart PW;
        LivingEntity LE;
        Object object = this.rdbt$this();
        if (object instanceof LivingEntity && (object = ((StandUser)(LE = (LivingEntity)object)).roundabout$getStandPowers()) instanceof PowersWalkingHeart && (PW = (PowersWalkingHeart)object).hasExtendedHeelsForWalking()) {
            ci.cancel();
        }
    }

    @Inject(method={"onInsideBubbleColumn(Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$onInsideBubbleColumn(boolean $$0, CallbackInfo ci) {
        PowersWalkingHeart PW;
        LivingEntity LE;
        Object object = this.rdbt$this();
        if (object instanceof LivingEntity && (object = ((StandUser)(LE = (LivingEntity)object)).roundabout$getStandPowers()) instanceof PowersWalkingHeart && (PW = (PowersWalkingHeart)object).hasExtendedHeelsForWalking()) {
            ci.cancel();
        }
    }

    @Inject(method={"updateFluidHeightAndDoFluidPushing(Lnet/minecraft/tags/TagKey;D)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$updateFluidHeightAndDoFluidPushing(TagKey<Fluid> $$0, double $$1, CallbackInfoReturnable<Boolean> cir) {
        Direction gravityDirection;
        PowersWalkingHeart PW;
        LivingEntity LE;
        if (Objects.equals(ModPacketHandler.PLATFORM_ACCESS.getPlatformName(), "Forge")) {
            if (this.m_20077_()) {
                return;
            }
            return;
        }
        boolean counterPushing = false;
        Object object = this.rdbt$this();
        if (object instanceof LivingEntity && (object = ((StandUser)(LE = (LivingEntity)object)).roundabout$getStandPowers()) instanceof PowersWalkingHeart && (PW = (PowersWalkingHeart)object).hasExtendedHeelsForWalking()) {
            counterPushing = true;
        }
        if ((gravityDirection = GravityAPI.getGravityDirection((Entity)this)) == Direction.DOWN && !counterPushing) {
            return;
        }
        if (this.m_146899_()) {
            cir.setReturnValue((Object)false);
        } else {
            AABB $$2 = this.m_20191_().m_82406_(0.001);
            int $$3 = Mth.m_14107_((double)$$2.f_82288_);
            int $$4 = Mth.m_14165_((double)$$2.f_82291_);
            int $$5 = Mth.m_14107_((double)$$2.f_82289_);
            int $$6 = Mth.m_14165_((double)$$2.f_82292_);
            int $$7 = Mth.m_14107_((double)$$2.f_82290_);
            int $$8 = Mth.m_14165_((double)$$2.f_82293_);
            double $$9 = 0.0;
            boolean $$10 = this.m_6063_();
            if (counterPushing) {
                $$10 = false;
            }
            boolean $$11 = false;
            Vec3 $$12 = Vec3.f_82478_;
            int $$13 = 0;
            BlockPos.MutableBlockPos $$14 = new BlockPos.MutableBlockPos();
            for (int $$15 = $$3; $$15 < $$4; ++$$15) {
                for (int $$16 = $$5; $$16 < $$6; ++$$16) {
                    for (int $$17 = $$7; $$17 < $$8; ++$$17) {
                        double $$19;
                        $$14.m_122178_($$15, $$16, $$17);
                        FluidState $$18 = this.m_9236_().m_6425_((BlockPos)$$14);
                        if (!$$18.m_205070_($$0) || !(($$19 = (double)((float)$$16 + $$18.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)$$14))) >= $$2.f_82289_)) continue;
                        $$11 = true;
                        $$9 = Math.max($$19 - $$2.f_82289_, $$9);
                        if (!$$10) continue;
                        Vec3 $$20 = $$18.m_76179_((BlockGetter)this.m_9236_(), (BlockPos)$$14);
                        if ($$9 < 0.4) {
                            $$20 = $$20.m_82490_($$9);
                        }
                        $$12 = $$12.m_82549_($$20);
                        ++$$13;
                    }
                }
            }
            if ($$12.m_82553_() > 0.0) {
                if ($$13 > 0) {
                    $$12 = $$12.m_82490_(1.0 / (double)$$13);
                }
                if (!((Entity)this instanceof Player)) {
                    $$12 = $$12.m_82541_();
                }
                Vec3 $$21 = this.m_20184_();
                $$12 = $$12.m_82490_($$1 * 1.0);
                double $$22 = 0.003;
                if (Math.abs($$21.f_82479_) < 0.003 && Math.abs($$21.f_82481_) < 0.003 && $$12.m_82553_() < 0.0045000000000000005) {
                    $$12 = $$12.m_82541_().m_82490_(0.0045000000000000005);
                }
                this.m_20256_(this.m_20184_().m_82549_(RotationUtil.vecWorldToPlayer($$12, gravityDirection)));
            }
            this.f_19799_.put($$0, $$9);
            cir.setReturnValue((Object)$$11);
        }
    }

    @Inject(method={"push(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_pushAwayFrom(Entity entity, CallbackInfo ci) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        Direction otherGravityDirection = GravityAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN && otherGravityDirection == Direction.DOWN) {
            return;
        }
        ci.cancel();
        if (!(this.m_20365_(entity) || entity.f_19794_ || this.f_19794_)) {
            double g;
            Vec3 entityOffset = entity.m_20191_().m_82399_().m_82546_(this.m_20191_().m_82399_());
            Vec3 playerEntityOffset = RotationUtil.vecWorldToPlayer(entityOffset, gravityDirection);
            double dx = playerEntityOffset.f_82479_;
            double dz = playerEntityOffset.f_82481_;
            double f = Mth.m_14005_((double)dx, (double)dz);
            if (f >= (double)0.01f) {
                f = Math.sqrt(f);
                dx /= f;
                dz /= f;
                g = 1.0 / f;
                if (g > 1.0) {
                    g = 1.0;
                }
                dx *= g;
                dz *= g;
                dx *= (double)0.05f;
                dz *= (double)0.05f;
                if (!this.m_20160_()) {
                    this.m_5997_(-dx, 0.0, -dz);
                }
            }
            Vec3 entityEntityOffset = RotationUtil.vecWorldToPlayer(entityOffset, otherGravityDirection);
            dx = entityEntityOffset.f_82479_;
            dz = entityEntityOffset.f_82481_;
            f = Mth.m_14005_((double)dx, (double)dz);
            if (f >= (double)0.01f) {
                f = Math.sqrt(f);
                dx /= f;
                dz /= f;
                g = 1.0 / f;
                if (g > 1.0) {
                    g = 1.0;
                }
                dx *= g;
                dz *= g;
                dx *= (double)0.05f;
                dz *= (double)0.05f;
                if (!entity.m_20160_()) {
                    entity.m_5997_(dx, 0.0, dz);
                }
            }
        }
    }

    @Inject(method={"isFree(DDD)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$isFree(double $$0, double $$1, double $$2, CallbackInfoReturnable<Boolean> cir) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        Vec3 rotate = new Vec3($$0, $$1, $$2);
        rotate = RotationUtil.vecPlayerToWorld(rotate, GravityAPI.getGravityDirection((Entity)this));
        cir.setReturnValue((Object)this.m_20131_(this.m_20191_().m_82386_(rotate.f_82479_, rotate.f_82480_, rotate.f_82481_)));
    }

    @ModifyVariable(method={"updateFluidOnEyes()V"}, at=@At(value="STORE"), ordinal=0)
    private double submergedInWaterEyeFix(double d) {
        d = this.m_146892_().m_7098_();
        return d;
    }

    @ModifyVariable(method={"updateFluidOnEyes()V"}, at=@At(value="STORE"), ordinal=0)
    private BlockPos submergedInWaterPosFix(BlockPos blockpos) {
        blockpos = BlockPos.m_274446_((Position)this.m_146892_());
        return blockpos;
    }

    @Shadow
    public abstract double m_20185_();

    @Shadow
    public abstract Vec3 m_146892_();

    @Shadow
    public abstract double m_20186_();

    @Shadow
    public abstract double m_20189_();

    @Shadow
    public abstract int m_146903_();

    @Shadow
    public abstract int m_146907_();

    @Shadow
    public abstract Vec3 m_20184_();

    @Shadow
    public abstract boolean m_20160_();

    @Shadow
    public abstract AABB m_20191_();

    @Shadow
    public static Vec3 m_198900_(Vec3 movement, AABB entityBoundingBox, List<VoxelShape> collisions) {
        return null;
    }

    @Shadow
    public abstract Vec3 m_20182_();

    @Shadow
    public abstract boolean m_20365_(Entity var1);

    @Shadow
    public abstract void m_5997_(double var1, double var3, double var5);

    @Shadow
    protected abstract void m_6088_();

    @Shadow
    public abstract double m_20188_();

    @Shadow
    public abstract float m_5675_(float var1);

    @Shadow
    public abstract float m_146908_();

    @Shadow
    public abstract float m_146909_();

    @Shadow
    public abstract SynchedEntityData m_20088_();

    @Shadow
    public abstract float m_274421_();

    @Shadow
    public static Vec3 m_198894_(@Nullable Entity entity, Vec3 vec3, AABB aABB, Level level, List<VoxelShape> list) {
        return null;
    }

    @Shadow
    public abstract Level m_9236_();

    @Shadow
    public abstract boolean m_146899_();

    @Shadow
    public abstract boolean m_6063_();

    @Shadow
    public abstract void m_20256_(Vec3 var1);

    @Shadow
    protected abstract boolean m_20131_(AABB var1);

    static {
        roundabout$baseGravityStrength = 1.0;
    }
}

