/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.stand.powers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.hydra.jojomod.access.IMob;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.projectile.AnubisSlipstreamEntity;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.elements.PowerContext;
import net.hydra.jojomod.stand.powers.presets.NewDashPreset;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.S2CPacketUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class PowersAnubis
extends NewDashPreset {
    public static final int MaxPossesionTime = 100;
    public static final int PogoDelay = 8;
    public static final byte SWING = 50;
    List<Integer> lasthits = new ArrayList<Integer>();
    float slipstreamTimer = 3.0f;
    boolean canPogo = true;
    public int pogoImmunity = 0;
    public static final byte HEAVY_SWING = 44;
    public static final byte THRUST = 45;
    public static final byte SECOND_SWING = 46;
    public static final byte UPPERCUT = 47;
    public static final byte QUICK_SLASH = 48;
    public static final byte QUICK_SLASH_ALT = 49;
    public static final byte OVERHEAD = 50;
    public static final byte OVERHEAD_ALT = 51;
    public static final byte RADIAL = 52;
    public static final byte RADIAL_ALT = 53;
    public static final byte FLURRY = 54;
    public static final byte FLURRY_ALT = 55;
    public static final byte ANIME = 1;
    public static final byte EVIL = 2;

    public PowersAnubis(LivingEntity self) {
        super(self);
    }

    @Override
    public StandPowers generateStandPowers(LivingEntity entity) {
        return new PowersAnubis(entity);
    }

    @Override
    public boolean canSummonStandAsEntity() {
        return false;
    }

    @Override
    public boolean rendersPlayer() {
        return true;
    }

    @Override
    public void renderIcons(GuiGraphics context, int x, int y) {
        if (!this.isHoldingSneak()) {
            this.setSkillIcon(context, x, y, 1, StandIcons.ANUBIS_ALLURING_LIGHT, (byte)0);
        } else {
            this.setSkillIcon(context, x, y, 1, StandIcons.ANUBIS_RAGING_LIGHT, (byte)4);
        }
        this.setSkillIcon(context, x, y, 2, StandIcons.NONE, (byte)1);
        if (!this.isHoldingSneak()) {
            this.setSkillIcon(context, x, y, 3, StandIcons.DODGE, (byte)6);
        } else {
            this.setSkillIcon(context, x, y, 3, StandIcons.ANUBIS_BACKFLIP, (byte)6);
        }
        this.setSkillIcon(context, x, y, 4, StandIcons.NONE, (byte)3);
        super.renderIcons(context, x, y);
    }

    @Override
    public float inputSpeedModifiers(float basis) {
        if (((StandUser)this.getSelf()).roundabout$getActive() && this.getActivePower() != 3) {
            basis *= this.getSelf().m_20142_() ? 1.6f : 1.0f;
        }
        return super.inputSpeedModifiers(basis);
    }

    @Override
    public void powerActivate(PowerContext context) {
        switch (context) {
            case SKILL_1_NORMAL: 
            case SKILL_1_GUARD: {
                this.AlluringLightClient();
                break;
            }
            case SKILL_1_CROUCH: 
            case SKILL_1_CROUCH_GUARD: {
                this.RagingLightClient();
                break;
            }
            case SKILL_3_NORMAL: {
                this.dash();
                break;
            }
            case SKILL_3_CROUCH: {
                this.BackflipClient();
            }
        }
    }

    public void AlluringLightClient() {
        if (!this.onCooldown((byte)0)) {
            this.setCooldown((byte)0, 200);
            this.tryPowerPacket((byte)21);
        }
    }

    public void AlluringLightServer() {
        this.setCooldown((byte)0, 200);
        int radius = 8;
        AABB box = this.getSelf().m_20191_().m_82377_((double)radius, 2.0, (double)radius);
        for (Mob M : this.getSelf().m_9236_().m_45971_(Mob.class, TargetingConditions.f_26872_, this.getSelf(), box)) {
            ((IMob)M).roundabout$setHypnotizedBy(this.getSelf(), 200);
        }
        Vec3 pos = this.getSelf().m_20318_(1.0f);
        Vector3f[] colors = new Vector3f[]{new Vector3f(0.96f, 0.96f, 0.92f), new Vector3f(0.93f, 0.87f, 0.57f)};
        ((ServerLevel)this.getSelf().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123815_, pos.f_82479_, pos.f_82480_ + (double)this.getSelf().m_20192_(), pos.f_82481_, 20, 0.0, 0.0, 0.0, 0.4);
    }

    public void RagingLightClient() {
        if (!this.onCooldown((byte)4)) {
            this.setCooldown((byte)4, 200);
            this.tryPowerPacket((byte)22);
        }
    }

    public void RagingLightServer() {
        this.setCooldown((byte)4, 200);
        int radius = 13;
        AABB box = this.getSelf().m_20191_().m_82377_((double)radius, 2.0, (double)radius);
        for (Mob M : this.getSelf().m_9236_().m_45971_(Mob.class, TargetingConditions.f_26872_, this.getSelf(), box)) {
            M.m_6710_(this.getSelf());
            M.m_6703_(this.getSelf());
        }
        Vec3 pos = this.getSelf().m_20318_(1.0f);
        Vector3f[] colors = new Vector3f[]{new Vector3f(0.85f, 0.31f, 0.15f), new Vector3f(0.31f, 0.22f, 0.2f)};
        ((ServerLevel)this.getSelf().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123815_, pos.f_82479_, pos.f_82480_ + (double)this.getSelf().m_20192_(), pos.f_82481_, 20, 0.0, 0.0, 0.0, 0.4);
    }

    public void BackflipClient() {
        if (!this.onCooldown((byte)6)) {
            this.tryPower(13, true);
            this.tryPowerPacket((byte)13);
        }
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        StandUser SU = (StandUser)this.getSelf();
        switch (move) {
            case 21: {
                this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.ANUBIS_ALLURING_EVENT, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 22: {
                this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.ANUBIS_RAGING_EVENT, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 13: {
                this.canPogo = true;
                this.setActivePower((byte)13);
                this.setAttackTime(0);
                this.setCooldown((byte)6, 260 + (this.getSelf().m_20096_() ? 0 : 60));
                this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.ANUBIS_BACKFLIP_EVENT, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (this.isClient()) break;
                Vec3 look = this.getSelf().m_20154_().m_82542_(1.0, 0.0, 1.0).m_82541_();
                SU.roundabout$setLeapTicks(((StandUser)this.getSelf()).roundabout$getMaxLeapTicks());
                SU.roundabout$setLeapIntentionally(true);
                float strength = 1.25f;
                if (Math.abs(look.f_82479_) + Math.abs(look.f_82481_) == 0.0) {
                    strength *= 0.7f;
                }
                MainUtil.takeUnresistableKnockbackWithY((Entity)this.getSelf(), strength, look.f_82479_ * 1.0, -1.0, look.f_82481_ * 1.0);
            }
        }
        return super.tryPower(move, forced);
    }

    @Override
    public boolean setPowerOther(int move, int lastMove) {
        switch (move) {
            case 21: {
                this.AlluringLightServer();
                break;
            }
            case 22: {
                this.RagingLightServer();
                break;
            }
            case 1: 
            case 2: {
                this.tryBasicAttack((byte)move);
                break;
            }
            case 43: {
                this.tryPogoAttack();
            }
        }
        return super.setPowerOther(move, lastMove);
    }

    @Override
    public void onActuallyHurt(DamageSource $$0, float $$1) {
        if (this.getActivePower() == 43 && this.getAttackTimeDuring() < 8) {
            this.setPowerNone();
        }
    }

    @Override
    public void tickPower() {
        if (this.isClient()) {
            // empty if block
        }
        if (this.getSelf().m_20096_() && !this.canPogo) {
            this.canPogo = true;
        }
        StandUser SU = this.getStandUserSelf();
        if (!this.isClient()) {
            Level level = this.getSelf().m_9236_();
            if (this.getSelf().m_20142_() && SU.roundabout$getActive()) {
                float dif = this.getSelf().f_19787_ - this.getSelf().f_19867_;
                if (dif != 0.0f) {
                    this.slipstreamTimer -= dif;
                }
                if (this.slipstreamTimer <= 0.0f) {
                    this.slipstreamTimer = 3.0f;
                    AnubisSlipstreamEntity AS = new AnubisSlipstreamEntity(ModEntities.ANUBIS_SLIPSTREAM, level);
                    AS.m_146884_(this.getSelf().m_20318_(1.0f));
                    level.m_7967_((Entity)AS);
                }
            }
        }
        SU.roundabout$setCombatMode(SU.roundabout$getActive());
        if (this.isGuarding()) {
            this.getStandUserSelf().roundabout$setStandAnimation((byte)3);
        } else if (this.getStandUserSelf().roundabout$getStandAnimation() == 3) {
            this.getStandUserSelf().roundabout$setStandAnimation((byte)0);
        }
        if (SU.roundabout$getStandAnimation() == 13 && this.getAttackTime() > 40) {
            SU.roundabout$setStandAnimation((byte)0);
        }
        if (this.pogoImmunity > 0) {
            --this.pogoImmunity;
        }
        if (this.getActivePower() == 13) {
            if (this.getAttackTime() > 10 && this.getAttackTime() < 20) {
                if (this.getSelf().m_6047_()) {
                    this.addMomentum(0.0f, -0.075f, 0.0f);
                }
            } else if (this.getAttackTime() > 20) {
                this.setPowerNone();
            }
        }
        super.tickPower();
    }

    @Override
    public boolean interceptAttack() {
        return true;
    }

    @Override
    public void buttonInputAttack(boolean keyIsDown, Options options) {
        if (keyIsDown && this.canAttack()) {
            int index = 1;
            if (this.getSelf().m_6047_()) {
                if (!this.getSelf().m_20096_() && this.canPogo) {
                    this.canPogo = false;
                    index = 43;
                } else {
                    index = 2;
                }
            }
            this.tryPower(index);
            this.tryPowerPacket((byte)index);
        }
    }

    @Override
    public boolean setPowerAttack() {
        return this.setPowerOther(1, this.getActivePower());
    }

    public void tryBasicAttack(byte move) {
        if (this.activePowerPhase >= 3) {
            this.activePowerPhase = 1;
        } else {
            this.activePowerPhase = (byte)(this.activePowerPhase + 1);
            this.attackTimeMax = this.activePowerPhase == 3 ? ClientNetworking.getAppropriateConfig().generalStandSettings.finalStandPunchInStringCooldown.intValue() : ClientNetworking.getAppropriateConfig().generalStandSettings.standPunchCooldown.intValue();
        }
        this.lasthits.add(1 + (move == 2 ? -2 : 0));
        this.attackTimeDuring = 0;
        this.setAttackTime(0);
        if (this.activePowerPhase == 3) {
            this.setActivePower(this.determineThird(this.lasthits));
        } else {
            this.setActivePower(move);
        }
    }

    @Override
    public void updateAttack() {
        this.updateUniqueMoves();
    }

    @Override
    public void updateUniqueMoves() {
        switch (this.getActivePower()) {
            case 1: 
            case 2: {
                this.updateAttacks();
                break;
            }
            case 43: {
                this.updatePogoAttack();
            }
        }
        if (PowersAnubis.isVariant(this.getActivePower())) {
            this.updateAttacks();
        }
    }

    public void updateAttacks() {
        if (!this.isClient() && this.attackTimeDuring > -1) {
            if (this.attackTimeDuring > this.attackTimeMax) {
                this.attackTime = -1;
                this.attackTimeMax = 0;
                this.lasthits = new ArrayList<Integer>();
                ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
            } else {
                switch (this.getActivePower()) {
                    case 44: {
                        if (this.attackTimeDuring > 4) {
                            this.heavySwing();
                            break;
                        }
                        if (this.attackTimeDuring <= 2) break;
                        Vec3 look = this.getSelf().m_20154_();
                        look = new Vec3(look.f_82479_, 0.0, look.f_82481_).m_82541_();
                        this.addMomentum(look.m_82490_(this.getSelf().m_20096_() ? (double)0.6f : (double)0.2f));
                    }
                }
                if (this.getActivePower() == 2 || this.getActivePower() == 1) {
                    if (this.getActivePower() == 2) {
                        this.SAttack();
                    } else {
                        this.NAttack();
                    }
                }
                if (this.getSelf() instanceof Player && this.isPacketPlayer()) {
                    this.setAttackTimeDuring(-10);
                }
            }
        }
    }

    public void NAttack() {
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player) {
            Player P = (Player)livingEntity;
            S2CPacketUtil.sendIntPowerDataPacket(P, (byte)50, 0);
        }
        Entity targetEntity = this.getTargetEntity(this.self, -1.0f, 15.0f);
        this.punchImpact(targetEntity);
    }

    public void SAttack() {
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player) {
            Player P = (Player)livingEntity;
            S2CPacketUtil.sendIntPowerDataPacket(P, (byte)50, 0);
        }
        Entity targetEntity = this.getTargetEntity(this.self, -1.0f, 15.0f);
        this.punchImpact(targetEntity);
    }

    public void tryPogoAttack() {
        this.attackTimeMax = ClientNetworking.getAppropriateConfig().generalStandSettings.finalStandPunchInStringCooldown;
        this.attackTimeDuring = 0;
        this.setActivePower((byte)43);
        this.setAttackTime(0);
    }

    public void updatePogoAttack() {
        this.getSelf().m_20242_(this.attackTimeDuring < 8);
        if (this.attackTimeDuring > -1) {
            if (this.getSelf().m_20096_()) {
                this.setPowerNone();
                this.attackTime += 5;
            }
            if (this.attackTimeDuring > this.attackTimeMax) {
                this.attackTime = -1;
                this.attackTimeMax = 0;
                ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
            } else if (!this.isClient()) {
                int windup = 8;
                if (this.attackTimeDuring == windup) {
                    this.PogoLaunch();
                } else if (this.attackTimeDuring < windup) {
                    MainUtil.slowTarget((Entity)this.getSelf(), 0.8f);
                } else if (this.attackTimeDuring < windup + 6) {
                    Vec3 pos = this.getSelf().m_20299_(0.0f).m_82549_(this.getSelf().m_20154_().m_82490_(1.0));
                    List<Entity> targets = MainUtil.genHitbox(this.getSelf().m_9236_(), pos.f_82479_, pos.f_82480_, pos.f_82481_, 1.5, 1.5, 1.5);
                    targets.removeIf(entity -> entity.equals((Object)this.getSelf()));
                    targets.removeIf(entity -> !entity.m_6097_());
                    Entity target = null;
                    if (!targets.isEmpty()) {
                        target = targets.get(0);
                    }
                    Options o = Minecraft.m_91087_().f_91066_;
                    if (target != null) {
                        double strength = this.getSelf().m_6047_() ? 0.5 : 0.9;
                        MainUtil.takeUnresistableKnockbackWithY((Entity)this.getSelf(), strength, 0.0, -1.0, 0.0);
                        this.getStandUserSelf().roundabout$setLeapTicks(20);
                        this.getStandUserSelf().roundabout$setLeapIntentionally(true);
                        if (this.StandDamageEntityAttack(target, 4.0f, 1.0f, (Entity)this.getSelf())) {
                            LivingEntity LE;
                            if (target instanceof LivingEntity && ((StandUser)(LE = (LivingEntity)target)).roundabout$getStandPowers().interceptGuard() && LE.m_21254_() && !((StandUser)LE).roundabout$isGuarding()) {
                                this.knockShield2(target, 60);
                            } else {
                                this.knockShield2(target, 40);
                            }
                        }
                        this.setPowerNone();
                        LivingEntity livingEntity = this.getSelf();
                        if (livingEntity instanceof Player) {
                            Player P = (Player)livingEntity;
                            S2CPacketUtil.sendIntPowerDataPacket(P, (byte)43, this.attackTime + 5);
                        }
                        this.pogoImmunity = 10;
                    }
                } else if (this.attackTimeDuring < windup + 9) {
                    MainUtil.slowTarget((Entity)this.getSelf(), 0.7f);
                    this.getSelf().m_183634_();
                }
            }
        }
    }

    public void PogoLaunch() {
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player) {
            Player P = (Player)livingEntity;
            S2CPacketUtil.sendIntPowerDataPacket(P, (byte)50, 0);
        }
        float power = 1.5f;
        Vec3 lookAngle = this.getSelf().m_20154_().m_82548_();
        this.getSelf().m_183634_();
        if (lookAngle.f_82480_ < -0.15) {
            power *= 0.5f;
        }
        this.pogoImmunity = 5;
        MainUtil.takeUnresistableKnockbackWithY((Entity)this.getSelf(), power, lookAngle.f_82479_, lookAngle.f_82480_, lookAngle.f_82481_);
    }

    @Override
    public void punchImpact(Entity entity) {
        this.setAttackTimeDuring(-10);
        float knockbackStrength = 0.2f;
        if (this.getActivePower() == 2) {
            knockbackStrength = 0.4f;
        }
        if (this.getSelf().m_20142_()) {
            knockbackStrength += 0.05f;
        }
        List<Entity> entities = this.getBasicSwordHitBox(this.getActivePower() == 2);
        for (Entity e : entities) {
            float pow;
            if (e == null || !this.StandDamageEntityAttack(e, pow = this.getPunchStrength(e) * (this.getActivePower() == 2 ? 1.3f : 1.0f), 0.0f, (Entity)this.self)) continue;
            if (e instanceof LivingEntity) {
                LivingEntity LE = (LivingEntity)e;
                this.addEXP(1);
            }
            this.takeDeterminedKnockback(this.getSelf(), e, knockbackStrength);
        }
        if (!entities.isEmpty() && !this.isClient()) {
            Entity e = entities.get(0);
            Vec3 pos = e.m_20318_(0.0f).m_82520_(0.0, (double)(e.m_20192_() / 2.0f), 0.0);
            ((ServerLevel)this.getSelf().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123766_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static boolean isVariant(byte b) {
        return b >= 44 && b <= 55;
    }

    public byte determineThird(List<Integer> list) {
        this.lasthits = new ArrayList<Integer>();
        String id = String.valueOf(list.get(0)) + String.valueOf(list.get(1)) + String.valueOf(list.get(2));
        return 44;
    }

    public void heavySwing() {
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player) {
            Player P = (Player)livingEntity;
            S2CPacketUtil.sendIntPowerDataPacket(P, (byte)50, 0);
        }
        this.setAttackTimeDuring(-10);
        float knockbackStrength = 0.5f;
        List<Entity> entities = this.defaultSwordHitbox((Entity)this.getSelf(), 1.6, 3.2);
        for (Entity e : entities) {
            LivingEntity LE;
            if (e == null) continue;
            float pow = this.getHeavyPunchStrength(e);
            if (this.StandDamageEntityAttack(e, pow, 0.0f, (Entity)this.self)) {
                if (e instanceof LivingEntity) {
                    LE = (LivingEntity)e;
                    this.addEXP(1);
                }
                this.takeDeterminedKnockback(this.getSelf(), e, knockbackStrength);
                continue;
            }
            if (!(e instanceof LivingEntity) || !(LE = (LivingEntity)e).m_21254_()) continue;
            MainUtil.knockShieldPlusStand(e, 40);
        }
        if (!entities.isEmpty() && !this.isClient()) {
            Entity e = entities.get(0);
            Vec3 pos = e.m_20318_(0.0f).m_82520_(0.0, (double)(e.m_20192_() / 2.0f), 0.0);
            ((ServerLevel)this.getSelf().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123766_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0, 0.0, 0.0, 0.0, 0.0);
            LivingEntity livingEntity2 = this.getSelf();
            if (livingEntity2 instanceof Player) {
                Player P = (Player)livingEntity2;
                P.m_5704_(e);
            }
        }
    }

    @Override
    public boolean setPowerBarrageCharge() {
        this.attackTimeDuring = 0;
        this.setActivePower((byte)4);
        this.playBarrageChargeSound();
        return true;
    }

    @Override
    public void setPowerBarrage() {
        this.attackTimeDuring = 0;
        this.setActivePower((byte)5);
        this.setAttackTimeMax(this.getBarrageRecoilTime());
        this.setActivePowerPhase(this.getActivePowerPhaseMax());
        this.playBarrageCrySound();
    }

    @Override
    public int getBarrageLength() {
        return 40;
    }

    @Override
    public void updatePowerInt(byte activePower, int data) {
        switch (activePower) {
            case 50: {
                this.getSelf().m_6674_(InteractionHand.MAIN_HAND);
                break;
            }
            case 43: {
                this.attackTime = data;
                this.setPowerNone();
            }
        }
    }

    @Override
    public void updateBarrage() {
        if (this.attackTimeDuring == -2 && this.getSelf() instanceof Player) {
            ((StandUser)this.self).roundabout$tryPower(3, true);
        } else if (this.attackTimeDuring > this.getBarrageLength()) {
            this.attackTimeDuring = -20;
        } else if (this.attackTimeDuring > 0) {
            this.setAttackTime(this.getBarrageRecoilTime() - 1 - Math.round((float)this.attackTimeDuring / (float)this.getBarrageLength() * (float)(this.getBarrageRecoilTime() - 1)));
            this.BarrageSpin();
        }
    }

    public void BarrageSpin() {
        boolean lastHit = this.attackTimeDuring >= this.getBarrageLength();
        Vec3 pos = this.getSelf().m_20318_(1.0f);
        float radius = 2.4f;
        List<Entity> entities = MainUtil.genHitbox(this.getSelf().m_9236_(), pos.f_82479_, pos.f_82480_, pos.f_82481_, radius, radius, radius);
        entities.remove(this.getSelf());
        entities.removeIf(entity -> !entity.m_6097_());
        entities.removeIf(entity -> entity.m_20270_((Entity)this.getSelf()) > radius);
        for (Entity entity2 : entities) {
            float power;
            DamageSource source = ModDamageTypes.of(this.getSelf().m_9236_(), ModDamageTypes.ANUBIS_SPIN, (Entity)this.getSelf());
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity LE = (LivingEntity)entity2;
            ((StandUser)LE).roundabout$setDazed((byte)3);
            float f = power = LE.m_21223_() > 0.4f ? 0.4f : 0.01f;
            if (!LE.m_6469_(source, 0.0f)) continue;
            if (lastHit) {
                float knockback = 0.8f;
                Vec3 vec3 = entity2.m_20318_(1.0f).m_82546_(pos).m_82541_().m_82490_((double)knockback);
                LE.m_6469_(source, 4.0f);
                entity2.f_19812_ = true;
                entity2.m_20334_(vec3.f_82479_, vec3.f_82480_ + 0.2, vec3.f_82481_);
                entity2.f_19864_ = true;
                continue;
            }
            LE.m_6469_(source, power);
            this.takeKnockbackUp(entity2, 0.015);
        }
        if (!this.getSelf().m_20096_()) {
            this.addMomentum(0.0f, 0.06f, 0.0f);
            if (!entities.isEmpty()) {
                this.getSelf().m_20334_(0.0, 0.02, 0.0);
            }
        }
    }

    @Override
    public boolean interceptGuard() {
        return true;
    }

    public boolean canGuard() {
        return !this.isBarraging() && !this.isClashing() && this.getActivePower() != 43;
    }

    @Override
    public boolean buttonInputGuard(boolean keyIsDown, Options options) {
        if (!this.isGuarding() && this.canGuard()) {
            this.tryPower(3, true);
            this.tryPowerPacket((byte)3);
            return true;
        }
        return false;
    }

    @Override
    public boolean setPowerNone() {
        this.getSelf().m_20242_(false);
        return super.setPowerNone();
    }

    @Override
    public Component getPosName(byte posID) {
        return switch (posID) {
            case 1 -> Component.m_237115_((String)"idle.roundabout.anubis_2");
            default -> Component.m_237115_((String)"idle.roundabout.anubis_1");
        };
    }

    @Override
    public List<Byte> getPosList() {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add((byte)0);
        $$1.add((byte)1);
        return $$1;
    }

    @Override
    public List<Byte> getSkinList() {
        return Arrays.asList((byte)1, (byte)2);
    }

    @Override
    public Component getSkinName(byte skinId) {
        return switch (skinId) {
            case 2 -> Component.m_237115_((String)"skins.roundabout.anubis.evil");
            default -> Component.m_237115_((String)"skins.roundabout.anubis.anime");
        };
    }

    @Override
    protected Byte getSummonSound() {
        return (byte)18;
    }

    @Override
    public byte worthinessType() {
        return 2;
    }

    @Override
    public boolean isWip() {
        return true;
    }

    @Override
    public Component ifWipListDevStatus() {
        return Component.m_237115_((String)"roundabout.dev_status.active").m_130940_(ChatFormatting.AQUA);
    }

    @Override
    public Component ifWipListDev() {
        return Component.m_237113_((String)"Prisma").m_130940_(ChatFormatting.YELLOW);
    }

    public List<Entity> getBasicSwordHitBox(boolean crouching) {
        List<Entity> entities = this.defaultSwordHitbox((Entity)this.getSelf(), 1.4, 3.5);
        if (crouching) {
            entities = this.defaultSwordHitbox((Entity)this.getSelf(), 2.2, 2.5);
        }
        return entities;
    }

    public List<Entity> defaultSwordHitbox(Entity e, double width, double forwards) {
        Vec3 pos = e.m_20299_(0.0f).m_82549_(e.m_20154_().m_82490_(0.5));
        double yrot = Math.toRadians(this.getSelf().m_5675_(0.0f));
        Vec3 forward = new Vec3(Math.cos(yrot + 1.5707963267948966), 0.0, Math.sin(yrot + 1.5707963267948966));
        Vec3 left = new Vec3(forward.f_82481_, 0.0, forward.f_82479_);
        Vec3 offset = Vec3.f_82478_;
        offset = offset.m_82549_(left.m_82490_(width));
        offset = offset.m_82549_(forward.m_82490_(forwards));
        List<Entity> list = MainUtil.genHitbox(e.m_9236_(), pos.f_82479_, pos.f_82480_, pos.f_82481_, 1.0 + Math.abs(offset.f_82479_), 2.3, 1.0 + Math.abs(offset.f_82481_));
        Entity closeRanged = this.getTargetEntity(this.getSelf(), 1.0f, 15.0f);
        list.removeIf(entity -> !entity.m_6084_() || !entity.m_6097_());
        list.removeIf(entity -> entity.m_20318_(1.0f).m_82554_(e.m_20318_(1.0f)) > Math.max(width, forwards));
        list.remove(e);
        return list;
    }

    public void addMomentum(float x, float y, float z) {
        this.addMomentum(new Vec3((double)x, (double)y, (double)z));
    }

    public void addMomentum(Vec3 v) {
        this.getSelf().f_19812_ = true;
        this.getSelf().f_19864_ = true;
        this.getSelf().m_20256_(this.getSelf().m_20184_().m_82549_(v));
    }

    @Override
    public void renderAttackHud(GuiGraphics context, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
        StandUser standUser = (StandUser)playerEntity;
        boolean standOn = standUser.roundabout$getActive();
        int j = scaledHeight / 2 - 7 - 4;
        int k = scaledWidth / 2 - 8;
        float attackTimeDuring = standUser.roundabout$getAttackTimeDuring();
        if (standOn && standUser.roundabout$isClashing()) {
            int ClashTime = 15 - Math.round(attackTimeDuring / 60.0f * 15.0f);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 30, ClashTime, 6);
        } else if (standOn && standUser.roundabout$getStandPowers().isBarrageAttacking() && attackTimeDuring > -1.0f) {
            int ClashTime = 15 - Math.round(attackTimeDuring / (float)standUser.roundabout$getStandPowers().getBarrageLength() * 15.0f);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 30, ClashTime, 6);
        } else if (standOn && standUser.roundabout$getStandPowers().isBarrageCharging()) {
            int ClashTime = Math.round(attackTimeDuring / (float)standUser.roundabout$getStandPowers().getBarrageWindup() * 15.0f);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 30, ClashTime, 6);
        } else {
            float attackTime;
            float finalATime;
            int barTexture = 0;
            List<Entity> TE = this.getBasicSwordHitBox(this.getSelf().m_6047_());
            float attackTimeMax = standUser.roundabout$getAttackTimeMax();
            if (attackTimeMax > 0.0f && (finalATime = (attackTime = (float)standUser.roundabout$getAttackTime()) / attackTimeMax) <= 1.0f) {
                barTexture = standUser.roundabout$getActivePowerPhase() == standUser.roundabout$getActivePowerPhaseMax() ? 24 : (!TE.isEmpty() ? 12 : 18);
                context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
                int finalATimeInt = Math.round(finalATime * 15.0f);
                context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, barTexture, finalATimeInt, 6);
            }
            if (standOn && !TE.isEmpty() && barTexture == 0) {
                context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 0, 15, 6);
            }
        }
    }
}

