/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.stand.powers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.AbilityIconInstance;
import net.hydra.jojomod.event.powers.DamageHandler;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.item.MaxStandDiscItem;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.elements.PowerContext;
import net.hydra.jojomod.stand.powers.presets.NewPunchingStand;
import net.hydra.jojomod.util.S2CPacketUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class PowersCream
extends NewPunchingStand {
    public static final byte CREAM_VOID_ATTACK = 103;
    public int transformDirection = 0;
    public int insideVoidInt = 0;
    public int transformTimer = 0;
    public boolean isTransforming = false;
    public boolean insideVoid = false;
    public Boolean previousMayFly;
    public Boolean previousFlying;
    public Boolean previousInvulnerable;
    public GameType gameMode;
    public Abilities abilities;
    public static final byte POWER_CREAM_VOID_ATTACK = 21;
    public static final byte VOID_ATTACK_ENABLE = 52;
    public int creamAnimationIntForUnEat = 0;

    public PowersCream(LivingEntity self) {
        super(self);
    }

    @Override
    public StandEntity getNewStandEntity() {
        return (StandEntity)ModEntities.CREAM.m_20615_(this.getSelf().m_9236_());
    }

    @Override
    public StandPowers generateStandPowers(LivingEntity entity) {
        return new PowersCream(entity);
    }

    @Override
    public boolean isStandEnabled() {
        return ClientNetworking.getAppropriateConfig().creamSettings.enableCream;
    }

    @Override
    public void playSummonSound() {
        if (this.self.m_6047_()) {
            return;
        }
        this.playStandUserOnlySoundsIfNearby(this.getSummonSound(), 10.0, false, false);
    }

    @Override
    protected Byte getSummonSound() {
        return (byte)18;
    }

    @Override
    public SoundEvent getSoundFromByte(byte soundChoice) {
        byte bt = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (soundChoice == 18) {
            return ModSounds.CREAM_SUMMON_EVENT;
        }
        if (soundChoice == 103) {
            return ModSounds.CREAM_VOID_ATTACK_EVENT;
        }
        return super.getSoundFromByte(soundChoice);
    }

    public void playVoidAttackEnterSound() {
        if (!this.self.m_9236_().m_5776_()) {
            byte skn = ((StandUser)this.getSelf()).roundabout$getStandSkin();
            this.playStandUserOnlySoundsIfNearby((byte)103, 27.0, false, true);
        }
    }

    @Override
    public int getMaxGuardPoints() {
        return ClientNetworking.getAppropriateConfig().creamSettings.creamGuardPoints;
    }

    @Override
    public float getMiningMultiplier() {
        return (float)(1.0 * ((double)ClientNetworking.getAppropriateConfig().creamSettings.miningSpeedMultiplierCream.intValue() * 0.01));
    }

    @Override
    public int getMiningLevel() {
        return ClientNetworking.getAppropriateConfig().creamSettings.getMiningTierCream;
    }

    public int getVoidTime() {
        return this.insideVoidInt;
    }

    public void setVoidTime(int vt) {
        LivingEntity livingEntity;
        this.insideVoidInt = vt;
        if (!this.self.m_9236_().f_46443_ && (livingEntity = this.self) instanceof Player) {
            Player player = (Player)livingEntity;
            S2CPacketUtil.creamUpdateTimer(player, vt);
        }
    }

    public int getTransformTimer() {
        return this.transformTimer;
    }

    public void setTransformTimer(int vt) {
        LivingEntity livingEntity;
        this.transformTimer = vt;
        if (!this.self.m_9236_().f_46443_ && (livingEntity = this.self) instanceof Player) {
            Player player = (Player)livingEntity;
            S2CPacketUtil.creamUpdateTransformTimer(player, vt);
        }
    }

    public int getTransformDirection() {
        return this.transformDirection;
    }

    public void setTransformDirection(int transformDirectionValue) {
        LivingEntity livingEntity;
        this.transformDirection = transformDirectionValue;
        if (!this.self.m_9236_().f_46443_ && (livingEntity = this.self) instanceof Player) {
            Player player = (Player)livingEntity;
            S2CPacketUtil.creamUpdateTransformDirection(player, transformDirectionValue);
        }
    }

    @Override
    public void powerActivate(PowerContext context) {
        switch (context) {
            case SKILL_1_NORMAL: 
            case SKILL_1_CROUCH: {
                this.enableVoidAttackClient();
                break;
            }
            case SKILL_2_NORMAL: 
            case SKILL_2_CROUCH: {
                break;
            }
            case SKILL_3_NORMAL: 
            case SKILL_3_CROUCH: {
                break;
            }
        }
    }

    @Override
    public boolean setPowerOther(int move, int lastMove) {
        switch (move) {
            case 52: {
                this.enterVoidModeAttack();
            }
        }
        return super.setPowerOther(move, lastMove);
    }

    public void enableVoidAttackClient() {
        if (!this.onCooldown((byte)1)) {
            this.tryPower(52, true);
            this.tryPowerPacket((byte)52);
        }
    }

    public void enterVoidModeAttack() {
        if (!this.isTransforming && !this.insideVoid) {
            this.playVoidAttackEnterSound();
            this.setTransformDirection(1);
            this.setTransformTimer(0);
            this.isTransforming = true;
            LivingEntity livingEntity = this.self;
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (!this.self.m_9236_().f_46443_) {
                    this.previousMayFly = ((Player)this.self).m_150110_().f_35936_;
                    this.previousFlying = ((Player)this.self).m_150110_().f_35935_;
                    this.previousInvulnerable = ((Player)this.self).m_150110_().f_35934_;
                    this.abilities = player.m_150110_();
                    this.gameMode = ((ServerPlayer)this.self).f_8941_.m_9290_();
                    if (((Player)this.self).m_7500_()) {
                        ((Player)this.self).m_150110_().f_35936_ = true;
                        ((Player)this.self).m_150110_().f_35934_ = true;
                    } else if (this.self.m_5833_()) {
                        ((Player)this.self).m_150110_().f_35936_ = true;
                        ((Player)this.self).m_150110_().f_35934_ = true;
                    } else {
                        ((Player)this.self).m_150110_().f_35936_ = true;
                        ((Player)this.self).m_150110_().f_35934_ = true;
                    }
                    Roundabout.LOGGER.info("Previous may fly:" + this.previousMayFly);
                    ((Player)this.self).m_6885_();
                }
                this.animateStand((byte)100);
            }
        }
    }

    public void exitVoidModeAttack() {
        this.insideVoid = false;
        this.setTransformDirection(2);
        this.setTransformTimer(0);
        this.setVoidTime(0);
        this.isTransforming = true;
        if (!this.self.m_9236_().f_46443_) {
            GameType currentMode = ((ServerPlayer)this.self).f_8941_.m_9290_();
            boolean gameModeSwitched = false;
            if (currentMode != this.gameMode) {
                this.gameMode = currentMode;
                gameModeSwitched = true;
            }
            switch (this.gameMode) {
                case CREATIVE: 
                case SPECTATOR: {
                    ((Player)this.self).m_150110_().f_35936_ = true;
                    ((Player)this.self).m_150110_().f_35935_ = this.previousFlying;
                    ((Player)this.self).m_150110_().f_35934_ = true;
                    break;
                }
                default: {
                    if (!gameModeSwitched) {
                        ((Player)this.self).m_150110_().f_35936_ = this.previousMayFly;
                        ((Player)this.self).m_150110_().f_35934_ = this.previousInvulnerable;
                    }
                    ((Player)this.self).m_150110_().f_35935_ = false;
                }
            }
            ((Player)this.self).m_6885_();
        }
        this.animateStand((byte)101);
    }

    public void creamIdleAnimationReset() {
        this.animateStand((byte)0);
    }

    public void creamBallAnimation() {
        this.animateStand((byte)102);
    }

    public void actualVoidAttackDestruction() {
        if (!this.self.m_9236_().f_46443_ && this.insideVoid) {
            int radius = 2;
            BlockPos playerPos = this.self.m_20183_().m_7494_();
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        BlockPos pos = playerPos.m_7918_(x, y, z);
                        if (this.self.m_9236_().m_46859_(pos)) continue;
                        BlockState state = this.self.m_9236_().m_8055_(pos);
                        float hardness = state.m_60800_((BlockGetter)this.self.m_9236_(), pos);
                        if (state.m_60713_(Blocks.f_49990_)) {
                            this.self.m_9236_().m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                        }
                        if (!(hardness >= 0.0f) || !(hardness < 50.0f)) continue;
                        this.self.m_9236_().m_46953_(pos, true, (Entity)this.self);
                    }
                }
            }
        }
    }

    public void radialDamage() {
        List<Entity> entityList;
        if (!this.self.m_9236_().m_5776_() && !(entityList = DamageHandler.genHitbox(this.self, this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_(), 2.5, 2.5, 2.5)).isEmpty()) {
            for (Entity entity : entityList) {
                if (entity == this.self || !entity.m_6087_() || !entity.m_6084_()) continue;
                DamageSource src = ModDamageTypes.of(this.self.m_9236_(), ModDamageTypes.CREAM_VOID_BALL, (Entity)this.self, (Entity)this.self);
                entity.m_6469_(src, this.getVoidDamage((Entity)this.self));
            }
        }
    }

    public float getVoidDamage(Entity entity) {
        if (this.getReducedDamage(entity)) {
            return this.levelupDamageMod((float)((double)2.7f * ((double)ClientNetworking.getAppropriateConfig().creamSettings.creamAttackMultOnPlayers.intValue() * 0.01)));
        }
        return this.levelupDamageMod((float)(10.0 * ((double)ClientNetworking.getAppropriateConfig().creamSettings.creamAttackMultOnMobs.intValue() * 0.01)));
    }

    @Override
    public void onStandSummon(boolean desummon) {
        if (desummon && (this.insideVoidInt > 0 || this.transformTimer > 0)) {
            this.exitVoidModeAttack();
        }
    }

    @Override
    public void tickPower() {
        LivingEntity livingEntity;
        super.tickPower();
        if (!this.self.m_9236_().f_46443_ && this.transformDirection == 2 && this.transformTimer > -1 && this.creamAnimationIntForUnEat >= 20) {
            this.creamAnimationIntForUnEat = 0;
            this.creamIdleAnimationReset();
        }
        if (!this.self.m_9236_().f_46443_ && this.insideVoidInt > 0) {
            this.radialDamage();
        }
        if (!this.self.m_9236_().f_46443_ && this.insideVoidInt > 0 && (livingEntity = this.self) instanceof Player) {
            Player player = (Player)livingEntity;
            if (!((Player)this.self).m_150110_().f_35935_) {
                ((Player)this.self).m_150110_().f_35935_ = true;
                ((Player)this.self).m_6885_();
            }
        }
        if (this.isTransforming) {
            if (this.getTransformDirection() == 1) {
                if (this.getTransformTimer() < 100) {
                    this.setTransformTimer(this.getTransformTimer() + 1);
                } else {
                    this.setTransformTimer(0);
                    this.insideVoid = true;
                    this.isTransforming = false;
                }
            } else if (this.getTransformDirection() == 2) {
                if (this.getTransformTimer() < 20) {
                    ++this.creamAnimationIntForUnEat;
                    this.setTransformTimer(this.getTransformTimer() + 1);
                } else {
                    this.setTransformTimer(0);
                    this.setVoidTime(0);
                    this.insideVoid = false;
                    this.isTransforming = false;
                    this.setTransformDirection(0);
                }
            }
        }
        if (!this.self.m_9236_().f_46443_ && this.insideVoid) {
            this.actualVoidAttackDestruction();
            if (this.getVoidTime() < 400) {
                this.creamBallAnimation();
                this.setVoidTime(this.getVoidTime() + 1);
            } else if (this.getVoidTime() >= 400) {
                this.exitVoidModeAttack();
            }
        }
    }

    @Override
    public void renderIcons(GuiGraphics context, int x, int y) {
        this.setSkillIcon(context, x, y, 1, StandIcons.CREAM_VOID_ATTACK, (byte)0);
    }

    @Override
    public List<Byte> getSkinList() {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add((byte)1);
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player) {
            boolean bypass;
            Player PE = (Player)livingEntity;
            byte Level2 = ((IPlayerEntity)PE).roundabout$getStandLevel();
            ItemStack goldDisc = ((StandUser)PE).roundabout$getStandDisc();
            boolean bl = bypass = PE.m_7500_() || !goldDisc.m_41619_() && goldDisc.m_41720_() instanceof MaxStandDiscItem;
            if (Level2 > 1 || bypass) {
                // empty if block
            }
            if (Level2 > 2 || bypass) {
                // empty if block
            }
            if (Level2 > 3 || bypass) {
                // empty if block
            }
            if (Level2 > 4 || bypass) {
                // empty if block
            }
            if (Level2 > 5 || bypass) {
                // empty if block
            }
            if (Level2 > 6 || bypass) {
                // empty if block
            }
            if (((IPlayerEntity)PE).roundabout$getUnlockedBonusSkin() || bypass) {
                // empty if block
            }
        }
        return $$1;
    }

    @Override
    public List<AbilityIconInstance> drawGUIIcons(GuiGraphics context, float delta, int mouseX, int mouseY, int leftPos, int topPos, byte level, boolean bypass) {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 80, 0, "ability.roundabout.void_attack", "instruction.roundabout.press_skill", StandIcons.CREAM_VOID_ATTACK, 1, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 99, 0, "ability.roundabout.heel_plant", "instruction.roundabout.press_skill", StandIcons.GROUND_IMPLANT, 2, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 118, 0, "ability.roundabout.dodge", "instruction.roundabout.press_skill", StandIcons.DODGE, 3, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 80, 0, "ability.roundabout.wall_walk_move", "instruction.roundabout.press_skill", StandIcons.WALL_WALK, 3, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 99, 0, "ability.roundabout.firm_swing", "instruction.roundabout.passive", StandIcons.FIRM_SWING, 0, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 118, 0, "ability.roundabout.fall_disperse", "instruction.roundabout.passive", StandIcons.FALL_ABSORB, 0, level, bypass));
        return $$1;
    }

    @Override
    public Component getSkinName(byte skinId) {
        return PowersCream.getSkinNameT(skinId);
    }

    public static Component getSkinNameT(byte skinId) {
        if (skinId == 1) {
            return Component.m_237115_((String)"skins.roundabout.the_world.base");
        }
        return Component.m_237115_((String)"skins.roundabout.the_world.base");
    }

    @Override
    public void levelUp() {
        LivingEntity livingEntity;
        if (!this.getSelf().m_9236_().m_5776_() && (livingEntity = this.getSelf()) instanceof Player) {
            Player PE = (Player)livingEntity;
            IPlayerEntity ipe = (IPlayerEntity)PE;
            byte level = ipe.roundabout$getStandLevel();
            if (level == 7) {
                ((ServerPlayer)this.self).m_5661_((Component)Component.m_237115_((String)"leveling.roundabout.levelup.max.skins").m_130940_(ChatFormatting.AQUA), true);
            } else if (level == 2 || level == 3 || level == 4 || level == 6 || level == 5) {
                ((ServerPlayer)this.self).m_5661_((Component)Component.m_237115_((String)"leveling.roundabout.levelup.both").m_130940_(ChatFormatting.AQUA), true);
            }
        }
        super.levelUp();
    }
}

