/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.hydra.jojomod.access.IKeyMapping;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.client.KeyInputRegistry;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.event.index.Corpses;
import net.hydra.jojomod.event.index.ShapeShifts;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.networking.ClientToServerPackets;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_339;
import net.minecraft.class_3675;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import net.minecraft.class_746;
import net.zetalasis.networking.message.api.ModMessageEvents;
import org.joml.Vector3f;

public class CorpseBagScreen
extends class_437 {
    static final class_2960 CORPSE_CHOOSER_LOCATION = new class_2960("roundabout", "textures/gui/corpse_chooser.png");
    private static final int SPRITE_SHEET_WIDTH = 256;
    private static final int SPRITE_SHEET_HEIGHT = 256;
    private static final int SLOT_AREA = 26;
    private static final int SLOT_PADDING = 5;
    private static final int SLOT_AREA_PADDED = 31;
    private static final int HELP_TIPS_OFFSET_Y = 5;
    private static final int ALL_SLOTS_WIDTH = corpseIcon.VALUES.length * 31 - 5;
    private corpseIcon currentlyHovered = null;
    private int firstMouseX;
    private int firstMouseY;
    private boolean setFirstMousePos;
    public boolean zHeld;
    public final class_1799 stack;
    private final List<PoseSlot> slots = Lists.newArrayList();
    public int zombies = 0;
    public int skeletons = 0;
    public int spiders = 0;
    public int villagers = 0;
    public int creepers = 0;
    public int phantoms = 0;

    public CorpseBagScreen() {
        super(class_333.field_18967);
        this.stack = null;
    }

    public CorpseBagScreen(class_1799 stack) {
        super(class_333.field_18967);
        this.stack = stack;
    }

    private ShapeShifts getDefaultSelected() {
        class_746 pl = class_310.method_1551().field_1724;
        if (pl != null) {
            return ShapeShifts.getShiftFromByte(((IPlayerEntity)pl).roundabout$getShapeShift());
        }
        return ShapeShifts.PLAYER;
    }

    protected void method_25426() {
        super.method_25426();
        this.zHeld = true;
        class_746 pl = class_310.method_1551().field_1724;
        if (this.stack != null && !this.stack.method_7960()) {
            class_2487 $$1 = this.stack.method_7911("bodies");
            this.zombies = $$1.method_10550("zombie");
            this.skeletons = $$1.method_10550("skeleton");
            this.spiders = $$1.method_10550("spider");
            this.villagers = $$1.method_10550("villager");
            this.creepers = $$1.method_10550("creeper");
            this.phantoms = $$1.method_10550("phantom");
        } else {
            this.zombies = 0;
            this.skeletons = 0;
            this.spiders = 0;
            this.villagers = 0;
            this.creepers = 0;
            this.phantoms = 0;
        }
        this.currentlyHovered = corpseIcon.NONE;
        for (int i = 0; i < corpseIcon.VALUES.length; ++i) {
            corpseIcon pIcon = corpseIcon.VALUES[i];
            this.slots.add(new PoseSlot(pIcon, this.field_22789 / 2 + pIcon.xoff - 13, this.field_22790 / 2 + pIcon.yoff - 44));
        }
    }

    public boolean method_25406(double $$0, double $$1, int $$2) {
        this.switchToHoveredGameMode();
        this.field_22787.method_1507(null);
        return true;
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        if (this.checkToClose()) {
            return;
        }
        guiGraphics.method_51448().method_22903();
        RenderSystem.enableBlend();
        int k = this.field_22789 / 2 - 62;
        int l = this.field_22790 / 2 - 31 - 39;
        guiGraphics.method_25290(CORPSE_CHOOSER_LOCATION, k, l, 0.0f, 0.0f, 125, 63, 256, 256);
        guiGraphics.method_51448().method_22909();
        super.method_25394(guiGraphics, i, j, f);
        if (this.currentlyHovered != null) {
            guiGraphics.method_27534(this.field_22793, this.currentlyHovered.getName(), this.field_22789 / 2, this.field_22790 / 2 - 31 - 32, -1);
        }
        if (!this.setFirstMousePos) {
            this.firstMouseX = i;
            this.firstMouseY = j;
            this.setFirstMousePos = true;
        }
        boolean bl = this.firstMouseX == i && this.firstMouseY == j;
        for (PoseSlot MobSlot2 : this.slots) {
            MobSlot2.method_25394(guiGraphics, i, j, f);
            MobSlot2.setSelected(this.currentlyHovered == MobSlot2.icon);
            if (bl || !MobSlot2.method_25367()) continue;
            this.currentlyHovered = MobSlot2.icon;
        }
        if (!this.stack.method_31574(ModItems.CREATIVE_BODY_BAG)) {
            for (int m = 0; m < corpseIcon.VALUES.length; ++m) {
                corpseIcon pIcon = corpseIcon.VALUES[m];
                if (pIcon.id == corpseIcon.NONE.id) continue;
                int num = 0;
                if (pIcon == corpseIcon.ZOMBIE) {
                    num = this.zombies;
                } else if (pIcon == corpseIcon.SKELETON) {
                    num = this.skeletons;
                } else if (pIcon == corpseIcon.CREEPER) {
                    num = this.creepers;
                } else if (pIcon == corpseIcon.SPIDER) {
                    num = this.spiders;
                } else if (pIcon == corpseIcon.VILLAGER) {
                    num = this.villagers;
                } else if (pIcon == corpseIcon.PHANTOM) {
                    num = this.phantoms;
                }
                guiGraphics.method_25303(this.field_22793, "" + num, this.field_22789 / 2 + pIcon.xoff - 13, this.field_22790 / 2 + pIcon.yoff - 44, -1);
            }
        }
    }

    private void switchToHoveredGameMode() {
        this.switchToHoveredGameMode(this.field_22787, this.currentlyHovered);
    }

    private void switchToHoveredGameMode(class_310 minecraft, corpseIcon pIcon) {
        if (minecraft.field_1761 == null || minecraft.field_1724 == null) {
            return;
        }
        if (this.stack != null && !this.stack.method_7960() && minecraft.field_1724 != null) {
            class_243 vec3d = minecraft.field_1724.method_5836(0.0f);
            class_243 vec3d2 = minecraft.field_1724.method_5828(0.0f);
            class_243 vec3d3 = vec3d.method_1031(vec3d2.field_1352 * 5.0, vec3d2.field_1351 * 5.0, vec3d2.field_1350 * 5.0);
            class_3965 blockHit = minecraft.field_1724.method_37908().method_17742(new class_3959(vec3d, vec3d3, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)minecraft.field_1724));
            Vector3f vc = minecraft.field_1724.method_19538().method_46409();
            if (blockHit.method_17783() == class_239.class_240.field_1332) {
                vc = blockHit.method_17777().method_46558().method_46409().add(0.0f, 1.0f, 0.0f);
            }
            ModMessageEvents.sendToServer(ClientToServerPackets.StandPowerPackets.MESSAGES.BodyBag.value, pIcon.id, this.stack, vc);
        }
    }

    public boolean sameKeyOne(class_304 key1, class_315 options) {
        return key1.method_1434() || key1.method_1435(options.field_1874) && options.field_1874.method_1434() || key1.method_1435(options.field_1879) && options.field_1879.method_1434();
    }

    public boolean sameKeyOneX(class_304 key1, class_315 options) {
        return class_3675.method_15987((long)this.field_22787.method_22683().method_4490(), (int)((IKeyMapping)key1).roundabout$justTellMeTheKey().method_1444()) || key1.method_1435(options.field_1874) && class_3675.method_15987((long)this.field_22787.method_22683().method_4490(), (int)((IKeyMapping)options.field_1874).roundabout$justTellMeTheKey().method_1444()) || key1.method_1435(options.field_1879) && class_3675.method_15987((long)this.field_22787.method_22683().method_4490(), (int)((IKeyMapping)options.field_1879).roundabout$justTellMeTheKey().method_1444());
    }

    private boolean checkToClose() {
        if (this.field_22787 != null && this.sameKeyOneX(KeyInputRegistry.abilityTwoKey, this.field_22787.field_1690)) {
            this.switchToHoveredGameMode();
            this.field_22787.method_1507(null);
            return true;
        }
        class_315 options = class_310.method_1551().field_1690;
        return false;
    }

    public boolean method_25404(int i, int j, int k) {
        return super.method_25404(i, j, k);
    }

    public boolean method_25421() {
        return false;
    }

    public static enum corpseIcon {
        ZOMBIE((class_2561)class_2561.method_43471((String)"entity.minecraft.zombie"), StandIcons.FALLEN_ZOMBIE, Corpses.ZOMBIE.id, -31, 31),
        SKELETON((class_2561)class_2561.method_43471((String)"entity.minecraft.skeleton"), StandIcons.FALLEN_SKELETON, Corpses.SKELETON.id, 0, 0),
        CREEPER((class_2561)class_2561.method_43471((String)"entity.minecraft.creeper"), StandIcons.FALLEN_CREEPER, Corpses.CREEPER.id, 31, 0),
        VILLAGER((class_2561)class_2561.method_43471((String)"entity.minecraft.villager"), StandIcons.FALLEN_VILLAGER, Corpses.VILLAGER.id, -31, 0),
        SPIDER((class_2561)class_2561.method_43471((String)"entity.minecraft.spider"), StandIcons.FALLEN_SPIDER, Corpses.SPIDER.id, 31, 31),
        PHANTOM((class_2561)class_2561.method_43471((String)"entity.minecraft.phantom"), StandIcons.FALLEN_PHANTOM, Corpses.PHANTOM.id, 0, 62),
        NONE((class_2561)class_2561.method_43471((String)"roundabout.corpse.none"), new class_2960("roundabout", "textures/gui/pose_icons/jonathan.png"), Corpses.NONE.id, 0, 31);

        protected static final corpseIcon[] VALUES;
        private static final int ICON_AREA = 16;
        protected static final int ICON_TOP_LEFT = 5;
        final class_2561 name;
        final class_2960 rl;
        final byte id;
        final int xoff;
        final int yoff;

        static corpseIcon getByte(Corpses corpse) {
            return switch (corpse) {
                default -> throw new IncompatibleClassChangeError();
                case Corpses.ZOMBIE -> ZOMBIE;
                case Corpses.SKELETON -> SKELETON;
                case Corpses.CREEPER -> CREEPER;
                case Corpses.VILLAGER -> VILLAGER;
                case Corpses.SPIDER -> SPIDER;
                case Corpses.PHANTOM -> PHANTOM;
                case Corpses.NONE -> NONE;
            };
        }

        private corpseIcon(class_2561 component, class_2960 rl, byte id, int xoff, int yoff) {
            this.name = component;
            this.rl = rl;
            this.id = id;
            this.xoff = xoff;
            this.yoff = yoff;
        }

        void drawIcon(class_332 guiGraphics, int i, int j) {
            guiGraphics.method_25290(this.rl, i - 1, j - 1, 0.0f, 0.0f, 18, 18, 18, 18);
        }

        class_2561 getName() {
            return this.name;
        }

        static {
            VALUES = new corpseIcon[]{ZOMBIE, SKELETON, VILLAGER, CREEPER, SPIDER, PHANTOM, NONE};
        }
    }

    public class PoseSlot
    extends class_339 {
        final corpseIcon icon;
        private boolean isSelected;

        public PoseSlot(corpseIcon pIcon, int i, int j) {
            super(i, j, 26, 26, pIcon.getName());
            this.icon = pIcon;
        }

        public void method_48579(class_332 guiGraphics, int i, int j, float f) {
            if (!this.icon.equals((Object)corpseIcon.NONE)) {
                guiGraphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
                if (!CorpseBagScreen.this.stack.method_31574(ModItems.CREATIVE_BODY_BAG) && (this.icon.equals((Object)corpseIcon.CREEPER) && CorpseBagScreen.this.creepers <= 0 || this.icon.equals((Object)corpseIcon.SKELETON) && CorpseBagScreen.this.skeletons <= 0 || this.icon.equals((Object)corpseIcon.ZOMBIE) && CorpseBagScreen.this.zombies <= 0 || this.icon.equals((Object)corpseIcon.SPIDER) && CorpseBagScreen.this.spiders <= 0 || this.icon.equals((Object)corpseIcon.VILLAGER) && CorpseBagScreen.this.villagers <= 0 || this.icon.equals((Object)corpseIcon.PHANTOM) && CorpseBagScreen.this.phantoms <= 0)) {
                    guiGraphics.method_51422(0.5f, 0.5f, 0.5f, 0.7f);
                }
                this.drawSlot(guiGraphics);
                guiGraphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
                this.icon.drawIcon(guiGraphics, this.method_46426() + 5, this.method_46427() + 5);
                if (this.isSelected) {
                    this.drawSelection(guiGraphics);
                }
            }
        }

        public void method_47399(class_6382 narrationElementOutput) {
            this.method_37021(narrationElementOutput);
        }

        public boolean method_25367() {
            return super.method_25367() || this.isSelected;
        }

        public void setSelected(boolean bl) {
            this.isSelected = bl;
        }

        private void drawSlot(class_332 guiGraphics) {
            guiGraphics.method_25290(CORPSE_CHOOSER_LOCATION, this.method_46426(), this.method_46427(), 144.0f, 0.0f, 26, 26, 256, 256);
        }

        private void drawSelection(class_332 guiGraphics) {
            guiGraphics.method_25290(CORPSE_CHOOSER_LOCATION, this.method_46426(), this.method_46427(), 170.0f, 0.0f, 26, 26, 256, 256);
        }
    }
}

