/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.stand.powers;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.projectile.RattDartEntity;
import net.hydra.jojomod.entity.stand.RattEntity;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.ModEffects;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.elements.PowerContext;
import net.hydra.jojomod.stand.powers.presets.NewDashPreset;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class PowersRatt
extends NewDashPreset {
    public static final int MinThreshold = 30;
    public static final int MaxThreshold = 90;
    public static final int BaseShootCooldown = 10;
    public static final int MaxShootCooldown = 30;
    public static final int[] ShotThresholds = new int[]{30, 50, 90};
    public static final float[] ShotPowerFloats = new float[]{3.0f, 4.2f, 5.0f};
    public static final float[] ShotDamageTicks = new float[]{0.5f, 0.5f, 0.5f};
    public static final int[] ShotSuperthrowTicks = new int[]{4, 10, 15};
    public static float PlacementRange = 5.0f;
    public static final byte UPDATE_POSITION = 0;
    public static final byte ROTATE = 2;
    public static final byte CHANGE_MODE = 5;
    public static final byte AUTO = 7;
    public static final byte SETPLACE = 8;
    public static final byte SCOPE = 9;
    public static final byte FIRE_DART = 10;
    public static final byte TOGGLE_BURSTING = 11;
    public static final byte START_PLAYER_BURST = 13;
    public static final byte PLAYER_BURST = 15;
    public static final byte PLACE_BURST = 16;
    public static final byte NET_PLACE_BURST = 17;
    public static final byte PLACE_BURST_FIRE = 16;
    public static final byte NET_PLACE = 1;
    public static final byte NET_RECALL = 2;
    public static final byte NET_SCOPE = 3;
    public static final byte UPDATE_CHARGE = 4;
    public class_1297 ShootTarget = null;
    boolean active = false;
    int chargeTime = 0;
    int shotcooldown = 0;
    int maxshotcooldown = 0;
    class_243 Placement = null;

    public PowersRatt(class_1309 self) {
        super(self);
    }

    @Override
    public StandPowers generateStandPowers(class_1309 entity) {
        return new PowersRatt(entity);
    }

    @Override
    public StandEntity getNewStandEntity() {
        return (StandEntity)ModEntities.RATT.method_5883(this.getSelf().method_37908());
    }

    public void setShotCooldown(int i) {
        this.shotcooldown = i;
        this.maxshotcooldown = i;
    }

    public class_1297 getShootTarget() {
        return this.ShootTarget;
    }

    public void setShootTarget(class_1297 e) {
        this.ShootTarget = e;
    }

    @Override
    public boolean canSummonStandAsEntity() {
        return false;
    }

    public int getChargeTime() {
        return this.chargeTime;
    }

    public void updateChargeTime(int i) {
        this.tryIntPower(4, true, i);
        this.tryIntPowerPacket((byte)4, i);
    }

    public boolean isPlaced() {
        return this.getStandEntity(this.getSelf()) != null;
    }

    public boolean isAuto() {
        return this.getStandUserSelf().roundabout$getUniqueStandModeToggle();
    }

    public class_3965 getTargetPos() {
        class_243 vec3d = this.getSelf().method_5836(0.0f);
        class_243 vec3d2 = this.getSelf().method_5828(0.0f);
        class_243 vec3d3 = vec3d.method_1031(vec3d2.field_1352 * 60.0, vec3d2.field_1351 * 60.0, vec3d2.field_1350 * 60.0);
        class_3965 blockHit = this.getSelf().method_37908().method_17742(new class_3959(vec3d, vec3d3, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.getSelf()));
        return blockHit;
    }

    public class_1297 CoolerrayCastEntity(class_1937 world, class_1309 ratt, double maxDistance) {
        class_243 lookVec;
        class_243 reachVec;
        StandEntity SE = (StandEntity)ratt;
        class_243 eyePos = ratt.method_5836(1.0f);
        class_3959 blockContext = new class_3959(eyePos, reachVec = eyePos.method_1019((lookVec = new class_243(Math.cos((double)SE.getStandRotationY() + 1.5707963267948966), Math.sin(SE.getHeadRotationX()), Math.sin((double)SE.getStandRotationY() + 1.5707963267948966))).method_1021(maxDistance)), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)ratt);
        class_3965 blockHit = world.method_17742(blockContext);
        double blockHitDistance = blockHit != null ? blockHit.method_17784().method_1022(eyePos) : maxDistance;
        class_238 box = ratt.method_5829().method_18804(lookVec.method_1021(maxDistance)).method_1014(1.0);
        List candidates = world.method_8333((class_1297)ratt, box, e -> e instanceof class_1297 && e.method_5863() && e.method_5805());
        class_1297 closest = null;
        double closestDistance = blockHitDistance;
        for (class_1297 entity : candidates) {
            double hitDistance;
            class_238 aabb = entity.method_5829().method_1014(0.3);
            Optional hitOptional = aabb.method_992(eyePos, reachVec);
            if (!hitOptional.isPresent() || !((hitDistance = eyePos.method_1022((class_243)hitOptional.get())) < closestDistance) || entity.method_7325() || !MainUtil.isStandPickable(entity) || entity.method_5655() || entity.method_5626((class_1297)ratt)) continue;
            closestDistance = hitDistance;
            closest = entity;
        }
        return closest;
    }

    private class_3965 getValidPlacement() {
        class_243 vec3d = this.getSelf().method_5836(0.0f);
        class_243 vec3d2 = this.getSelf().method_5828(0.0f);
        class_243 vec3d3 = vec3d.method_1031(vec3d2.field_1352 * (double)PlacementRange, vec3d2.field_1351 * (double)PlacementRange, vec3d2.field_1350 * (double)PlacementRange);
        class_3965 blockHit = this.getSelf().method_37908().method_17742(new class_3959(vec3d, vec3d3, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.getSelf()));
        boolean cond = false;
        if (blockHit.method_17780() != class_2350.field_11036 && blockHit.method_17780() != class_2350.field_11033) {
            class_2338 pos = blockHit.method_17777();
            if (this.getSelf().method_37908().method_8320(pos.method_10084()).method_26215()) {
                cond = true;
            }
        }
        if (blockHit.method_17783() == class_239.class_240.field_1332 && (blockHit.method_17780() == class_2350.field_11036 || cond)) {
            return blockHit;
        }
        return null;
    }

    @Override
    public void renderIcons(class_332 context, int x, int y) {
        ClientUtil.fx.roundabout$onGUI(context);
        if (this.isPlaced()) {
            if (!this.getSelf().method_18276()) {
                this.setSkillIcon(context, x, y, 1, StandIcons.RATT_BURST, (byte)16);
            } else if (this.isAuto()) {
                this.setSkillIcon(context, x, y, 1, StandIcons.RATT_AUTO, (byte)5);
            } else {
                this.setSkillIcon(context, x, y, 1, StandIcons.RATT_UNAUTO, (byte)5);
            }
            if (this.scopeLevel == 0) {
                this.setSkillIcon(context, x, y, 2, StandIcons.RATT_RECALL, (byte)8);
            }
        } else {
            class_2960 ScopeIcon = StandIcons.RATT_SCOPE_IN;
            if (this.scopeLevel == 1) {
                ScopeIcon = StandIcons.RATT_SCOPE_OUT;
            }
            this.setSkillIcon(context, x, y, 1, ScopeIcon, (byte)9);
            if (this.scopeLevel == 0) {
                this.setSkillIcon(context, x, y, 2, StandIcons.RATT_PLACE, (byte)8);
            } else if (this.isAuto()) {
                this.setSkillIcon(context, x, y, 2, StandIcons.RATT_BURST, (byte)5);
            } else {
                this.setSkillIcon(context, x, y, 2, StandIcons.RATT_SINGLE, (byte)5);
            }
        }
        this.setSkillIcon(context, x, y, 3, StandIcons.DODGE, (byte)6);
    }

    @Override
    public boolean tryPosPower(int move, boolean forced, class_243 pos) {
        Roundabout.LOGGER.info("A: {}, B: {}", (Object)this.getSelf().method_5477().toString(), (Object)move);
        StandEntity SE = this.getStandEntity(this.getSelf());
        switch (move) {
            case 0: {
                if (SE == null) break;
                SE.method_33574(pos);
                break;
            }
            case 1: {
                this.getStandUserSelf().roundabout$setUniqueStandModeToggle(false);
                this.active = true;
                this.Placement = pos;
                this.setCooldown((byte)8, 80);
                break;
            }
            case 2: {
                StandEntity standEntity;
                if (this.getStandEntity(this.getSelf()) == null || !((standEntity = this.getStandEntity(this.getSelf())) instanceof RattEntity)) break;
                RattEntity RE = (RattEntity)standEntity;
                RE.setHeadRotationX((float)pos.field_1352);
                RE.setStandRotationY((float)pos.field_1351);
            }
        }
        return true;
    }

    public void placeRatt(class_243 pos) {
        int cooldown = 60;
        this.setCooldown((byte)8, cooldown);
        if (!this.isClient()) {
            this.blipStand(pos);
        }
    }

    public void blipStand(class_243 pos) {
        StandEntity stand = this.getNewStandEntity();
        if (stand instanceof RattEntity) {
            RattEntity RE = (RattEntity)stand;
            StandUser user = this.getStandUserSelf();
            stand.setSkin(user.roundabout$getStandSkin());
            stand.setMaster(this.self);
            stand.method_30634(pos.method_10216(), pos.method_10214(), pos.method_10215());
            this.getStandUserSelf().roundabout$standMount(stand);
            this.self.method_37908().method_8649((class_1297)stand);
        }
    }

    @Override
    public void tickPower() {
        StandEntity standEntity;
        super.tickPower();
        if (this.getAttackTime() > 20 && this.getAnimation() == 82) {
            this.animateStand((byte)-1);
        }
        if (this.getSelf().method_37908().method_8608() && this.getStandEntity(this.getSelf()) != null && (standEntity = this.getStandEntity(this.getSelf())) instanceof RattEntity) {
            RattEntity RE = (RattEntity)standEntity;
            class_1297 target = this.getShootTarget();
            class_243 targetPos = this.getTargetPos().method_17784();
            if (target != null && this.isAuto()) {
                targetPos = target.method_5836(1.0f);
                double dist = targetPos.method_1022(RE.method_30950(1.0f));
                double time = dist / (double)ShotPowerFloats[1];
                class_243 vec = target.method_18798();
                targetPos = targetPos.method_1019(vec.method_18805(time *= 1.4, time, time));
            }
            double x = targetPos.method_10216() - RE.method_30950(0.0f).method_10216();
            double z = targetPos.method_10215() - RE.method_30950(0.0f).method_10215();
            float rot = (float)(Math.atan2(z, x) - 1.5707963267948966);
            double hy = targetPos.method_10214() - (RE.method_30950(0.0f).method_10214() + 0.5);
            double hd = Math.sqrt(Math.pow(x, 2.0) + Math.pow(z, 2.0));
            float hrot = (float)(Math.atan2(hd, hy) + 1.5707963267948966);
            double percent = (double)RE.getFadeOut() / (double)RE.getMaxFade();
            if (percent != 1.0) {
                hrot = (float)class_3532.method_16436((double)percent, (double)0.0, (double)hrot);
            }
            this.tryPosPower(2, true, new class_243((double)hrot, (double)rot, 0.0));
            this.tryPosPowerPacket((byte)2, new class_243((double)hrot, (double)rot, 0.0));
        }
        if (this.shotcooldown != 0) {
            --this.shotcooldown;
        }
        if (this.shotcooldown == 0) {
            this.maxshotcooldown = 0;
        }
        if (this.scopeLevel == 0 && this.attackTime > 60 && this.getChargeTime() != 0) {
            this.chargeTime -= 2;
        }
        StandEntity SE = this.getStandEntity(this.getSelf());
        if (this.isPlaced()) {
            if (this.isClient()) {
                class_1297 e = MainUtil.getTargetEntity(this.self, 30.0f, 15);
                if (this.getShootTarget() == null) {
                    this.getStandUserSelf().roundabout$setUniqueStandModeToggle(false);
                }
                if (this.isAuto()) {
                    class_1297 f = this.CoolerrayCastEntity(this.getSelf().method_37908(), (class_1309)SE, 60.0);
                    if (f != null) {
                        this.BurstFire();
                    }
                } else {
                    this.setShootTarget(null);
                    if (e instanceof class_1309 && !e.equals((Object)this.getSelf()) && !e.equals((Object)this.getStandEntity(this.getSelf()))) {
                        this.setShootTarget(e);
                    }
                }
                if (e != null && e.method_5739((class_1297)SE) >= 30.0f) {
                    this.setShootTarget(null);
                }
                this.setGoBeyondTarget(this.getShootTarget());
            }
        } else if (this.active && this.getStandUserSelf().roundabout$getActive() && !this.isClient() && this.Placement != null) {
            this.placeRatt(this.Placement);
        }
    }

    @Override
    public void updateUniqueMoves() {
        if (this.getActivePower() == 3) {
            this.updateChargeTime(class_3532.method_15340((int)(this.getChargeTime() + (this.attackTimeDuring % 2 == 0 ? 4 : 4)), (int)0, (int)100));
            if (this.getChargeTime() == 100) {
                this.setPowerNone();
            }
            if (this.scopeLevel == 0) {
                this.setPowerNone();
            }
        } else if (this.getActivePower() == 15) {
            if (this.isClient()) {
                if (this.attackTimeDuring % 3 == 1) {
                    this.tryPower(15, true);
                    this.tryPowerPacket((byte)15);
                }
                if (this.getChargeTime() < 30) {
                    this.updateChargeTime(0);
                    this.setShotCooldown(30);
                    this.tryPower(0, true);
                    this.tryPowerPacket((byte)0);
                }
            }
        } else if (this.getActivePower() == 16) {
            this.setShotCooldown(25);
            if (this.getAttackTimeDuring() > 8) {
                this.setPowerNone();
                this.setAttackTimeDuring(-1);
            } else if (this.getAttackTime() == 1) {
                this.tryPower(16, true);
                this.tryPowerPacket((byte)16);
            }
        }
        super.updateUniqueMoves();
    }

    @Override
    public void powerActivate(PowerContext context) {
        switch (context) {
            case SKILL_1_NORMAL: {
                if (!this.isPlaced()) {
                    this.RattScope();
                    break;
                }
                this.BurstFire();
                break;
            }
            case SKILL_1_CROUCH: {
                if (!this.isPlaced() || this.isAttackIneptVisually((byte)7, 1)) break;
                this.ToggleAuto();
                break;
            }
            case SKILL_2_NORMAL: {
                if (this.scopeLevel != 0) {
                    this.ToggleBursting();
                    break;
                }
                if (!this.isPlaced()) {
                    if (this.getValidPlacement() == null) break;
                    this.DeployClient();
                    break;
                }
                this.RecallClient();
                break;
            }
            case SKILL_3_NORMAL: 
            case SKILL_3_CROUCH: {
                this.dash();
            }
        }
    }

    public void RattScope() {
        if (!this.onCooldown((byte)9)) {
            int nl = this.scopeLevel + 1;
            this.tryIntPower(3, true, nl == 2 ? 0 : nl);
            this.tryIntPowerPacket((byte)3, nl == 2 ? 0 : nl);
            if (nl != 2) {
                this.getSelf().method_5783(ModSounds.RATT_SCOPE_EVENT, 1.0f, (float)((double)0.98f + Math.random() * (double)0.04f));
            }
        }
    }

    @Override
    public boolean tryIntPower(int move, boolean forced, int chargeTime) {
        switch (move) {
            case 3: {
                this.setCooldown((byte)9, 10);
                this.setAttackTime(-1);
                this.setScopeLevel(chargeTime);
                this.getStandUserSelf().roundabout$setCombatMode(this.scopeLevel != 0);
                break;
            }
            case 4: {
                this.chargeTime = chargeTime;
                break;
            }
            case 10: {
                this.setShotCooldown(chargeTime >= 90 ? 30 : 10);
                this.setCooldown((byte)8, 30);
                if (!this.isClient()) {
                    this.FireDart(chargeTime, 0.2f);
                    break;
                }
                this.updateChargeTime(0);
            }
        }
        return super.tryIntPower(move, forced, chargeTime);
    }

    public void ToggleBursting() {
        this.getStandUserSelf().roundabout$setUniqueStandModeToggle(!this.isAuto());
        this.tryPower(11, true);
        this.tryPowerPacket((byte)11);
    }

    public void PlayerFire() {
        int i = this.getChargeTime();
        this.tryIntPower(10, true, i);
        this.tryIntPowerPacket((byte)10, i);
    }

    public void BurstFire() {
        if (!this.isAttackIneptVisually((byte)16, 2)) {
            this.tryPower(17, true);
            this.tryPowerPacket((byte)17);
        }
    }

    public void FireDart(int i, float acuracy) {
        float power = 0.0f;
        for (int b = ShotThresholds.length - 1; b >= 0; --b) {
            if (i < ShotThresholds[b]) continue;
            power = ShotPowerFloats[b];
            break;
        }
        RattDartEntity e = new RattDartEntity(this.getSelf().method_37908(), this.getSelf(), i);
        e.method_24919((class_1297)this.getSelf(), this.getSelf().method_36455(), this.getSelf().method_36454(), -0.5f, power, acuracy);
        e.EnableSuperThrow();
        this.getSelf().method_37908().method_8649((class_1297)e);
    }

    public void ToggleAuto() {
        this.getStandUserSelf().roundabout$setUniqueStandModeToggle(!this.isAuto());
    }

    public void DeployClient() {
        if (!this.onCooldown((byte)8)) {
            this.updateChargeTime(0);
            this.getSelf().method_5783(ModSounds.RATT_SUMMON_EVENT, 1.0f, (float)((double)0.98f + Math.random() * (double)0.04f));
            class_3965 blockHitResult = this.getValidPlacement();
            if (blockHitResult != null) {
                class_243 pos = blockHitResult.method_17784();
                if (blockHitResult.method_17780() != class_2350.field_11036 && blockHitResult.method_17780() != class_2350.field_11033) {
                    pos = new class_243(pos.method_10216(), (double)((int)pos.method_10214() + 1), pos.method_10215());
                }
                this.tryPosPower(1, true, pos);
                this.tryPosPowerPacket((byte)1, pos);
            }
        }
    }

    public void RecallClient() {
        if (!this.onCooldown((byte)8)) {
            this.tryPower(2, true);
            this.tryPowerPacket((byte)2);
        }
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        switch (move) {
            case 2: {
                this.active = false;
                this.getStandUserSelf().roundabout$setUniqueStandModeToggle(false);
                this.getStandEntity(this.getSelf()).method_5650(class_1297.class_5529.field_26999);
                this.setCooldown((byte)8, 40);
                break;
            }
            case 10: {
                this.setCooldown((byte)5, 15);
                break;
            }
            case 13: {
                this.setAttackTimeDuring(0);
                this.setActivePower((byte)15);
                break;
            }
            case 15: {
                this.setCooldown((byte)8, 10);
                this.setActivePower((byte)15);
                this.chargeTime -= 30;
                if (this.isClient()) break;
                this.FireDart(51, 0.4f);
                break;
            }
            case 11: {
                this.setCooldown((byte)5, 10);
                break;
            }
            case 17: {
                this.setAttackTimeDuring(0);
                this.setAttackTime(-1);
                this.setActivePower((byte)16);
                if (this.isClient()) break;
                this.animateStand((byte)-1);
                break;
            }
            case 16: {
                StandEntity standEntity;
                this.setAttackTime(-1);
                if (this.isClient()) break;
                this.animateStand((byte)82);
                float power = 0.0f;
                for (int b = ShotThresholds.length - 1; b >= 0; --b) {
                    if (51 < ShotThresholds[b]) continue;
                    power = ShotPowerFloats[b];
                    break;
                }
                if (!((standEntity = this.getStandEntity(this.getSelf())) instanceof RattEntity)) break;
                RattEntity RE = (RattEntity)standEntity;
                RattDartEntity e = new RattDartEntity(RE.method_37908(), this.getSelf(), 51);
                e.method_24919((class_1297)RE, RE.getHeadRotationX() * 180.0f / (float)Math.PI + 180.0f, RE.getStandRotationY() * 180.0f / (float)Math.PI, -0.5f, power, 0.1f);
                e.EnableSuperThrow();
                RE.method_37908().method_8649((class_1297)e);
            }
        }
        return super.tryPower(move, forced);
    }

    @Override
    public boolean setPowerNone() {
        if (!this.isPlaced()) {
            return super.setPowerNone();
        }
        return true;
    }

    @Override
    public float inputSpeedModifiers(float basis) {
        if (this.scopeLevel != 0) {
            basis *= 0.5f;
        }
        return super.inputSpeedModifiers(basis);
    }

    @Override
    public boolean isAttackIneptVisually(byte activeP, int slot) {
        switch (activeP) {
            case 7: {
                return this.getShootTarget() == null && this.getSelf().method_18276() && !this.isAuto() && this.isPlaced();
            }
            case 8: {
                if (this.isPlaced()) {
                    return false;
                }
                if (this.scopeLevel != 0) break;
                return this.getValidPlacement() == null && !this.isPlaced();
            }
            case 16: {
                return this.shotcooldown != 0;
            }
            case 5: {
                if (this.scopeLevel != 0) {
                    return this.getChargeTime() <= 30 || this.shotcooldown != 0;
                }
                if (!this.isPlaced()) break;
                return !this.isAuto() && this.getShootTarget() == null;
            }
        }
        return super.isAttackIneptVisually(activeP, slot);
    }

    @Override
    public boolean interceptAttack() {
        return this.scopeLevel != 0;
    }

    @Override
    public void buttonInputAttack(boolean keyIsDown, class_315 options) {
        if (keyIsDown && this.scopeLevel != 0 && this.chargeTime >= 30 && this.getActivePower() == 0 && !this.isAttackIneptVisually((byte)5, 2)) {
            if (this.isAuto()) {
                this.tryPower(13, true);
                this.tryPowerPacket((byte)13);
            } else {
                this.PlayerFire();
            }
        }
    }

    @Override
    public boolean interceptGuard() {
        return this.scopeLevel != 0;
    }

    @Override
    public boolean buttonInputGuard(boolean keyIsDown, class_315 options) {
        if (this.getActivePower() == 0 && this.getChargeTime() != 100 && this.shotcooldown == 0) {
            this.tryPower(3, true);
            this.tryPowerPacket((byte)3);
        }
        return true;
    }

    @Override
    public void tickStandRejection(class_1293 effect) {
        if (!this.isClient() && effect.method_5584() % 15 == 0) {
            class_1293 effec = this.getSelf().method_6112(ModEffects.MELTING);
            int stack = effec != null ? effec.method_5578() : 0;
            this.getSelf().method_6092(new class_1293(ModEffects.MELTING, 600, stack + 2));
            float degrees = (float)Math.random() * 360.0f;
            MainUtil.takeUnresistableKnockbackWithY((class_1297)this.getSelf(), 0.27f, class_3532.method_15374((float)(degrees * ((float)Math.PI / 180))), class_3532.method_15374((float)-0.34906584f), -class_3532.method_15362((float)(degrees * ((float)Math.PI / 180))));
        }
    }

    @Override
    public void renderAttackHud(class_332 context, class_1657 playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
        int j = scaledHeight / 2 - 7 - 4;
        int k = scaledWidth / 2 - 8;
        if (this.shotcooldown != 0) {
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            float ratio = (float)this.shotcooldown / (float)this.maxshotcooldown;
            int fifteen = 15 - Math.round(ratio * 15.0f);
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 12, fifteen, 6);
        } else if (this.getChargeTime() >= 10 || this.scopeLevel != 0) {
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            float amount = (float)this.getChargeTime() / 100.0f;
            int finalAmount = Math.round(amount * 15.0f);
            int bartexture = 30;
            if (this.getChargeTime() >= 90) {
                bartexture -= 6;
            }
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, bartexture, finalAmount, 6);
        }
        super.renderAttackHud(context, playerEntity, scaledWidth, scaledHeight, ticks, vehicleHeartCount, flashAlpha, otherFlashAlpha);
    }

    @Override
    public boolean canScope() {
        return this.getStandUserSelf().roundabout$getActive() && !this.isPlaced();
    }

    @Override
    public boolean rendersPlayer() {
        return !this.isPlaced();
    }

    @Override
    public List<Byte> getSkinList() {
        return Arrays.asList((byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6, (byte)7);
    }

    @Override
    public class_2561 getSkinName(byte skinId) {
        return PowersRatt.getSkinNameT(skinId);
    }

    public static class_2561 getSkinNameT(byte skinId) {
        switch (skinId) {
            case 2: {
                return class_2561.method_43471((String)"skins.roundabout.ratt.manga");
            }
            case 3: {
                return class_2561.method_43471((String)"skins.roundabout.ratt.melon");
            }
            case 4: {
                return class_2561.method_43471((String)"skins.roundabout.ratt.sand");
            }
            case 5: {
                return class_2561.method_43471((String)"skins.roundabout.ratt.aztec");
            }
            case 6: {
                return class_2561.method_43471((String)"skins.roundabout.ratt.tower");
            }
            case 7: {
                return class_2561.method_43471((String)"skins.roundabout.ratt.snowy");
            }
        }
        return class_2561.method_43471((String)"skins.roundabout.ratt.anime");
    }

    @Override
    public class_2561 getPosName(byte posID) {
        if (posID == 1) {
            return class_2561.method_43471((String)"idle.roundabout.ratt_1");
        }
        return class_2561.method_43471((String)"idle.roundabout.ratt_2");
    }

    @Override
    public class_3414 getSoundFromByte(byte soundChoice) {
        byte bt = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (soundChoice == 18) {
            return ModSounds.RATT_SUMMON_EVENT;
        }
        return super.getSoundFromByte(soundChoice);
    }

    @Override
    public boolean isWip() {
        return true;
    }

    @Override
    public class_2561 ifWipListDevStatus() {
        return class_2561.method_43471((String)"roundabout.dev_status.active").method_27692(class_124.field_1075);
    }

    @Override
    public class_2561 ifWipListDev() {
        return class_2561.method_43470((String)"Prisma").method_27692(class_124.field_1054);
    }
}

