/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.stand.powers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.hydra.jojomod.access.IGravityEntity;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.npcs.Aesthetician;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.AbilityIconInstance;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.elements.PowerContext;
import net.hydra.jojomod.stand.powers.presets.NewDashPreset;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.S2CPacketUtil;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1439;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public class PowersWalkingHeart
extends NewDashPreset {
    public boolean hasUIOpen = false;
    public static final byte VISAGE_NOISE = 104;
    public static final byte IMPALE_NOISE = 105;

    public PowersWalkingHeart(class_1309 self) {
        super(self);
    }

    @Override
    public StandEntity getNewStandEntity() {
        return (StandEntity)ModEntities.WALKING_HEART.method_5883(this.getSelf().method_37908());
    }

    @Override
    public StandPowers generateStandPowers(class_1309 entity) {
        return new PowersWalkingHeart(entity);
    }

    @Override
    public boolean isSecondaryStand() {
        return true;
    }

    @Override
    public List<Byte> getPosList() {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add((byte)0);
        $$1.add((byte)1);
        $$1.add((byte)2);
        $$1.add((byte)3);
        $$1.add((byte)4);
        return $$1;
    }

    @Override
    public void powerActivate(PowerContext context) {
        switch (context) {
            case SKILL_1_NORMAL: 
            case SKILL_1_CROUCH: {
                this.doUIClient();
                break;
            }
            case SKILL_2_NORMAL: 
            case SKILL_2_CROUCH: {
                this.doDefaceClient();
                break;
            }
            case SKILL_3_NORMAL: 
            case SKILL_3_CROUCH: {
                this.dash();
            }
        }
    }

    public void doDefaceClient() {
        if (!this.onCooldown((byte)1)) {
            if (this.activePower == 23) {
                ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
                this.tryPowerPacket((byte)0);
            } else {
                ((StandUser)this.getSelf()).roundabout$tryPower(23, true);
                this.tryPowerPacket((byte)23);
            }
        }
    }

    public void doUIClient() {
        this.tryPowerPacket((byte)21);
        ClientUtil.setCinderellaUI();
        this.hasUIOpen = true;
    }

    @Override
    public class_2561 getSkinName(byte skinId) {
        return PowersWalkingHeart.getSkinNameT(skinId);
    }

    public static class_2561 getSkinNameT(byte skinId) {
        if (skinId == 2) {
            return class_2561.method_43471((String)"skins.roundabout.cinderella.manga");
        }
        if (skinId == 3) {
            return class_2561.method_43471((String)"skins.roundabout.cinderella.zombie");
        }
        if (skinId == 4) {
            return class_2561.method_43471((String)"skins.roundabout.cinderella.jack_in_the_box");
        }
        if (skinId == 5) {
            return class_2561.method_43471((String)"skins.roundabout.cinderella.business");
        }
        return class_2561.method_43471((String)"skins.roundabout.cinderella.base");
    }

    @Override
    public void renderIcons(class_332 context, int x, int y) {
        this.setSkillIcon(context, x, y, 1, StandIcons.CINDERELLA_MASK, (byte)-1);
        this.setSkillIcon(context, x, y, 2, StandIcons.CINDERELLA_SCALP, (byte)1);
        this.setSkillIcon(context, x, y, 3, StandIcons.DODGE, (byte)6);
    }

    @Override
    protected Byte getSummonSound() {
        return (byte)18;
    }

    @Override
    public class_3414 getSoundFromByte(byte soundChoice) {
        byte bt = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (soundChoice == 18) {
            return ModSounds.CINDERELLA_SUMMON_EVENT;
        }
        if (soundChoice == 105) {
            return ModSounds.CINDERELLA_ATTACK_EVENT;
        }
        if (soundChoice == 104) {
            return ModSounds.CINDERELLA_VISAGE_CREATION_EVENT;
        }
        return super.getSoundFromByte(soundChoice);
    }

    @Override
    public boolean isWip() {
        return true;
    }

    @Override
    public class_2561 ifWipListDevStatus() {
        return class_2561.method_43471((String)"roundabout.dev_status.active").method_27692(class_124.field_1075);
    }

    @Override
    public class_2561 ifWipListDev() {
        return class_2561.method_43470((String)"Hydra").method_27692(class_124.field_1054);
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        switch (move) {
            case 23: {
                this.switchDirections();
            }
        }
        return super.tryPower(move, forced);
    }

    public void switchDirections() {
        ((IGravityEntity)this.self).roundabout$setGravityDirection(class_2350.field_11035);
        class_238 $$0 = this.self.method_5829().method_1009(10.0, 8.0, 10.0);
        List $$1 = this.self.method_37908().method_8335((class_1297)this.self, $$0);
        float mindist = -1.0f;
        for (class_1297 $$3 : $$1) {
            ((IGravityEntity)$$3).roundabout$setGravityDirection(class_2350.field_11035);
        }
    }

    @Override
    public void tickPower() {
        if (this.self.method_37908().method_8608()) {
            if (this.hasUIOpen && !ClientUtil.hasCinderellaUI()) {
                this.hasUIOpen = false;
                ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
                this.tryPowerPacket((byte)0);
            }
        } else if (this.getActivePower() == 21) {
            ((class_3218)this.getSelf().method_37908()).method_14199((class_2394)ModParticles.PINK_SMOKE, this.getSelf().method_23317(), this.getSelf().method_23318() + 0.3, this.getSelf().method_23321(), 1, 2.5, 2.0, 2.5, 0.015);
            class_1309 class_13092 = this.self;
            if (class_13092 instanceof Aesthetician) {
                Aesthetician aes = (Aesthetician)class_13092;
                if ((this.getStandEntity(this.self) == null || this.getStandEntity(this.self).method_31481()) && this.canSummonStand()) {
                    ((StandUser)this.self).roundabout$summonStand(this.self.method_37908(), true, false);
                }
                if (aes.interactingWith != null && aes.interactingWith.isEmpty()) {
                    ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
                }
            }
        } else {
            class_1309 class_13093 = this.self;
            if (class_13093 instanceof Aesthetician) {
                Aesthetician aes = (Aesthetician)class_13093;
                if (aes.interactingWith != null && !aes.interactingWith.isEmpty()) {
                    ((StandUser)this.getSelf()).roundabout$tryPower(21, true);
                }
            }
        }
        super.tickPower();
    }

    @Override
    public void updateUniqueMoves() {
        super.updateUniqueMoves();
    }

    @Override
    public boolean setPowerOther(int move, int lastMove) {
        return super.setPowerOther(move, lastMove);
    }

    public boolean deface() {
        StandEntity stand = this.getStandEntity(this.self);
        if (Objects.nonNull(stand)) {
            this.setAttackTimeDuring(0);
            this.setActivePower((byte)23);
            this.playStandUserOnlySoundsIfNearby((byte)105, 27.0, false, false);
            this.animateStand((byte)81);
            this.poseStand((byte)1);
            return true;
        }
        return false;
    }

    public void updateDeface() {
        if (this.attackTimeDuring > -1) {
            if (this.attackTimeDuring > 15) {
                this.standImpale();
            } else if (!this.getSelf().method_37908().method_8608() && this.attackTimeDuring % 4 == 0) {
                ((class_3218)this.getSelf().method_37908()).method_14199((class_2394)ModParticles.MENACING, this.getSelf().method_23317(), this.getSelf().method_23318() + 0.3, this.getSelf().method_23321(), 1, 0.2, 0.2, 0.2, 0.05);
            }
        }
    }

    @Override
    public void tickMobAI(class_1309 attackTarget) {
        if (attackTarget != null && attackTarget.method_5805()) {
            class_1297 targetEntity;
            if (this.getActivePower() != 0 || attackTarget.method_5739((class_1297)this.getSelf()) <= 5.0f) {
                this.getSelf().method_36457(this.getLookAtEntityPitch((class_1297)this.getSelf(), (class_1297)attackTarget));
                float yrot = this.getLookAtEntityYaw((class_1297)this.getSelf(), (class_1297)attackTarget);
                this.getSelf().method_36456(yrot);
                this.getSelf().method_5847(yrot);
            }
            if ((targetEntity = this.getTargetEntity(this.self, 5.0f)) != null && targetEntity.method_5779((class_1297)attackTarget) && this.getActivePower() == 0 && (!this.onCooldown((byte)1) || this.self instanceof class_1439)) {
                ((StandUser)this.getSelf()).roundabout$tryPower(23, true);
            }
        }
    }

    @Override
    public List<AbilityIconInstance> drawGUIIcons(class_332 context, float delta, int mouseX, int mouseY, int leftPos, int topPos, byte level, boolean bypass) {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 80, 0, "ability.roundabout.visage_creation", "instruction.roundabout.press_skill", StandIcons.CINDERELLA_MASK, 1, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 99, 0, "ability.roundabout.face_removal", "instruction.roundabout.press_skill", StandIcons.CINDERELLA_SCALP, 2, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 118, 0, "ability.roundabout.dodge", "instruction.roundabout.press_skill", StandIcons.DODGE, 3, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 80, 0, "ability.roundabout.visages", "instruction.roundabout.passive", StandIcons.CINDERELLA_VISAGES, 0, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 99, 0, "ability.roundabout.lucky_lipstick", "instruction.roundabout.passive", StandIcons.CINDERELLA_LIPSTICK, 0, level, bypass));
        return $$1;
    }

    @Override
    public List<Byte> getSkinList() {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add((byte)1);
        $$1.add((byte)2);
        $$1.add((byte)3);
        $$1.add((byte)4);
        $$1.add((byte)5);
        return $$1;
    }

    public void standImpale() {
        if (this.self instanceof class_1657) {
            if (this.isPacketPlayer()) {
                this.setAttackTimeDuring(-15);
                this.tryIntToServerPacket((byte)4, this.getTargetEntityId2(5.0f));
            }
        } else {
            class_1297 targetEntity = this.getTargetEntity(this.self, 5.0f);
            this.defaceImpact(targetEntity);
        }
    }

    public float getDefaceStrength(class_1297 entity) {
        if (this.getReducedDamage(entity)) {
            return this.levelupDamageMod((float)(3.0 * ((double)ClientNetworking.getAppropriateConfig().cinderellaSettings.cinderellaAttackMultOnPlayers.intValue() * 0.01)));
        }
        return this.levelupDamageMod((float)(9.0 * ((double)ClientNetworking.getAppropriateConfig().cinderellaSettings.cinderellaAttackMultOnMobs.intValue() * 0.01)));
    }

    public float getDefaceKnockback() {
        return 0.7f;
    }

    @Override
    public void handleStandAttack(class_1657 player, class_1297 target) {
        this.defaceImpact(target);
    }

    public void defaceImpact(class_1297 entity) {
        class_3414 SE;
        this.setAttackTimeDuring(-20);
        if (entity != null) {
            float pow = this.getDefaceStrength(entity);
            float knockbackStrength = this.getDefaceKnockback();
            if (this.StandDamageEntityAttack(entity, pow, 0.0f, (class_1297)this.self)) {
                if (entity instanceof class_1309) {
                    class_1309 LE = (class_1309)entity;
                    this.addEXP(5, LE);
                    if (MainUtil.getMobBleed(entity)) {
                        int bleedlevel = ((StandUser)LE).roundabout$getBleedLevel();
                        if (bleedlevel < 0) {
                            MainUtil.makeFaceless(entity, 200, 0, (class_1297)this.getSelf());
                            MainUtil.makeBleed(entity, 0, 200, (class_1297)this.getSelf());
                        } else if (bleedlevel == 0) {
                            MainUtil.makeFaceless(entity, 250, 1, (class_1297)this.getSelf());
                            MainUtil.makeBleed(entity, 1, 250, (class_1297)this.getSelf());
                        } else {
                            MainUtil.makeFaceless(entity, 300, 2, (class_1297)this.getSelf());
                            MainUtil.makeBleed(entity, 2, 300, (class_1297)this.getSelf());
                            MainUtil.makeMobBleed(entity);
                        }
                    } else {
                        MainUtil.makeFaceless(entity, 200, 0, (class_1297)this.getSelf());
                    }
                }
                this.takeDeterminedKnockback(this.self, entity, knockbackStrength);
            }
        }
        if (this.getSelf() instanceof class_1657) {
            S2CPacketUtil.sendCooldownSyncPacket((class_1657)((class_3222)this.getSelf()), (byte)1, ClientNetworking.getAppropriateConfig().cinderellaSettings.defaceAttackCooldown);
        }
        this.setCooldown((byte)1, ClientNetworking.getAppropriateConfig().cinderellaSettings.defaceAttackCooldown);
        float pitch = 1.0f;
        if (entity != null) {
            SE = ModSounds.PUNCH_3_SOUND_EVENT;
            pitch = 1.2f;
        } else {
            SE = ModSounds.PUNCH_2_SOUND_EVENT;
        }
        if (!this.self.method_37908().method_8608()) {
            this.self.method_37908().method_8396(null, this.self.method_24515(), SE, class_3419.field_15248, 0.95f, pitch);
        }
    }

    @Override
    public void tickStandRejection(class_1293 effect) {
        if (!this.getSelf().method_37908().method_8608() && effect.method_5584() == 15) {
            MainUtil.makeFaceless((class_1297)this.self, 800, 0, (class_1297)this.self);
            this.self.method_37908().method_8396(null, this.self.method_24515(), ModSounds.CINDERELLA_FAIL_EVENT, class_3419.field_15248, 1.0f, 1.0f);
        }
    }

    @Override
    public void renderAttackHud(class_332 context, class_1657 playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
        class_1297 TE;
        int j = scaledHeight / 2 - 7 - 4;
        int k = scaledWidth / 2 - 8;
        if (this.getActivePower() == 23 && (TE = this.getTargetEntity((class_1309)playerEntity, 5.0f)) != null) {
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 0, 15, 6);
        }
    }
}

