/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.util;

import net.hydra.jojomod.util.gravity.QuaternionUtil;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.apache.commons.lang3.Validate;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RotationAnimation {
    private boolean inAnimation = false;
    private Quaternionf startGravityRotation;
    private Quaternionf endGravityRotation;
    private class_243 relativeRotationCenter = class_243.field_1353;
    private long startTimeMs;
    private long endTimeMs;

    public void startRotationAnimation(class_2350 newGravity, class_2350 prevGravity, long durationTimeMs, class_1297 entity, long timeMs, boolean rotateView, class_243 relativeRotationCenter) {
        if (durationTimeMs == 0L) {
            this.inAnimation = false;
            return;
        }
        Validate.notNull((Object)entity);
        class_243 newLookingDirection = this.getNewLookingDirection(newGravity, prevGravity, entity, rotateView);
        Quaternionf oldViewRotation = QuaternionUtil.getViewRotation(entity.method_36455(), entity.method_36454());
        this.update(timeMs);
        Quaternionf currentAnimatedGravityRotation = this.getCurrentGravityRotation(prevGravity, timeMs);
        Quaternionf currentAnimatedCameraRotation = new Quaternionf().set((Quaternionfc)oldViewRotation).mul((Quaternionfc)currentAnimatedGravityRotation);
        Quaternionf newEndGravityRotation = RotationUtil.getWorldRotationQuaternion(newGravity);
        class_241 newYawAndPitch = RotationUtil.vecToRot(RotationUtil.vecWorldToPlayer(newLookingDirection, newGravity));
        float newPitch = newYawAndPitch.field_1342;
        float newYaw = newYawAndPitch.field_1343;
        float deltaYaw = newYaw - entity.method_36454();
        float deltaPitch = newPitch - entity.method_36455();
        entity.method_36456(entity.method_36454() + deltaYaw);
        entity.method_36457(entity.method_36455() + deltaPitch);
        entity.field_5982 += deltaYaw;
        entity.field_6004 += deltaPitch;
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            livingEntity.field_6283 += deltaYaw;
            livingEntity.field_6220 += deltaYaw;
            livingEntity.field_6241 += deltaYaw;
            livingEntity.field_6259 += deltaYaw;
        }
        Quaternionf newViewRotation = QuaternionUtil.getViewRotation(entity.method_36455(), entity.method_36454());
        Quaternionf animationStartGravityRotation = new Quaternionf().set((Quaternionfc)newViewRotation).conjugate().mul((Quaternionfc)currentAnimatedCameraRotation);
        this.relativeRotationCenter = relativeRotationCenter;
        this.inAnimation = true;
        this.startGravityRotation = animationStartGravityRotation;
        this.endGravityRotation = newEndGravityRotation;
        this.startTimeMs = timeMs;
        this.endTimeMs = timeMs + durationTimeMs;
    }

    private class_243 getNewLookingDirection(class_2350 newGravity, class_2350 prevGravity, class_1297 player, boolean rotateView) {
        class_243 oldLookingDirection = RotationUtil.vecPlayerToWorld(RotationUtil.rotToVec(player.method_36454(), player.method_36455()), prevGravity);
        if (!rotateView) {
            return oldLookingDirection;
        }
        if (newGravity == prevGravity.method_10153()) {
            return oldLookingDirection.method_1021(-1.0);
        }
        Quaternionf deltaRotation = QuaternionUtil.getRotationBetween(class_243.method_24954((class_2382)prevGravity.method_10163()), class_243.method_24954((class_2382)newGravity.method_10163()));
        Vector3f lookingDirection = new Vector3f((float)oldLookingDirection.field_1352, (float)oldLookingDirection.field_1351, (float)oldLookingDirection.field_1350);
        lookingDirection.rotate((Quaternionfc)deltaRotation);
        class_243 newLookingDirection = new class_243(lookingDirection);
        return newLookingDirection;
    }

    public Quaternionf getCurrentGravityRotation(class_2350 currentGravity, long timeMs) {
        this.update(timeMs);
        if (!this.inAnimation) {
            return RotationUtil.getWorldRotationQuaternion(currentGravity);
        }
        double delta = (double)(timeMs - this.startTimeMs) / (double)(this.endTimeMs - this.startTimeMs);
        return RotationUtil.interpolate(this.startGravityRotation, this.endGravityRotation, RotationAnimation.mapProgress((float)delta));
    }

    public void update(long timeMs) {
        if (timeMs > this.endTimeMs) {
            this.inAnimation = false;
        }
    }

    public class_243 getEyeOffset(Quaternionf gravityRot, class_243 localEyeOffset, class_2350 newGravity) {
        Quaternionf gravityRotForEntity = new Quaternionf((Quaternionfc)gravityRot).conjugate();
        if (!this.inAnimation || this.relativeRotationCenter.equals((Object)class_243.field_1353)) {
            return QuaternionUtil.rotate(localEyeOffset, gravityRotForEntity);
        }
        class_243 rotationCenterOffset = RotationUtil.vecPlayerToWorld(this.relativeRotationCenter, newGravity);
        class_243 eyeOffsetFromRotationCenter = localEyeOffset.method_1020(this.relativeRotationCenter);
        class_243 rotatedEyeOffsetFromRotationCenter = QuaternionUtil.rotate(eyeOffsetFromRotationCenter, gravityRotForEntity);
        return rotationCenterOffset.method_1019(rotatedEyeOffsetFromRotationCenter);
    }

    private static float mapProgress(float delta) {
        return class_3532.method_15363((float)(delta * delta * (3.0f - 2.0f * delta)), (float)0.0f, (float)1.0f);
    }

    public boolean isInAnimation() {
        return this.inAnimation;
    }
}

