/*
 * Decompiled with CFR 0.152.
 */
package net.zetalasis.networking.packet.impl;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.client.ClientUtil;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.zetalasis.networking.packet.api.IClientNetworking;
import net.zetalasis.networking.packet.api.args.c2s.AbstractBaseC2SPacket;
import net.zetalasis.networking.packet.api.args.s2c.AbstractBaseS2CPacket;
import net.zetalasis.networking.packet.impl.packet.MessageC2S;
import net.zetalasis.networking.packet.impl.packet.MessageS2C;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ModNetworking {
    private static final HashMap<Class<?>, Function<class_2540, Object>> DECODERS = new HashMap();
    public static final Map<Class<?>, BiConsumer<class_2540, Object>> ENCODERS = new HashMap();
    private static final HashMap<class_2960, AbstractBaseC2SPacket> registrarC2S = new HashMap();
    private static final HashMap<class_2960, AbstractBaseS2CPacket> registrarS2C = new HashMap();

    public static void bootstrap() {
        ModNetworking.register(new MessageC2S());
        ModNetworking.register(new MessageS2C());
    }

    @Nullable
    public static class_2535 getC2SConnection() {
        return ClientUtil.getC2SConnection();
    }

    private static class_2960 buildFromClassName(Class<?> c) {
        return Roundabout.location(c.getSimpleName().toLowerCase());
    }

    public static <T extends AbstractBaseC2SPacket> void register(T packet) {
        if (registrarC2S.containsValue(packet)) {
            Roundabout.LOGGER.warn("Duplicate caught while registering C2S packet \"{}\"", (Object)ModNetworking.buildFromClassName(packet.getClass()));
            return;
        }
        registrarC2S.put(ModNetworking.buildFromClassName(packet.getClass()), packet);
    }

    public static <T extends AbstractBaseS2CPacket> void register(T packet) {
        if (registrarS2C.containsValue(packet)) {
            Roundabout.LOGGER.warn("Duplicate caught while registering S2C packet \"{}\"", (Object)ModNetworking.buildFromClassName(packet.getClass()));
            return;
        }
        registrarS2C.put(ModNetworking.buildFromClassName(packet.getClass()), packet);
    }

    public static <T extends AbstractBaseC2SPacket> void send(T packetType, Object ... args) {
        class_2535 con = ModNetworking.getC2SConnection();
        if (con == null) {
            return;
        }
        con.method_10743((class_2596)new class_2817(ModNetworking.buildFromClassName(packetType.getClass()), ModNetworking.createBufferFromVArgs(args)));
    }

    public static <T extends AbstractBaseS2CPacket> void send(T packetType, class_3222 recipient, Object ... args) {
        class_2535 con = ((IClientNetworking)recipient.field_13987).roundabout$getServer();
        if (con == null) {
            return;
        }
        con.method_10743((class_2596)new class_2658(ModNetworking.buildFromClassName(packetType.getClass()), ModNetworking.createBufferFromVArgs(args)));
    }

    public static void encodeValue(class_2540 buf, Object value) {
        BiConsumer<class_2540, Object> encoder = ENCODERS.get(value.getClass());
        if (encoder == null) {
            throw new IllegalArgumentException("No encoder for type: " + value.getClass().getName());
        }
        encoder.accept(buf, value);
    }

    public static Object decodeValue(class_2540 buf, Class<?> type) {
        Function<class_2540, Object> decoder = DECODERS.get(type);
        if (decoder == null) {
            throw new IllegalArgumentException("No decoder for type: " + type.getName());
        }
        return decoder.apply(buf);
    }

    private static String generateSignature(Object ... args) {
        if (args.length == 0) {
            return "void";
        }
        StringBuilder sig = new StringBuilder();
        for (Object arg : args) {
            Class<?> c = arg.getClass();
            sig.append(c.getName()).append(";");
        }
        return sig.toString();
    }

    private static class_2540 createBufferFromVArgs(Object ... args) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10814(ModNetworking.generateSignature(args));
        for (Object arg : args) {
            ModNetworking.encodeValue(buf, arg);
        }
        return buf;
    }

    public static Object[] decodeBufferToVArgs(class_2540 buf) {
        String[] sigClasses;
        String sig = buf.method_19772();
        if (sig.equals("void")) {
            return new Object[0];
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (String className : sigClasses = sig.split(";")) {
            if (className.isEmpty()) continue;
            try {
                Class<?> clazz = Class.forName(className);
                result.add(ModNetworking.decodeValue(buf, clazz));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed decoding FriendlyByteBuf to VArgs:\n" + className + " was not found.\n[" + sig + "]");
            }
        }
        if (buf.readableBytes() > 0) {
            throw new RuntimeException("Warning: extra unread bytes in buffer! Signature: " + sig);
        }
        return result.toArray();
    }

    @Nullable
    public static AbstractBaseC2SPacket getC2S(class_2960 location) {
        return registrarC2S.get(location);
    }

    @Nullable
    public static AbstractBaseS2CPacket getS2C(class_2960 location) {
        return registrarS2C.get(location);
    }

    static {
        DECODERS.put(Integer.class, class_2540::readInt);
        DECODERS.put(Long.class, class_2540::readLong);
        DECODERS.put(Float.class, class_2540::readFloat);
        DECODERS.put(Double.class, class_2540::readDouble);
        DECODERS.put(Boolean.class, class_2540::readBoolean);
        DECODERS.put(Byte.class, class_2540::readByte);
        DECODERS.put(Short.class, class_2540::readShort);
        DECODERS.put(String.class, class_2540::method_19772);
        DECODERS.put(UUID.class, class_2540::method_10790);
        DECODERS.put(class_2960.class, class_2540::method_10810);
        DECODERS.put(class_2338.class_2339.class, class_2540::method_10811);
        DECODERS.put(class_2338.class, class_2540::method_10811);
        DECODERS.put(Vector3f.class, class_2540::method_49069);
        DECODERS.put(class_1799.class, class_2540::method_10819);
        DECODERS.put(class_3965.class, class_2540::method_17814);
        DECODERS.put(class_2487.class, class_2540::method_10798);
        ENCODERS.put(Integer.class, (buf, o) -> buf.writeInt(((Integer)o).intValue()));
        ENCODERS.put(Integer.TYPE, (buf, o) -> buf.writeInt(((Integer)o).intValue()));
        ENCODERS.put(Long.class, (buf, o) -> buf.writeLong(((Long)o).longValue()));
        ENCODERS.put(Long.TYPE, (buf, o) -> buf.writeLong(((Long)o).longValue()));
        ENCODERS.put(Float.class, (buf, o) -> buf.writeFloat(((Float)o).floatValue()));
        ENCODERS.put(Float.TYPE, (buf, o) -> buf.writeFloat(((Float)o).floatValue()));
        ENCODERS.put(Double.class, (buf, o) -> buf.writeDouble(((Double)o).doubleValue()));
        ENCODERS.put(Double.TYPE, (buf, o) -> buf.writeDouble(((Double)o).doubleValue()));
        ENCODERS.put(Boolean.class, (buf, o) -> buf.writeBoolean(((Boolean)o).booleanValue()));
        ENCODERS.put(Boolean.TYPE, (buf, o) -> buf.writeBoolean(((Boolean)o).booleanValue()));
        ENCODERS.put(Byte.class, (buf, o) -> buf.writeByte((int)((Byte)o).byteValue()));
        ENCODERS.put(Byte.TYPE, (buf, o) -> buf.writeByte((int)((Byte)o).byteValue()));
        ENCODERS.put(Short.class, (buf, o) -> buf.writeShort((int)((Short)o).shortValue()));
        ENCODERS.put(Short.TYPE, (buf, o) -> buf.writeShort((int)((Short)o).shortValue()));
        ENCODERS.put(Character.class, (buf, o) -> buf.writeChar((int)((Character)o).charValue()));
        ENCODERS.put(Character.TYPE, (buf, o) -> buf.writeChar((int)((Character)o).charValue()));
        ENCODERS.put(String.class, (buf, o) -> buf.method_10814((String)o));
        ENCODERS.put(UUID.class, (buf, o) -> buf.method_10797((UUID)o));
        ENCODERS.put(class_2960.class, (buf, o) -> buf.method_10812((class_2960)o));
        ENCODERS.put(class_2338.class_2339.class, (buf, o) -> buf.method_10807((class_2338)o));
        ENCODERS.put(class_2338.class, (buf, o) -> buf.method_10807((class_2338)o));
        ENCODERS.put(class_1799.class, (buf, o) -> buf.method_10793((class_1799)o));
        ENCODERS.put(Vector3f.class, (buf, o) -> buf.method_49068((Vector3f)o));
        ENCODERS.put(class_3965.class, (buf, o) -> buf.method_17813((class_3965)o));
        ENCODERS.put(class_2487.class, (buf, o) -> buf.method_10794((class_2487)o));
    }
}

