/*
 * Decompiled with CFR 0.152.
 */
package net.zetalasis.world;

import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.advancement.criteria.ModCriteria;
import net.hydra.jojomod.entity.stand.D4CEntity;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.stand.powers.PowersD4C;
import net.hydra.jojomod.util.S2CPacketUtil;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2780;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.zetalasis.networking.message.impl.IMessageEvent;
import net.zetalasis.world.DynamicWorldAccessor;
import org.jetbrains.annotations.Nullable;

public class DynamicWorld {
    private class_3218 level;
    private final String name;
    public static HashMap<String, class_1937> levels = new HashMap();
    public class_5321<class_1937> LEVEL_KEY;

    public DynamicWorld(MinecraftServer server, String name, boolean broadcastPacket) {
        this.name = name;
        DynamicWorldAccessor accessor = DynamicWorldAccessor.getFrom(server);
        this.LEVEL_KEY = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)Roundabout.location(name));
        class_2370<class_5363> manager = DynamicWorld.getLevelStemRegistry(server);
        DynamicWorldAccessor managerAccessor = DynamicWorldAccessor.getFrom(manager);
        boolean isFrozen = managerAccessor.roundabout$isFrozen();
        managerAccessor.roundabout$setFrozen(false);
        class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41224, (class_2960)this.LEVEL_KEY.method_29177());
        if (!manager.method_35842(key)) {
            manager.method_10272(key, (Object)new class_5363(server.method_30002().method_8410().method_40134(), server.method_30002().method_14178().method_12129()), Lifecycle.stable());
        }
        managerAccessor.roundabout$setFrozen(isFrozen);
        this.level = new class_3218(server, accessor.roundabout$getExecutor(), accessor.roundabout$getLevelStorageAccess(), accessor.roundabout$getLevelData(), this.LEVEL_KEY, accessor.roundabout$getLevelStem(), accessor.roundabout$getProgressListener(), false, accessor.roundabout$getObfuscatedSeed(), new ArrayList(), false, null);
        server.method_30002().method_8621().method_11983((class_2780)new class_2780.class_3976(this.level.method_8621()));
        accessor.roundabout$addWorld(this.LEVEL_KEY, this.level);
        this.level.method_18765(() -> true);
        levels.put(name, (class_1937)this.level);
        if (broadcastPacket) {
            this.broadcastPacketsToPlayers(server);
        }
    }

    public void broadcastPacketsToPlayers(MinecraftServer server) {
        for (class_3222 sp : server.method_3760().method_14571()) {
            S2CPacketUtil.sendNewDyanmicWorldPacket((class_1657)sp, this.name);
        }
    }

    public class_3218 getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    private static class_2370<class_5363> getLevelStemRegistry(MinecraftServer server) {
        class_5455.class_6890 registryManager = server.method_30611();
        class_2378 temp = registryManager.method_30530(class_7924.field_41224);
        return (class_2370)temp;
    }

    public static void deregisterWorld(MinecraftServer server, String name) {
    }

    private static String generateRandomStringByWords(int numWords) {
        String[] words = new String[]{"boat", "ship", "airplane", "sword", "car", "train", "bike", "rocket", "submarine", "zeppelin", "spiral-staircase", "desolation-row", "fig-tart", "rhinoceros-beetle", "singularity-point", "giotto", "angel", "hydrangea", "secret-emperor"};
        Random random = new Random();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < numWords; ++i) {
            if (i > 0) {
                result.append("-");
            }
            result.append(words[random.nextInt(words.length)]);
        }
        return result.toString();
    }

    public static DynamicWorld generateD4CWorld(MinecraftServer server) {
        return new DynamicWorld(server, "d4c-" + DynamicWorld.generateRandomStringByWords(7) + "-" + server.method_30002().method_8409().method_39332(0, 999999), false);
    }

    public static void loadDynamicWorlds(MinecraftServer server) {
        for (class_3218 level : server.method_3738()) {
            if (!level.method_27983().method_29177().method_12836().equals("roundabout")) continue;
            levels.put(level.method_27983().method_29177().method_12832(), (class_1937)level);
        }
    }

    public static boolean isWorldDynamic(class_1937 level) {
        return levels.containsValue(level);
    }

    public static class DynamicWorldNetMessages
    implements IMessageEvent {
        @Override
        public void INVOKE(String message, @Nullable class_3222 sender, Object ... vargs) {
            if (message.equals(MESSAGES.ADD_WORLD.value)) {
                if (sender == null) {
                    throw new RuntimeException("\"sender\" was null on a C2S packet!");
                }
                MinecraftServer server = sender.field_13995;
                server.execute(() -> {
                    DynamicWorld world;
                    if (((StandUser)sender).roundabout$getStand() instanceof D4CEntity && (world = PowersD4C.queuedWorldTransports.remove(sender.method_5628())) != null && world.getLevel() != null) {
                        sender.method_14251(world.getLevel(), sender.method_23317(), sender.method_23318(), sender.method_23321(), sender.method_36454(), sender.method_36455());
                        ((StandUser)sender).roundabout$summonStand((class_1937)world.getLevel(), true, false);
                        ModCriteria.DIMENSION_HOP_TRIGGER.trigger(sender);
                    }
                });
            }
        }

        public static enum MESSAGES {
            ADD_WORLD("add_world"),
            REMOVE_WORLD("remove_world");

            public final String value;

            private MESSAGES(String value) {
                this.value = value;
            }
        }
    }
}

