/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StairsWoolRedBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    protected static final VoxelShape SHAPE;
    private static final VoxelShape NORTH_SHAPE;
    private static final VoxelShape EAST_SHAPE;
    private static final VoxelShape SOUTH_SHAPE;
    private static final VoxelShape WEST_SHAPE;

    public StairsWoolRedBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            default -> NORTH_SHAPE;
        };
    }

    public boolean m_6104_(BlockState p_53972_, BlockState p_53973_, Direction p_53974_) {
        return false;
    }

    public VoxelShape m_7952_(BlockState $$0, BlockGetter $$1, BlockPos $$2) {
        return Shapes.m_83040_();
    }

    private static VoxelShape rotateShape(VoxelShape shape, Direction to) {
        VoxelShape rotated = shape;
        int times = switch (to) {
            case Direction.EAST -> 1;
            case Direction.SOUTH -> 2;
            case Direction.WEST -> 3;
            default -> 0;
        };
        for (int i = 0; i < times; ++i) {
            VoxelShape next = Shapes.m_83040_();
            for (AABB box : rotated.m_83299_()) {
                double minX = box.f_82288_;
                double minY = box.f_82289_;
                double minZ = box.f_82290_;
                double maxX = box.f_82291_;
                double maxY = box.f_82292_;
                double maxZ = box.f_82293_;
                double nMinX = 1.0 - maxZ;
                double nMinZ = minX;
                double nMaxX = 1.0 - minZ;
                double nMaxZ = maxX;
                next = Shapes.m_83110_((VoxelShape)next, (VoxelShape)Block.m_49796_((double)(nMinX * 16.0), (double)(minY * 16.0), (double)(nMinZ * 16.0), (double)(nMaxX * 16.0), (double)(maxY * 16.0), (double)(nMaxZ * 16.0)));
            }
            rotated = next.m_83296_();
        }
        return rotated;
    }

    static {
        NORTH_SHAPE = SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0));
        EAST_SHAPE = StairsWoolRedBlock.rotateShape(SHAPE, Direction.EAST);
        SOUTH_SHAPE = StairsWoolRedBlock.rotateShape(SHAPE, Direction.SOUTH);
        WEST_SHAPE = StairsWoolRedBlock.rotateShape(SHAPE, Direction.WEST);
    }
}

