/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.models.substand.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.entity.substand.EncasementBubbleEntity;
import net.hydra.jojomod.event.powers.TimeStop;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class EncasementBubbleRenderer
extends EntityRenderer<EncasementBubbleEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("roundabout", "textures/stand/soft_and_wet/projectiles/large_bubble.png");
    private final float scale;
    private final ItemRenderer itemRenderer;

    public EncasementBubbleRenderer(EntityRendererProvider.Context context, float scale) {
        super(context);
        this.itemRenderer = context.m_174025_();
        this.scale = scale;
    }

    public EncasementBubbleRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.m_174025_();
        this.scale = 2.9f;
    }

    public void render(EncasementBubbleEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (ClientUtil.canSeeStands(ClientUtil.getPlayer())) {
            if (((TimeStop)entity.m_9236_()).inTimeStopRange(entity)) {
                partialTicks = 0.0f;
            }
            ClientUtil.pushPoseAndCooperate(poseStack, 55);
            poseStack.m_252880_(0.0f, entity.m_20206_() / 2.0f, 0.0f);
            poseStack.m_85841_(this.scale, this.scale, this.scale);
            poseStack.m_252781_(this.f_114476_.m_253208_());
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity)));
            Matrix4f matrix = poseStack.m_85850_().m_252922_();
            Vector3f normal = Minecraft.m_91087_().f_91063_.m_109153_().m_253058_();
            normal.normalize();
            Vector3f coursecorrect = new Vector3f(0.577f, 0.577f, 0.577f);
            if (normal.y > 0.0f) {
                coursecorrect = new Vector3f(0.01f, 1.0f, 0.01f);
                if ((double)normal.y > 0.95) {
                    coursecorrect = new Vector3f(-0.577f, -0.577f, -0.577f);
                }
            }
            float scaleIt = 0.23f;
            float size = (float)Math.min((double)scaleIt, (double)((float)entity.f_19797_ + partialTicks) * ((double)scaleIt * 0.1));
            vertexConsumer.m_252986_(matrix, -size, -size, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(coursecorrect.x, coursecorrect.y, coursecorrect.z).m_5752_();
            vertexConsumer.m_252986_(matrix, size, -size, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(coursecorrect.x, coursecorrect.y, coursecorrect.z).m_5752_();
            vertexConsumer.m_252986_(matrix, size, size, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(coursecorrect.x, coursecorrect.y, coursecorrect.z).m_5752_();
            vertexConsumer.m_252986_(matrix, -size, size, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(coursecorrect.x, coursecorrect.y, coursecorrect.z).m_5752_();
            ClientUtil.popPoseAndCooperate(poseStack, 55);
            super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    public ResourceLocation getTextureLocation(EncasementBubbleEntity entity) {
        return TEXTURE;
    }
}

