/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.projectile;

import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.stand.RattEntity;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.ModEffects;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.PowersRatt;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class RattDartEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Boolean> ROUNDABOUT$SUPER_THROWN = SynchedEntityData.m_135353_(RattDartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int superThrowTicks = -1;
    int melting = 0;
    float damage = 0.0f;
    int charged = 0;
    boolean particles = false;

    protected void m_8097_() {
        super.m_8097_();
        if (!this.m_20088_().m_285897_(ROUNDABOUT$SUPER_THROWN)) {
            this.m_20088_().m_135372_(ROUNDABOUT$SUPER_THROWN, (Object)false);
        }
    }

    public RattDartEntity(EntityType<? extends RattDartEntity> entity, Level world) {
        super(entity, world);
    }

    double ding() {
        double ding = 0.2;
        return Math.random() * ding - ding / 2.0;
    }

    public void alignDart(LivingEntity player) {
        PowersRatt PR;
        StandEntity standEntity;
        StandPowers standPowers = ((StandUser)player).roundabout$getStandPowers();
        if (standPowers instanceof PowersRatt && (standEntity = (PR = (PowersRatt)standPowers).getStandEntity(player)) instanceof RattEntity) {
            RattEntity RE = (RattEntity)standEntity;
            Vec3 rots = PR.getRotations((Entity)PR.getShootTarget());
            Vec2 v = new Vec2((float)(-1.0 * Math.cos(rots.f_82480_)), (float)(-1.0 * Math.sin(rots.f_82480_)));
            this.m_146884_(RE.getEyeP(0.0f).m_82549_(new Vec3(this.ding(), Mth.m_14008_((double)this.ding(), (double)0.0, (double)3.0), this.ding())));
        }
    }

    public RattDartEntity(Level world, LivingEntity player, int m, float d) {
        super(ModEntities.RATT_DART, player, world);
        this.alignDart(player);
        this.melting = m;
        this.damage = d;
        this.charged = 51;
        this.particles = true;
    }

    public RattDartEntity(Level world, LivingEntity player, int i) {
        super(ModEntities.RATT_DART, player, world);
        this.melting = i > 90 || i == -1 ? 0 : 1;
        this.damage = i < 90 ? 0.1f : 3.2f;
        this.charged = i;
    }

    protected void m_8060_(BlockHitResult $$0) {
        this.DisableSuperThrow();
        this.particles = false;
        super.m_8060_($$0);
    }

    public void shootWithVariance(double $$0, double $$1, double $$2, float $$3, float $$4) {
        Vec3 $$5 = new Vec3($$0, $$1, $$2).m_82541_().m_82520_(this.f_19796_.m_216328_(0.0, 0.13 * (double)$$4), this.f_19796_.m_216328_(0.0, 0.13 * (double)$$4), this.f_19796_.m_216328_(0.0, 0.13 * (double)$$4)).m_82490_((double)$$3);
        this.m_20256_($$5);
        double $$6 = $$5.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)$$5.f_82479_, (double)$$5.f_82481_) * 180.0 / 3.1415927410125732));
        this.m_146926_((float)(Mth.m_14136_((double)$$5.f_82480_, (double)$$6) * 180.0 / 3.1415927410125732));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public void shootFromRotationWithVariance(Entity $$0, float $$1, float $$2, float $$3, float $$4, float $$5) {
        float $$6 = -Mth.m_14031_((float)($$2 * ((float)Math.PI / 180))) * Mth.m_14089_((float)($$1 * ((float)Math.PI / 180)));
        float $$7 = -Mth.m_14031_((float)(($$1 + $$3) * ((float)Math.PI / 180)));
        float $$8 = Mth.m_14089_((float)($$2 * ((float)Math.PI / 180))) * Mth.m_14089_((float)($$1 * ((float)Math.PI / 180)));
        this.shootWithVariance($$6, $$7, $$8, $$4, $$5);
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public void EnableSuperThrow() {
        this.f_19804_.m_135381_(ROUNDABOUT$SUPER_THROWN, (Object)true);
        int ticks = 0;
        for (int b = PowersRatt.ShotThresholds.length - 1; b >= 0; --b) {
            if (this.charged < PowersRatt.ShotThresholds[b]) continue;
            ticks = PowersRatt.ShotSuperthrowTicks[b];
            break;
        }
        this.superThrowTicks = ticks;
    }

    public void DisableSuperThrow() {
        this.f_19804_.m_135381_(ROUNDABOUT$SUPER_THROWN, (Object)false);
        this.superThrowTicks = 0;
    }

    protected SoundEvent m_7239_() {
        return ModSounds.RATT_DART_THUNK_EVENT;
    }

    public void applyEffect(LivingEntity $$1) {
        int stack = -1;
        stack = $$1.m_21124_(ModEffects.MELTING) != null ? $$1.m_21124_(ModEffects.MELTING).m_19564_() + this.melting : this.melting - 1;
        if (stack != -1) {
            $$1.m_147207_(new MobEffectInstance(ModEffects.MELTING, 900, stack), (Entity)this);
        }
    }

    protected void m_5790_(EntityHitResult $$0) {
        LivingEntity $$3;
        StandPowers entityPowers;
        Entity $$1 = $$0.m_82443_();
        if ($$1.equals((Object)this.m_19749_())) {
            return;
        }
        if ($$1 instanceof LivingEntity && (entityPowers = ((StandUser)($$3 = (LivingEntity)$$1)).roundabout$getStandPowers()) != null && entityPowers.dealWithProjectile((Entity)this, (HitResult)$$0)) {
            this.m_146870_();
            return;
        }
        Entity $$4 = this.m_19749_();
        DamageSource $$5 = ModDamageTypes.of($$1.m_9236_(), ModDamageTypes.STAND, $$4);
        SoundEvent $$6 = ModSounds.RATT_DART_IMPACT_EVENT;
        if ($$1.m_6469_($$5, this.damage + ($$1 instanceof Mob ? 1.0f : 0.0f))) {
            if ($$4 instanceof LivingEntity) {
                LivingEntity LE = (LivingEntity)$$4;
                StandPowers standPowers = ((StandUser)$$4).roundabout$getStandPowers();
                if (standPowers instanceof PowersRatt) {
                    PowersRatt PR = (PowersRatt)standPowers;
                    if ($$1 instanceof LivingEntity) {
                        LivingEntity l = (LivingEntity)$$1;
                        PR.addEXP(1, l);
                    }
                }
                LE.m_21335_($$1);
            }
            if ($$1.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if ($$1 instanceof LivingEntity) {
                LivingEntity $$7 = (LivingEntity)$$1;
                this.applyEffect($$7);
                $$1.m_20256_($$1.m_20184_().m_82542_(0.4, 0.4, 0.4));
                if ($$4 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)$$7, (Entity)$$4);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)$$4), (Entity)$$7);
                }
                this.m_7761_($$7);
            }
            this.m_5496_($$6, 1.0f, this.f_19796_.m_188501_() * 0.2f + 0.9f);
        }
        this.m_146870_();
    }

    public void m_8119_() {
        Vec3 delta = this.m_20184_();
        if (this.f_36704_ >= 160) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (this.m_20069_()) {
            this.f_19804_.m_135381_(ROUNDABOUT$SUPER_THROWN, (Object)false);
        }
        super.m_8119_();
        if (((Boolean)this.m_20088_().m_135370_(ROUNDABOUT$SUPER_THROWN)).booleanValue()) {
            this.m_20256_(delta);
        }
        if (!this.m_9236_().m_5776_() && this.particles) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.86f, 0.28f, 0.48f), 1.0f), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

