/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.stand.powers;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.hydra.jojomod.access.IEntityAndData;
import net.hydra.jojomod.access.IMob;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.event.AbilityIconInstance;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.SavedSecond;
import net.hydra.jojomod.event.powers.CooldownInstance;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.networking.ServerToClientPackets;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.elements.PowerContext;
import net.hydra.jojomod.stand.powers.presets.NewDashPreset;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.S2CPacketUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.zetalasis.networking.message.api.ModMessageEvents;

public class PowersMandom
extends NewDashPreset {
    public static final byte ROTATE = 1;
    public int timeHasBeenAltered = -1;
    int ticksSinceLastYap = 0;
    int maxTicksSinceLastYap = 400;
    public int meltDodgeTicks = -1;
    public static final byte WATCHLESS = 0;
    public static final byte MAIN = 1;
    public static final byte ROLEX = 2;
    public byte getWatchStyle = 0;
    public int unskipInterp = -1;
    public static final byte MANGA = 1;
    public static final byte PURPLE = 2;
    public static final byte SKY = 3;
    public static final byte SQUID = 4;
    public static final byte GLOW_SQUID = 5;
    public static final byte ROSE = 6;
    public static final byte NAUTILUS = 7;
    public static final byte ALIEN = 8;
    public static final byte DARK = 9;
    public static final byte JELLYFISH = 10;
    public static final byte HAPPY = 11;
    public static final byte EYE = 12;
    public static final byte MELON = 13;
    public static final byte ESIDISI = 14;
    boolean thisistheend = false;
    public float lastRewindHealth = -1.0f;

    public PowersMandom(LivingEntity self) {
        super(self);
    }

    @Override
    public StandPowers generateStandPowers(LivingEntity entity) {
        return new PowersMandom(entity);
    }

    @Override
    public boolean isStandEnabled() {
        return ClientNetworking.getAppropriateConfig().mandomSettings.enableMandom;
    }

    @Override
    public boolean canSummonStandAsEntity() {
        return false;
    }

    @Override
    public boolean rendersPlayer() {
        return true;
    }

    @Override
    public void renderIcons(GuiGraphics context, int x, int y) {
        if (this.activatedPastVision()) {
            this.setSkillIcon(context, x, y, 1, StandIcons.MANDOM_VISION_ON, (byte)-1);
        } else {
            this.setSkillIcon(context, x, y, 1, StandIcons.MANDOM_VISION_OFF, (byte)-1);
        }
        if (this.timeHasBeenAltered > -1 && ClientNetworking.getAppropriateConfig().mandomSettings.timeRewindCooldownExtraCondition > 0) {
            this.setSkillIcon(context, x, y, 2, StandIcons.REWIND_PENALTY, (byte)1);
        } else {
            this.setSkillIcon(context, x, y, 2, StandIcons.REWIND, (byte)1);
        }
        if (!this.isHoldingSneak()) {
            this.setSkillIcon(context, x, y, 3, StandIcons.DODGE, (byte)6);
        } else {
            this.setSkillIcon(context, x, y, 3, StandIcons.WATCH, (byte)-1);
        }
        this.renderClock(context, x, y, 4);
        super.renderIcons(context, x, y);
    }

    public void renderClock(GuiGraphics context, int x, int y, int slot) {
        RenderSystem.enableBlend();
        context.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        Object cd = null;
        RenderSystem.enableBlend();
        context.m_280163_(StandIcons.NOVELTY_ICON, (x += slot * 25) - 3, --y - 3, 0.0f, 0.0f, 24, 24, 24, 24);
        RenderSystem.enableBlend();
        ItemStack clock = new ItemStack((ItemLike)Items.f_42524_);
        context.m_280480_(clock, x + 1, y + 1);
    }

    public byte getWatchStyle() {
        LivingEntity livingEntity = this.self;
        if (livingEntity instanceof Player) {
            Player PL = (Player)livingEntity;
            return ((IPlayerEntity)PL).roundabout$getWatchStyle();
        }
        return 0;
    }

    public void swapWatchStyle() {
        LivingEntity livingEntity;
        byte style = this.getWatchStyle();
        if ((style = (byte)(style + 1)) > 2) {
            style = 0;
        }
        if ((livingEntity = this.self) instanceof Player) {
            Player PL = (Player)livingEntity;
            ((IPlayerEntity)PL).roundabout$setWatchStyle(style);
        }
    }

    public boolean activatedPastVision() {
        return this.getStandUserSelf().roundabout$getUniqueStandModeToggle();
    }

    @Override
    public void powerActivate(PowerContext context) {
        switch (context) {
            case SKILL_1_NORMAL: 
            case SKILL_1_CROUCH: {
                this.swapVisionModeClient();
                break;
            }
            case SKILL_2_NORMAL: 
            case SKILL_2_CROUCH: {
                this.rewindTimeClient();
                break;
            }
            case SKILL_3_NORMAL: {
                this.dash();
                break;
            }
            case SKILL_3_CROUCH: {
                this.switchWatchClient();
            }
        }
    }

    public void switchWatchClient() {
        this.tryPower(27, true);
        this.tryPowerPacket((byte)27);
    }

    public boolean switchWatch() {
        LivingEntity livingEntity;
        this.swapWatchStyle();
        if (!this.isClient() && (livingEntity = this.self) instanceof ServerPlayer) {
            ServerPlayer PE = (ServerPlayer)livingEntity;
            switch (this.getWatchStyle()) {
                case 0: {
                    PE.m_5661_((Component)Component.m_237115_((String)"text.roundabout.mandom.watch_off").m_130940_(ChatFormatting.GOLD), true);
                    break;
                }
                case 1: {
                    PE.m_5661_((Component)Component.m_237115_((String)"text.roundabout.mandom.watch_on").m_130940_(ChatFormatting.GOLD), true);
                    break;
                }
                case 2: {
                    PE.m_5661_((Component)Component.m_237115_((String)"text.roundabout.mandom.watch_on_rolex").m_130940_(ChatFormatting.GOLD), true);
                }
            }
        }
        return true;
    }

    public void rewindTimeClient() {
        if (!this.onCooldown((byte)1)) {
            this.tryPower(23, true);
            this.tryPowerPacket((byte)23);
        }
    }

    public void swapVisionModeClient() {
        this.tryPower(21, true);
        this.tryPowerPacket((byte)21);
    }

    @Override
    public boolean setPowerOther(int move, int lastMove) {
        switch (move) {
            case 21: {
                return this.toggleVision();
            }
            case 23: {
                return this.itsRewindTime();
            }
            case 27: {
                return this.switchWatch();
            }
        }
        return super.setPowerOther(move, lastMove);
    }

    public boolean toggleVision() {
        this.getStandUserSelf().roundabout$setUniqueStandModeToggle(!this.activatedPastVision());
        if (!this.isClient()) {
            if (this.activatedPastVision()) {
                ((ServerPlayer)this.self).m_5661_((Component)Component.m_237115_((String)"text.roundabout.mandom.vision_on").m_130940_(ChatFormatting.DARK_PURPLE), true);
            } else {
                ((ServerPlayer)this.self).m_5661_((Component)Component.m_237115_((String)"text.roundabout.mandom.vision_off").m_130940_(ChatFormatting.DARK_PURPLE), true);
            }
        }
        return true;
    }

    public boolean itsRewindTime() {
        if (this.isClient() || !this.onCooldown((byte)1) || !ClientNetworking.getAppropriateConfig().mandomSettings.timeRewindCooldownUsesServerLatency.booleanValue()) {
            int cooldown = ClientNetworking.getAppropriateConfig().mandomSettings.timeRewindCooldownv2;
            if (this.timeHasBeenAltered > -1) {
                cooldown += ClientNetworking.getAppropriateConfig().mandomSettings.timeRewindCooldownExtraCondition.intValue();
            }
            this.setCooldown((byte)1, cooldown);
            this.setTimeHasBeenAltered(-1);
            if (this.isClient()) {
                this.self.m_5496_(ModSounds.MANDOM_REWIND_EVENT, 200.0f, 1.0f);
            } else {
                this.rewindTimeActivation();
            }
        }
        return true;
    }

    @Override
    public void onStandSwitchInto() {
        if (!(this.getSelf() instanceof Player) || !((Player)this.getSelf()).m_7500_()) {
            if (this.getSelf() instanceof Player && !this.isClient()) {
                S2CPacketUtil.sendCooldownSyncPacket((Player)((ServerPlayer)this.getSelf()), (byte)1, ClientNetworking.getAppropriateConfig().mandomSettings.timeRewindCooldownv2 + ClientNetworking.getAppropriateConfig().mandomSettings.timeRewindCooldownExtraCondition);
            }
            this.setCooldown((byte)1, ClientNetworking.getAppropriateConfig().mandomSettings.timeRewindCooldownv2 + ClientNetworking.getAppropriateConfig().mandomSettings.timeRewindCooldownExtraCondition);
        }
        super.onStandSwitchInto();
    }

    @Override
    public void onPlaceBlock(ServerPlayer $$0, BlockPos $$1, ItemStack $$2) {
        if (!$$0.m_7500_()) {
            this.setTimeHasBeenAltered(140);
        }
        super.onPlaceBlock($$0, $$1, $$2);
    }

    @Override
    public void onDestroyBlock(Level $$0, Player $$1, BlockPos $$2, BlockState $$3, BlockEntity $$4, ItemStack $$5) {
        if (!($$3.m_204336_(BlockTags.f_13104_) || $$3.m_204336_(BlockTags.f_13041_) || $$3.m_204336_(BlockTags.f_278394_))) {
            this.setTimeHasBeenAltered(140);
        }
        super.onDestroyBlock($$0, $$1, $$2, $$3, $$4, $$5);
    }

    @Override
    public boolean onKilledEntity(ServerLevel $$0, LivingEntity $$1) {
        Player PL;
        LivingEntity livingEntity = this.self;
        if (!(livingEntity instanceof Player) || !(PL = (Player)livingEntity).m_7500_()) {
            this.setTimeHasBeenAltered(140);
        }
        return super.onKilledEntity($$0, $$1);
    }

    public void tickTimeAlteration() {
        if (!this.self.m_9236_().m_5776_() && this.timeHasBeenAltered > -1) {
            this.setTimeHasBeenAltered(this.timeHasBeenAltered - 1);
        }
    }

    public void setTimeHasBeenAltered(int altered) {
        if (this.timeHasBeenAltered != altered && ClientNetworking.getAppropriateConfig().mandomSettings.timeRewindCooldownExtraCondition > 0) {
            LivingEntity livingEntity;
            this.timeHasBeenAltered = altered;
            if (!this.self.m_9236_().m_5776_() && (livingEntity = this.self) instanceof ServerPlayer) {
                ServerPlayer SP = (ServerPlayer)livingEntity;
                ModMessageEvents.sendToPlayer(SP, "mandom_penalty", altered);
            }
        }
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        return super.tryPower(move, forced);
    }

    @Override
    public boolean isAttackIneptVisually(byte activeP, int slot) {
        return super.isAttackIneptVisually(activeP, slot);
    }

    public SimpleParticleType getParticle(Entity ent) {
        Mob mb;
        if (ent instanceof Monster || ent instanceof Mob && (mb = (Mob)ent).m_5912_()) {
            return ModParticles.RED_CLOCK;
        }
        if (ent != null && ent.m_7306_((Entity)this.self)) {
            return ModParticles.CLOCK;
        }
        if (ent instanceof Player) {
            return ModParticles.BLUE_CLOCK;
        }
        if (ent instanceof Projectile || ent instanceof ItemEntity) {
            return ModParticles.ORANGE_CLOCK;
        }
        return ModParticles.GREEN_CLOCK;
    }

    public void rewindTimeActivation() {
        Player PE;
        IPlayerEntity iPlayerEntity;
        LivingEntity livingEntity;
        int rewindPacketRange = ClientNetworking.getAppropriateConfig().mandomSettings.timeRewindRange;
        int rewindCooldown = ClientNetworking.getAppropriateConfig().mandomSettings.timeRewindCooldownv2;
        this.spreadRadialClientPacket(rewindPacketRange, false, ServerToClientPackets.S2CPackets.MESSAGES.Rewind.value);
        List<Entity> mobsInRange = MainUtil.getEntitiesInRange(this.self.m_9236_(), this.self.m_20183_(), rewindPacketRange);
        if (!mobsInRange.isEmpty()) {
            for (Entity entity : mobsInRange) {
                PowersMandom PM;
                LivingEntity LE;
                StandUser user;
                StandPowers powers;
                if (!MainUtil.canRewindInTime(entity, (Entity)this.self)) continue;
                IEntityAndData iData = (IEntityAndData)entity;
                SavedSecond lastSecond = iData.roundabout$getLastSavedSecond();
                if (lastSecond != null) {
                    lastSecond.loadTime(entity);
                }
                if (entity.m_7306_((Entity)this.self) || !(entity instanceof LivingEntity) || !((powers = (user = (StandUser)(LE = (LivingEntity)entity)).roundabout$getStandPowers()) instanceof PowersMandom) || (PM = (PowersMandom)powers).onCooldown((byte)1) && PM.getCooldown((byte)1).time > rewindCooldown) continue;
                PM.setCooldown((byte)1, rewindCooldown);
            }
            this.unskipInterp = 1;
        }
        if ((livingEntity = this.self) instanceof Player && (iPlayerEntity = (IPlayerEntity)(PE = (Player)livingEntity)).roundabout$getWatchStyle() > 0) {
            iPlayerEntity.roundabout$SetPoseEmote((byte)10);
        }
    }

    @Override
    public boolean canUseStillStandingRecharge(byte bt) {
        if (bt == 1) {
            return false;
        }
        return super.canUseStillStandingRecharge(bt);
    }

    @Override
    public void tickPower() {
        List<Entity> mobsInRange;
        super.tickPower();
        this.tickTimeAlteration();
        if (this.unskipInterp > -1) {
            --this.unskipInterp;
            if (this.unskipInterp <= -1) {
                int rewindPacketRange = ClientNetworking.getAppropriateConfig().mandomSettings.timeRewindRange;
                this.spreadRadialClientPacket(rewindPacketRange + 50, false, "unskip_interpolation");
            }
        }
        if (!this.self.m_9236_().m_5776_() && this.activatedPastVision() && this.self.f_19797_ % 3 == 0 && !(mobsInRange = MainUtil.getEntitiesInRange(this.self.m_9236_(), this.self.m_20183_(), ClientNetworking.getAppropriateConfig().mandomSettings.chronoVisionRange.intValue())).isEmpty()) {
            for (Entity ent : mobsInRange) {
                IEntityAndData iData;
                SavedSecond lastSecond;
                if (!MainUtil.canRewindInTime(ent, (Entity)this.self) || (lastSecond = (iData = (IEntityAndData)ent).roundabout$getLastSavedSecond()) == null) continue;
                if (!lastSecond.hasHadParticle) {
                    LivingEntity livingEntity;
                    lastSecond.hasHadParticle = true;
                    lastSecond.isTickingParticles = this.self;
                    if (ent instanceof Player && (livingEntity = this.self) instanceof Player) {
                        Player PE = (Player)livingEntity;
                        this.spreadRadialClientPacket(ClientNetworking.getAppropriateConfig().mandomSettings.chronoVisionRange.intValue(), false, "chrono_vision_player", ent.m_19879_(), lastSecond.position.f_82479_, lastSecond.position.f_82480_, lastSecond.position.f_82481_);
                    } else {
                        ((ServerLevel)this.self.m_9236_()).m_8767_((ParticleOptions)this.getParticle(ent), lastSecond.position.f_82479_, lastSecond.position.f_82480_ + (double)ent.m_20192_() * 0.8, lastSecond.position.f_82481_, 0, 0.0, 0.0, 0.0, 0.015);
                    }
                }
                if (ent instanceof Projectile || ent instanceof ItemEntity || lastSecond.isTickingParticles == null || !lastSecond.isTickingParticles.m_7306_((Entity)this.self)) continue;
                Vec3 forward = Vec3.m_82503_((Vec2)new Vec2(lastSecond.rotationVec.f_82470_, lastSecond.headYRotation));
                ((ServerLevel)this.self.m_9236_()).m_8767_((ParticleOptions)ModParticles.TIME_EMBER, lastSecond.position.f_82479_, lastSecond.position.f_82480_ + (double)ent.m_20192_() * 0.8, lastSecond.position.f_82481_, 0, forward.f_82479_, forward.f_82480_, forward.f_82481_, 0.25);
            }
        }
    }

    @Override
    public void updateUniqueMoves() {
        super.updateUniqueMoves();
    }

    @Override
    public List<Byte> getSkinList() {
        return Arrays.asList((byte)1, (byte)2, (byte)3, (byte)8, (byte)9, (byte)4, (byte)5, (byte)6, (byte)7, (byte)10, (byte)11, (byte)12, (byte)13, (byte)14);
    }

    @Override
    public Component getSkinName(byte skinId) {
        return switch (skinId) {
            case 2 -> Component.m_237115_((String)"skins.roundabout.mandom.purple");
            case 3 -> Component.m_237115_((String)"skins.roundabout.mandom.sky");
            case 4 -> Component.m_237115_((String)"skins.roundabout.mandom.squid");
            case 8 -> Component.m_237115_((String)"skins.roundabout.mandom.alien");
            case 9 -> Component.m_237115_((String)"skins.roundabout.mandom.dark");
            case 5 -> Component.m_237115_((String)"skins.roundabout.mandom.glow_squid");
            case 6 -> Component.m_237115_((String)"skins.roundabout.mandom.rose");
            case 7 -> Component.m_237115_((String)"skins.roundabout.mandom.nautilus");
            case 10 -> Component.m_237115_((String)"skins.roundabout.mandom.jellyfish");
            case 11 -> Component.m_237115_((String)"skins.roundabout.mandom.happy");
            case 12 -> Component.m_237115_((String)"skins.roundabout.mandom.eye");
            case 13 -> Component.m_237115_((String)"skins.roundabout.mandom.melon");
            case 14 -> Component.m_237115_((String)"skins.roundabout.mandom.esidisi");
            default -> Component.m_237115_((String)"skins.roundabout.mandom.manga");
        };
    }

    @Override
    public boolean isSecondaryStand() {
        return true;
    }

    @Override
    protected Byte getSummonSound() {
        return (byte)18;
    }

    @Override
    public SoundEvent getSoundFromByte(byte soundChoice) {
        switch (soundChoice) {
            case 18: {
                return ModSounds.SUMMON_MANDOM_EVENT;
            }
        }
        return super.getSoundFromByte(soundChoice);
    }

    @Override
    public void tickStandRejection(MobEffectInstance effect) {
        if (!this.getSelf().m_9236_().m_5776_() && !this.thisistheend) {
            this.thisistheend = true;
            this.itsRewindTime();
        }
    }

    @Override
    public void tickMobAI(LivingEntity attackTarget) {
        if (this.lastRewindHealth < 0.0f) {
            this.lastRewindHealth = this.self.m_21223_();
        }
        if (this.self.m_21223_() < this.lastRewindHealth && !this.onCooldown((byte)1)) {
            this.itsRewindTime();
            if (!this.hasStandActive(this.self)) {
                ((IMob)this.self).roundabout$setRetractTicks(500);
                this.getStandUserSelf().roundabout$summonStand(this.self.m_9236_(), true, false);
            }
        }
        this.lastRewindHealth = this.self.m_21223_();
    }

    @Override
    public byte worthinessType() {
        return 2;
    }

    @Override
    public Component getPosName(byte posID) {
        if (posID == 1) {
            return Component.m_237115_((String)"idle.roundabout.hey_ya_2");
        }
        if (posID == 2) {
            return Component.m_237115_((String)"idle.roundabout.mandom_back");
        }
        return Component.m_237115_((String)"idle.roundabout.hey_ya_1");
    }

    @Override
    public List<Byte> getPosList() {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add((byte)0);
        $$1.add((byte)1);
        $$1.add((byte)2);
        return $$1;
    }

    @Override
    public List<AbilityIconInstance> drawGUIIcons(GuiGraphics context, float delta, int mouseX, int mouseY, int leftPos, int topPos, byte level, boolean bypass) {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 80, 0, "ability.roundabout.chrono_vision", "instruction.roundabout.press_skill", StandIcons.MANDOM_VISION_ON, 1, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 99, 0, "ability.roundabout.rewind_time", "instruction.roundabout.press_skill", StandIcons.REWIND, 2, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 118, 0, "ability.roundabout.dodge", "instruction.roundabout.press_skill", StandIcons.DODGE, 3, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 80, 0, "ability.roundabout.watch_switch", "instruction.roundabout.press_skill_crouch", StandIcons.WATCH, 3, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 99, 0, "ability.roundabout.clock", "instruction.roundabout.passive", StandIcons.CLOCK, 4, level, bypass));
        return $$1;
    }

    @Override
    public boolean isServerControlledCooldown(CooldownInstance ci, byte num) {
        if (num == 1 && ClientNetworking.getAppropriateConfig().mandomSettings.timeRewindCooldownUsesServerLatency.booleanValue()) {
            return true;
        }
        return super.isServerControlledCooldown(ci, num);
    }
}

