/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.stand.powers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.hydra.jojomod.access.IGravityEntity;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.npcs.Aesthetician;
import net.hydra.jojomod.entity.projectile.CinderellaVisageDisplayEntity;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.AbilityIconInstance;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.item.LuckyLipstickItem;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.elements.PowerContext;
import net.hydra.jojomod.stand.powers.presets.NewDashPreset;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.S2CPacketUtil;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1439;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class PowersCinderella
extends NewDashPreset {
    public List<CinderellaVisageDisplayEntity> floatingVisages = new ArrayList<CinderellaVisageDisplayEntity>();
    public double spinint = 0.0;
    public double lastSpinInt = 0.0;
    public double maxSpinint = 4.0;
    public boolean hasUIOpen = false;
    public static final byte VISAGE_NOISE = 104;
    public static final byte IMPALE_NOISE = 105;

    public PowersCinderella(class_1309 self) {
        super(self);
    }

    @Override
    public boolean isStandEnabled() {
        return ClientNetworking.getAppropriateConfig().cinderellaSettings.enableCinderella;
    }

    @Override
    public StandEntity getNewStandEntity() {
        return (StandEntity)ModEntities.CINDERELLA.method_5883(this.getSelf().method_37908());
    }

    @Override
    public boolean canSummonStand() {
        return true;
    }

    @Override
    public StandPowers generateStandPowers(class_1309 entity) {
        return new PowersCinderella(entity);
    }

    @Override
    public boolean isSecondaryStand() {
        return true;
    }

    @Override
    public List<Byte> getPosList() {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add((byte)0);
        $$1.add((byte)1);
        $$1.add((byte)2);
        $$1.add((byte)3);
        $$1.add((byte)4);
        return $$1;
    }

    @Override
    public void powerActivate(PowerContext context) {
        switch (context) {
            case SKILL_1_NORMAL: 
            case SKILL_1_CROUCH: {
                this.doUIClient();
                break;
            }
            case SKILL_2_NORMAL: 
            case SKILL_2_CROUCH: {
                this.doDefaceClient();
                break;
            }
            case SKILL_3_NORMAL: 
            case SKILL_3_CROUCH: {
                this.dash();
            }
        }
    }

    public void doDefaceClient() {
        if (!this.onCooldown((byte)1)) {
            if (this.activePower == 23) {
                ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
                this.tryPowerPacket((byte)0);
            } else {
                ((StandUser)this.getSelf()).roundabout$tryPower(23, true);
                this.tryPowerPacket((byte)23);
            }
        }
    }

    public void doUIClient() {
        this.tryPowerPacket((byte)21);
        ClientUtil.setCinderellaUI();
        this.hasUIOpen = true;
    }

    @Override
    public void tickPowerEnd() {
        if (this.floatingVisages != null && !this.floatingVisages.isEmpty()) {
            this.removeFloatingVisages();
            if (!this.self.method_37908().method_8608()) {
                this.floatingVisagesRotation();
            } else {
                this.lastSpinInt += this.maxSpinint;
            }
        }
    }

    public void floatingVisageInit() {
        if (this.floatingVisages == null) {
            this.floatingVisages = new ArrayList<CinderellaVisageDisplayEntity>();
        }
    }

    public void floatingVisagesRotation() {
        this.floatingVisageInit();
        ArrayList<CinderellaVisageDisplayEntity> hurricaneSpecial2 = new ArrayList<CinderellaVisageDisplayEntity>(this.floatingVisages){};
        if (!hurricaneSpecial2.isEmpty()) {
            int totalnumber = hurricaneSpecial2.size();
            for (CinderellaVisageDisplayEntity value : hurricaneSpecial2) {
                this.transformFloatingVisages(value, totalnumber, this.self.method_23317(), this.self.method_23318(), this.self.method_23321(), value.getSize());
            }
        }
    }

    @Override
    public class_2561 getSkinName(byte skinId) {
        return PowersCinderella.getSkinNameT(skinId);
    }

    public static class_2561 getSkinNameT(byte skinId) {
        if (skinId == 2) {
            return class_2561.method_43471((String)"skins.roundabout.cinderella.manga");
        }
        if (skinId == 3) {
            return class_2561.method_43471((String)"skins.roundabout.cinderella.zombie");
        }
        if (skinId == 4) {
            return class_2561.method_43471((String)"skins.roundabout.cinderella.jack_in_the_box");
        }
        if (skinId == 5) {
            return class_2561.method_43471((String)"skins.roundabout.cinderella.business");
        }
        if (skinId == 6) {
            return class_2561.method_43471((String)"skins.roundabout.cinderella.face_off");
        }
        return class_2561.method_43471((String)"skins.roundabout.cinderella.base");
    }

    public void addFloatingVisage(CinderellaVisageDisplayEntity che) {
        this.floatingVisageInit();
        this.floatingVisages.add(che);
    }

    public void transformFloatingVisages(CinderellaVisageDisplayEntity value, int totalnumber, double entityX, double entityY, double entityZ, double rsize) {
        if (value != null) {
            int size = value.getSize();
            double distanceUp = 0.3;
            if (size < value.getMaxSize()) {
                size = (int)((float)size + value.getAccrualRate());
                value.setSize(size);
            }
            distanceUp += rsize / 20.0;
            double offset = 0.0;
            int number = value.getCrossNumber();
            if (this.self.method_37908().method_8608()) {
                if (number == 1) {
                    offset = 0.0;
                } else if (number == 2) {
                    offset = 90.0;
                } else if (number == 3) {
                    offset = 180.0;
                } else if (number == 4) {
                    offset = 270.0;
                } else if (number == 5) {
                    offset = 45.0;
                } else if (number == 6) {
                    offset = 135.0;
                } else if (number == 7) {
                    offset = 225.0;
                } else if (number == 8) {
                    offset = 315.0;
                }
                offset += (double)class_3532.method_15357((double)(this.spinint / 2.0));
                if (offset > 360.0) {
                    offset -= 360.0;
                } else if (offset < 0.0) {
                    offset += 360.0;
                }
            } else {
                offset = this.self.method_36454() % 360.0f;
            }
            double offset2 = offset;
            offset = (offset - 180.0) * Math.PI;
            double distanceOut = 3.0;
            if (number > 4) {
                distanceUp *= 0.5;
            }
            class_243 finalOffset = new class_243(-(-1.0 * (distanceOut * Math.sin(offset / 180.0))), distanceUp, -(distanceOut * Math.cos(offset / 180.0)));
            class_2350 dir = ((IGravityEntity)this.self).roundabout$getGravityDirection();
            if (dir != class_2350.field_11033) {
                finalOffset = RotationUtil.vecPlayerToWorld(finalOffset, dir);
            }
            double x1 = entityX + finalOffset.field_1352;
            double y1 = entityY + finalOffset.field_1351;
            double z1 = entityZ + finalOffset.field_1350;
            if (!this.self.method_37908().method_8608()) {
                value.method_22862();
            }
            value.actuallyTick();
            value.storeVec = new class_243(x1, y1, z1);
            if (this.self.method_37908().method_8608()) {
                value.method_36456((float)offset2);
                value.field_5982 = (float)offset2;
                value.field_6038 = x1;
                value.field_5971 = y1;
                value.field_5989 = z1;
                value.method_30634(x1, y1, z1);
            } else {
                value.method_36456((float)offset2);
                value.field_5982 = (float)offset2;
                value.field_6038 = x1;
                value.field_5971 = y1;
                value.field_5989 = z1;
                value.method_5814(x1, y1, z1);
            }
        }
    }

    public void removeFloatingVisages() {
        this.floatingVisageInit();
        ArrayList<CinderellaVisageDisplayEntity> hurricaneSpecial2 = new ArrayList<CinderellaVisageDisplayEntity>(this.floatingVisages){};
        if (!hurricaneSpecial2.isEmpty()) {
            for (CinderellaVisageDisplayEntity value : hurricaneSpecial2) {
                if (!value.method_31481() && value.method_5805() && value.getCrossNumber() > 0) continue;
                value.initialized = false;
                this.floatingVisages.remove(value);
            }
        }
    }

    @Override
    public void renderIcons(class_332 context, int x, int y) {
        this.setSkillIcon(context, x, y, 1, StandIcons.CINDERELLA_MASK, (byte)-1);
        this.setSkillIcon(context, x, y, 2, StandIcons.CINDERELLA_SCALP, (byte)1);
        this.setSkillIcon(context, x, y, 3, StandIcons.DODGE, (byte)6);
    }

    @Override
    protected Byte getSummonSound() {
        return (byte)18;
    }

    @Override
    public class_3414 getSoundFromByte(byte soundChoice) {
        byte bt = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (soundChoice == 18) {
            return ModSounds.CINDERELLA_SUMMON_EVENT;
        }
        if (soundChoice == 105) {
            return ModSounds.CINDERELLA_ATTACK_EVENT;
        }
        if (soundChoice == 104) {
            return ModSounds.CINDERELLA_VISAGE_CREATION_EVENT;
        }
        return super.getSoundFromByte(soundChoice);
    }

    public void clearAllFloatingVisages() {
        this.floatingVisageInit();
        ArrayList<CinderellaVisageDisplayEntity> hurricaneSpecial2 = new ArrayList<CinderellaVisageDisplayEntity>(this.floatingVisages){};
        if (!hurricaneSpecial2.isEmpty()) {
            int totalnumber = hurricaneSpecial2.size();
            for (CinderellaVisageDisplayEntity value : hurricaneSpecial2) {
                value.method_31472();
            }
        }
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        if (!this.getSelf().method_37908().field_9236 && this.getActivePower() == 23 && this.attackTimeDuring > -1) {
            this.stopSoundsIfNearby((byte)105, 100.0, true);
        }
        if (!(this.getSelf().method_37908().field_9236 || this.getActivePower() != 21 && move == 21)) {
            this.stopSoundsIfNearby((byte)104, 100.0, true);
        }
        if (!this.getSelf().method_37908().method_8608()) {
            this.clearAllFloatingVisages();
        }
        return super.tryPower(move, forced);
    }

    @Override
    public void tickPower() {
        if (this.self.method_37908().method_8608()) {
            if (this.hasUIOpen && !ClientUtil.hasCinderellaUI()) {
                this.hasUIOpen = false;
                ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
                this.tryPowerPacket((byte)0);
            }
        } else if (this.getActivePower() == 21) {
            ((class_3218)this.getSelf().method_37908()).method_14199((class_2394)ModParticles.PINK_SMOKE, this.getSelf().method_23317(), this.getSelf().method_23318() + 0.3, this.getSelf().method_23321(), 1, 2.5, 2.0, 2.5, 0.015);
            class_1309 class_13092 = this.self;
            if (class_13092 instanceof Aesthetician) {
                Aesthetician aes = (Aesthetician)class_13092;
                if ((this.getStandEntity(this.self) == null || this.getStandEntity(this.self).method_31481()) && this.canSummonStand()) {
                    ((StandUser)this.self).roundabout$summonStand(this.self.method_37908(), true, false);
                }
                if (aes.interactingWith != null && aes.interactingWith.isEmpty()) {
                    ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
                }
            }
        } else {
            class_1309 class_13093 = this.self;
            if (class_13093 instanceof Aesthetician) {
                Aesthetician aes = (Aesthetician)class_13093;
                if (aes.interactingWith != null && !aes.interactingWith.isEmpty()) {
                    ((StandUser)this.getSelf()).roundabout$tryPower(21, true);
                }
            }
        }
        super.tickPower();
    }

    @Override
    public void updateUniqueMoves() {
        if (this.getActivePower() == 23) {
            this.updateDeface();
        }
        super.updateUniqueMoves();
    }

    @Override
    public boolean setPowerOther(int move, int lastMove) {
        if (move == 23) {
            return this.deface();
        }
        if (move == 21) {
            return this.visages();
        }
        return super.setPowerOther(move, lastMove);
    }

    public void generateFloatingMask(int crossNumber, int maxSize) {
        CinderellaVisageDisplayEntity cross;
        class_1799 stack = ModItems.getVisageStore().get((int)class_3532.method_15357((double)(Math.random() * (double)(ModItems.getVisageStore().size() - 1)))).stack;
        if (stack.method_7909() instanceof LuckyLipstickItem) {
            stack = ModItems.BLANK_MASK.method_7854().method_7972();
        }
        if ((cross = new CinderellaVisageDisplayEntity(this.self, this.self.method_37908(), stack)) != null) {
            cross.method_30634(this.getSelf().method_23317(), this.getSelf().method_23318(), this.getSelf().method_23321());
            cross.setUser(this.self);
            if (this.floatingVisages == null) {
                this.floatingVisages = new ArrayList<CinderellaVisageDisplayEntity>();
            }
            cross.setCrossNumber(crossNumber);
            cross.setMaxSize(maxSize);
            this.floatingVisages.add(cross);
            this.getSelf().method_37908().method_8649((class_1297)cross);
        }
    }

    public static int getChargingCrossfireSpecialSize() {
        return 26;
    }

    public boolean visages() {
        StandEntity stand = this.getStandEntity(this.self);
        if (Objects.nonNull(stand)) {
            this.setAttackTimeDuring(0);
            this.setActivePower((byte)21);
            this.animateStand((byte)82);
            this.playStandUserOnlySoundsIfNearby((byte)104, 27.0, false, false);
            this.poseStand((byte)2);
            this.generateFloatingMask(1, PowersCinderella.getChargingCrossfireSpecialSize());
            this.generateFloatingMask(2, PowersCinderella.getChargingCrossfireSpecialSize());
            this.generateFloatingMask(3, PowersCinderella.getChargingCrossfireSpecialSize());
            this.generateFloatingMask(4, PowersCinderella.getChargingCrossfireSpecialSize());
            this.generateFloatingMask(5, PowersCinderella.getChargingCrossfireSpecialSize());
            this.generateFloatingMask(6, PowersCinderella.getChargingCrossfireSpecialSize());
            this.generateFloatingMask(7, PowersCinderella.getChargingCrossfireSpecialSize());
            this.generateFloatingMask(8, PowersCinderella.getChargingCrossfireSpecialSize());
            return true;
        }
        return false;
    }

    public boolean deface() {
        StandEntity stand = this.getStandEntity(this.self);
        if (Objects.nonNull(stand)) {
            this.setAttackTimeDuring(0);
            this.setActivePower((byte)23);
            this.playStandUserOnlySoundsIfNearby((byte)105, 27.0, false, false);
            this.animateStand((byte)81);
            this.poseStand((byte)1);
            return true;
        }
        return false;
    }

    public void updateDeface() {
        if (this.attackTimeDuring > -1) {
            if (this.attackTimeDuring > 15) {
                this.standImpale();
            } else if (!this.getSelf().method_37908().method_8608() && this.attackTimeDuring % 4 == 0) {
                ((class_3218)this.getSelf().method_37908()).method_14199((class_2394)ModParticles.MENACING, this.getSelf().method_23317(), this.getSelf().method_23318() + 0.3, this.getSelf().method_23321(), 1, 0.2, 0.2, 0.2, 0.05);
            }
        }
    }

    @Override
    public void tickMobAI(class_1309 attackTarget) {
        if (attackTarget != null && attackTarget.method_5805()) {
            class_1297 targetEntity;
            if (this.getActivePower() != 0 || attackTarget.method_5739((class_1297)this.getSelf()) <= 5.0f) {
                this.getSelf().method_36457(this.getLookAtEntityPitch((class_1297)this.getSelf(), (class_1297)attackTarget));
                float yrot = this.getLookAtEntityYaw((class_1297)this.getSelf(), (class_1297)attackTarget);
                this.getSelf().method_36456(yrot);
                this.getSelf().method_5847(yrot);
            }
            if ((targetEntity = this.getTargetEntity(this.self, 5.0f)) != null && targetEntity.method_5779((class_1297)attackTarget) && this.getActivePower() == 0 && (!this.onCooldown((byte)1) || this.self instanceof class_1439)) {
                ((StandUser)this.getSelf()).roundabout$tryPower(23, true);
            }
        }
    }

    @Override
    public List<AbilityIconInstance> drawGUIIcons(class_332 context, float delta, int mouseX, int mouseY, int leftPos, int topPos, byte level, boolean bypass) {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 80, 0, "ability.roundabout.visage_creation", "instruction.roundabout.press_skill", StandIcons.CINDERELLA_MASK, 1, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 99, 0, "ability.roundabout.face_removal", "instruction.roundabout.press_skill", StandIcons.CINDERELLA_SCALP, 2, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 118, 0, "ability.roundabout.dodge", "instruction.roundabout.press_skill", StandIcons.DODGE, 3, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 80, 0, "ability.roundabout.visages", "instruction.roundabout.passive", StandIcons.CINDERELLA_VISAGES, 0, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 99, 0, "ability.roundabout.lucky_lipstick", "instruction.roundabout.passive", StandIcons.CINDERELLA_LIPSTICK, 0, level, bypass));
        return $$1;
    }

    @Override
    public List<Byte> getSkinList() {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add((byte)1);
        $$1.add((byte)2);
        $$1.add((byte)3);
        $$1.add((byte)4);
        $$1.add((byte)5);
        $$1.add((byte)6);
        return $$1;
    }

    public void standImpale() {
        if (this.self instanceof class_1657) {
            if (this.isPacketPlayer()) {
                this.setAttackTimeDuring(-15);
                this.tryIntToServerPacket((byte)4, this.getTargetEntityId2(5.0f));
            }
        } else {
            class_1297 targetEntity = this.getTargetEntity(this.self, 5.0f);
            this.defaceImpact(targetEntity);
        }
    }

    public float getDefaceStrength(class_1297 entity) {
        if (this.getReducedDamage(entity)) {
            return this.levelupDamageMod((float)(3.0 * ((double)ClientNetworking.getAppropriateConfig().cinderellaSettings.cinderellaAttackMultOnPlayers.intValue() * 0.01)));
        }
        return this.levelupDamageMod((float)(9.0 * ((double)ClientNetworking.getAppropriateConfig().cinderellaSettings.cinderellaAttackMultOnMobs.intValue() * 0.01)));
    }

    public float getDefaceKnockback() {
        return 0.7f;
    }

    @Override
    public void handleStandAttack(class_1657 player, class_1297 target) {
        this.defaceImpact(target);
    }

    public void defaceImpact(class_1297 entity) {
        class_3414 SE;
        this.setAttackTimeDuring(-20);
        if (entity != null) {
            float pow = this.getDefaceStrength(entity);
            float knockbackStrength = this.getDefaceKnockback();
            if (this.StandDamageEntityAttack(entity, pow, 0.0f, (class_1297)this.self)) {
                if (entity instanceof class_1309) {
                    class_1309 LE = (class_1309)entity;
                    this.addEXP(5, LE);
                    if (MainUtil.getMobBleed(entity)) {
                        int bleedlevel = ((StandUser)LE).roundabout$getBleedLevel();
                        if (bleedlevel < 0) {
                            MainUtil.makeFaceless(entity, 200, 0, (class_1297)this.getSelf());
                            MainUtil.makeBleed(entity, 0, 200, (class_1297)this.getSelf());
                        } else if (bleedlevel == 0) {
                            MainUtil.makeFaceless(entity, 250, 1, (class_1297)this.getSelf());
                            MainUtil.makeBleed(entity, 1, 250, (class_1297)this.getSelf());
                        } else {
                            MainUtil.makeFaceless(entity, 300, 2, (class_1297)this.getSelf());
                            MainUtil.makeBleed(entity, 2, 300, (class_1297)this.getSelf());
                            MainUtil.makeMobBleed(entity);
                        }
                    } else {
                        MainUtil.makeFaceless(entity, 200, 0, (class_1297)this.getSelf());
                    }
                }
                this.takeDeterminedKnockback(this.self, entity, knockbackStrength);
            }
        }
        if (this.getSelf() instanceof class_1657) {
            S2CPacketUtil.sendCooldownSyncPacket((class_1657)((class_3222)this.getSelf()), (byte)1, ClientNetworking.getAppropriateConfig().cinderellaSettings.defaceAttackCooldown);
        }
        this.setCooldown((byte)1, ClientNetworking.getAppropriateConfig().cinderellaSettings.defaceAttackCooldown);
        float pitch = 1.0f;
        if (entity != null) {
            SE = ModSounds.PUNCH_3_SOUND_EVENT;
            pitch = 1.2f;
        } else {
            SE = ModSounds.PUNCH_2_SOUND_EVENT;
        }
        if (!this.self.method_37908().method_8608()) {
            this.self.method_37908().method_8396(null, this.self.method_24515(), SE, class_3419.field_15248, 0.95f, pitch);
        }
    }

    @Override
    public void tickStandRejection(class_1293 effect) {
        if (!this.getSelf().method_37908().method_8608() && effect.method_5584() == 15) {
            MainUtil.makeFaceless((class_1297)this.self, 800, 0, (class_1297)this.self);
            this.self.method_37908().method_8396(null, this.self.method_24515(), ModSounds.CINDERELLA_FAIL_EVENT, class_3419.field_15248, 1.0f, 1.0f);
        }
    }

    @Override
    public void renderAttackHud(class_332 context, class_1657 playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
        class_1297 TE;
        int j = scaledHeight / 2 - 7 - 4;
        int k = scaledWidth / 2 - 8;
        if (this.getActivePower() == 23 && (TE = this.getTargetEntity((class_1309)playerEntity, 5.0f)) != null) {
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 0, 15, 6);
        }
    }
}

