/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.stand.powers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.hydra.jojomod.access.IAbstractArrowAccess;
import net.hydra.jojomod.access.IBucketItem;
import net.hydra.jojomod.access.IGravityEntity;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.block.BubbleScaffoldBlockEntity;
import net.hydra.jojomod.block.ModBlocks;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.pathfinding.GroundBubbleEntity;
import net.hydra.jojomod.entity.projectile.GoBeyondEntity;
import net.hydra.jojomod.entity.projectile.SoftAndWetBubbleEntity;
import net.hydra.jojomod.entity.projectile.SoftAndWetExplosiveBubbleEntity;
import net.hydra.jojomod.entity.projectile.SoftAndWetItemLaunchingBubbleEntity;
import net.hydra.jojomod.entity.projectile.SoftAndWetPlunderBubbleEntity;
import net.hydra.jojomod.entity.projectile.ThrownObjectEntity;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.entity.substand.EncasementBubbleEntity;
import net.hydra.jojomod.entity.visages.JojoNPC;
import net.hydra.jojomod.entity.visages.mobs.AvdolNPC;
import net.hydra.jojomod.event.AbilityIconInstance;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.index.PlunderTypes;
import net.hydra.jojomod.event.powers.DamageHandler;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.item.MaxStandDiscItem;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.elements.PowerContext;
import net.hydra.jojomod.stand.powers.presets.NewPunchingStand;
import net.hydra.jojomod.util.C2SPacketUtil;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.config.ClientConfig;
import net.hydra.jojomod.util.config.ConfigManager;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1307;
import net.minecraft.class_1309;
import net.minecraft.class_1439;
import net.minecraft.class_1472;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1548;
import net.minecraft.class_1584;
import net.minecraft.class_1590;
import net.minecraft.class_1613;
import net.minecraft.class_1628;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1686;
import net.minecraft.class_1747;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3763;
import net.minecraft.class_4760;
import net.minecraft.class_4836;
import net.minecraft.class_5419;

public class PowersSoftAndWet
extends NewPunchingStand {
    public List<SoftAndWetBubbleEntity> bubbleList = new ArrayList<SoftAndWetBubbleEntity>();
    public int waterShieldTicks = 0;
    public byte bubbleType;
    public boolean hold1;
    public boolean holdDownClick;
    public static int maxSuperHitTime = 25;
    int bubbleMax;
    int bubbleCd;
    public int shootTicks;
    public int goBeyondChargeTicks;
    public boolean inExplosiveSpinMode;
    public int grabInventorySlot;
    public int chargedFinal;
    public static final byte BARRAGE_NOISE = 20;
    public static final byte BARRAGE_NOISE_2 = 21;
    public static final byte BARRAGE_NOISE_3 = 22;
    class_1297 goBeyondActiveTarget;
    public int bubbleNumber;
    int bubbleScaffoldCount;
    public int pauseGrowthTicks;
    public class_2338 buildingBubbleScaffoldPos;

    public PowersSoftAndWet(class_1309 self) {
        super(self);
        this.bubbleType = PlunderTypes.ITEM.id;
        this.hold1 = false;
        this.holdDownClick = false;
        this.bubbleMax = 0;
        this.bubbleCd = 20;
        this.shootTicks = 0;
        this.goBeyondChargeTicks = 0;
        this.inExplosiveSpinMode = false;
        this.grabInventorySlot = 1;
        this.goBeyondActiveTarget = null;
        this.bubbleNumber = 0;
        this.bubbleScaffoldCount = 0;
        this.pauseGrowthTicks = 0;
        this.buildingBubbleScaffoldPos = class_2338.field_10980;
    }

    @Override
    public boolean isStandEnabled() {
        return ClientNetworking.getAppropriateConfig().softAndWetSettings.enableSoftAndWet;
    }

    @Override
    public StandEntity getNewStandEntity() {
        byte sk = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (sk == 3) {
            return (StandEntity)ModEntities.SOFT_AND_WET_KING.method_5883(this.getSelf().method_37908());
        }
        if (sk == 9) {
            return (StandEntity)ModEntities.SOFT_AND_WET_DEBUT.method_5883(this.getSelf().method_37908());
        }
        if (sk == 5 || sk == 6) {
            return (StandEntity)ModEntities.SOFT_AND_WET_DROWNED.method_5883(this.getSelf().method_37908());
        }
        if (sk == 10) {
            return (StandEntity)ModEntities.SOFT_AND_WET_KILLER_QUEEN.method_5883(this.getSelf().method_37908());
        }
        return (StandEntity)ModEntities.SOFT_AND_WET.method_5883(this.getSelf().method_37908());
    }

    @Override
    public void powerActivate(PowerContext context) {
        switch (context) {
            case SKILL_1_NORMAL: {
                this.plunderBubbleSelectClient();
                break;
            }
            case SKILL_1_CROUCH: {
                this.plunderBubbleClusterClient();
                break;
            }
            case SKILL_1_GUARD: 
            case SKILL_1_CROUCH_GUARD: {
                this.clusterRedirectClient();
                break;
            }
            case SKILL_2_NORMAL: {
                this.plunderOrItemLaunchBubbleClient();
                break;
            }
            case SKILL_2_CROUCH: {
                this.bubblePopClient();
                break;
            }
            case SKILL_2_GUARD: 
            case SKILL_2_CROUCH_GUARD: {
                this.activatedBubbleRedirectClient();
                break;
            }
            case SKILL_3_NORMAL: {
                this.tryToDashClient();
                break;
            }
            case SKILL_3_CROUCH: {
                this.tryToBubbleScaffoldClient();
                break;
            }
            case SKILL_3_GUARD: 
            case SKILL_3_CROUCH_GUARD: {
                this.tryToBigBubbleClient();
                break;
            }
            case SKILL_4_NORMAL: {
                this.shootingModeToggleClient();
                break;
            }
            case SKILL_4_CROUCH: {
                this.waterShieldAttemptClient();
            }
        }
    }

    public boolean goBeyondClient() {
        if (this.inShootingMode()) {
            if (this.canExecuteMoveWithLevel(this.getGoBeyondLevel()) && this.goBeyondCharged() && this.getGoBeyondTarget() != null) {
                this.tryIntPower(11, true, this.getGoBeyondTarget().method_5628());
                this.tryIntPowerPacket((byte)11, this.getGoBeyondTarget().method_5628());
                this.setGoBeyondTarget(null);
                this.setGoBeyondChargeTicks(0);
                this.setShootTicks(0);
            }
            return true;
        }
        return false;
    }

    public void plunderBubbleSelectClient() {
        if (!this.goBeyondClient()) {
            ClientUtil.openPlunderScreen();
        }
    }

    public void plunderBubbleClusterClient() {
        if (!this.goBeyondClient() && this.canExecuteMoveWithLevel(this.getSpreadLevel())) {
            if (!this.onCooldown((byte)4)) {
                if (this.activePower != 22 && !this.canDoBubbleClusterPop()) {
                    this.hold1 = true;
                    int bubbleType = 1;
                    ClientConfig clientConfig = ConfigManager.getClientConfig();
                    if (clientConfig != null && clientConfig.dynamicSettings != null) {
                        bubbleType = clientConfig.dynamicSettings.SoftAndWetCurrentlySelectedBubble;
                    }
                    this.tryIntPower(22, true, bubbleType);
                    this.tryIntPowerPacket((byte)22, bubbleType);
                } else if (!this.onCooldown((byte)9)) {
                    this.hold1 = true;
                    this.tryPower(16, true);
                    this.tryPowerPacket((byte)16);
                }
            } else if ((this.activePower == 22 || this.canDoBubbleClusterRedirect()) && !this.onCooldown((byte)9)) {
                this.hold1 = true;
                this.tryPower(16, true);
                this.tryPowerPacket((byte)16);
            }
        }
    }

    public void clusterRedirectClient() {
        if (!this.goBeyondClient() && this.canExecuteMoveWithLevel(this.getSpreadLevel()) && !this.onCooldown((byte)9)) {
            this.tryPower(34, true);
            this.tryPowerPacket((byte)34);
        }
    }

    public void activatedBubbleRedirectClient() {
        if (!this.inShootingMode() && !this.onCooldown((byte)9)) {
            class_243 pos = MainUtil.getRaytracePointOnMobOrBlock((class_1297)this.self, 30.0f);
            this.tryPosPower(29, true, pos);
            this.tryPosPowerPacket((byte)29, pos);
        }
    }

    public void bubblePopClient() {
        if (!this.onCooldown((byte)5)) {
            class_243 pos = MainUtil.getRaytracePointOnMobOrBlock((class_1297)this.self, 30.0f);
            this.tryPosPower(24, true, pos);
            this.tryPosPowerPacket((byte)24, pos);
        }
    }

    public void plunderOrItemLaunchBubbleClient() {
        if (!this.inShootingMode()) {
            if (!this.onCooldown((byte)1)) {
                int bubbleType = 1;
                ClientConfig clientConfig = ConfigManager.getClientConfig();
                if (clientConfig != null && clientConfig.dynamicSettings != null) {
                    bubbleType = clientConfig.dynamicSettings.SoftAndWetCurrentlySelectedBubble;
                }
                this.tryIntPower(23, true, bubbleType);
                this.tryIntPowerPacket((byte)23, bubbleType);
            }
        } else if (this.canExecuteMoveWithLevel(this.getItemShootingLevel()) && !this.onCooldown((byte)1) && this.canDoBubbleItemLaunch()) {
            this.tryIntPower(35, true, ((class_1657)this.getSelf()).method_31548().field_7545);
            this.tryIntPowerPacket((byte)35, ((class_1657)this.getSelf()).method_31548().field_7545);
        }
    }

    public void shootingModeToggleClient() {
        if (this.canExecuteMoveWithLevel(this.getShootingModeLevel())) {
            this.tryPower(27, true);
            this.tryPowerPacket((byte)27);
            this.getStandUserSelf().roundabout$getStandPowers().tryPower(0, true);
            this.tryPowerPacket((byte)0);
            ClientUtil.stopDestroyingBlock();
        }
    }

    public void waterShieldAttemptClient() {
        if (!this.inShootingMode()) {
            if (!this.onCooldown((byte)7) && this.canExecuteMoveWithLevel(this.getWaterShieldLevel()) && this.canUseWaterShield()) {
                this.tryPower(28, true);
                this.tryPowerPacket((byte)28);
            }
        } else {
            this.shootingModeToggleClient();
        }
    }

    public void tryToBubbleScaffoldClient() {
        if (this.vaultOrFallBraceFails() && this.canExecuteMoveWithLevel(this.getScaffoldLevel()) && !this.onCooldown((byte)2) && this.canBridge()) {
            ((StandUser)this.getSelf()).roundabout$tryPower(25, true);
            this.tryPowerPacket((byte)25);
        }
    }

    public void tryToBigBubbleClient() {
        if (this.vaultOrFallBraceFails() && !this.onCooldown((byte)8) && this.canBigBubble()) {
            ((StandUser)this.getSelf()).roundabout$tryPower(36, true);
            this.tryPowerPacket((byte)36);
        }
    }

    public void tryToDashClient() {
        if (this.vaultOrFallBraceFails()) {
            this.dash();
        }
    }

    @Override
    public float getMiningMultiplier() {
        return (float)(1.0 * ((double)ClientNetworking.getAppropriateConfig().softAndWetSettings.miningSpeedMultiplierSoftAndWet.intValue() * 0.01));
    }

    @Override
    public float getPickMiningSpeed() {
        return 12.0f;
    }

    @Override
    public float getAxeMiningSpeed() {
        return 8.0f;
    }

    @Override
    public float getSwordMiningSpeed() {
        return 8.0f;
    }

    @Override
    public float getShovelMiningSpeed() {
        return 8.0f;
    }

    @Override
    public int getMiningLevel() {
        return ClientNetworking.getAppropriateConfig().softAndWetSettings.getMiningTierSoftAndWet;
    }

    @Override
    public boolean canSummonStand() {
        return !(this.getSelf() instanceof class_1548);
    }

    @Override
    public StandPowers generateStandPowers(class_1309 entity) {
        return new PowersSoftAndWet(entity);
    }

    @Override
    protected Byte getSummonSound() {
        return (byte)18;
    }

    @Override
    public byte getSoundCancelingGroupByte(byte soundChoice) {
        if (soundChoice == 2) {
            return 100;
        }
        if (soundChoice >= 20 && soundChoice <= 21) {
            return 100;
        }
        return super.getSoundCancelingGroupByte(soundChoice);
    }

    @Override
    public void playBarrageClashSound() {
        byte skn;
        if (!this.self.method_37908().method_8608() && (skn = ((StandUser)this.getSelf()).roundabout$getStandSkin()) != 10) {
            this.playStandUserOnlySoundsIfNearby((byte)20, 27.0, false, true);
        }
    }

    @Override
    public class_3414 getSoundFromByte(byte soundChoice) {
        byte bt = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (soundChoice == 18) {
            return ModSounds.SUMMON_SOFT_AND_WET_EVENT;
        }
        if (soundChoice == 20) {
            return ModSounds.SOFT_AND_WET_BARRAGE_EVENT;
        }
        if (soundChoice == 2) {
            return ModSounds.STAND_BARRAGE_WINDUP_EVENT;
        }
        if (soundChoice == 21) {
            return ModSounds.SOFT_AND_WET_BARRAGE_2_EVENT;
        }
        return super.getSoundFromByte(soundChoice);
    }

    public void bubbleListInit() {
        if (this.bubbleList == null) {
            this.bubbleList = new ArrayList<SoftAndWetBubbleEntity>();
        }
    }

    @Override
    public List<Byte> getSkinList() {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add((byte)2);
        class_1309 class_13092 = this.getSelf();
        if (class_13092 instanceof class_1657) {
            class_1657 PE = (class_1657)class_13092;
            byte Level = ((IPlayerEntity)PE).roundabout$getStandLevel();
            class_1799 goldDisc = ((StandUser)PE).roundabout$getStandDisc();
            boolean bypass = PE.method_7337() || !goldDisc.method_7960() && goldDisc.method_7909() instanceof MaxStandDiscItem;
            $$1.add((byte)1);
            if (Level > 1 || bypass) {
                $$1.add((byte)9);
            }
            if (Level > 2 || bypass) {
                $$1.add((byte)12);
                $$1.add((byte)8);
            }
            if (Level > 3 || bypass) {
                $$1.add((byte)7);
                $$1.add((byte)11);
            }
            if (Level > 4 || bypass) {
                $$1.add((byte)13);
            }
            if (Level > 5 || bypass) {
                $$1.add((byte)5);
                $$1.add((byte)6);
            }
            if (Level > 6 || bypass) {
                $$1.add((byte)3);
                $$1.add((byte)4);
            }
            if (((IPlayerEntity)PE).roundabout$getUnlockedBonusSkin() || bypass) {
                $$1.add((byte)10);
            }
        }
        return $$1;
    }

    public boolean goBeyondCharged() {
        class_1657 PE;
        class_1309 class_13092;
        return this.getInExplosiveSpinMode() || (class_13092 = this.self) instanceof class_1657 && (PE = (class_1657)class_13092).method_7337();
    }

    @Override
    public boolean isAttackIneptVisually(byte activeP, int slot) {
        if (this.inShootingMode()) {
            if (!(slot != 1 || this.goBeyondCharged() && this.getGoBeyondTarget() != null)) {
                return true;
            }
            if (slot == 2 && !this.canDoBubbleItemLaunch() && !this.isHoldingSneak()) {
                return true;
            }
        } else {
            if (slot == 1 && !this.canDoBubbleClusterRedirect() && this.isGuarding()) {
                return true;
            }
            if (slot == 2 && !this.canDoBubbleRedirect() && this.isGuarding()) {
                return true;
            }
            if (slot == 4 && this.isHoldingSneak() && !this.canUseWaterShield()) {
                return true;
            }
        }
        if (!(slot != 3 || this.canVault() || this.canFallBrace() || this.isGuarding() || !this.isHoldingSneak() || this.canBridge())) {
            return true;
        }
        if (slot == 3 && !this.canVault() && !this.canFallBrace() && this.isGuarding() && !this.canBigBubble()) {
            return false;
        }
        return super.isAttackIneptVisually(activeP, slot);
    }

    public boolean hasWaterShield() {
        return this.waterShieldTicks > 0;
    }

    public void setWaterShieldTicks(int ticks) {
        this.waterShieldTicks = ticks;
    }

    public int getWaterShieldTicks() {
        return this.waterShieldTicks;
    }

    public void tickWaterShield() {
        if (this.waterShieldTicks > 0) {
            --this.waterShieldTicks;
        }
    }

    @Override
    public List<AbilityIconInstance> drawGUIIcons(class_332 context, float delta, int mouseX, int mouseY, int leftPos, int topPos, byte level, boolean bypas) {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 80, 0, "ability.roundabout.punch", "instruction.roundabout.press_attack", StandIcons.SOFT_AND_WET_PUNCH, 0, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 99, 0, "ability.roundabout.guard", "instruction.roundabout.hold_block", StandIcons.SOFT_AND_WET_GUARD, 0, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 118, 0, "ability.roundabout.encasement_strike", "instruction.roundabout.hold_attack_crouch", StandIcons.ENCASEMENT_STRIKE, 0, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 80, 0, "ability.roundabout.barrage", "instruction.roundabout.barrage", StandIcons.SOFT_AND_WET_BARRAGE, 0, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 99, this.getShootingModeLevel(), "ability.roundabout.bubble_barrage", "instruction.roundabout.shooting_barrage", StandIcons.BUBBLE_BARRAGE, 0, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 118, 0, "ability.roundabout.bubble_selection", "instruction.roundabout.press_skill", StandIcons.PLUNDER_SELECTION, 1, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 58, topPos + 80, this.getGoBeyondLevel(), "ability.roundabout.go_beyond", "instruction.roundabout.press_skill_explosive_spin_mode", StandIcons.GO_BEYOND, 1, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 58, topPos + 99, this.getSpreadLevel(), "ability.roundabout.bubble_spread", "instruction.roundabout.press_skill_crouch", StandIcons.PLUNDER_BUBBLE_FILL, 1, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 58, topPos + 118, this.getSpreadLevel(), "ability.roundabout.bubble_spread_redirect", "instruction.roundabout.press_skill_block", StandIcons.PLUNDER_BUBBLE_FILL_CONTROL, 1, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 77, topPos + 80, 0, "ability.roundabout.plunder_bubble", "instruction.roundabout.press_skill", StandIcons.PLUNDER_BUBBLE, 2, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 77, topPos + 99, 0, "ability.roundabout.bubble_pop", "instruction.roundabout.press_skill_crouch", StandIcons.PLUNDER_BUBBLE_POP, 2, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 77, topPos + 118, 0, "ability.roundabout.bubble_redirect", "instruction.roundabout.press_skill_block", StandIcons.PLUNDER_BUBBLE_CONTROL, 2, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 96, topPos + 80, this.getItemShootingLevel(), "ability.roundabout.item_launching_bubble", "instruction.roundabout.press_skill_shooting_mode", StandIcons.ITEM_BUBBLE, 2, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 96, topPos + 99, 0, "ability.roundabout.dodge", "instruction.roundabout.press_skill", StandIcons.DODGE, 3, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 96, topPos + 118, 0, "ability.roundabout.fall_brace", "instruction.roundabout.press_skill_falling", StandIcons.SOFT_AND_WET_FALL_CATCH, 3, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 115, topPos + 80, 0, "ability.roundabout.vault", "instruction.roundabout.press_skill_air", StandIcons.SOFT_AND_WET_VAULT, 3, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 115, topPos + 99, this.getScaffoldLevel(), "ability.roundabout.bubble_scaffold", "instruction.roundabout.press_skill_crouch", StandIcons.SOFT_AND_WET_BUBBLE_SCAFFOLD, 3, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 115, topPos + 118, 0, "ability.roundabout.encasement_bubble", "instruction.roundabout.press_skill_block", StandIcons.SOFT_AND_WET_BUBBLE_ENCASEMENT, 3, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 134, topPos + 80, this.getShootingModeLevel(), "ability.roundabout.shooting_mode", "instruction.roundabout.press_skill", StandIcons.SOFT_SHOOTING_MODE, 4, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 134, topPos + 99, this.getWaterShieldLevel(), "ability.roundabout.water_shield", "instruction.roundabout.press_skill_crouch", StandIcons.WATER_SHIELD, 4, level, bypas));
        return $$1;
    }

    public int getGoBeyondLevel() {
        return 7;
    }

    public int getWaterShieldLevel() {
        return 6;
    }

    public int getItemShootingLevel() {
        return 5;
    }

    public int getShootingModeLevel() {
        return 4;
    }

    public int getScaffoldLevel() {
        return 3;
    }

    public int getSpreadLevel() {
        return 2;
    }

    @Override
    public void renderIcons(class_332 context, int x, int y) {
        if (this.inShootingMode()) {
            if (this.canExecuteMoveWithLevel(this.getGoBeyondLevel())) {
                this.setSkillIcon(context, x, y, 1, StandIcons.GO_BEYOND, (byte)9);
            } else {
                this.setSkillIcon(context, x, y, 1, StandIcons.LOCKED, (byte)-1, true);
            }
        } else if (this.isGuarding()) {
            if (this.canExecuteMoveWithLevel(this.getSpreadLevel())) {
                this.setSkillIcon(context, x, y, 1, StandIcons.PLUNDER_BUBBLE_FILL_CONTROL, (byte)9);
            } else {
                this.setSkillIcon(context, x, y, 1, StandIcons.LOCKED, (byte)-1, true);
            }
        } else if (this.isHoldingSneak()) {
            if (this.canExecuteMoveWithLevel(this.getSpreadLevel())) {
                if (this.canDoBubbleClusterPop()) {
                    this.setSkillIcon(context, x, y, 1, StandIcons.PLUNDER_BUBBLE_FILL_POP, (byte)5);
                } else {
                    this.setSkillIcon(context, x, y, 1, StandIcons.PLUNDER_BUBBLE_FILL, (byte)4);
                }
            } else {
                this.setSkillIcon(context, x, y, 1, StandIcons.LOCKED, (byte)-1, true);
            }
        } else {
            this.setSkillIcon(context, x, y, 1, StandIcons.PLUNDER_SELECTION, (byte)-1);
        }
        if (this.inShootingMode()) {
            if (this.isHoldingSneak()) {
                this.setSkillIcon(context, x, y, 2, StandIcons.PLUNDER_BUBBLE_POP, (byte)5);
            } else if (this.canExecuteMoveWithLevel(this.getItemShootingLevel())) {
                this.setSkillIcon(context, x, y, 2, StandIcons.ITEM_BUBBLE, (byte)1);
            } else {
                this.setSkillIcon(context, x, y, 2, StandIcons.LOCKED, (byte)-1, true);
            }
        } else if (this.isGuarding()) {
            this.setSkillIcon(context, x, y, 2, StandIcons.PLUNDER_BUBBLE_CONTROL, (byte)9);
        } else if (this.isHoldingSneak()) {
            this.setSkillIcon(context, x, y, 2, StandIcons.PLUNDER_BUBBLE_POP, (byte)5);
        } else {
            this.setSkillIcon(context, x, y, 2, StandIcons.PLUNDER_BUBBLE, (byte)1);
        }
        if (this.canVault()) {
            this.setSkillIcon(context, x, y, 3, StandIcons.SOFT_AND_WET_VAULT, (byte)6);
        } else if (this.canFallBrace()) {
            this.setSkillIcon(context, x, y, 3, StandIcons.SOFT_AND_WET_FALL_CATCH, (byte)0);
        } else if (this.isGuarding()) {
            this.setSkillIcon(context, x, y, 3, StandIcons.SOFT_AND_WET_BUBBLE_ENCASEMENT, (byte)8);
        } else if (this.isHoldingSneak()) {
            if (this.canExecuteMoveWithLevel(this.getScaffoldLevel())) {
                this.setSkillIcon(context, x, y, 3, StandIcons.SOFT_AND_WET_BUBBLE_SCAFFOLD, (byte)2);
            } else {
                this.setSkillIcon(context, x, y, 3, StandIcons.LOCKED, (byte)-1, true);
            }
        } else {
            this.setSkillIcon(context, x, y, 3, StandIcons.DODGE, (byte)6);
        }
        if (this.inShootingMode()) {
            this.setSkillIcon(context, x, y, 4, StandIcons.SOFT_SHOOTING_MODE_EXIT, (byte)3);
        } else if (this.isHoldingSneak()) {
            if (this.canExecuteMoveWithLevel(this.getWaterShieldLevel())) {
                this.setSkillIcon(context, x, y, 4, StandIcons.WATER_SHIELD, (byte)7);
            } else {
                this.setSkillIcon(context, x, y, 4, StandIcons.LOCKED, (byte)-1, true);
            }
        } else if (this.canExecuteMoveWithLevel(this.getShootingModeLevel())) {
            this.setSkillIcon(context, x, y, 4, StandIcons.SOFT_SHOOTING_MODE, (byte)3);
        } else {
            this.setSkillIcon(context, x, y, 4, StandIcons.LOCKED, (byte)-1, true);
        }
    }

    @Override
    public byte getMaxLevel() {
        return 7;
    }

    @Override
    public int getExpForLevelUp(int currentLevel) {
        int amt = currentLevel == 1 ? 100 : 100 + (currentLevel - 1) * 55;
        amt = (int)((float)amt * this.getLevelMultiplier());
        return amt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canUseWaterShield() {
        class_1792 class_17922;
        class_1799 stack = this.getSelf().method_6047();
        class_1799 stack2 = this.getSelf().method_6079();
        if (!stack.method_7960() && (class_17922 = stack.method_7909()) instanceof class_1812) {
            class_1812 PI = (class_1812)class_17922;
            if (class_1844.method_8063((class_1799)stack) == class_1847.field_8991) return true;
        }
        if (!stack2.method_7960() && (class_17922 = stack2.method_7909()) instanceof class_1812) {
            class_1812 PI2 = (class_1812)class_17922;
            if (class_1844.method_8063((class_1799)stack2) == class_1847.field_8991) return true;
        }
        if (!stack.method_7960() && (class_17922 = stack.method_7909()) instanceof class_1755) {
            class_1755 BI = (class_1755)class_17922;
            if (((IBucketItem)BI).roundabout$getContents().method_15791(class_3486.field_15517)) return true;
        }
        if (stack2.method_7960()) return false;
        class_17922 = stack2.method_7909();
        if (!(class_17922 instanceof class_1755)) return false;
        class_1755 BI2 = (class_1755)class_17922;
        if (!((IBucketItem)BI2).roundabout$getContents().method_15791(class_3486.field_15517)) return false;
        return true;
    }

    @Override
    public boolean canGuard() {
        if (this.isBubbleBarraging()) {
            return false;
        }
        return super.canGuard();
    }

    public int getUseTicks() {
        return ClientNetworking.getAppropriateConfig().softAndWetSettings.heatGainedPerShot;
    }

    public int getGoBeyondUseTicks() {
        return ClientNetworking.getAppropriateConfig().softAndWetSettings.explosiveSpinMeterGainedPerShot;
    }

    @Override
    public void buttonInputAttack(boolean keyIsDown, class_315 options) {
        if (!this.consumeClickInput) {
            if (this.holdDownClick) {
                if (!keyIsDown) {
                    if (this.getActivePower() == 43) {
                        int atd = this.getAttackTimeDuring();
                        this.tryIntPower(2, true, atd);
                        this.tryIntPowerPacket((byte)2, atd);
                    }
                    this.holdDownClick = false;
                }
            } else if (keyIsDown) {
                if (this.inShootingMode()) {
                    if (!(this.holdDownClick || this.onCooldown((byte)3) || this.getActivePower() != 0 && this.getActivePower() != 33 || !this.getInExplosiveSpinMode() && !this.confirmShot(this.getUseTicks()))) {
                        class_1309 class_13092 = this.self;
                        if (class_13092 instanceof class_1657) {
                            class_1657 PE = (class_1657)class_13092;
                            IPlayerEntity ipe = (IPlayerEntity)PE;
                            ipe.roundabout$getBubbleShotAim().method_41325();
                            ipe.roundabout$setBubbleShotAimPoints(10);
                        }
                        this.tryPower(33, true);
                        if (this.getInExplosiveSpinMode()) {
                            this.tryPowerPacket((byte)37);
                        } else {
                            this.tryPowerPacket((byte)33);
                        }
                    }
                } else {
                    class_310 mc = class_310.method_1551();
                    if (!this.isHoldingSneak()) {
                        super.buttonInputAttack(keyIsDown, options);
                    } else if (this.canAttack()) {
                        this.tryPower(43, true);
                        this.holdDownClick = true;
                        this.tryPowerPacket((byte)43);
                    } else {
                        super.buttonInputAttack(keyIsDown, options);
                    }
                }
            }
        } else if (!keyIsDown) {
            this.consumeClickInput = false;
        }
    }

    public boolean isBubbleBarraging() {
        return this.getActivePower() == 41 || this.getActivePower() == 42;
    }

    @Override
    public void buttonInputBarrage(boolean keyIsDown, class_315 options) {
        if (keyIsDown && !this.isBubbleBarraging()) {
            if (!this.inShootingMode()) {
                super.buttonInputBarrage(keyIsDown, options);
            } else if (this.getAttackTime() >= this.getAttackTimeMax() || this.getActivePowerPhase() != this.getActivePowerPhaseMax()) {
                this.tryPower(41, true);
                this.tryPowerPacket((byte)41);
            }
        }
    }

    public int getBubbleBarrageWindup() {
        return ClientNetworking.getAppropriateConfig().generalStandSettings.barrageWindup;
    }

    public float getBubbleBarrageChargePitch() {
        return 1.0f / ((float)this.getBubbleBarrageWindup() / 20.0f);
    }

    @Override
    public float getSoundPitchFromByte(byte soundChoice) {
        if (soundChoice == 2) {
            return this.getBubbleBarrageChargePitch();
        }
        return super.getSoundPitchFromByte(soundChoice);
    }

    public int getBubbleBarrageRecoilTime() {
        return ClientNetworking.getAppropriateConfig().softAndWetSettings.bubbleBarrageRecoilCooldown;
    }

    public void updateBubbleBarrage() {
        if (this.attackTimeDuring == -2 && this.getSelf() instanceof class_1657) {
            ((StandUser)this.self).roundabout$tryPower(3, true);
        } else if (this.attackTimeDuring > this.getBubbleBarrageLength()) {
            this.attackTimeDuring = -20;
        } else if (this.attackTimeDuring > 0) {
            this.setAttackTime(this.getBubbleBarrageRecoilTime() - 1 - Math.round((float)this.attackTimeDuring / (float)this.getBubbleBarrageLength() * (float)(this.getBubbleBarrageRecoilTime() - 1)));
            this.bubbleBarrageTick();
        }
    }

    public void bubbleBarrageTick() {
        if (!this.self.method_37908().method_8608()) {
            this.playBarrageMissNoise(this.attackTimeDuring);
            if (this.attackTimeDuring % 5 == 1) {
                this.generateGroundBubble();
            }
            if (this.activePower == 42 && this.attackTimeDuring == this.getBubbleBarrageLength()) {
                this.attackTimeDuring = -10;
                this.animateStand((byte)13);
            }
            this.findDeflectables();
        }
    }

    public int getBubbleBarrageLength() {
        return 20;
    }

    @Override
    public void renderAttackHud(class_332 context, class_1657 playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
        StandUser standUser = (StandUser)playerEntity;
        StandPowers powers = standUser.roundabout$getStandPowers();
        boolean standOn = standUser.roundabout$getActive();
        int j = scaledHeight / 2 - 7 - 4;
        int k = scaledWidth / 2 - 8;
        if (standOn && this.getActivePower() == 42 && this.attackTimeDuring > -1) {
            int ClashTime = 15 - Math.round((float)this.attackTimeDuring / (float)this.getBubbleBarrageLength() * 15.0f);
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 30, ClashTime, 6);
        } else if (standOn && this.getActivePower() == 43) {
            int ClashTime = Math.min(15, Math.round((float)this.attackTimeDuring / (float)maxSuperHitTime * 15.0f));
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 30, ClashTime, 6);
        } else if (standOn && this.getActivePower() == 41) {
            int ClashTime = Math.round((float)this.attackTimeDuring / (float)this.getBubbleBarrageWindup() * 15.0f);
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 30, ClashTime, 6);
        } else {
            super.renderAttackHud(context, playerEntity, scaledWidth, scaledHeight, ticks, vehicleHeartCount, flashAlpha, otherFlashAlpha);
        }
    }

    @Override
    public boolean cancelItemUse() {
        return this.getActivePower() == 41 || this.getActivePower() == 42;
    }

    @Override
    public boolean canInterruptPower() {
        if (this.getActivePower() == 41) {
            return true;
        }
        return super.canInterruptPower();
    }

    @Override
    public boolean clickRelease() {
        return this.getActivePower() == 41 || this.getActivePower() == 42 || this.getActivePower() == 45;
    }

    @Override
    public void tickStandRejection(class_1293 effect) {
        StandUser SE;
        if (!this.getSelf().method_37908().method_8608() && effect.method_5584() == 50 && !(SE = (StandUser)this.self).roundabout$isLaunchBubbleEncased()) {
            SE.roundabout$setStoredVelocity(new class_243(0.0, 0.1, 0.0));
            if (this.self.method_5805()) {
                SE.roundabout$setBubbleLaunchEncased();
            }
            if (SE instanceof class_1657 && !this.self.method_37908().field_9236) {
                ((class_3222)SE).method_7353((class_2561)class_2561.method_43471((String)"text.roundabout.launch_bubble_encased"), true);
            }
            class_243 storedVec = SE.roundabout$getStoredVelocity();
            this.self.method_37908().method_8396(null, this.self.method_24515(), ModSounds.WATER_ENCASE_EVENT, class_3419.field_15248, 1.0f, 1.0f);
            MainUtil.takeLiteralUnresistableKnockbackWithY((class_1297)this.self, storedVec.field_1352, storedVec.field_1351, storedVec.field_1350);
        }
    }

    public void creeperSpawnBubble() {
        this.bubbleType = PlunderTypes.SOUND.id;
        SoftAndWetPlunderBubbleEntity bubble = this.getPlunderBubble();
        if (!this.onCooldown((byte)1) && bubble != null) {
            this.setCooldown((byte)1, ClientNetworking.getAppropriateConfig().softAndWetSettings.basicBubbleShotCooldown);
            this.poseStand((byte)0);
            this.setAttackTimeDuring(-10);
            this.setActivePower((byte)23);
            bubble.setPlunderType(this.bubbleType);
            bubble.setSingular(true);
            this.shootBubbleSpeed(bubble, 0.0f);
            this.bubbleListInit();
            this.bubbleList.add(bubble);
            this.getSelf().method_37908().method_8649((class_1297)bubble);
            bubble.setBlockPos(this.self.method_24515());
            bubble.setFloating();
        }
    }

    @Override
    public void tickMobAI(class_1309 attackTarget) {
        if (!(this.attackTimeDuring > -1 || !(this.getSelf().field_6017 > 4.0f) || this.self instanceof class_1307 || this.getSelf().method_5740() || this.getSelf().field_5960 || this.self instanceof class_1510 || this.self instanceof class_1528 || ((StandUser)this.getSelf()).roundabout$isBubbleEncased() || this.onCooldown((byte)8))) {
            this.self.method_37908().method_8396(null, this.self.method_24515(), ModSounds.BIG_BUBBLE_CREATE_EVENT, class_3419.field_15248, 2.0f, (float)(0.98 + Math.random() * 0.04));
            ((StandUser)this.getSelf()).roundabout$setBubbleEncased((byte)1);
            this.setCooldown((byte)8, ClientNetworking.getAppropriateConfig().softAndWetSettings.encasementBubbleCreateCooldown);
            return;
        }
        if (attackTarget != null && attackTarget.method_5805() && !this.isDazed(this.getSelf())) {
            double dist = attackTarget.method_5739((class_1297)this.getSelf());
            boolean isCreeper = this.getSelf() instanceof class_1548;
            if (!isCreeper) {
                class_1297 targetEntity;
                boolean isBasicMob;
                boolean bl = isBasicMob = this.self instanceof class_1642 || this.self instanceof class_1628 || this.self instanceof class_1613;
                this.bubbleType = this.self instanceof JojoNPC || this.self instanceof class_1646 || this.self instanceof class_3763 ? (Math.random() > 0.5 ? PlunderTypes.SIGHT.id : PlunderTypes.FRICTION.id) : (this.self instanceof class_1472 ? PlunderTypes.POTION_EFFECTS.id : (isBasicMob ? PlunderTypes.SIGHT.id : PlunderTypes.FRICTION.id));
                if (this.bubbleMax < 10) {
                    if (dist <= 20.0 && this.activePower == 0 && !this.onCooldown((byte)1)) {
                        ((StandUser)this.getSelf()).roundabout$tryIntPower(23, true, this.bubbleType);
                        ++this.bubbleMax;
                        this.bubbleCd = 300;
                    }
                } else {
                    --this.bubbleCd;
                    if (this.bubbleCd <= 0) {
                        this.bubbleMax = 0;
                    }
                }
                if (dist <= 6.0 && (this.activePower == 0 || this.activePower == 1) && (targetEntity = this.getTargetEntity(this.self, -1.0f)) != null && targetEntity.method_5779((class_1297)attackTarget) && this.attackTimeDuring <= -1) {
                    double RNG = Math.random();
                    Objects.requireNonNull(this);
                    if (!(this.activePowerPhase >= 3 && this.attackTime < this.attackTimeMax || this.activePower != 0 && this.activePower != 1)) {
                        if (RNG < 0.5 && (this.self instanceof class_1439 || this.self instanceof class_1584 || this.self instanceof class_4836 || this.self instanceof AvdolNPC || this.self instanceof class_1590 || this.self instanceof class_4760 || this.self instanceof class_5419)) {
                            this.wentForCharge = false;
                            ((StandUser)this.getSelf()).roundabout$tryPower(43, true);
                        } else {
                            this.wentForCharge = false;
                            ((StandUser)this.getSelf()).roundabout$tryPower(1, true);
                        }
                    }
                }
            }
        }
    }

    public SoftAndWetPlunderBubbleEntity getPlunderBubble() {
        SoftAndWetPlunderBubbleEntity bubble = new SoftAndWetPlunderBubbleEntity(this.self, this.self.method_37908());
        bubble.method_30634(this.getSelf().method_23317(), this.getSelf().method_23318(), this.getSelf().method_23321());
        bubble.setUser(this.self);
        bubble.method_7432((class_1297)this.self);
        bubble.lifeSpan = ClientNetworking.getAppropriateConfig().softAndWetSettings.primaryPlunderBubbleLifespanInTicks;
        return bubble;
    }

    public SoftAndWetItemLaunchingBubbleEntity getItemLaunchingBubble() {
        SoftAndWetItemLaunchingBubbleEntity bubble = new SoftAndWetItemLaunchingBubbleEntity(this.self, this.self.method_37908());
        bubble.method_30634(this.getSelf().method_23317(), this.getSelf().method_23318(), this.getSelf().method_23321());
        bubble.setUser(this.self);
        bubble.method_7432((class_1297)this.self);
        bubble.lifeSpan = ClientNetworking.getAppropriateConfig().softAndWetSettings.primaryPlunderBubbleLifespanInTicks;
        return bubble;
    }

    public SoftAndWetExplosiveBubbleEntity getExplosiveBubble() {
        SoftAndWetExplosiveBubbleEntity bubble = new SoftAndWetExplosiveBubbleEntity(this.self, this.self.method_37908());
        bubble.method_30634(this.getSelf().method_23317(), this.getSelf().method_23318(), this.getSelf().method_23321());
        bubble.setUser(this.self);
        bubble.method_7432((class_1297)this.self);
        bubble.lifeSpan = 400;
        return bubble;
    }

    public GoBeyondEntity getGoBeyondBubble() {
        GoBeyondEntity bubble = new GoBeyondEntity(this.self, this.self.method_37908());
        bubble.method_30634(this.getSelf().method_23317(), this.getSelf().method_23318(), this.getSelf().method_23321());
        bubble.setUser(this.self);
        bubble.method_7432((class_1297)this.self);
        bubble.ticksUntilDamage = ClientNetworking.getAppropriateConfig().softAndWetSettings.goBeyondTicksUntilItCanHit;
        bubble.lifeSpan = ClientNetworking.getAppropriateConfig().softAndWetSettings.goBeyondLifespanInTicks;
        return bubble;
    }

    public boolean canShootExplosive(int useTicks) {
        return this.shootTicks + useTicks <= this.getMaxShootTicks();
    }

    public int pauseTicks() {
        return ClientNetworking.getAppropriateConfig().softAndWetSettings.heatTickDownPauseLength;
    }

    public int getPauseGrowthTicks() {
        return this.pauseGrowthTicks;
    }

    public boolean confirmShot(int useTicks) {
        if (this.canShootExplosive(useTicks)) {
            this.pauseGrowthTicks = this.pauseTicks();
            this.setGoBeyondChargeTicks(this.goBeyondChargeTicks + this.getGoBeyondUseTicks());
            this.setShootTicks(this.shootTicks + useTicks);
            return true;
        }
        return false;
    }

    public int getShootTicks() {
        return this.shootTicks;
    }

    public void setShootTicks(int shootTicks) {
        this.shootTicks = class_3532.method_15340((int)shootTicks, (int)0, (int)this.getMaxShootTicks());
    }

    public boolean getInExplosiveSpinMode() {
        return this.inExplosiveSpinMode;
    }

    public void setInExplosiveSpinMode(boolean mode) {
        this.inExplosiveSpinMode = mode;
    }

    public int getGoBeyondCharge() {
        return this.goBeyondChargeTicks;
    }

    public void setGoBeyondChargeTicks(int goBeyondChargeTicks) {
        this.goBeyondChargeTicks = class_3532.method_15340((int)goBeyondChargeTicks, (int)0, (int)this.getMaxGoBeyondChargeTicks());
        if (this.getInExplosiveSpinMode() && this.getGoBeyondCharge() == 0) {
            this.setInExplosiveSpinMode(false);
        }
        if (!this.getInExplosiveSpinMode() && this.getGoBeyondCharge() >= this.getMaxGoBeyondChargeTicks()) {
            if (this.self.method_37908().method_8608()) {
                this.self.method_5783(ModSounds.EXPLOSIVE_SPIN_MODE_EVENT, 1.0f, 1.0f);
            }
            this.setInExplosiveSpinMode(true);
        }
    }

    @Override
    public void updateGoBeyondTarget() {
        if (this.canExecuteMoveWithLevel(this.getGoBeyondLevel())) {
            if (this.inShootingMode() && this.goBeyondCharged()) {
                class_1297 TE = MainUtil.getTargetEntity(this.self, 30.0f, 15);
                if (TE != null && !TE.method_5779((class_1297)this.self) && (!(TE instanceof StandEntity) || TE.method_5732()) && MainUtil.isActuallyALivingEntityNoCap(TE)) {
                    this.setGoBeyondTarget(TE);
                }
            } else {
                this.setGoBeyondTarget(null);
            }
        } else {
            this.setGoBeyondTarget(null);
        }
    }

    public int getMaxShootTicks() {
        return 10000;
    }

    public int getMaxGoBeyondChargeTicks() {
        return 10000;
    }

    public float getExplosiveSpeed() {
        if (this.getInExplosiveSpinMode()) {
            return (float)((double)0.8f * ((double)ClientNetworking.getAppropriateConfig().softAndWetSettings.explosiveBubbleShootSpeedMultiplier.intValue() * 0.01));
        }
        return (float)((double)0.54f * ((double)ClientNetworking.getAppropriateConfig().softAndWetSettings.explosiveBubbleShootSpeedMultiplier.intValue() * 0.01));
    }

    public boolean inShootingMode() {
        return this.getStandUserSelf().roundabout$getCombatMode();
    }

    public boolean shootExplosiveBubble() {
        this.setCooldown((byte)3, 3);
        SoftAndWetExplosiveBubbleEntity bubble = this.getExplosiveBubble();
        if (bubble != null) {
            this.poseStand((byte)0);
            this.setAttackTimeDuring(-10);
            this.setActivePower((byte)33);
            this.shootExplosiveBubbleSpeed(bubble, this.getExplosiveSpeed());
            this.bubbleListInit();
            this.bubbleList.add(bubble);
            this.getSelf().method_37908().method_8649((class_1297)bubble);
            this.self.method_37908().method_8396(null, this.self.method_24515(), ModSounds.EXPLOSIVE_BUBBLE_SHOT_EVENT, class_3419.field_15248, 2.0f, (float)(0.98 + Math.random() * 0.04));
        }
        return true;
    }

    public boolean useWaterShield() {
        class_1657 PL;
        class_1309 class_13092 = this.self;
        if (class_13092 instanceof class_1657 && !(PL = (class_1657)class_13092).method_37908().method_8608()) {
            class_1755 BI;
            class_1792 class_17922;
            class_1755 BI2;
            class_1792 class_17923;
            class_1799 stack = this.getSelf().method_6047();
            if (!stack.method_7960() && (class_17923 = stack.method_7909()) instanceof class_1812) {
                class_1812 PI = (class_1812)class_17923;
                if (class_1844.method_8063((class_1799)stack) == class_1847.field_8991) {
                    if (!PL.method_31549().field_7477) {
                        stack.method_7934(1);
                        PL.method_31548().method_7394(new class_1799((class_1935)class_1802.field_8469));
                    }
                    this.splashWaterShield();
                    return true;
                }
            }
            if (!stack.method_7960() && (class_17923 = stack.method_7909()) instanceof class_1755 && ((IBucketItem)(BI2 = (class_1755)class_17923)).roundabout$getContents().method_15791(class_3486.field_15517)) {
                if (!PL.method_31549().field_7477) {
                    stack.method_7934(1);
                    PL.method_31548().method_7394(new class_1799((class_1935)class_1802.field_8550));
                }
                this.splashWaterShield();
                return true;
            }
            class_1799 stack2 = this.getSelf().method_6079();
            if (!stack2.method_7960() && (class_17922 = stack2.method_7909()) instanceof class_1812) {
                class_1812 PI2 = (class_1812)class_17922;
                if (class_1844.method_8063((class_1799)stack2) == class_1847.field_8991) {
                    if (!PL.method_31549().field_7477) {
                        stack2.method_7934(1);
                        PL.method_31548().method_7394(new class_1799((class_1935)class_1802.field_8469));
                    }
                    this.splashWaterShield();
                }
            }
            if (!stack2.method_7960() && (class_17922 = stack2.method_7909()) instanceof class_1755 && ((IBucketItem)(BI = (class_1755)class_17922)).roundabout$getContents().method_15791(class_3486.field_15517)) {
                if (!PL.method_31549().field_7477) {
                    stack2.method_7934(1);
                    PL.method_31548().method_7394(new class_1799((class_1935)class_1802.field_8550));
                }
                this.splashWaterShield();
                return true;
            }
        }
        this.setCooldown((byte)7, ClientNetworking.getAppropriateConfig().softAndWetSettings.waterShieldCooldown);
        return true;
    }

    public void splashWaterShield() {
        float width = this.self.method_17681() * 0.5f;
        float height = this.self.method_17682() * 0.5f;
        if (((StandUser)this.self).roundabout$isOnStandFire()) {
            ((StandUser)this.self).roundabout$setRemainingStandFireTicks(0);
        }
        ((StandUser)this.self).roundabout$setGasolineTime(-1);
        this.self.method_46395();
        this.self.method_37908().method_8396(null, this.self.method_24515(), ModSounds.WATER_ENCASE_EVENT, class_3419.field_15248, 1.0f, (float)(1.5 + Math.random() * 0.04));
        class_243 vec3 = new class_243(0.0, (double)this.self.method_17682() * 0.5, 0.0);
        class_2350 direction = ((IGravityEntity)this.self).roundabout$getGravityDirection();
        if (direction != class_2350.field_11033) {
            vec3 = RotationUtil.vecPlayerToWorld(vec3, direction);
        }
        ((class_3218)this.self.method_37908()).method_14199((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10382.method_9564()), this.self.method_23317() + vec3.field_1352, this.self.method_23318() + vec3.field_1351, this.self.method_23321() + vec3.field_1350, 120, (double)width, (double)height, (double)width, 0.4);
        this.setWaterShieldTicks(ClientNetworking.getAppropriateConfig().softAndWetSettings.waterShieldDurationInTicks);
    }

    public boolean switchModes() {
        if (this.getStandUserSelf().roundabout$getCombatMode()) {
            this.getStandUserSelf().roundabout$setCombatMode(false);
            if (this.self.method_37908().method_8608()) {
                this.self.method_5783(ModSounds.EXPLOSIVE_BUBBLE_SWITCH_OFF_EVENT, 1.0f, 1.0f);
            }
        } else {
            this.getStandUserSelf().roundabout$setCombatMode(true);
            if (this.self.method_37908().method_8608()) {
                this.self.method_5783(ModSounds.EXPLOSIVE_BUBBLE_SWITCH_EVENT, 1.0f, 1.0f);
            }
        }
        return true;
    }

    public boolean goBeyond() {
        GoBeyondEntity bubble;
        if (!this.self.method_37908().method_8608() && this.goBeyondActiveTarget != null && (bubble = this.getGoBeyondBubble()) != null) {
            this.setCooldown((byte)1, 20);
            this.poseStand((byte)0);
            this.setAttackTimeDuring(-10);
            this.setActivePower((byte)23);
            bubble.setChasing(this.goBeyondActiveTarget);
            this.shootBubbleSpeed(bubble, 0.165f);
            this.bubbleListInit();
            this.bubbleList.add(bubble);
            this.getSelf().method_37908().method_8649((class_1297)bubble);
            this.self.method_37908().method_45445((class_1297)bubble, bubble.method_24515(), ModSounds.GO_BEYOND_LAUNCH_EVENT, class_3419.field_15248, 2.0f, (float)(0.98 + Math.random() * 0.04));
            class_243 vector = class_243.method_1034((class_241)new class_241(-52.0f, this.self.field_6283 - 90.0f));
            class_243 normvec = new class_243(0.0, (double)(this.self.method_5751() * 0.7f), 0.0);
            class_2350 direction = ((IGravityEntity)this.self).roundabout$getGravityDirection();
            if (direction != class_2350.field_11033) {
                vector = RotationUtil.vecPlayerToWorld(vector, direction);
                normvec = RotationUtil.vecPlayerToWorld(normvec, direction);
            }
            for (int i = 0; i < 10; ++i) {
                double randomX = Math.random() * 0.5 - 0.25;
                double randomY = Math.random() * 0.5 - 0.25;
                double randomZ = Math.random() * 0.5 - 0.25;
                class_243 xvec = vector.method_1031(randomX, randomY, randomZ);
                byte sk = ((StandUser)this.getSelf()).roundabout$getStandSkin();
                if (sk == 10) {
                    ((class_3218)this.getSelf().method_37908()).method_14199((class_2394)ModParticles.HEART_ATTACK_MINI, this.getSelf().method_23317() + normvec.field_1352, this.getSelf().method_23318() + normvec.field_1351, this.getSelf().method_23321() + normvec.field_1350, 0, xvec.field_1352, xvec.field_1351, xvec.field_1350, 0.12);
                    continue;
                }
                ((class_3218)this.getSelf().method_37908()).method_14199((class_2394)ModParticles.PURPLE_STAR, this.getSelf().method_23317() + normvec.field_1352, this.getSelf().method_23318() + normvec.field_1351, this.getSelf().method_23321() + normvec.field_1350, 0, xvec.field_1352, xvec.field_1351, xvec.field_1350, 0.12);
            }
        }
        return true;
    }

    public boolean itemBubbleShot() {
        class_1799 stack = ((class_1657)this.getSelf()).method_31548().method_5438(this.grabInventorySlot);
        if (!(stack.method_7960() || stack.method_7909() instanceof class_1747 && ((class_1747)stack.method_7909()).method_7711() instanceof class_2480)) {
            SoftAndWetItemLaunchingBubbleEntity bubble;
            this.setCooldown((byte)1, ClientNetworking.getAppropriateConfig().softAndWetSettings.itemBubbleShotCooldown);
            if (!this.self.method_37908().method_8608() && (bubble = this.getItemLaunchingBubble()) != null) {
                bubble.setHeldItem(stack.method_46651(1));
                stack.method_7934(1);
                this.poseStand((byte)0);
                this.setAttackTimeDuring(-10);
                this.setActivePower((byte)35);
                this.addEXP(1);
                this.shootExplosiveItemBubbleSpeed(bubble, this.getExplosiveItemBubbleSpeed());
                this.bubbleListInit();
                this.bubbleList.add(bubble);
                this.getSelf().method_37908().method_8649((class_1297)bubble);
                this.self.method_37908().method_8396(null, this.self.method_24515(), ModSounds.EXPLOSIVE_BUBBLE_SHOT_EVENT, class_3419.field_15248, 0.7f, (float)(1.2 + Math.random() * 0.04));
            }
        }
        return true;
    }

    public boolean bubbleShot() {
        SoftAndWetPlunderBubbleEntity bubble = this.getPlunderBubble();
        if (bubble != null) {
            this.setCooldown((byte)1, ClientNetworking.getAppropriateConfig().softAndWetSettings.basicBubbleShotCooldown);
            this.poseStand((byte)0);
            this.setAttackTimeDuring(-10);
            this.setActivePower((byte)23);
            bubble.setPlunderType(this.bubbleType);
            bubble.setSingular(true);
            this.shootBubbleSpeed(bubble, this.getBubbleSpeed());
            this.bubbleListInit();
            this.bubbleList.add(bubble);
            this.getSelf().method_37908().method_8649((class_1297)bubble);
            if (this.bubbleType != PlunderTypes.SOUND.id) {
                this.self.method_37908().method_8396(null, this.self.method_24515(), ModSounds.BUBBLE_CREATE_EVENT, class_3419.field_15248, 2.0f, (float)(0.98 + Math.random() * 0.04));
            }
        }
        return true;
    }

    public boolean canDoBubblePop() {
        this.bubbleListInit();
        ArrayList<SoftAndWetBubbleEntity> bubbleList2 = new ArrayList<SoftAndWetBubbleEntity>(this.bubbleList){};
        if (!bubbleList2.isEmpty()) {
            int totalnumber = bubbleList2.size();
            for (SoftAndWetBubbleEntity value : bubbleList2) {
                SoftAndWetPlunderBubbleEntity PBE;
                if (value instanceof SoftAndWetPlunderBubbleEntity && (PBE = (SoftAndWetPlunderBubbleEntity)value).isPopPlunderBubbble()) continue;
                return true;
            }
        }
        return !this.bubbleList.isEmpty();
    }

    public boolean canDoBubbleClusterRedirect() {
        this.bubbleListInit();
        ArrayList<SoftAndWetBubbleEntity> bubbleList2 = new ArrayList<SoftAndWetBubbleEntity>(this.bubbleList){};
        if (!bubbleList2.isEmpty()) {
            int totalnumber = bubbleList2.size();
            for (SoftAndWetBubbleEntity value : bubbleList2) {
                SoftAndWetPlunderBubbleEntity PBE;
                if (!(value instanceof SoftAndWetPlunderBubbleEntity) || (PBE = (SoftAndWetPlunderBubbleEntity)value).getSingular() || PBE.getActivated() || PBE.getFinished()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canDoBubbleClusterPop() {
        this.bubbleListInit();
        if (this.activePower == 22) {
            return true;
        }
        ArrayList<SoftAndWetBubbleEntity> bubbleList2 = new ArrayList<SoftAndWetBubbleEntity>(this.bubbleList){};
        if (!bubbleList2.isEmpty()) {
            int totalnumber = bubbleList2.size();
            for (SoftAndWetBubbleEntity value : bubbleList2) {
                SoftAndWetPlunderBubbleEntity PBE;
                if (!(value instanceof SoftAndWetPlunderBubbleEntity) || (PBE = (SoftAndWetPlunderBubbleEntity)value).isPopPlunderBubbble() || PBE.getSingular() || PBE.getFinished()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canDoBubbleRedirect() {
        this.bubbleListInit();
        ArrayList<SoftAndWetBubbleEntity> bubbleList2 = new ArrayList<SoftAndWetBubbleEntity>(this.bubbleList){};
        if (!bubbleList2.isEmpty()) {
            int totalnumber = bubbleList2.size();
            for (SoftAndWetBubbleEntity value : bubbleList2) {
                SoftAndWetPlunderBubbleEntity PBE;
                if (!value.getActivated() || value instanceof SoftAndWetPlunderBubbleEntity && ((PBE = (SoftAndWetPlunderBubbleEntity)value).getPlunderType() == PlunderTypes.SIGHT.id || PBE.getPlunderType() == PlunderTypes.FRICTION.id)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean clusterBubblePop() {
        this.bubbleListInit();
        if (!this.bubbleList.isEmpty()) {
            ArrayList<SoftAndWetBubbleEntity> bubbleList2;
            this.setCooldown((byte)5, 10);
            if (!this.self.method_37908().method_8608() && !(bubbleList2 = new ArrayList<SoftAndWetBubbleEntity>(this.bubbleList){}).isEmpty()) {
                for (SoftAndWetBubbleEntity value : bubbleList2) {
                    SoftAndWetPlunderBubbleEntity plunder;
                    if (!(value instanceof SoftAndWetPlunderBubbleEntity) || (plunder = (SoftAndWetPlunderBubbleEntity)value).isPopPlunderBubbble() || plunder.getFinished() || plunder.getSingular()) continue;
                    if (plunder.getPlunderType() == PlunderTypes.ITEM.id) {
                        plunder.forceDropItem();
                    }
                    plunder.popBubble();
                }
            }
        }
        return false;
    }

    public boolean bubblePop() {
        this.bubbleListInit();
        if (!this.self.method_37908().method_8608()) {
            ++this.bubbleNumber;
        }
        if (!this.bubbleList.isEmpty()) {
            ArrayList<SoftAndWetBubbleEntity> bubbleList2;
            this.setCooldown((byte)5, 20);
            if (!this.self.method_37908().method_8608() && !(bubbleList2 = new ArrayList<SoftAndWetBubbleEntity>(this.bubbleList){}).isEmpty()) {
                for (SoftAndWetBubbleEntity value : bubbleList2) {
                    SoftAndWetPlunderBubbleEntity plunder;
                    if (value instanceof SoftAndWetPlunderBubbleEntity && !(plunder = (SoftAndWetPlunderBubbleEntity)value).isPopPlunderBubbble()) {
                        if (plunder.getFinished()) continue;
                        if (plunder.getPlunderType() == PlunderTypes.ITEM.id) {
                            plunder.forceDropItem();
                        }
                        plunder.popBubble();
                        continue;
                    }
                    if (value instanceof SoftAndWetExplosiveBubbleEntity) {
                        SoftAndWetExplosiveBubbleEntity SBE = (SoftAndWetExplosiveBubbleEntity)value;
                        SBE.popWithForce();
                        continue;
                    }
                    if (!(value instanceof SoftAndWetItemLaunchingBubbleEntity)) continue;
                    SoftAndWetItemLaunchingBubbleEntity GBE = (SoftAndWetItemLaunchingBubbleEntity)value;
                    GBE.popWithForce(this.savedPos);
                }
            }
        }
        return false;
    }

    public boolean bubbleClusterRedirect() {
        this.bubbleListInit();
        ArrayList<SoftAndWetBubbleEntity> bubbleList2 = new ArrayList<SoftAndWetBubbleEntity>(this.bubbleList){};
        if (!bubbleList2.isEmpty()) {
            int totalnumber = bubbleList2.size();
            for (SoftAndWetBubbleEntity value : bubbleList2) {
                SoftAndWetPlunderBubbleEntity PBE;
                if (!(value instanceof SoftAndWetPlunderBubbleEntity) || (PBE = (SoftAndWetPlunderBubbleEntity)value).getSingular() || PBE.getActivated() || PBE.getFinished()) continue;
                this.shootBubbleSpeed2(PBE, PBE.getSped() * 0.65f);
                PBE.setLaunched(true);
            }
        }
        return false;
    }

    public boolean bubbleRedirect() {
        this.bubbleListInit();
        if (!this.bubbleList.isEmpty() && this.canDoBubbleRedirect()) {
            this.setCooldown((byte)9, 3);
            if (!this.self.method_37908().method_8608()) {
                ArrayList<SoftAndWetBubbleEntity> bubbleList3;
                if (this.savedPos != null && !(bubbleList3 = new ArrayList<SoftAndWetBubbleEntity>(this.bubbleList){}).isEmpty()) {
                    int totalnumber = bubbleList3.size();
                    for (SoftAndWetBubbleEntity value : bubbleList3) {
                        SoftAndWetPlunderBubbleEntity PBE;
                        if (!value.getActivated() || value instanceof SoftAndWetPlunderBubbleEntity && ((PBE = (SoftAndWetPlunderBubbleEntity)value).getPlunderType() == PlunderTypes.SIGHT.id || PBE.getPlunderType() == PlunderTypes.FRICTION.id)) continue;
                        class_243 vector = new class_243(this.savedPos.method_10216() - value.method_23317(), this.savedPos.method_10214() - value.method_23318(), this.savedPos.method_10215() - value.method_23321()).method_1029().method_1021((double)value.getSped());
                        if (totalnumber > 1) {
                            vector = new class_243(vector.method_10216() + (Math.random() - 0.5) * (double)totalnumber * (double)value.getSped() * 0.03, vector.method_10214(), vector.method_10215() + (Math.random() - 0.5) * (double)totalnumber * (double)value.getSped() * 0.03).method_1029().method_1021((double)value.getSped());
                        }
                        value.method_18799(vector);
                        value.field_6037 = true;
                        value.field_6007 = true;
                        if (value.getLaunched()) continue;
                        value.setLaunched(true);
                    }
                }
            } else if (this.savedPos != null) {
                this.self.method_5783(ModSounds.BUBBLE_HOVERED_OVER_EVENT, 0.2f, (float)((double)0.95f + Math.random() * (double)0.1f));
                this.self.method_37908().method_8406((class_2394)ModParticles.POINTER_SOFT, this.savedPos.method_10216(), this.savedPos.method_10214() + 0.5, this.savedPos.method_10215(), 0.0, 0.0, 0.0);
            }
        }
        return true;
    }

    @Override
    public boolean hasShootingModeVisually() {
        return true;
    }

    public float getBubbleSpeed() {
        if (this.bubbleType == PlunderTypes.OXYGEN.id) {
            return 0.6f;
        }
        if (this.bubbleType == PlunderTypes.ITEM.id) {
            return 0.5f;
        }
        if (this.bubbleType == PlunderTypes.POTION_EFFECTS.id) {
            return 0.25f;
        }
        if (this.bubbleType == PlunderTypes.SOUND.id) {
            return 0.3f;
        }
        if (this.bubbleType == PlunderTypes.MOISTURE.id) {
            return 0.3f;
        }
        return 0.17f;
    }

    public float getExplosiveItemBubbleSpeed() {
        return 0.25f;
    }

    public void generateGroundBubble() {
        GroundBubbleEntity groundent = new GroundBubbleEntity(this.getSelf().method_37908(), this.self);
        groundent.bubbleNo = this.bubbleNumber;
        class_243 pos = MainUtil.getRaytracePointOnMobOrBlock((class_1297)this.self, 2.5f);
        groundent.method_33574(pos);
        groundent.setLifeSpan(120);
        float rando = (float)(Math.random() * (double)0.05f) - 0.025f;
        groundent.method_6125(groundent.method_6029() + rando);
        this.getSelf().method_37908().method_8649((class_1297)groundent);
    }

    public void shootBubble(SoftAndWetBubbleEntity ankh) {
        this.shootBubbleSpeed(ankh, 1.01f);
    }

    public void shootExplosiveBubbleSpeed(SoftAndWetBubbleEntity ankh, float speed) {
        ankh.setSped(speed);
        class_243 addToPosition = new class_243(0.0, (double)(this.self.method_5751() * 0.8f), 0.0);
        class_2350 direction = ((IGravityEntity)this.self).roundabout$getGravityDirection();
        if (direction != class_2350.field_11033) {
            addToPosition = RotationUtil.vecPlayerToWorld(addToPosition, direction);
        }
        class_243 pos = this.self.method_30950(1.0f).method_1031(addToPosition.field_1352, addToPosition.field_1351, addToPosition.field_1350).method_1019(this.self.method_5663().method_1021((double)(this.self.method_17681() * 1.0f)));
        ankh.method_5814(pos.method_10216(), pos.method_10214(), pos.method_10215());
        ankh.shootFromRotationDeltaAgnostic((class_1297)this.getSelf(), this.getSelf().method_36455(), this.getSelf().method_36454(), 1.0f, speed, 0.0f);
    }

    public void shootExplosiveItemBubbleSpeed(SoftAndWetBubbleEntity ankh, float speed) {
        ankh.setSped(speed);
        class_243 addToPosition = new class_243(0.0, (double)(this.self.method_5751() * 0.8f), 0.0);
        class_2350 direction = ((IGravityEntity)this.self).roundabout$getGravityDirection();
        if (direction != class_2350.field_11033) {
            addToPosition = RotationUtil.vecPlayerToWorld(addToPosition, direction);
        }
        class_243 pos = this.self.method_30950(1.0f).method_1031(addToPosition.field_1352, addToPosition.field_1351, addToPosition.field_1350).method_1019(this.self.method_5663().method_1021((double)(this.self.method_17681() * 1.0f)));
        ankh.method_5814(pos.method_10216(), pos.method_10214(), pos.method_10215());
        ankh.shootFromRotationDeltaAgnostic((class_1297)this.getSelf(), this.getSelf().method_36455(), this.getSelf().method_36454(), 1.0f, speed, 0.0f);
    }

    public void shootBubbleSpeed(SoftAndWetBubbleEntity ankh, float speed) {
        ankh.setSped(speed);
        class_243 addToPosition = new class_243(0.0, (double)this.self.method_5751() * 0.71, 0.0);
        class_2350 direction = ((IGravityEntity)this.self).roundabout$getGravityDirection();
        if (direction != class_2350.field_11033) {
            addToPosition = RotationUtil.vecPlayerToWorld(addToPosition, direction);
        }
        ankh.method_5814(this.self.method_23317() + addToPosition.field_1352, this.self.method_23318() + addToPosition.field_1351, this.self.method_23321() + addToPosition.field_1350);
        ankh.shootFromRotationDeltaAgnostic((class_1297)this.getSelf(), this.getSelf().method_36455(), this.getSelf().method_36454(), 1.0f, speed, 0.0f);
    }

    public void shootBubbleSpeed2(SoftAndWetBubbleEntity ankh, float speed) {
        ankh.shootFromRotationDeltaAgnostic3((class_1297)this.getSelf(), this.getSelf().method_36455(), this.getSelf().method_36454(), 1.0f, speed);
    }

    public void shootBubbleRandomly(SoftAndWetBubbleEntity ankh, float speed) {
        ankh.setSped(speed);
        class_243 addToPosition = new class_243(0.0, (double)this.self.method_5751() * 0.2, 0.0);
        class_2350 direction = ((IGravityEntity)this.self).roundabout$getGravityDirection();
        if (direction != class_2350.field_11033) {
            addToPosition = RotationUtil.vecPlayerToWorld(addToPosition, direction);
        }
        ankh.method_5814(this.self.method_23317() + addToPosition.field_1352, this.self.method_23318() + addToPosition.field_1351, this.self.method_23321() + addToPosition.field_1350);
        class_241 yavec = new class_241(-1.0f * (float)(Math.random() * 50.0), (float)(Math.random() * 360.0));
        if (direction != class_2350.field_11033) {
            yavec = RotationUtil.rotPlayerToWorld(yavec.field_1342, yavec.field_1343, direction);
        }
        ankh.shootFromRotationDeltaAgnosticR((class_1297)this.getSelf(), yavec.field_1343, yavec.field_1342, 1.0f, 0.25f, 0.0f);
    }

    public boolean setPowerBubbleBarrage() {
        this.attackTimeDuring = 0;
        this.setActivePower((byte)42);
        this.poseStand((byte)1);
        this.setAttackTimeMax(this.getBubbleBarrageRecoilTime());
        this.setActivePowerPhase(this.getActivePowerPhaseMax());
        this.animateStand((byte)12);
        return true;
    }

    @Override
    public boolean setPowerOther(int move, int lastMove) {
        if (move == 23) {
            return this.bubbleShot();
        }
        if (move == 35) {
            return this.itemBubbleShot();
        }
        if (move == 41) {
            return this.setPowerBubbleBarrageCharge();
        }
        if (move == 29) {
            return this.bubbleRedirect();
        }
        if (move == 24) {
            return this.bubblePop();
        }
        if (move == 42) {
            return this.setPowerBubbleBarrage();
        }
        if (move == 15) {
            return this.fallBraceInit();
        }
        if (move == 17) {
            return this.fallBrace();
        }
        if (move == 19) {
            return this.vault();
        }
        if (move == 27) {
            return this.switchModes();
        }
        if (move == 28) {
            return this.useWaterShield();
        }
        if (move == 33) {
            if (!this.self.method_37908().method_8608()) {
                this.setInExplosiveSpinMode(false);
            }
            return this.shootExplosiveBubble();
        }
        if (move == 37) {
            if (!this.self.method_37908().method_8608()) {
                this.setInExplosiveSpinMode(true);
            }
            return this.shootExplosiveBubble();
        }
        if (move == 25) {
            return this.bubbleLadder();
        }
        if (move == 31) {
            return this.bubbleLadderPlace();
        }
        if (move == 36) {
            return this.bigEncasementBubbleCreate();
        }
        if (move == 22) {
            return this.bubbleClusterStart();
        }
        if (move == 21) {
            return this.spawnRandomBubble();
        }
        if (move == 34) {
            return this.bubbleClusterRedirect();
        }
        if (move == 43) {
            return this.setPowerKickAttack();
        }
        if (move == 2) {
            return this.setPowerSuperHit();
        }
        if (move == 16) {
            return this.clusterBubblePop();
        }
        if (move == 11) {
            return this.goBeyond();
        }
        return super.setPowerOther(move, lastMove);
    }

    public boolean setPowerSuperHit() {
        this.attackTimeDuring = 0;
        this.setActivePower((byte)2);
        this.poseStand((byte)1);
        this.chargedFinal = Math.min(this.chargedFinal, maxSuperHitTime);
        if (this.chargedFinal >= maxSuperHitTime) {
            this.animateStand((byte)26);
        } else {
            this.animateStand((byte)25);
        }
        return true;
    }

    public boolean setPowerKickAttack() {
        this.attackTimeDuring = 0;
        this.setActivePower((byte)43);
        this.animateStand((byte)27);
        this.poseStand((byte)2);
        return true;
    }

    @Override
    public byte chooseBarrageSound() {
        byte skn = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (skn == 10) {
            return 0;
        }
        double rand = Math.random();
        if (rand > 0.5) {
            return 20;
        }
        return 21;
    }

    @Override
    public boolean tryIntPower(int move, boolean forced, int chargeTime) {
        if (move == 23 || move == 22) {
            this.bubbleType = (byte)chargeTime;
        } else if (move == 2) {
            this.chargedFinal = chargeTime;
        } else if (move == 11) {
            this.goBeyondActiveTarget = this.self.method_37908().method_8469(chargeTime);
        } else if (move == 35) {
            this.grabInventorySlot = chargeTime;
        }
        return super.tryIntPower(move, forced, chargeTime);
    }

    @Override
    public boolean cancelSprintJump() {
        if (this.getActivePower() == 22) {
            return true;
        }
        if (this.getActivePower() == 41 || this.getActivePower() == 42 || this.getActivePower() == 43) {
            return true;
        }
        return super.cancelSprintJump();
    }

    public void unlockSkin() {
        IPlayerEntity ipe;
        class_1657 PE;
        StandUser user;
        class_1799 stack;
        class_1937 lv = this.getSelf().method_37908();
        class_1309 class_13092 = this.getSelf();
        if (class_13092 instanceof class_1657 && !(stack = (user = (StandUser)(PE = (class_1657)class_13092)).roundabout$getStandDisc()).method_7960() && stack.method_31574(ModItems.STAND_DISC_SOFT_AND_WET) && !(ipe = (IPlayerEntity)PE).roundabout$getUnlockedBonusSkin() && !lv.method_8608()) {
            ipe.roundabout$setUnlockedBonusSkin(true);
            lv.method_43128(null, PE.method_23317(), PE.method_23318(), PE.method_23321(), ModSounds.UNLOCK_SKIN_EVENT, PE.method_5634(), 2.0f, 1.0f);
            ((class_3218)lv).method_14199((class_2394)ModParticles.HEART_ATTACK_MINI, PE.method_23317(), PE.method_23318() + (double)PE.method_5751(), PE.method_23321(), 10, 0.5, 0.5, 0.5, 0.2);
            user.roundabout$setStandSkin((byte)10);
            user.roundabout$summonStand(this.getSelf().method_37908(), true, false);
            ((class_3222)ipe).method_7353((class_2561)class_2561.method_43471((String)"unlock_skin.roundabout.soft_and_wet.kira"), true);
        }
    }

    public void playBubbleBarrageChargeSound() {
        class_3414 barrageChargeSound;
        if (!this.self.method_37908().method_8608() && (barrageChargeSound = this.getBarrageChargeSound()) != null) {
            this.playSoundsIfNearby((byte)2, 27.0, false);
        }
    }

    public boolean setPowerBubbleBarrageCharge() {
        this.animateStand((byte)11);
        this.attackTimeDuring = 0;
        this.setActivePower((byte)41);
        this.poseStand((byte)1);
        this.playBubbleBarrageChargeSound();
        return true;
    }

    @Override
    public float inputSpeedModifiers(float basis) {
        if (this.activePower == 41) {
            basis *= 0.5f;
        } else if (this.activePower == 22) {
            basis *= 0.2f;
        } else if (this.activePower == 43) {
            if (this.getSelf().method_18276()) {
                float f = class_3532.method_15363((float)(0.3f + class_1890.method_42304((class_1309)this.getSelf())), (float)0.0f, (float)1.0f);
                float g = 1.0f / f;
                basis *= g;
            }
            basis *= 0.6f;
        }
        return super.inputSpeedModifiers(basis);
    }

    public boolean bubbleClusterStart() {
        if (!this.self.method_37908().method_8608()) {
            this.clusterBubblePop();
        }
        this.setActivePower((byte)22);
        this.poseStand((byte)0);
        this.attackTimeDuring = 0;
        this.animateStand((byte)0);
        return true;
    }

    @Override
    public int getMaxGuardPoints() {
        return ClientNetworking.getAppropriateConfig().softAndWetSettings.softAndWetGuardPoints;
    }

    @Override
    public boolean tryBlockPosPower(int move, boolean forced, class_2338 blockPos) {
        return this.tryPower(move, forced);
    }

    @Override
    public boolean tryPosPower(int move, boolean forced, class_243 pos) {
        this.savedPos = pos;
        return this.tryPower(move, forced);
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        if (!(this.self.method_37908().field_9236 || this.getActivePower() != 41 && this.getActivePower() != 42 || move == 42 || move == 41 || move == 3)) {
            this.stopSoundsIfNearby((byte)100, 100.0, false);
        }
        return super.tryPower(move, forced);
    }

    public boolean bigEncasementBubbleCreate() {
        EncasementBubbleEntity encasement;
        this.setCooldown((byte)8, ClientNetworking.getAppropriateConfig().softAndWetSettings.encasementBubbleCreateCooldown);
        if (!this.self.method_37908().method_8608() && (encasement = (EncasementBubbleEntity)ModEntities.ENCASEMENT_BUBBLE.method_5883(this.getSelf().method_37908())) != null) {
            encasement.bubbleNo = this.bubbleNumber;
            class_243 cvec = new class_243(0.0, (double)(this.self.method_5751() * 0.65f), 0.0);
            class_2350 gravD = ((IGravityEntity)this.self).roundabout$getGravityDirection();
            if (gravD != class_2350.field_11033) {
                cvec = RotationUtil.vecPlayerToWorld(cvec, gravD);
            }
            class_243 movevec = this.self.method_30950(1.0f).method_1031(cvec.field_1352, cvec.field_1351, cvec.field_1350).method_1019(this.self.method_5663().method_1021((double)this.self.method_17681() * 2.5));
            encasement.method_30634(movevec.method_10216(), movevec.method_10214(), movevec.method_10215());
            encasement.setUser(this.self);
            encasement.lifeSpan = 200;
            this.getSelf().method_37908().method_8649((class_1297)encasement);
            this.addEXP(1);
            this.self.method_37908().method_8396(null, this.self.method_24515(), ModSounds.BIG_BUBBLE_CREATE_EVENT, class_3419.field_15248, 2.0f, (float)(0.98 + Math.random() * 0.04));
        }
        return false;
    }

    @Override
    public void levelUp() {
        class_1309 class_13092;
        if (!this.getSelf().method_37908().method_8608() && (class_13092 = this.getSelf()) instanceof class_1657) {
            class_1657 PE = (class_1657)class_13092;
            IPlayerEntity ipe = (IPlayerEntity)PE;
            byte level = ipe.roundabout$getStandLevel();
            if (level == 7) {
                ((class_3222)this.self).method_7353((class_2561)class_2561.method_43471((String)"leveling.roundabout.levelup.max.both").method_27692(class_124.field_1075), true);
            } else {
                ((class_3222)this.self).method_7353((class_2561)class_2561.method_43471((String)"leveling.roundabout.levelup.both").method_27692(class_124.field_1075), true);
            }
        }
        super.levelUp();
    }

    @Override
    public void updateMovesFromPacket(byte activePower) {
        if (activePower == 42) {
            Objects.requireNonNull(this);
            this.setActivePowerPhase((byte)3);
        }
        super.updateMovesFromPacket(activePower);
    }

    public boolean bubbleLadderPlace() {
        if (!this.self.method_37908().method_8608()) {
            class_241 adjustedDir = new class_241(this.self.method_5791(), this.self.method_36455());
            class_2350 gravdir = ((IGravityEntity)this.self).roundabout$getGravityDirection();
            if (gravdir != class_2350.field_11033) {
                adjustedDir = RotationUtil.rotPlayerToWorld(adjustedDir, gravdir);
            }
            this.buildingBubbleScaffoldPos = adjustedDir.field_1342 > 35.0f ? this.buildingBubbleScaffoldPos.method_10074() : (adjustedDir.field_1342 < -35.0f ? this.buildingBubbleScaffoldPos.method_10084() : this.buildingBubbleScaffoldPos.method_10093(class_2350.method_10150((double)adjustedDir.field_1343)));
            if (MainUtil.tryPlaceBlock((class_1297)this.self, this.buildingBubbleScaffoldPos, false)) {
                boolean heartAttackState = ((StandUser)this.getSelf()).roundabout$getStandSkin() == 10;
                this.self.method_37908().method_8501(this.buildingBubbleScaffoldPos, (class_2680)ModBlocks.BUBBLE_SCAFFOLD.method_9564().method_11657((class_2769)class_2741.field_12522, (Comparable)Boolean.valueOf(heartAttackState)));
                class_2586 class_25862 = this.self.method_37908().method_8321(this.buildingBubbleScaffoldPos);
                if (class_25862 instanceof BubbleScaffoldBlockEntity) {
                    BubbleScaffoldBlockEntity SBE = (BubbleScaffoldBlockEntity)class_25862;
                    SBE.standuser = this.self;
                    SBE.bubbleNo = this.bubbleNumber;
                    this.self.method_37908().method_8396(null, this.self.method_24515(), ModSounds.BUBBLE_CREATE_EVENT, class_3419.field_15248, 2.0f, (float)(0.9 + Math.random() * 0.2));
                    this.self.method_37908().method_8396(null, this.self.method_24515(), ModSounds.BUBBLE_CREATE_EVENT, class_3419.field_15248, 2.0f, (float)(0.9 + Math.random() * 0.2));
                    this.self.method_37908().method_8396(null, this.self.method_24515(), ModSounds.BUBBLE_CREATE_EVENT, class_3419.field_15248, 2.0f, (float)(0.9 + Math.random() * 0.2));
                    this.self.method_37908().method_8396(null, this.self.method_24515(), ModSounds.BUBBLE_CREATE_EVENT, class_3419.field_15248, 2.0f, (float)(0.9 + Math.random() * 0.2));
                }
            }
        }
        return false;
    }

    public boolean bubbleLadder() {
        this.setActivePower((byte)25);
        this.poseStand((byte)9);
        this.addEXP(1);
        this.attackTimeDuring = 0;
        this.bubbleScaffoldCount = 0;
        this.animateStand((byte)1);
        this.buildingBubbleScaffoldPos = this.self.method_24515();
        if (this.self.method_37908().method_8320(this.self.method_24515()).method_51367()) {
            class_2350 gravdir = ((IGravityEntity)this.self).roundabout$getGravityDirection();
            this.buildingBubbleScaffoldPos = this.buildingBubbleScaffoldPos.method_10093(gravdir.method_10153());
        }
        return true;
    }

    @Override
    public void updateUniqueMoves() {
        if (this.getActivePower() == 22) {
            this.updateBubbleCluster();
        } else if (this.getActivePower() == 42) {
            this.updateBubbleBarrage();
        } else if (this.getActivePower() == 41) {
            this.updateBubbleBarrageCharge();
        } else if (this.getActivePower() == 43) {
            this.updateKickAttackCharge();
        } else if (this.getActivePower() == 2) {
            this.updateKickAttack();
        } else if (this.getActivePower() == 25) {
            this.updateBubbleScaffold();
        }
        super.updateUniqueMoves();
    }

    public void updateBubbleBarrageCharge() {
        if (this.attackTimeDuring >= this.getBubbleBarrageWindup()) {
            ((StandUser)this.self).roundabout$tryPower(42, true);
        }
    }

    public void updateKickAttack() {
        if (this.attackTimeDuring > -1 && this.attackTimeDuring == 5) {
            this.encasementKick();
        }
    }

    @Override
    public float getBarrageDamagePlayer() {
        return 8.0f;
    }

    @Override
    public float getBarrageDamageMob() {
        return 18.0f;
    }

    @Override
    public float getBarrageHitStrength(class_1297 entity) {
        float str = super.getBarrageHitStrength(entity);
        if (str > 0.005f) {
            str = this.getReducedDamage(entity) ? (str *= this.levelupDamageMod((float)((double)ClientNetworking.getAppropriateConfig().softAndWetSettings.softAndWetAttackMultOnPlayers.intValue() * 0.01))) : (str *= this.levelupDamageMod((float)((double)ClientNetworking.getAppropriateConfig().softAndWetSettings.softAndWetAttackMultOnMobs.intValue() * 0.01)));
        }
        if (entity instanceof class_1309 && str >= ((class_1309)entity).method_6032() && ClientNetworking.getAppropriateConfig().generalStandSettings.barragesOnlyKillOnLastHit.booleanValue()) {
            str = entity instanceof class_1657 ? 1.0E-5f : 0.0f;
        }
        return str;
    }

    @Override
    public float multiplyPowerByStandConfigPlayers(float power) {
        return (float)((double)power * ((double)ClientNetworking.getAppropriateConfig().softAndWetSettings.softAndWetAttackMultOnPlayers.intValue() * 0.01));
    }

    @Override
    public float multiplyPowerByStandConfigMobs(float power) {
        return (float)((double)power * ((double)ClientNetworking.getAppropriateConfig().softAndWetSettings.softAndWetAttackMultOnMobs.intValue() * 0.01));
    }

    public float multiplyPowerByStandConfigShooting(float power) {
        return (float)((double)power * ((double)ClientNetworking.getAppropriateConfig().softAndWetSettings.softAndWetShootingModePower.intValue() * 0.01));
    }

    public float multiplyPowerByStandConfigGoBeyond(float power) {
        return (float)((double)power * ((double)ClientNetworking.getAppropriateConfig().softAndWetSettings.softAndWetGoBeyondPower.intValue() * 0.01));
    }

    @Override
    public float getPunchStrength(class_1297 entity) {
        if (this.getReducedDamage(entity)) {
            return this.levelupDamageMod(this.multiplyPowerByStandConfigPlayers(1.45f));
        }
        return this.levelupDamageMod(this.multiplyPowerByStandConfigMobs(4.0f));
    }

    @Override
    public float getHeavyPunchStrength(class_1297 entity) {
        if (this.getReducedDamage(entity)) {
            return this.levelupDamageMod(this.multiplyPowerByStandConfigPlayers(2.15f));
        }
        return this.levelupDamageMod(this.multiplyPowerByStandConfigMobs(5.0f));
    }

    public float getExplosiveBubbleStrength(class_1297 entity) {
        if (this.getReducedDamage(entity)) {
            return this.levelupDamageMod(this.multiplyPowerByStandConfigShooting(this.multiplyPowerByStandConfigPlayers(1.5f)));
        }
        return this.levelupDamageMod(this.multiplyPowerByStandConfigShooting(this.multiplyPowerByStandConfigMobs(3.0f)));
    }

    public float getGoBeyondStrength(class_1297 entity) {
        if (this.getReducedDamage(entity)) {
            return this.levelupDamageMod(this.multiplyPowerByStandConfigGoBeyond(this.multiplyPowerByStandConfigPlayers(11.0f)));
        }
        return this.levelupDamageMod(this.multiplyPowerByStandConfigGoBeyond(this.multiplyPowerByStandConfigMobs(40.0f)));
    }

    public float getKickAttackKnockback() {
        return (float)this.chargedFinal / (float)maxSuperHitTime * 2.2f;
    }

    public float getKickAttackStrength(class_1297 entity) {
        float punchD = this.getPunchStrength(entity) * 1.8f + this.getHeavyPunchStrength(entity);
        if (this.chargedFinal >= maxSuperHitTime) {
            punchD *= 0.5f;
        }
        if (this.getReducedDamage(entity)) {
            return (float)this.chargedFinal / (float)maxSuperHitTime * punchD;
        }
        return (float)this.chargedFinal / (float)maxSuperHitTime * punchD + 1.0f;
    }

    public void kickAttackImpact(class_1297 entity) {
        class_3414 SE;
        this.setAttackTimeDuring(-20);
        if (entity != null) {
            StandUser SE2;
            class_1657 PE;
            class_1309 LE;
            float pow = this.getKickAttackStrength(entity);
            float knockbackStrength = this.getKickAttackKnockback();
            if (this.StandDamageEntityAttack(entity, pow, 0.0f, (class_1297)this.self)) {
                if (entity instanceof class_1309) {
                    LE = (class_1309)entity;
                    if (this.chargedFinal >= maxSuperHitTime) {
                        this.addEXP(5, LE);
                    } else {
                        this.addEXP(1, LE);
                    }
                }
                this.takeDeterminedKnockbackWithY(this.self, entity, knockbackStrength);
            } else if (this.chargedFinal >= maxSuperHitTime) {
                this.knockShield2(entity, this.getKickAttackKnockShieldTime());
            }
            if (!(!(entity instanceof class_1309) || (LE = (class_1309)entity) instanceof class_1657 && (PE = (class_1657)LE).method_7337() || this.chargedFinal < maxSuperHitTime || (SE2 = (StandUser)LE).roundabout$isLaunchBubbleEncased())) {
                float xRot = this.self.method_36455();
                SE2.roundabout$setStoredVelocity(this.self.method_5663().method_1029().method_1021(0.13).method_1031(0.0, (double)0.033f, 0.0));
                if (LE.method_5805()) {
                    SE2.roundabout$setBubbleLaunchEncased();
                }
                if (!this.self.method_37908().method_8608()) {
                    class_243 $$2 = LE.method_18798();
                    float $$4 = class_3532.method_15357((double)LE.method_23318());
                    int $$8 = 0;
                    while ((float)$$8 < 1.0f + LE.method_17681() * 20.0f) {
                        double $$9 = (LE.method_37908().field_9229.method_43058() * 2.0 - 1.0) * (double)LE.method_17681();
                        double $$10 = (LE.method_37908().field_9229.method_43058() * 2.0 - 1.0) * (double)LE.method_17681();
                        class_243 vec3 = new class_243($$9, 1.0, $$10);
                        class_2350 direction = ((IGravityEntity)this.self).roundabout$getGravityDirection();
                        if (direction != class_2350.field_11033) {
                            vec3 = RotationUtil.vecPlayerToWorld(vec3, direction);
                        }
                        ((class_3218)this.getSelf().method_37908()).method_14199((class_2394)class_2398.field_11202, LE.method_23317() + vec3.field_1352, (double)$$4 + vec3.field_1351, LE.method_23321() + vec3.field_1350, 30, $$2.field_1352, $$2.field_1351, $$2.field_1350, 0.4);
                        ++$$8;
                    }
                }
                if (SE2 instanceof class_1657 && !this.self.method_37908().field_9236) {
                    ((class_3222)SE2).method_7353((class_2561)class_2561.method_43471((String)"text.roundabout.launch_bubble_encased"), true);
                }
                class_243 storedVec = SE2.roundabout$getStoredVelocity();
                MainUtil.takeLiteralUnresistableKnockbackWithY((class_1297)LE, storedVec.field_1352, storedVec.field_1351, storedVec.field_1350);
            }
            int fireCount = 50;
            float firespeed = 0.05f;
            if (this.chargedFinal >= maxSuperHitTime) {
                fireCount = 100;
                firespeed = 0.1f;
            }
        } else {
            float distMax = this.getDistanceOut(this.self, this.getReach(), false);
            float halfReach = (float)((double)distMax * 0.5);
            class_243 pointVec = DamageHandler.getRayPoint(this.self, halfReach);
            if (!this.self.method_37908().field_9236) {
                ((class_3218)this.self.method_37908()).method_14199((class_2394)class_2398.field_11236, pointVec.field_1352, pointVec.field_1351, pointVec.field_1350, 1, 0.0, 0.0, 0.0, 1.0);
            }
        }
        float pitch = 1.0f;
        if (entity != null) {
            SE = this.getKickAttackSound();
            pitch = 1.2f;
        } else {
            SE = ModSounds.PUNCH_2_SOUND_EVENT;
        }
        if (!this.self.method_37908().method_8608()) {
            this.self.method_37908().method_8396(null, this.self.method_24515(), SE, class_3419.field_15248, 0.95f, pitch);
            if (this.chargedFinal >= maxSuperHitTime && entity instanceof class_1309) {
                this.self.method_37908().method_8396(null, this.self.method_24515(), ModSounds.WATER_ENCASE_EVENT, class_3419.field_15248, 1.0f, pitch);
            }
        }
    }

    @Override
    public void handleStandAttack(class_1657 player, class_1297 target) {
        if (this.getActivePower() == 2) {
            this.kickAttackImpact(target);
        }
    }

    public class_3414 getKickAttackSound() {
        return ModSounds.SOFT_AND_WET_KICK_EVENT;
    }

    public int getKickAttackKnockShieldTime() {
        return 40;
    }

    public void encasementKick() {
        if (this.chargedFinal >= maxSuperHitTime) {
            this.setAttackTimeMax((int)((double)ClientNetworking.getAppropriateConfig().softAndWetSettings.kickMinimumCooldown.intValue() + (double)this.chargedFinal * 1.5));
        } else {
            this.setAttackTimeMax(ClientNetworking.getAppropriateConfig().softAndWetSettings.kickMinimumCooldown + this.chargedFinal);
        }
        this.setAttackTime(0);
        this.setActivePowerPhase(this.getActivePowerPhaseMax());
        if (this.self instanceof class_1657) {
            if (this.isPacketPlayer()) {
                this.attackTimeDuring = -10;
                C2SPacketUtil.intToServerPacket((byte)4, this.getTargetEntityId());
            }
        } else {
            class_1297 targetEntity = this.getTargetEntity(this.self, -1.0f);
            this.kickAttackImpact(targetEntity);
        }
    }

    public void updateKickAttackCharge() {
        if (this.attackTimeDuring > -1 && this.attackTimeDuring >= maxSuperHitTime && (!(this.getSelf() instanceof class_1657) || this.self.method_37908().method_8608() && this.isPacketPlayer())) {
            int atd = this.getAttackTimeDuring();
            ((StandUser)this.getSelf()).roundabout$tryIntPower(2, true, maxSuperHitTime);
            if (this.self.method_37908().method_8608()) {
                this.tryIntPowerPacket((byte)2, atd);
            }
        }
    }

    public void updateBubbleScaffold() {
        class_1309 class_13092 = this.self;
        if (class_13092 instanceof class_1657) {
            class_1657 PE = (class_1657)class_13092;
            if (this.self.method_37908().method_8608() && this.isPacketPlayer() && this.attackTimeDuring % 6 == 2) {
                this.tryPowerPacket((byte)31);
                ++this.bubbleScaffoldCount;
                this.setCooldown((byte)2, ClientNetworking.getAppropriateConfig().softAndWetSettings.bubbleScaffoldingCooldown);
                if (this.bubbleScaffoldCount >= 10) {
                    this.tryPower(0, true);
                    this.tryPowerPacket((byte)0);
                }
            }
        }
    }

    public void updateBubbleCluster() {
        if (this.self instanceof class_1657) {
            if (this.isPacketPlayer()) {
                this.bubbleCheck(true);
            }
        } else {
            this.bubbleCheck(false);
        }
    }

    public void bubbleCheck(boolean packetPlayer) {
        if (this.attackTimeDuring > -1) {
            if (this.attackTimeDuring > 37) {
                this.tryPower(0, true);
                if (packetPlayer) {
                    this.tryPowerPacket((byte)0);
                }
            } else if (this.attackTimeDuring % 3 == 0) {
                if (packetPlayer) {
                    this.tryPowerPacket((byte)21);
                } else {
                    this.spawnRandomBubble();
                }
            }
        }
    }

    public boolean spawnRandomBubble() {
        SoftAndWetPlunderBubbleEntity bubble = this.getPlunderBubble();
        if (bubble != null) {
            bubble.setPlunderType(this.bubbleType);
            bubble.setSingular(false);
            this.shootBubbleRandomly(bubble, this.getBubbleSpeed());
            this.bubbleListInit();
            this.bubbleList.add(bubble);
            this.getSelf().method_37908().method_8649((class_1297)bubble);
            if (this.bubbleType != PlunderTypes.SOUND.id) {
                this.self.method_37908().method_8396(null, this.self.method_24515(), ModSounds.BUBBLE_CREATE_EVENT, class_3419.field_15248, 2.0f, (float)(0.98 + Math.random() * 0.04));
            }
        }
        return true;
    }

    public void unloadBubbles() {
        this.bubbleListInit();
        ArrayList<SoftAndWetBubbleEntity> bubbleList2 = new ArrayList<SoftAndWetBubbleEntity>(this.bubbleList){};
        if (!bubbleList2.isEmpty()) {
            for (SoftAndWetBubbleEntity value : bubbleList2) {
                if (!value.method_31481() && value.method_5805() && (!this.self.method_37908().method_8608() || this.self.method_37908().method_8469(value.method_5628()) != null)) continue;
                this.bubbleList.remove(value);
            }
        }
    }

    public int getLowerTicks() {
        return ClientNetworking.getAppropriateConfig().softAndWetSettings.heatTickDownRate;
    }

    public int getLowerGoBeyondTicks() {
        return ClientNetworking.getAppropriateConfig().softAndWetSettings.explosiveSpinMeterTickDownRate;
    }

    public int getLowerExplosiveSpinTicks() {
        return ClientNetworking.getAppropriateConfig().softAndWetSettings.explosiveSpinModeTickDownRate;
    }

    @Override
    public void tickPower() {
        class_1657 PE;
        IPlayerEntity ipe;
        int pt;
        class_1309 class_13092;
        this.unloadBubbles();
        this.tickWaterShield();
        if (this.self.method_37908().method_8608() && (class_13092 = this.self) instanceof class_1657 && (pt = (ipe = (IPlayerEntity)(PE = (class_1657)class_13092)).roundabout$getBubbleShotAimPoints()) > 0) {
            ipe.roundabout$setBubbleShotAimPoints(--pt);
        }
        if ((class_13092 = this.self) instanceof class_1657 && (PE = (class_1657)class_13092).method_7337()) {
            this.setShootTicks(0);
        } else if (this.getPauseGrowthTicks() > 0) {
            --this.pauseGrowthTicks;
        } else if (this.getShootTicks() > 0) {
            this.setShootTicks(this.getShootTicks() - this.getLowerTicks());
        }
        class_13092 = this.self;
        if (class_13092 instanceof class_1657 && (PE = (class_1657)class_13092).method_7337()) {
            if (this.getGoBeyondCharge() > 0) {
                this.setGoBeyondChargeTicks(0);
            }
        } else if (this.getGoBeyondCharge() > 0) {
            if (this.getInExplosiveSpinMode()) {
                this.setGoBeyondChargeTicks(this.getGoBeyondCharge() - this.getLowerExplosiveSpinTicks());
            } else {
                this.setGoBeyondChargeTicks(this.getGoBeyondCharge() - this.getLowerGoBeyondTicks());
            }
        }
        super.tickPower();
    }

    public class_243 BubbleRandomPos() {
        float r1 = (float)(Math.random() * 1.0 - 0.5);
        float r2 = (float)(Math.random() * 0.4 - (double)0.2f);
        float r3 = (float)(Math.random() * 1.0 - 0.5);
        return this.self.method_33571().method_1031((double)r1, (double)r2, (double)r3);
    }

    @Override
    public boolean dealWithProjectile(class_1297 ent, class_239 res) {
        if (!ent.method_37908().method_8608() && this.hasWaterShield()) {
            SoftAndWetItemLaunchingBubbleEntity bubble;
            class_1686 TP;
            class_1799 ii;
            boolean success = false;
            if (ent instanceof class_1665) {
                SoftAndWetItemLaunchingBubbleEntity bubble2;
                class_1665 AA = (class_1665)ent;
                class_1799 ii2 = ((IAbstractArrowAccess)ent).roundabout$GetPickupItem();
                if (!ii2.method_7960() && !ii2.method_7963() && (bubble2 = this.getItemLaunchingBubble()) != null) {
                    success = true;
                    if (!AA.field_7572.equals((Object)class_1665.class_1666.field_7593)) {
                        bubble2.canGiveYouItem = false;
                    }
                    bubble2.setHeldItem(ii2.method_51164());
                    bubble2.method_33574(this.BubbleRandomPos());
                    this.bubbleListInit();
                    this.bubbleList.add(bubble2);
                    this.getSelf().method_37908().method_8649((class_1297)bubble2);
                }
            } else if (ent instanceof ThrownObjectEntity) {
                SoftAndWetItemLaunchingBubbleEntity bubble3;
                ThrownObjectEntity TO = (ThrownObjectEntity)ent;
                class_1799 ii3 = TO.method_7495();
                if (!ii3.method_7960() && (bubble3 = this.getItemLaunchingBubble()) != null) {
                    success = true;
                    if (!TO.places) {
                        bubble3.canGiveYouItem = false;
                    }
                    bubble3.setHeldItem(ii3.method_51164());
                    bubble3.method_33574(this.BubbleRandomPos());
                    this.bubbleListInit();
                    this.bubbleList.add(bubble3);
                    this.getSelf().method_37908().method_8649((class_1297)bubble3);
                }
            } else if (ent instanceof class_1686 && !(ii = (TP = (class_1686)ent).method_7495()).method_7960() && (bubble = this.getItemLaunchingBubble()) != null) {
                success = true;
                if (TP.method_24921() != null && !(TP.method_24921() instanceof class_1657)) {
                    bubble.canGiveYouItem = false;
                }
                bubble.setHeldItem(ii.method_51164());
                bubble.method_33574(this.BubbleRandomPos());
                this.bubbleListInit();
                this.bubbleList.add(bubble);
                this.getSelf().method_37908().method_8649((class_1297)bubble);
            }
            if (success) {
                this.getSelf().method_37908().method_8396(null, this.getSelf().method_24515(), ModSounds.BUBBLE_PLUNDER_EVENT, class_3419.field_15248, 1.7f, 1.8f);
                return true;
            }
        }
        return false;
    }

    public boolean waterShieldBlockProjectile(class_1676 projectile) {
        return true;
    }

    public boolean canDoBubbleItemLaunch() {
        class_1799 stack = this.getSelf().method_6047();
        return !stack.method_7960();
    }

    @Override
    public void playFallBraceImpactParticles() {
        ((class_3218)this.getSelf().method_37908()).method_14199((class_2394)ModParticles.BUBBLE_POP, this.getSelf().method_23317(), (double)this.getSelf().method_23312().method_10264() + 1.1, this.getSelf().method_23321(), 50, 1.1, 0.05, 1.1, 0.4);
        ((class_3218)this.getSelf().method_37908()).method_14199((class_2394)ModParticles.BUBBLE_POP, this.getSelf().method_23317(), (double)this.getSelf().method_23312().method_10264() + 1.1, this.getSelf().method_23321(), 30, 1.0, 0.05, 1.0, 0.4);
    }

    @Override
    public void playFallBraceInitSound() {
        this.getSelf().method_37908().method_8396(null, this.getSelf().method_24515(), ModSounds.SUMMON_SOFT_AND_WET_EVENT, class_3419.field_15248, 2.3f, (float)(0.78 + Math.random() * 0.04));
    }

    @Override
    public void playFallBraceImpactSounds() {
        this.getSelf().method_37908().method_8396(null, this.getSelf().method_24515(), ModSounds.BUBBLE_POP_EVENT, class_3419.field_15248, 1.0f, (float)(0.9 + Math.random() * 0.2));
        this.getSelf().method_37908().method_8396(null, this.getSelf().method_24515(), ModSounds.BUBBLE_POP_EVENT, class_3419.field_15248, 1.0f, (float)(0.9 + Math.random() * 0.2));
        this.getSelf().method_37908().method_8396(null, this.getSelf().method_24515(), ModSounds.BUBBLE_POP_EVENT, class_3419.field_15248, 1.0f, (float)(0.9 + Math.random() * 0.2));
        this.getSelf().method_37908().method_8396(null, this.getSelf().method_24515(), ModSounds.BUBBLE_POP_EVENT, class_3419.field_15248, 1.0f, (float)(0.9 + Math.random() * 0.2));
        this.getSelf().method_37908().method_8396(null, this.getSelf().method_24515(), ModSounds.BUBBLE_POP_EVENT, class_3419.field_15248, 1.0f, (float)(0.9 + Math.random() * 0.2));
        this.getSelf().method_37908().method_8396(null, this.getSelf().method_24515(), ModSounds.BUBBLE_POP_EVENT, class_3419.field_15248, 1.0f, (float)(0.9 + Math.random() * 0.2));
        this.getSelf().method_37908().method_8396(null, this.getSelf().method_24515(), ModSounds.BUBBLE_POP_EVENT, class_3419.field_15248, 1.0f, (float)(0.9 + Math.random() * 0.2));
    }

    public boolean canBridge() {
        class_1657 PE;
        class_1309 class_13092;
        return this.self.method_24828() && !this.self.method_5799() || this.self.method_6101() || (class_13092 = this.self) instanceof class_1657 && (PE = (class_1657)class_13092).method_7337();
    }

    public boolean canBigBubble() {
        class_1657 PE;
        class_1309 class_13092;
        return this.self.method_24828() || this.self.method_5799() || this.self.method_6101() || (class_13092 = this.self) instanceof class_1657 && (PE = (class_1657)class_13092).method_7337();
    }

    @Override
    public class_2561 getSkinName(byte skinId) {
        return switch (skinId) {
            case 1 -> class_2561.method_43471((String)"skins.roundabout.soft_and_wet.base");
            case 4 -> class_2561.method_43471((String)"skins.roundabout.soft_and_wet.beta");
            case 3 -> class_2561.method_43471((String)"skins.roundabout.soft_and_wet.king");
            case 5 -> class_2561.method_43471((String)"skins.roundabout.soft_and_wet.drowned");
            case 6 -> class_2561.method_43471((String)"skins.roundabout.soft_and_wet.drowned_2");
            case 7 -> class_2561.method_43471((String)"skins.roundabout.soft_and_wet.figure");
            case 8 -> class_2561.method_43471((String)"skins.roundabout.soft_and_wet.striped");
            case 9 -> class_2561.method_43471((String)"skins.roundabout.soft_and_wet.debut");
            case 11 -> class_2561.method_43471((String)"skins.roundabout.soft_and_wet.colors");
            case 10 -> class_2561.method_43471((String)"skins.roundabout.soft_and_wet.kira");
            case 12 -> class_2561.method_43471((String)"skins.roundabout.soft_and_wet.green");
            case 13 -> class_2561.method_43471((String)"skins.roundabout.soft_and_wet.knight");
            default -> class_2561.method_43471((String)"skins.roundabout.soft_and_wet.light");
        };
    }
}

