/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.event.powers.visagedata.voicedata;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.hydra.jojomod.event.powers.VoiceLine;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3414;
import net.minecraft.class_4051;

public class VoiceData {
    public final class_1309 self;
    public int talkingTicks = -1;
    public int idleCooldown = -1;
    public int killCooldown = -1;
    public int hurtCooldown = -1;
    public int attackCooldown = -1;
    public int summonCooldown = -1;
    public int challengeCooldown = -1;
    public int challengeNumber = -1;
    public List<VoiceLine> tickLines = new ArrayList<VoiceLine>();
    public List<VoiceLine> hurtLines = new ArrayList<VoiceLine>();
    public List<VoiceLine> deathLines = new ArrayList<VoiceLine>();
    public List<VoiceLine> killLines = new ArrayList<VoiceLine>();
    public List<VoiceLine> attackLines = new ArrayList<VoiceLine>();
    public List<VoiceLine> summonLines = new ArrayList<VoiceLine>();
    public static final class_4051 roundabout$attackTargeting = class_4051.method_36626().method_18418(64.0);

    public VoiceData(class_1309 self) {
        this.self = self;
    }

    public boolean inTheMiddleOfTalking() {
        return this.talkingTicks > -1;
    }

    public void safeInit() {
        if (this.tickLines == null) {
            this.tickLines = new ArrayList<VoiceLine>();
        }
        if (this.hurtLines == null) {
            this.hurtLines = new ArrayList<VoiceLine>();
        }
        if (this.deathLines == null) {
            this.deathLines = new ArrayList<VoiceLine>();
        }
        if (this.killLines == null) {
            this.killLines = new ArrayList<VoiceLine>();
        }
        if (this.attackLines == null) {
            this.attackLines = new ArrayList<VoiceLine>();
        }
        if (this.summonLines == null) {
            this.summonLines = new ArrayList<VoiceLine>();
        }
    }

    public void addVoiceLine(VoiceLine vl) {
        this.safeInit();
        switch (vl.soundCategory) {
            case IDLE: {
                this.tickLines.add(vl);
                break;
            }
            case HURT: {
                this.hurtLines.add(vl);
                break;
            }
            case DEATH: {
                this.deathLines.add(vl);
                break;
            }
            case KILL: {
                this.killLines.add(vl);
                break;
            }
            case ATTACK: {
                this.attackLines.add(vl);
                break;
            }
            case SUMMON: {
                this.summonLines.add(vl);
            }
        }
    }

    public void forceTalkingTicks(int ticksLasting) {
        this.talkingTicks = ticksLasting;
    }

    public void playSoundIfPossible(class_3414 se, int ticksLasting, float pitch, float volume) {
        if (!this.inTheMiddleOfTalking()) {
            this.talkingTicks = ticksLasting;
            this.self.method_37908().method_43129(null, (class_1297)this.self, se, this.self.method_5634(), volume, pitch);
        }
    }

    public void playSound(class_3414 se, int ticksLasting) {
        this.talkingTicks = ticksLasting;
        this.idleCooldown = ticksLasting + 6000;
        this.self.method_37908().method_43129(null, (class_1297)this.self, se, this.self.method_5634(), 2.0f, 1.0f);
    }

    public void playSound2(class_3414 se, int ticksLasting) {
        this.talkingTicks = ticksLasting;
        this.self.method_37908().method_43128(null, this.self.method_23317(), this.self.method_23318(), this.self.method_23321(), se, this.self.method_5634(), 2.0f, 1.0f);
    }

    public void playSoundKill(class_3414 se, int ticksLasting) {
        this.talkingTicks = ticksLasting;
        this.killCooldown = ticksLasting + 600;
        this.self.method_37908().method_43129(null, (class_1297)this.self, se, this.self.method_5634(), 2.0f, 1.0f);
    }

    public void playSoundSummon(class_3414 se, int ticksLasting) {
        this.talkingTicks = ticksLasting;
        this.summonCooldown = ticksLasting + 200;
        this.self.method_37908().method_43129(null, (class_1297)this.self, se, this.self.method_5634(), 2.0f, 1.0f);
    }

    public void playSoundAttack(class_3414 se, int ticksLasting) {
        this.talkingTicks = ticksLasting;
        this.attackCooldown = ticksLasting + 600;
        this.self.method_37908().method_43129(null, (class_1297)this.self, se, this.self.method_5634(), 2.0f, 1.0f);
    }

    public void playSoundHurt(class_3414 se, int ticksLasting) {
        this.talkingTicks = ticksLasting;
        this.hurtCooldown = ticksLasting + 100;
        this.self.method_37908().method_43129(null, (class_1297)this.self, se, this.self.method_5634(), 2.0f, 1.0f);
    }

    public void playSoundChallenge(class_3414 se, int ticksLasting) {
        this.talkingTicks = ticksLasting;
        this.challengeCooldown = ticksLasting + 2400;
        this.self.method_37908().method_43129(null, (class_1297)this.self, se, this.self.method_5634(), 2.0f, 1.0f);
    }

    public void challengeId(int tickCount, int challengeID) {
        this.challengeNumber = challengeID;
        this.talkingTicks = tickCount;
    }

    public void respondToChallenge() {
    }

    public void playOnTick() {
        if (this.inTheMiddleOfTalking()) {
            --this.talkingTicks;
            if (this.talkingTicks <= -1 && this.challengeNumber != -1) {
                this.respondToChallenge();
                this.challengeNumber = -1;
            }
        }
        if (this.idleCooldown > -1) {
            --this.idleCooldown;
        }
        if (this.killCooldown > -1) {
            --this.killCooldown;
        }
        if (this.hurtCooldown > -1) {
            --this.hurtCooldown;
        }
        if (this.attackCooldown > -1) {
            --this.attackCooldown;
        }
        if (this.summonCooldown > -1) {
            --this.summonCooldown;
        }
        if (this.challengeCooldown > -1) {
            --this.challengeCooldown;
        }
        if (!this.inTheMiddleOfTalking() && !this.self.method_18276()) {
            VoiceLine vl;
            this.safeInit();
            if (this.challengeCooldown <= -1) {
                this.challenge();
            }
            this.overrideTick();
            if (!this.tickLines.isEmpty() && this.idleCooldown <= -1 && (vl = VoiceData.getRandomElement(this.tickLines)) != null) {
                this.playSound(vl.soundEvent, vl.lengthInTicks);
            }
        }
    }

    public static <T> T getRandomElement(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        Random random = new Random();
        int randomIndex = random.nextInt(list.size());
        return list.get(randomIndex);
    }

    public void overrideTick() {
    }

    public void playIfHurt(class_1282 $$0) {
        if (!this.inTheMiddleOfTalking()) {
            VoiceLine vl;
            this.safeInit();
            this.overrideHurt($$0);
            if (!this.hurtLines.isEmpty() && this.hurtCooldown <= -1 && (vl = VoiceData.getRandomElement(this.hurtLines)) != null) {
                this.playSoundHurt(vl.soundEvent, vl.lengthInTicks);
            }
        }
    }

    public void overrideHurt(class_1282 $$0) {
    }

    public void playIfDying(class_1282 $$0) {
        if (!this.inTheMiddleOfTalking()) {
            VoiceLine vl;
            this.safeInit();
            this.overrideDying($$0);
            if (!this.deathLines.isEmpty() && (vl = VoiceData.getRandomElement(this.deathLines)) != null) {
                this.playSound2(vl.soundEvent, vl.lengthInTicks);
            }
        }
    }

    public void overrideDying(class_1282 $$0) {
    }

    public void playIfKilled(class_1309 victim) {
        if (!this.inTheMiddleOfTalking()) {
            VoiceLine vl;
            this.safeInit();
            this.overrideKilling(victim);
            if (!this.killLines.isEmpty() && this.killCooldown <= -1 && (vl = VoiceData.getRandomElement(this.killLines)) != null) {
                this.playSoundKill(vl.soundEvent, vl.lengthInTicks);
            }
        }
    }

    public void overrideKilling(class_1309 victim) {
    }

    public void playIfAttacking(class_1297 victim) {
        if (!this.inTheMiddleOfTalking()) {
            VoiceLine vl;
            this.safeInit();
            this.overrideAttacking(victim);
            if (!this.attackLines.isEmpty() && this.attackCooldown <= -1 && (vl = VoiceData.getRandomElement(this.attackLines)) != null) {
                this.playSoundAttack(vl.soundEvent, vl.lengthInTicks);
            }
        }
    }

    public void overrideAttacking(class_1297 victim) {
    }

    public void playSummon() {
        if (!this.inTheMiddleOfTalking()) {
            VoiceLine vl;
            this.safeInit();
            this.playSummonOverride();
            if (!this.summonLines.isEmpty() && this.summonCooldown <= -1 && (vl = VoiceData.getRandomElement(this.summonLines)) != null) {
                this.playSoundSummon(vl.soundEvent, vl.lengthInTicks);
            }
        }
    }

    public void playSummonOverride() {
    }

    public void challenge() {
    }
}

