/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.item;

import java.util.List;
import javax.annotation.Nullable;
import net.hydra.jojomod.entity.projectile.RoundaboutBulletEntity;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.item.FirearmItem;
import net.hydra.jojomod.item.SnubnoseAmmoItem;
import net.hydra.jojomod.sound.ModSounds;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5150;

public class SnubnoseRevolverItem
extends FirearmItem
implements class_5150 {
    private static final String AMMO_COUNT_TAG = "AmmoCount";
    private static final String RELOADING_TAG = "IsReloading";
    int maxAmmo = 6;

    public SnubnoseRevolverItem(class_1792.class_1793 $$0) {
        super($$0);
    }

    public boolean method_7870(class_1799 p_41456_) {
        return false;
    }

    private int getAmmo(class_1799 stack) {
        return stack.method_7948().method_10550(AMMO_COUNT_TAG);
    }

    private void setAmmo(class_1799 stack, int count) {
        stack.method_7948().method_10569(AMMO_COUNT_TAG, count);
    }

    private boolean getReloading(class_1799 stack) {
        return stack.method_7948().method_10577(RELOADING_TAG);
    }

    private void setReloading(class_1799 stack, boolean value) {
        stack.method_7948().method_10556(RELOADING_TAG, value);
    }

    private boolean isReloading(class_1799 stack) {
        return stack.method_7948().method_10577(RELOADING_TAG);
    }

    public class_1839 method_7853(class_1799 $$0) {
        return class_1839.field_8953;
    }

    private boolean hasSnubnoseAmmo(class_1657 player) {
        class_1661 inv = player.method_31548();
        for (class_1799 stack : inv.field_7547) {
            if (!(stack.method_7909() instanceof SnubnoseAmmoItem) || stack.method_7947() <= 0) continue;
            return true;
        }
        for (class_1799 stack : inv.field_7544) {
            if (!(stack.method_7909() instanceof SnubnoseAmmoItem) || stack.method_7947() <= 0) continue;
            return true;
        }
        return player.method_7337();
    }

    private int consumeSnubnoseAmmo(class_1657 player, int amount) {
        int remove;
        class_1799 stack;
        int i;
        class_1661 inv = player.method_31548();
        int consumed = 0;
        for (i = 0; i < inv.field_7547.size() && amount > 0; ++i) {
            stack = (class_1799)inv.field_7547.get(i);
            if (!(stack.method_7909() instanceof SnubnoseAmmoItem) || player.method_7337()) continue;
            remove = Math.min(stack.method_7947(), amount);
            stack.method_7934(remove);
            consumed += remove;
            if ((amount -= remove) <= 0) break;
        }
        for (i = 0; i < inv.field_7544.size() && amount > 0; ++i) {
            stack = (class_1799)inv.field_7544.get(i);
            if (!(stack.method_7909() instanceof SnubnoseAmmoItem) || player.method_7337()) continue;
            remove = Math.min(stack.method_7947(), amount);
            stack.method_7934(remove);
            consumed += remove;
            if ((amount -= remove) <= 0) break;
        }
        if (player.method_7337()) {
            return this.maxAmmo;
        }
        return consumed;
    }

    public void cancelReload(class_1799 stack, class_1657 player) {
        if (this.isReloading(stack)) {
            ((StandUser)player).roundabout$getStandPowers().stopSoundsIfNearby((byte)104, 10.0, false);
            this.setReloading(stack, false);
            player.method_7357().method_7900((class_1792)this);
        }
    }

    @Override
    public void fireBullet(class_1937 level, class_1657 player, class_1268 hand) {
        if (!level.field_9236 && player.method_7357().method_7904((class_1792)this)) {
            return;
        }
        class_1799 itemStack = player.method_5998(hand);
        if (this.getAmmo(itemStack) > 0) {
            player.method_7357().method_7906((class_1792)this, 5);
            if (!player.method_7337()) {
                this.setAmmo(itemStack, this.getAmmo(itemStack) - 1);
            }
            class_1657 livingEntity = player;
            RoundaboutBulletEntity $$7 = new RoundaboutBulletEntity(level, (class_1309)livingEntity);
            $$7.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, 4.0f, 0.0f);
            $$7.setAmmoType((byte)1);
            level.method_8649((class_1297)$$7);
            level.method_43129(null, (class_1297)player, ModSounds.SNUBNOSE_FIRE_EVENT, class_3419.field_15248, 1.0f, 1.0f);
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                class_243 look = player.method_5720().method_1029();
                class_243 up = new class_243(0.0, 1.0, 0.0);
                class_243 right = look.method_1036(up).method_1029();
                double forwardOffset = 1.0;
                double sideOffset = 0.24;
                double verticalOffset = -0.15;
                if (player.method_6068() == class_1306.field_6182) {
                    sideOffset -= sideOffset * 2.0;
                }
                class_243 pos = player.method_33571().method_1019(look.method_1021(forwardOffset)).method_1019(right.method_1021(sideOffset)).method_1031(0.0, verticalOffset, 0.0);
                serverLevel.method_14199((class_2394)class_2398.field_11251, pos.field_1352, pos.field_1351, pos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (livingEntity != null && ((StandUser)livingEntity).roundabout$isBubbleEncased()) {
                StandUser SE = (StandUser)livingEntity;
                if (!level.method_8608()) {
                    SE.roundabout$setBubbleEncased((byte)0);
                    level.method_8396(null, livingEntity.method_24515(), ModSounds.BUBBLE_POP_EVENT, class_3419.field_15248, 2.0f, (float)(0.98 + Math.random() * 0.04));
                    ((class_3218)level).method_14199((class_2394)ModParticles.BUBBLE_POP, livingEntity.method_23317(), livingEntity.method_23318() + (double)livingEntity.method_17682() * 0.5, livingEntity.method_23321(), 5, 0.25, 0.25, 0.25, 0.025);
                }
            }
        } else {
            level.method_43129(null, (class_1297)player, ModSounds.SNUBNOSE_DRY_FIRE_EVENT, class_3419.field_15248, 1.0f, 1.0f);
            if (player instanceof class_3222) {
                class_3222 SP = (class_3222)player;
                SP.method_7353((class_2561)class_2561.method_43471((String)"text.roundabout.out_of_bullets").method_27692(class_124.field_1076), true);
            }
        }
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        super.method_7836(level, player, hand);
        class_1799 itemStack = player.method_5998(hand);
        if (!(itemStack.method_7909() instanceof SnubnoseRevolverItem)) {
            return class_1271.method_22431((Object)itemStack);
        }
        if (player.method_6030() != itemStack) {
            if (player.method_18276() && this.hasSnubnoseAmmo(player) && this.getAmmo(itemStack) != this.maxAmmo || player.method_18276() && player.method_7337()) {
                if (!this.isReloading(itemStack)) {
                    this.setReloading(itemStack, true);
                    player.method_7357().method_7906((class_1792)this, 60);
                    ((StandUser)player).roundabout$getStandPowers().playSoundsIfNearby((byte)-23, 10.0, false);
                }
                return class_1271.method_22428((Object)itemStack);
            }
            if (player.method_18276() && this.getAmmo(itemStack) == this.maxAmmo) {
                if (player instanceof class_3222) {
                    class_3222 SP = (class_3222)player;
                    SP.method_7353((class_2561)class_2561.method_43471((String)"text.roundabout.already_reloaded").method_27692(class_124.field_1080), true);
                }
            } else if (player.method_18276() && this.getAmmo(itemStack) != this.maxAmmo && !this.hasSnubnoseAmmo(player)) {
                if (player instanceof class_3222) {
                    class_3222 SP = (class_3222)player;
                    SP.method_7353((class_2561)class_2561.method_43471((String)"text.roundabout.no_more_usable_ammo").method_27692(class_124.field_1080), true);
                }
            } else {
                player.method_6019(hand);
            }
        }
        return class_1271.method_22428((Object)itemStack);
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, level, entity, slot, selected);
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        if (level.field_9236) {
            return;
        }
        if (this.isReloading(stack)) {
            class_1282 last;
            boolean justTookDamage;
            boolean bl = justTookDamage = player.field_6235 == player.field_6254 - 1;
            if (justTookDamage && (last = player.method_6081()) != null && last.method_5529() instanceof class_1297) {
                this.cancelReload(stack, player);
                return;
            }
        }
        if (this.isReloading(stack) && player.method_6047() != stack) {
            this.cancelReload(stack, player);
            return;
        }
        if (this.isReloading(stack) && !player.method_7357().method_7904((class_1792)this) && player.method_6047() == stack) {
            int currentAmmo = this.getAmmo(stack);
            int ammoNeeded = this.maxAmmo - currentAmmo;
            int ammoLoaded = this.consumeSnubnoseAmmo(player, ammoNeeded);
            if (ammoLoaded > 0) {
                if (player.method_7337()) {
                    this.setAmmo(stack, this.maxAmmo);
                } else {
                    this.setAmmo(stack, currentAmmo + ammoLoaded);
                }
            }
            this.setReloading(stack, false);
        }
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltip, class_1836 flag) {
        int ammo = this.getAmmo(stack);
        tooltip.add((class_2561)class_2561.method_43470((String)("Ammo: " + ammo + " / " + this.maxAmmo)).method_27692(class_124.field_1080));
    }
}

