/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.stand.powers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.access.IMob;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.projectile.AnubisSlipstreamEntity;
import net.hydra.jojomod.event.ModEffects;
import net.hydra.jojomod.event.index.AnubisMemory;
import net.hydra.jojomod.event.index.AnubisMoment;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.elements.PowerContext;
import net.hydra.jojomod.stand.powers.presets.NewDashPreset;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.S2CPacketUtil;
import net.hydra.jojomod.util.config.ConfigManager;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3218;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4051;
import org.joml.Vector3f;

public class PowersAnubis
extends NewDashPreset {
    public static final int MaxPossesionTime = 100;
    public static final int PogoDelay = 8;
    public static final byte SWING = 50;
    public List<AnubisMemory> memories = new ArrayList<AnubisMemory>();
    List<Integer> lasthits = new ArrayList<Integer>();
    float slipstreamTimer = 3.0f;
    boolean canPogo = true;
    int pogoCounter = 0;
    public static final byte DOUBLE = 52;
    public static final byte THRUST = 53;
    public static final byte UPPERCUT = 54;
    public static final byte SPIN = 55;
    List<class_1297> targets = new ArrayList<class_1297>();
    public static final byte ANIME = 1;
    public static final byte EVIL = 2;

    public PowersAnubis(class_1309 self) {
        super(self);
    }

    @Override
    public StandPowers generateStandPowers(class_1309 entity) {
        PowersAnubis PA = new PowersAnubis(entity);
        return PA;
    }

    @Override
    public boolean canSummonStandAsEntity() {
        return false;
    }

    @Override
    public boolean rendersPlayer() {
        return true;
    }

    @Override
    public void renderIcons(class_332 context, int x, int y) {
        if (!this.isHoldingSneak()) {
            this.setSkillIcon(context, x, y, 1, StandIcons.ANUBIS_ALLURING_LIGHT, (byte)0);
        } else {
            this.setSkillIcon(context, x, y, 1, StandIcons.ANUBIS_RAGING_LIGHT, (byte)4);
        }
        this.setSkillIcon(context, x, y, 2, StandIcons.NONE, (byte)1);
        if (!this.isHoldingSneak()) {
            this.setSkillIcon(context, x, y, 3, StandIcons.DODGE, (byte)6);
        } else {
            this.setSkillIcon(context, x, y, 3, StandIcons.ANUBIS_BACKFLIP, (byte)6);
        }
        this.setSkillIcon(context, x, y, 4, StandIcons.NONE, (byte)3);
        super.renderIcons(context, x, y);
    }

    @Override
    public float inputSpeedModifiers(float basis) {
        if (((StandUser)this.getSelf()).roundabout$getActive() && this.getActivePower() != 3 && this.getActivePower() != 4) {
            basis *= this.getSelf().method_5624() ? 1.6f : 1.0f;
        }
        if (this.getActivePower() == 4 && this.getAttackTimeDuring() > this.getBarrageMinimum()) {
            int v = this.getBarrageWindup() - this.getBarrageMinimum();
            float scale = Math.min((float)(this.getAttackTimeDuring() - v) / (float)v, 1.0f);
            basis *= 1.0f - 0.7f * scale;
        }
        return super.inputSpeedModifiers(basis);
    }

    @Override
    public int getJumpHeightAddon() {
        if (this.getStandUserSelf().roundabout$getActive() && this.getActivePower() != 4) {
            return 1;
        }
        return super.getJumpHeightAddon();
    }

    @Override
    public boolean cancelSprintJump() {
        if (this.getActivePower() == 3) {
            return true;
        }
        return super.cancelSprintJump();
    }

    @Override
    public void powerActivate(PowerContext context) {
        switch (context) {
            case SKILL_1_NORMAL: 
            case SKILL_1_GUARD: {
                this.AlluringLightClient();
                break;
            }
            case SKILL_1_CROUCH: 
            case SKILL_1_CROUCH_GUARD: {
                this.RagingLightClient();
                break;
            }
            case SKILL_2_NORMAL: 
            case SKILL_2_CROUCH: {
                this.MemoryPlayClient();
                break;
            }
            case SKILL_3_NORMAL: {
                this.dash();
                break;
            }
            case SKILL_3_CROUCH: {
                this.BackflipClient();
                break;
            }
            case SKILL_4_NORMAL: 
            case SKILL_4_CROUCH: {
                this.MemoryRecordClient();
            }
        }
    }

    public void AlluringLightClient() {
        if (!this.onCooldown((byte)0)) {
            this.setCooldown((byte)0, 200);
            this.tryPowerPacket((byte)21);
        }
    }

    public void AlluringLightServer() {
        this.setCooldown((byte)0, 200);
        int radius = 8;
        class_238 box = this.getSelf().method_5829().method_1009((double)radius, 2.0, (double)radius);
        for (class_1308 M : this.getSelf().method_37908().method_18466(class_1308.class, class_4051.field_18092, this.getSelf(), box)) {
            ((IMob)M).roundabout$setHypnotizedBy(this.getSelf(), 200);
        }
        class_243 pos = this.getSelf().method_30950(1.0f);
        Vector3f[] colors = new Vector3f[]{new Vector3f(0.96f, 0.96f, 0.92f), new Vector3f(0.93f, 0.87f, 0.57f)};
        ((class_3218)this.getSelf().method_37908()).method_14199((class_2394)class_2398.field_11248, pos.field_1352, pos.field_1351 + (double)this.getSelf().method_5751(), pos.field_1350, 20, 0.0, 0.0, 0.0, 0.4);
    }

    public void RagingLightClient() {
        if (!this.onCooldown((byte)4)) {
            this.setCooldown((byte)4, 200);
            this.tryPowerPacket((byte)22);
        }
    }

    public void RagingLightServer() {
        this.setCooldown((byte)4, 200);
        int radius = 13;
        class_238 box = this.getSelf().method_5829().method_1009((double)radius, 2.0, (double)radius);
        for (class_1308 M : this.getSelf().method_37908().method_18466(class_1308.class, class_4051.field_18092, this.getSelf(), box)) {
            M.method_5980(this.getSelf());
            M.method_6015(this.getSelf());
        }
        class_243 pos = this.getSelf().method_30950(1.0f);
        Vector3f[] colors = new Vector3f[]{new Vector3f(0.85f, 0.31f, 0.15f), new Vector3f(0.31f, 0.22f, 0.2f)};
        ((class_3218)this.getSelf().method_37908()).method_14199((class_2394)class_2398.field_11248, pos.field_1352, pos.field_1351 + (double)this.getSelf().method_5751(), pos.field_1350, 20, 0.0, 0.0, 0.0, 0.4);
    }

    public void BackflipClient() {
        if (!this.onCooldown((byte)6)) {
            this.tryPower(13, true);
            this.tryPowerPacket((byte)13);
        }
    }

    public void MemoryRecordClient() {
        if (!this.getStandUserSelf().roundabout$getUniqueStandModeToggle() && class_310.method_1551().field_1729.method_1613()) {
            ClientUtil.openMemoryRecordScreen(true);
        }
    }

    public void MemoryPlayClient() {
        if (!this.getStandUserSelf().roundabout$getUniqueStandModeToggle() && class_310.method_1551().field_1729.method_1613()) {
            ClientUtil.openMemoryRecordScreen(false);
        }
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        StandUser SU = (StandUser)this.getSelf();
        switch (move) {
            case 21: {
                this.getSelf().method_37908().method_8396(null, this.getSelf().method_24515(), ModSounds.ANUBIS_ALLURING_EVENT, class_3419.field_15248, 1.0f, 1.0f);
                break;
            }
            case 22: {
                this.getSelf().method_37908().method_8396(null, this.getSelf().method_24515(), ModSounds.ANUBIS_RAGING_EVENT, class_3419.field_15248, 1.0f, 1.0f);
                break;
            }
            case 5: {
                this.setActivePower((byte)49);
                this.setPowerOther(49, this.getActivePower());
                break;
            }
            case 13: {
                this.canPogo = true;
                this.setAttackTime(0);
                this.setActivePower((byte)13);
                this.setCooldown((byte)6, 260 + (this.getSelf().method_24828() ? 0 : 60));
                this.getSelf().method_37908().method_8396(null, this.getSelf().method_24515(), ModSounds.ANUBIS_BACKFLIP_EVENT, class_3419.field_15248, 1.0f, 1.0f);
                this.getStandUserSelf().roundabout$setStandAnimation((byte)13);
                if (this.isClient()) break;
                class_243 look = this.getSelf().method_5720().method_18805(1.0, 0.0, 1.0).method_1029();
                SU.roundabout$setLeapTicks(((StandUser)this.getSelf()).roundabout$getMaxLeapTicks());
                SU.roundabout$setLeapIntentionally(true);
                float strength = 1.25f;
                if (Math.abs(look.field_1352) + Math.abs(look.field_1350) == 0.0) {
                    strength *= 0.7f;
                }
                MainUtil.takeUnresistableKnockbackWithY((class_1297)this.getSelf(), strength, look.field_1352 * 1.0, -1.0, look.field_1350 * 1.0);
            }
        }
        return super.tryPower(move, forced);
    }

    @Override
    public boolean setPowerOther(int move, int lastMove) {
        switch (move) {
            case 21: {
                this.AlluringLightServer();
                break;
            }
            case 22: {
                this.RagingLightServer();
                break;
            }
            case 1: 
            case 2: {
                this.tryBasicAttack((byte)move);
                break;
            }
            case 43: {
                this.tryPogoAttack();
                break;
            }
            case 41: {
                this.attackTimeDuring = 0;
                this.playBarrageChargeSound();
                this.setActivePower((byte)41);
                break;
            }
            case 49: {
                this.setActivePower((byte)49);
                this.setAttackTime(0);
            }
        }
        return super.setPowerOther(move, lastMove);
    }

    @Override
    public void onActuallyHurt(class_1282 $$0, float $$1) {
        if (this.getActivePower() == 43 && this.getAttackTimeDuring() < 8) {
            this.setPowerNone();
        }
    }

    @Override
    public void tickPower() {
        class_1657 P;
        class_1309 class_13092;
        StandUser SU;
        Roundabout.LOGGER.info("" + this.getActivePowerPhase());
        if (this.memories.size() != 8) {
            PowersAnubis.generateMemories(this);
        }
        if ((SU = this.getStandUserSelf()).roundabout$getStandSkin() == 0) {
            SU.roundabout$setStandSkin((byte)1);
        }
        if (this.getSelf().method_24828()) {
            if (this.getActivePower() != 43 || this.attackTime > 11) {
                this.canPogo = true;
            }
            if (this.isClient()) {
                class_13092 = this.getSelf();
                if (class_13092 instanceof class_1657) {
                    P = (class_1657)class_13092;
                    if (this.pogoCounter != 0 && ConfigManager.getClientConfig().standTweakSettings.anubisPogoCounter.booleanValue()) {
                        P.method_7353((class_2561)class_2561.method_43470((String)("" + this.pogoCounter)).method_27692(class_124.field_1061), true);
                    }
                }
                this.pogoCounter = 0;
            }
        } else if (!this.canPogo && (class_13092 = this.getSelf()) instanceof class_1657 && (P = (class_1657)class_13092).method_7337()) {
            this.canPogo = true;
        }
        if (!this.isClient()) {
            boolean noSlip;
            class_1937 level = this.getSelf().method_37908();
            boolean bl = noSlip = this.getActivePower() == 13 || this.getActivePower() == 43;
            if (this.getSelf().method_5624() && SU.roundabout$getActive() && !noSlip) {
                float dif = this.getSelf().field_5973 - this.getSelf().field_6039;
                if (dif != 0.0f) {
                    this.slipstreamTimer -= dif;
                }
                if (this.slipstreamTimer <= 0.0f) {
                    this.slipstreamTimer = 3.0f;
                    AnubisSlipstreamEntity AS = new AnubisSlipstreamEntity(ModEntities.ANUBIS_SLIPSTREAM, level);
                    AS.method_33574(this.getSelf().method_30950(1.0f));
                    level.method_8649((class_1297)AS);
                }
            }
        }
        SU.roundabout$setCombatMode(SU.roundabout$getActive());
        if (this.isGuarding()) {
            this.getStandUserSelf().roundabout$setStandAnimation((byte)3);
        } else if (this.getStandUserSelf().roundabout$getStandAnimation() == 3) {
            this.getStandUserSelf().roundabout$setStandAnimation((byte)0);
        }
        if (SU.roundabout$getStandAnimation() == 13 && this.attackTime > 16) {
            SU.roundabout$setStandAnimation((byte)0);
        }
        if (SU.roundabout$getStandAnimation() == 43 && (this.getActivePower() == 0 || this.getSelf().method_24828())) {
            SU.roundabout$setStandAnimation((byte)0);
        }
        if (this.getActivePower() == 13) {
            if (this.getAttackTime() > 10 && this.getAttackTime() < 20) {
                if (this.getSelf().method_18276()) {
                    this.addMomentum(0.0f, -0.075f, 0.0f);
                }
            } else if (this.getAttackTime() > 20) {
                this.setPowerNone();
            }
        }
        this.getSelf().method_5875(this.getActivePower() == 43 && this.attackTimeDuring < 8);
        super.tickPower();
    }

    @Override
    public boolean interceptAttack() {
        return true;
    }

    @Override
    public void buttonInputAttack(boolean keyIsDown, class_315 options) {
        if (keyIsDown && this.canAttack()) {
            int index = 1;
            if (this.isHoldingSneak()) {
                if (!this.getSelf().method_24828() && this.canPogo) {
                    this.canPogo = false;
                    index = 43;
                } else {
                    index = 2;
                }
            }
            this.tryPower(index);
            this.tryPowerPacket((byte)index);
        }
    }

    @Override
    public boolean setPowerAttack() {
        return this.setPowerOther(1, this.getActivePower());
    }

    public void tryBasicAttack(byte move) {
        if (this.activePowerPhase >= 3) {
            this.activePowerPhase = 1;
        } else {
            this.activePowerPhase = (byte)(this.activePowerPhase + 1);
            this.attackTimeMax = this.activePowerPhase == 3 ? ClientNetworking.getAppropriateConfig().generalStandSettings.finalStandPunchInStringCooldown.intValue() : ClientNetworking.getAppropriateConfig().generalStandSettings.standPunchCooldown.intValue();
        }
        this.lasthits.add(1 + (move == 2 ? -2 : 0));
        this.attackTimeDuring = 0;
        this.setAttackTime(0);
        if (this.activePowerPhase == 3) {
            this.setActivePower(this.determineThird(this.lasthits));
        } else {
            this.setActivePower(move);
        }
    }

    @Override
    public void updateAttack() {
        this.updateUniqueMoves();
    }

    @Override
    public void updateUniqueMoves() {
        switch (this.getActivePower()) {
            case 1: 
            case 2: {
                this.updateAttacks();
                break;
            }
            case 43: {
                this.updatePogoAttack();
                break;
            }
            case 41: {
                if (this.attackTimeDuring < this.getKickBarrageWindup()) break;
                this.setActivePower((byte)42);
                break;
            }
            case 42: {
                this.BarrageSlash();
                break;
            }
            case 49: {
                Roundabout.LOGGER.info("" + this.getAttackTime());
                if (this.getAttackTime() == 5) {
                    this.StartQuickdraw(8.0f);
                    break;
                }
                this.UpdateQuickdraw();
            }
        }
        if (PowersAnubis.isVariant(this.getActivePower())) {
            this.updateAttacks();
        }
    }

    public void updateAttacks() {
        if (!this.isClient() && this.attackTimeDuring > -1) {
            if (this.attackTimeDuring > this.attackTimeMax) {
                this.attackTime = -1;
                this.attackTimeMax = 0;
                this.lasthits = new ArrayList<Integer>();
                ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
            } else {
                class_315 o = class_310.method_1551().field_1690;
                switch (this.getActivePower()) {
                    case 52: {
                        if (this.attackTimeDuring % 4 != 0) break;
                        this.DoubleCut(this.attackTimeDuring < 8);
                        break;
                    }
                    case 55: {
                        this.SpinCut();
                    }
                }
                if (this.getActivePower() == 2 || this.getActivePower() == 1) {
                    if (this.getActivePower() == 2) {
                        this.SAttack();
                    } else {
                        this.NAttack();
                    }
                }
                if (this.getSelf() instanceof class_1657 && this.isPacketPlayer()) {
                    this.setAttackTimeDuring(-10);
                }
            }
        }
    }

    public void NAttack() {
        class_1309 class_13092 = this.getSelf();
        if (class_13092 instanceof class_1657) {
            class_1657 P = (class_1657)class_13092;
            S2CPacketUtil.sendIntPowerDataPacket(P, (byte)50, 0);
        }
        class_1297 targetEntity = this.getTargetEntity(this.self, -1.0f, 15.0f);
        this.punchImpact(targetEntity);
    }

    public void SAttack() {
        class_1309 class_13092 = this.getSelf();
        if (class_13092 instanceof class_1657) {
            class_1657 P = (class_1657)class_13092;
            S2CPacketUtil.sendIntPowerDataPacket(P, (byte)50, 0);
        }
        class_1297 targetEntity = this.getTargetEntity(this.self, -1.0f, 15.0f);
        this.punchImpact(targetEntity);
    }

    public void tryPogoAttack() {
        this.attackTimeMax = ClientNetworking.getAppropriateConfig().generalStandSettings.finalStandPunchInStringCooldown;
        this.attackTimeDuring = 0;
        this.setActivePower((byte)43);
        this.setAttackTime(0);
    }

    public void updatePogoAttack() {
        this.getSelf().method_5875(this.attackTimeDuring < 8);
        if (this.attackTimeDuring > -1) {
            if (this.getSelf().method_24828() && this.getAttackTime() < 8) {
                this.setPowerNone();
                this.attackTime += 5;
            }
            if (this.attackTimeDuring > this.attackTimeMax) {
                this.attackTime = -1;
                this.attackTimeMax = 0;
                ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
            } else if (!this.isClient()) {
                int windup = 8;
                if (this.attackTimeDuring == windup) {
                    this.PogoLaunch();
                } else if (this.attackTimeDuring < windup) {
                    MainUtil.slowTarget((class_1297)this.getSelf(), 0.8f);
                } else if (this.attackTimeDuring < windup + 6) {
                    class_243 pos = this.getSelf().method_5836(0.0f).method_1019(this.getSelf().method_5720().method_1021(1.0));
                    List<class_1297> targets = MainUtil.genHitbox(this.getSelf().method_37908(), pos.field_1352, pos.field_1351, pos.field_1350, 1.4, 1.4, 1.4);
                    targets.removeIf(entity -> entity.equals((Object)this.getSelf()));
                    targets = this.doAttackChecks(targets);
                    class_1297 target = null;
                    if (!targets.isEmpty()) {
                        target = targets.get(0);
                    }
                    class_315 o = class_310.method_1551().field_1690;
                    if (target != null) {
                        class_1309 LE;
                        this.setAttackTimeDuring(this.getAttackTimeDuring() + 15);
                        double strength = this.getSelf().method_18276() ? 0.5 : 0.9;
                        MainUtil.takeUnresistableKnockbackWithY((class_1297)this.getSelf(), strength, 0.0, -1.0, 0.0);
                        this.getStandUserSelf().roundabout$setLeapTicks(20);
                        this.getStandUserSelf().roundabout$setLeapIntentionally(true);
                        if (this.StandDamageEntityAttack(target, 4.0f, 1.0f, (class_1297)this.getSelf()) && target instanceof class_1309 && ((StandUser)(LE = (class_1309)target)).roundabout$getStandPowers().interceptGuard() && LE.method_6039() && !((StandUser)LE).roundabout$isGuarding()) {
                            this.knockShield2(target, 30);
                        }
                        this.setPowerNone();
                        class_1309 class_13092 = this.getSelf();
                        if (class_13092 instanceof class_1657) {
                            class_1657 P = (class_1657)class_13092;
                            S2CPacketUtil.sendIntPowerDataPacket(P, (byte)43, this.attackTime + 5);
                            if (target instanceof class_1531) {
                                S2CPacketUtil.sendIntPowerDataPacket(P, (byte)15, 1);
                            }
                        }
                        this.getSelf().method_37908().method_8396(null, this.getSelf().method_24515(), ModSounds.ANUBIS_POGO_HIT_EVENT, class_3419.field_15248, 1.0f, 0.9f + (float)Math.random() * 0.2f);
                        ((StandUser)this.getSelf()).roundabout$setMeleeImmunity((byte)(this.getSelf().method_18276() ? 10 : 5));
                    }
                } else if (this.attackTimeDuring < windup + 9) {
                    MainUtil.slowTarget((class_1297)this.getSelf(), 0.7f);
                    this.getSelf().method_38785();
                }
            }
        }
    }

    public void PogoLaunch() {
        class_1309 class_13092 = this.getSelf();
        if (class_13092 instanceof class_1657) {
            class_1657 P = (class_1657)class_13092;
            S2CPacketUtil.sendIntPowerDataPacket(P, (byte)50, 0);
        }
        float power = 1.5f;
        class_243 lookAngle = this.getSelf().method_5720().method_22882();
        this.getSelf().method_38785();
        if (lookAngle.field_1351 < -0.15) {
            power *= 0.5f;
        }
        this.getSelf().method_37908().method_8396(null, this.getSelf().method_24515(), ModSounds.ANUBIS_POGO_LAUNCH_EVENT, class_3419.field_15248, 1.0f, 0.9f + (float)(Math.random() * 0.2));
        this.getStandUserSelf().roundabout$setMeleeImmunity((byte)6);
        MainUtil.takeUnresistableKnockbackWithY((class_1297)this.getSelf(), power, lookAngle.field_1352, lookAngle.field_1351, lookAngle.field_1350);
    }

    @Override
    public void punchImpact(class_1297 entity) {
        this.setAttackTimeDuring(-10);
        float knockbackStrength = 0.2f;
        if (this.getActivePower() == 2) {
            knockbackStrength = 0.4f;
        }
        if (this.getSelf().method_5624()) {
            knockbackStrength += 0.05f;
        }
        List<class_1297> entities = this.getBasicSwordHitBox(this.getActivePower() == 2);
        for (class_1297 e : entities) {
            float pow;
            if (e == null || !this.StandDamageEntityAttack(e, pow = this.getPunchStrength(e) * (this.getActivePower() == 2 ? 1.3f : 1.0f), 0.0f, (class_1297)this.self)) continue;
            if (e instanceof class_1309) {
                class_1309 LE = (class_1309)e;
                this.addEXP(1);
            }
            this.takeDeterminedKnockback(this.getSelf(), e, knockbackStrength);
        }
        if (!entities.isEmpty() && !this.isClient()) {
            class_1297 e = entities.get(0);
            class_243 pos = e.method_30950(0.0f).method_1031(0.0, (double)(e.method_5751() / 2.0f), 0.0);
            ((class_3218)this.getSelf().method_37908()).method_14199((class_2394)class_2398.field_11227, pos.field_1352, pos.field_1351, pos.field_1350, 0, 0.0, 0.0, 0.0, 0.0);
            float pitch = 0.9f + (float)(Math.random() * (double)0.2f);
            this.getSelf().method_37908().method_8396(null, this.getSelf().method_24515(), class_3417.field_14706, class_3419.field_15248, 1.0f, pitch += this.getActivePower() == 2 ? -0.3f : 0.0f);
        }
    }

    public static boolean isVariant(byte b) {
        return b >= 52 && b <= 55;
    }

    public byte determineThird(List<Integer> list) {
        String id;
        this.lasthits = new ArrayList<Integer>();
        return switch (id = String.valueOf(list.get(0)) + String.valueOf(list.get(1))) {
            case "11" -> 52;
            case "1-1" -> 52;
            case "-11" -> 55;
            case "-1-1" -> 55;
            default -> throw new IllegalStateException("How did you do this: " + id);
        };
    }

    public void DoubleCut(boolean first) {
        class_1309 class_13092 = this.getSelf();
        if (class_13092 instanceof class_1657) {
            class_1657 P = (class_1657)class_13092;
            S2CPacketUtil.sendIntPowerDataPacket(P, (byte)50, 0);
        }
        if (!this.canPogo) {
            this.setAttackTime(0);
            this.setAttackTimeMax(this.getAttackTimeMax() + 10);
        }
        if (!first) {
            this.setAttackTimeDuring(-10);
        }
        if (this.getSelf().method_24828() && this.getTargetEntity(this.getSelf(), 2.0f, this.getSelf().method_36455()) == null) {
            class_243 look = this.getSelf().method_5720();
            look = new class_243(look.field_1352, 0.0, look.field_1350).method_1029();
            MainUtil.takeUnresistableKnockbackWithY((class_1297)this.getSelf(), -0.5, look.field_1352, look.field_1351, look.field_1350);
        }
        float knockbackStrength = 0.5f + (this.getSelf().method_5624() ? 0.1f : 0.0f);
        if (first) {
            knockbackStrength = 0.2f;
        }
        List<class_1297> entities = this.defaultSwordHitbox((class_1297)this.getSelf(), 1.3, 3.4);
        entities = this.doAttackChecks(entities);
        for (class_1297 e : entities) {
            class_1309 LE;
            float pow;
            if (e == null) continue;
            if (e.method_5739((class_1297)this.getSelf()) < 1.5f) {
                knockbackStrength += 0.15f;
                this.setAttackTime(0);
                this.setAttackTimeMax(this.getAttackTimeMax() + 5);
            }
            if (this.StandDamageEntityAttack(e, pow = this.getHeavyPunchStrength(e) * 0.6f, 0.0f, (class_1297)this.self)) {
                this.getSelf().method_37908().method_8396(null, this.getSelf().method_24515(), class_3417.field_14706, class_3419.field_15248, 1.0f, 0.4f + (float)(Math.random() * 0.2) + (first ? 0.0f : 0.3f));
                if (e instanceof class_1309) {
                    LE = (class_1309)e;
                    this.addEXP(2);
                }
                this.takeDeterminedKnockback(this.getSelf(), e, knockbackStrength);
                continue;
            }
            if (first || !(e instanceof class_1309) || !(LE = (class_1309)e).method_6039()) continue;
            MainUtil.knockShieldPlusStand(e, 40);
        }
        if (!entities.isEmpty() && !this.isClient()) {
            class_1297 e = entities.get(0);
            class_243 pos = e.method_30950(0.0f).method_1031(0.0, (double)(e.method_5751() / 2.0f), 0.0);
            ((class_3218)this.getSelf().method_37908()).method_14199((class_2394)class_2398.field_11227, pos.field_1352, pos.field_1351, pos.field_1350, 0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void SpinCut() {
        class_1309 class_13092 = this.getSelf();
        if (class_13092 instanceof class_1657) {
            class_1657 P = (class_1657)class_13092;
            S2CPacketUtil.sendIntPowerDataPacket(P, (byte)50, 0);
        }
        this.setAttackTimeDuring(-10);
        float knockbackStrength = 0.75f + (this.getSelf().method_5624() ? 0.1f : 0.0f);
        class_243 pos = this.getSelf().method_30950(1.0f);
        List<class_1297> entities = MainUtil.genHitbox(this.getSelf().method_37908(), pos.field_1352, pos.field_1351, pos.field_1350, 3.3, 2.0, 3.3);
        entities.removeIf(entity -> (double)entity.method_5739((class_1297)this.getSelf()) > 3.3);
        entities = this.doAttackChecks(entities);
        for (class_1297 e : entities) {
            class_1309 LE;
            float pow;
            if (e == null) continue;
            if (e.method_5739((class_1297)this.getSelf()) < 1.5f) {
                knockbackStrength += 0.15f;
                this.setAttackTime(0);
                this.setAttackTimeMax(this.getAttackTimeMax() + 5);
            }
            if (this.StandDamageEntityAttack(e, pow = this.getHeavyPunchStrength(e), 0.0f, (class_1297)this.self)) {
                this.getSelf().method_37908().method_8396(null, this.getSelf().method_24515(), ModSounds.ANUBIS_BARRAGE_1_EVENT, class_3419.field_15248, 0.8f, 1.3f);
                if (e instanceof class_1309) {
                    LE = (class_1309)e;
                    this.addEXP(2);
                    if (MainUtil.getMobBleed((class_1297)LE)) {
                        LE.method_6092(new class_1293(ModEffects.BLEED, 200, 0));
                    }
                }
                class_243 dir = e.method_30950(1.0f).method_1020(this.getSelf().method_30950(1.0f)).method_1029().method_22882();
                MainUtil.takeKnockbackWithY(e, knockbackStrength, dir.field_1352, -0.33, dir.field_1350);
                continue;
            }
            if (!(e instanceof class_1309) || !(LE = (class_1309)e).method_6039()) continue;
            MainUtil.knockShieldPlusStand(e, 40);
        }
        if (!entities.isEmpty() && !this.isClient()) {
            class_1297 e = entities.get(0);
            pos = e.method_30950(0.0f).method_1031(0.0, (double)(e.method_5751() / 2.0f), 0.0);
            ((class_3218)this.getSelf().method_37908()).method_14199((class_2394)class_2398.field_11227, pos.field_1352, pos.field_1351, pos.field_1350, 0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean setPowerBarrageCharge() {
        this.attackTimeDuring = 0;
        this.setActivePower((byte)4);
        this.playBarrageChargeSound();
        return true;
    }

    @Override
    public void setPowerBarrage() {
        this.attackTimeDuring = 0;
        this.setActivePower((byte)49);
        this.setAttackTimeMax(this.getBarrageRecoilTime());
        this.setActivePowerPhase(this.getActivePowerPhaseMax());
        this.playBarrageCrySound();
    }

    @Override
    public void updatePowerInt(byte activePower, int data) {
        switch (activePower) {
            case 50: {
                this.getSelf().method_6104(class_1268.field_5808);
                break;
            }
            case 43: {
                this.attackTime = data;
                this.setPowerNone();
                ++this.pogoCounter;
                if (!ConfigManager.getClientConfig().standTweakSettings.anubisPogoCounter.booleanValue()) break;
                ((class_1657)this.getSelf()).method_7353((class_2561)class_2561.method_43470((String)("" + this.pogoCounter)).method_27692(class_124.field_1068), true);
                break;
            }
            case 15: {
                this.canPogo = data == 1;
                break;
            }
            case 5: {
                if (data == 1) {
                    this.setPowerNone();
                    break;
                }
                this.setAttackTime(0);
                this.setAttackTimeDuring(0);
                this.setActivePowerPhase(this.getActivePowerPhaseMax());
                this.setAttackTimeMax(data);
            }
        }
        super.updatePowerInt(activePower, data);
    }

    @Override
    public boolean interceptGuard() {
        return true;
    }

    public boolean canGuard() {
        return !this.isBarraging() && !this.isClashing() && this.getActivePower() != 43;
    }

    @Override
    public boolean buttonInputGuard(boolean keyIsDown, class_315 options) {
        if (this.isBarrageCharging() || this.isBarrageAttacking()) {
            return false;
        }
        if (!this.isGuarding() && this.canGuard()) {
            this.tryPower(3, true);
            this.tryPowerPacket((byte)3);
            return true;
        }
        return false;
    }

    @Override
    public void buttonInputBarrage(boolean keyIsDown, class_315 options) {
        if (keyIsDown) {
            if (this.isHoldingSneak() && (this.getAttackTime() >= this.getAttackTimeMax() || this.getActivePowerPhase() != this.getActivePowerPhaseMax())) {
                this.tryPower(41);
                this.tryPowerPacket((byte)41);
            } else {
                super.buttonInputBarrage(keyIsDown, options);
            }
        }
    }

    @Override
    public void updateBarrage() {
    }

    @Override
    public void updateBarrageCharge() {
    }

    @Override
    public boolean isBarrageAttacking() {
        return super.isBarrageAttacking() || this.getActivePower() == 42;
    }

    @Override
    public boolean isBarrageCharging() {
        return super.isBarrageCharging() || this.getActivePower() == 41;
    }

    public int getBarrageMinimum() {
        return this.getBarrageWindup();
    }

    @Override
    public int getBarrageWindup() {
        return super.getBarrageWindup() + 10;
    }

    @Override
    public boolean clickRelease() {
        return this.getActivePower() == 41;
    }

    @Override
    public boolean onClickRelease() {
        if (this.getActivePower() == 4 && this.getAttackTimeDuring() > this.getBarrageMinimum()) {
            this.tryPower(5);
            this.tryPowerPacket((byte)5);
            return true;
        }
        return super.onClickRelease();
    }

    @Override
    public boolean canScope() {
        return true;
    }

    public void StartQuickdraw(float dist) {
        class_3965 bh;
        class_2338 bp;
        if (this.getAttackTime() < 5) {
            return;
        }
        class_1937 level = this.getSelf().method_37908();
        if (level.method_8320(bp = (bh = MainUtil.getAheadVec((class_1297)this.getSelf(), dist)).method_17777()).method_26215()) {
            for (int i = 0; i < 5 && level.method_8320(bp = bp.method_10074()).method_26215(); ++i) {
            }
        }
        if (!level.method_8320(bp).method_26215() && level.method_8320(bp.method_10084().method_10084()).method_26215()) {
            bp = bp.method_10084();
            class_243 pos = this.getSelf().method_30950(1.0f);
            class_243 npos = new class_243((double)bp.method_10263(), (double)bp.method_10264(), (double)bp.method_10260());
            class_243 dpos = npos.method_1020(pos);
            ArrayList<class_1297> entities = new ArrayList<class_1297>();
            int intervals = 5;
            for (int i = 0; i < intervals - 1; ++i) {
                float d = 1.0f / (float)intervals * (float)i;
                class_243 spos = pos.method_1019(dpos.method_1021((double)d));
                List<class_1297> targets = MainUtil.genHitbox(level, spos.field_1352, spos.field_1351, spos.field_1350, 3.0, 1.5, 3.0);
                targets = this.doAttackChecks(targets);
                for (class_1297 entity : targets) {
                    if (entities.contains(entity)) continue;
                    entities.add(entity);
                }
            }
            this.targets = entities;
            this.setAttackTimeMax(70);
            this.getSelf().method_5859((double)bp.method_10263(), (double)bp.method_10264(), (double)bp.method_10260());
        } else {
            this.setAttackTimeMax(15);
        }
        this.setAttackTime(6);
        this.setAttackTimeDuring(0);
        this.setActivePowerPhase(this.getActivePowerPhaseMax());
        class_1309 class_13092 = this.getSelf();
        if (class_13092 instanceof class_1657) {
            class_1657 P = (class_1657)class_13092;
            S2CPacketUtil.sendIntPowerDataPacket(P, (byte)5, this.getAttackTimeMax());
        }
    }

    public void UpdateQuickdraw() {
        int duration = 15;
        for (class_1297 entity : this.targets) {
            ((StandUser)entity).roundabout$setDazed((byte)3);
            if (this.getAttackTimeDuring() > duration) {
                if (this.StandRushDamageEntityAttack(entity, 3.0f, 0.0f, (class_1297)this.getSelf())) {
                    MainUtil.takeKnockbackWithY(entity, 0.9, 0.0, -1.0, 0.0);
                }
                this.getSelf().method_37908().method_8396(null, this.getSelf().method_24515(), ModSounds.ANUBIS_BARRAGE_1_EVENT, class_3419.field_15248, 2.0f, 1.0f);
                continue;
            }
            if (this.getSelf().field_6012 % 3 != 1 || !this.StandRushDamageEntityAttack(entity, this.getBarrageHitStrength(entity), 0.0f, (class_1297)this.getSelf())) continue;
            MainUtil.takeUnresistableKnockbackWithY(entity, 0.01, 0.0, -1.0, 0.0);
            this.hitParticles(entity);
            this.getSelf().method_37908().method_8396(null, this.getSelf().method_24515(), ModSounds.ANUBIS_BARRAGE_1_HIT_EVENT, class_3419.field_15248, 1.0f, 0.9f + (float)(Math.random() * 0.2));
        }
        if (this.getAttackTimeDuring() > duration) {
            this.targets = new ArrayList<class_1297>();
            this.setPowerNone();
            class_1309 class_13092 = this.getSelf();
            if (class_13092 instanceof class_1657) {
                class_1657 P = (class_1657)class_13092;
                S2CPacketUtil.sendActivePowerPacket(P, (byte)0);
            }
        }
    }

    public void BarrageSlash() {
        class_1309 class_13092 = this.getSelf();
        if (class_13092 instanceof class_1657) {
            class_1657 P = (class_1657)class_13092;
            S2CPacketUtil.sendIntPowerDataPacket(P, (byte)50, 0);
        }
        this.setAttackTimeMax(ClientNetworking.getAppropriateConfig().generalStandSettings.finalStandPunchInStringCooldown);
        this.setAttackTime(0);
        this.setAttackTimeDuring(0);
        this.setActivePowerPhase(this.getActivePowerPhaseMax());
        this.setPowerNone();
        float knockbackStrength = 1.25f + (this.getSelf().method_5624() ? 0.1f : 0.0f);
        List<class_1297> entities = this.defaultSwordHitbox((class_1297)this.getSelf(), 1.5, 3.3);
        for (class_1297 e : entities) {
            class_1309 LE;
            float pow;
            if (e == null) continue;
            if (e.method_5739((class_1297)this.getSelf()) < 1.5f) {
                knockbackStrength += 0.15f;
                this.setAttackTime(0);
                this.setAttackTimeMax(this.getAttackTimeMax() + 5);
            }
            if (this.StandDamageEntityAttack(e, pow = this.getHeavyPunchStrength(e), 0.0f, (class_1297)this.self)) {
                this.getSelf().method_37908().method_8396(null, this.getSelf().method_24515(), class_3417.field_14999, class_3419.field_15248, 1.0f, 0.4f + (float)(Math.random() * 0.2));
                if (e instanceof class_1309) {
                    LE = (class_1309)e;
                    this.addEXP(2);
                }
                this.takeDeterminedKnockback(this.getSelf(), e, knockbackStrength);
                class_315 o = class_310.method_1551().field_1690;
                if (o.field_1894.method_1434()) continue;
                class_243 look = this.getSelf().method_5720();
                look = new class_243(look.field_1352, -0.1, look.field_1350).method_1029();
                MainUtil.takeUnresistableKnockbackWithY((class_1297)this.getSelf(), 0.15f, look.field_1352, look.field_1351, look.field_1350);
                continue;
            }
            if (!(e instanceof class_1309) || !(LE = (class_1309)e).method_6039()) continue;
            MainUtil.knockShieldPlusStand(e, 200);
        }
        if (!entities.isEmpty() && !this.isClient()) {
            class_1297 e = entities.get(0);
            class_243 pos = e.method_30950(0.0f).method_1031(0.0, (double)(e.method_5751() / 2.0f), 0.0);
            ((class_3218)this.getSelf().method_37908()).method_14199((class_2394)class_2398.field_11227, pos.field_1352, pos.field_1351, pos.field_1350, 0, 0.0, 0.0, 0.0, 0.0);
            class_1309 class_13093 = this.getSelf();
            if (class_13093 instanceof class_1657) {
                class_1657 P = (class_1657)class_13093;
                P.method_7277(e);
            }
        }
    }

    @Override
    public boolean setPowerNone() {
        return super.setPowerNone();
    }

    @Override
    public class_2561 getPosName(byte posID) {
        return switch (posID) {
            case 1 -> class_2561.method_43471((String)"idle.roundabout.anubis_2");
            default -> class_2561.method_43471((String)"idle.roundabout.anubis_1");
        };
    }

    @Override
    public List<Byte> getPosList() {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add((byte)0);
        $$1.add((byte)1);
        return $$1;
    }

    @Override
    public List<Byte> getSkinList() {
        return Arrays.asList((byte)1, (byte)2);
    }

    @Override
    public class_2561 getSkinName(byte skinId) {
        return switch (skinId) {
            case 2 -> class_2561.method_43471((String)"skins.roundabout.anubis.evil");
            default -> class_2561.method_43471((String)"skins.roundabout.anubis.anime");
        };
    }

    @Override
    protected Byte getSummonSound() {
        return (byte)18;
    }

    @Override
    public byte worthinessType() {
        return 2;
    }

    @Override
    public boolean isWip() {
        return true;
    }

    @Override
    public class_2561 ifWipListDevStatus() {
        return class_2561.method_43471((String)"roundabout.dev_status.active").method_27692(class_124.field_1075);
    }

    @Override
    public class_2561 ifWipListDev() {
        return class_2561.method_43470((String)"Prisma").method_27692(class_124.field_1054);
    }

    public List<class_1297> getBasicSwordHitBox(boolean crouching) {
        List<class_1297> entities = this.defaultSwordHitbox((class_1297)this.getSelf(), 1.2, 3.5);
        if (crouching) {
            entities = this.defaultSwordHitbox((class_1297)this.getSelf(), 1.7, 2.5);
        }
        return entities;
    }

    public List<class_1297> defaultSwordHitbox(class_1297 e, double width, double forwards) {
        class_243 pos = e.method_5836(0.0f).method_1019(e.method_5720().method_1021(forwards));
        double yrot = Math.toRadians(this.getSelf().method_5705(0.0f));
        class_243 forward = new class_243(Math.cos(yrot + 1.5707963267948966), 0.0, Math.sin(yrot + 1.5707963267948966));
        class_243 left = new class_243(forward.field_1350, 0.0, forward.field_1352);
        class_243 offset = class_243.field_1353;
        offset = offset.method_1019(left.method_1021(width));
        offset = offset.method_1019(forward.method_1021(forwards));
        List<class_1297> list = MainUtil.genHitbox(e.method_37908(), pos.field_1352, pos.field_1351, pos.field_1350, 1.0 + Math.abs(offset.field_1352), 2.0, 1.0 + Math.abs(offset.field_1350));
        list = this.doAttackChecks(this.doAttackChecks(list));
        double size = Math.max(width, forwards);
        list.removeIf(entity -> entity.method_30950(1.0f).method_1022(e.method_30950(1.0f)) > size);
        list.remove(e);
        return list;
    }

    public List<class_1297> doAttackChecks(List<class_1297> list) {
        list.remove(this.getSelf());
        list.removeIf(Entity -> !Entity.method_5732());
        list.removeIf(entity -> {
            class_1321 TA;
            return entity instanceof class_1321 && (TA = (class_1321)entity).method_35057().equals((Object)this.getSelf());
        });
        return list;
    }

    public void addMomentum(float x, float y, float z) {
        this.addMomentum(new class_243((double)x, (double)y, (double)z));
    }

    public void addMomentum(class_243 v) {
        this.getSelf().field_6007 = true;
        this.getSelf().field_6037 = true;
        this.getSelf().method_18799(this.getSelf().method_18798().method_1019(v));
    }

    @Override
    public class_3414 getSoundFromByte(byte soundChoice) {
        if (soundChoice == 1) {
            return ModSounds.STAND_BARRAGE_WINDUP_EVENT;
        }
        return super.getSoundFromByte(soundChoice);
    }

    @Override
    public void renderAttackHud(class_332 context, class_1657 playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
        StandUser standUser = (StandUser)playerEntity;
        boolean standOn = standUser.roundabout$getActive();
        int j = scaledHeight / 2 - 7 - 4;
        int k = scaledWidth / 2 - 8;
        boolean renderingSomething = false;
        float attackTimeDuring = this.getAttackTimeDuring();
        if (standOn && this.isClashing()) {
            renderingSomething = true;
            int ClashTime = 15 - Math.round(attackTimeDuring / 60.0f * 15.0f);
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 30, ClashTime, 6);
        } else if (standOn && this.isBarrageAttacking() && attackTimeDuring > -1.0f) {
            renderingSomething = true;
            int ClashTime = 15 - Math.round(attackTimeDuring / (float)this.getBarrageLength() * 15.0f);
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 30, ClashTime, 6);
        } else if (standOn && this.isBarrageCharging()) {
            renderingSomething = true;
            int windup = this.getActivePower() == 41 ? this.getKickBarrageWindup() : this.getBarrageWindup();
            int ClashTime = Math.round(Math.min(attackTimeDuring, (float)windup) / (float)windup * 15.0f);
            int height = 30;
            if (this.getActivePower() == 4 && this.getAttackTimeDuring() > this.getBarrageMinimum()) {
                height -= 6;
            }
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, height, ClashTime, 6);
        } else {
            float attackTime;
            float finalATime;
            int barTexture = 0;
            List<class_1297> TE = this.getBasicSwordHitBox(this.isHoldingSneak());
            float attackTimeMax = this.getAttackTimeMax();
            if (attackTimeMax > 0.0f && (finalATime = (attackTime = (float)this.getAttackTime()) / attackTimeMax) <= 1.0f) {
                barTexture = this.getActivePowerPhase() == standUser.roundabout$getActivePowerPhaseMax() ? 24 : (!TE.isEmpty() ? 12 : 18);
                renderingSomething = true;
                context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
                int finalATimeInt = Math.round(finalATime * 15.0f);
                context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, barTexture, finalATimeInt, 6);
            }
            if (standOn && !TE.isEmpty() && barTexture == 0) {
                renderingSomething = true;
                context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 0, 15, 6);
            }
        }
        if (this.canPogo && this.getAttackTimeDuring() == -1 && renderingSomething) {
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 60, 15, 6);
        }
    }

    public void recordMemory(byte slot) {
        Roundabout.LOGGER.info("RECORDING: " + slot);
    }

    public void playbackMemory(byte slot) {
        Roundabout.LOGGER.info("PLAYBACK: " + slot);
    }

    public static void generateMemories(PowersAnubis PA) {
        for (int i = 0; i < 8; ++i) {
            Object[] data = new Object[]{false};
            AnubisMoment[] moment = new AnubisMoment[]{new AnubisMoment(2, 0, data)};
            AnubisMemory AM = new AnubisMemory(ModItems.ANUBIS_ITEM, 1, moment);
            PA.memories.add(AM);
        }
    }
}

