/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.stand.powers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.AbilityIconInstance;
import net.hydra.jojomod.event.powers.DamageHandler;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.item.MaxStandDiscItem;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.elements.PowerContext;
import net.hydra.jojomod.stand.powers.presets.NewPunchingStand;
import net.hydra.jojomod.util.S2CPacketUtil;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1656;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1934;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_332;
import net.minecraft.class_3414;

public class PowersCream
extends NewPunchingStand {
    public static final byte CREAM_VOID_ATTACK = 103;
    public int transformDirection = 0;
    public int insideVoidInt = 0;
    public int transformTimer = 0;
    public boolean isTransforming = false;
    public boolean insideVoid = false;
    public Boolean previousMayFly;
    public Boolean previousFlying;
    public Boolean previousInvulnerable;
    public class_1934 gameMode;
    public class_1656 abilities;
    public static final byte POWER_CREAM_VOID_ATTACK = 21;
    public static final byte VOID_ATTACK_ENABLE = 52;
    public int creamAnimationIntForUnEat = 0;

    public PowersCream(class_1309 self) {
        super(self);
    }

    @Override
    public StandEntity getNewStandEntity() {
        return (StandEntity)ModEntities.CREAM.method_5883(this.getSelf().method_37908());
    }

    @Override
    public StandPowers generateStandPowers(class_1309 entity) {
        return new PowersCream(entity);
    }

    @Override
    public boolean isStandEnabled() {
        return ClientNetworking.getAppropriateConfig().creamSettings.enableCream;
    }

    @Override
    public boolean isWip() {
        return true;
    }

    @Override
    public class_2561 ifWipListDevStatus() {
        return class_2561.method_43471((String)"roundabout.dev_status.active").method_27692(class_124.field_1075);
    }

    @Override
    public class_2561 ifWipListDev() {
        return class_2561.method_43470((String)"Secret").method_27692(class_124.field_1054);
    }

    @Override
    public void playSummonSound() {
        if (this.self.method_18276()) {
            return;
        }
        this.playStandUserOnlySoundsIfNearby(this.getSummonSound(), 10.0, false, false);
    }

    @Override
    protected Byte getSummonSound() {
        return (byte)18;
    }

    @Override
    public class_3414 getSoundFromByte(byte soundChoice) {
        byte bt = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (soundChoice == 18) {
            return ModSounds.CREAM_SUMMON_EVENT;
        }
        if (soundChoice == 103) {
            return ModSounds.CREAM_VOID_ATTACK_EVENT;
        }
        return super.getSoundFromByte(soundChoice);
    }

    public void playVoidAttackEnterSound() {
        if (!this.self.method_37908().method_8608()) {
            byte skn = ((StandUser)this.getSelf()).roundabout$getStandSkin();
            this.playStandUserOnlySoundsIfNearby((byte)103, 27.0, false, true);
        }
    }

    @Override
    public int getMaxGuardPoints() {
        return ClientNetworking.getAppropriateConfig().creamSettings.creamGuardPoints;
    }

    @Override
    public float getMiningMultiplier() {
        return (float)(1.0 * ((double)ClientNetworking.getAppropriateConfig().creamSettings.miningSpeedMultiplierCream.intValue() * 0.01));
    }

    @Override
    public int getMiningLevel() {
        return ClientNetworking.getAppropriateConfig().creamSettings.getMiningTierCream;
    }

    public int getVoidTime() {
        return this.insideVoidInt;
    }

    public void setVoidTime(int vt) {
        class_1309 class_13092;
        this.insideVoidInt = vt;
        if (!this.self.method_37908().field_9236 && (class_13092 = this.self) instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            S2CPacketUtil.creamUpdateTimer(player, vt);
        }
    }

    public int getTransformTimer() {
        return this.transformTimer;
    }

    public void setTransformTimer(int vt) {
        class_1309 class_13092;
        this.transformTimer = vt;
        if (!this.self.method_37908().field_9236 && (class_13092 = this.self) instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            S2CPacketUtil.creamUpdateTransformTimer(player, vt);
        }
    }

    public int getTransformDirection() {
        return this.transformDirection;
    }

    public void setTransformDirection(int transformDirectionValue) {
        class_1309 class_13092;
        this.transformDirection = transformDirectionValue;
        if (!this.self.method_37908().field_9236 && (class_13092 = this.self) instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            S2CPacketUtil.creamUpdateTransformDirection(player, transformDirectionValue);
        }
    }

    @Override
    public void powerActivate(PowerContext context) {
        switch (context) {
            case SKILL_1_NORMAL: 
            case SKILL_1_CROUCH: {
                this.enableVoidAttackClient();
                break;
            }
            case SKILL_2_NORMAL: 
            case SKILL_2_CROUCH: {
                break;
            }
            case SKILL_3_NORMAL: 
            case SKILL_3_CROUCH: {
                break;
            }
        }
    }

    @Override
    public boolean setPowerOther(int move, int lastMove) {
        switch (move) {
            case 52: {
                this.enterVoidModeAttack();
            }
        }
        return super.setPowerOther(move, lastMove);
    }

    public void enableVoidAttackClient() {
        if (!this.onCooldown((byte)1)) {
            this.tryPower(52, true);
            this.tryPowerPacket((byte)52);
        }
    }

    public void enterVoidModeAttack() {
        if (!this.isTransforming && !this.insideVoid) {
            this.playVoidAttackEnterSound();
            this.setTransformDirection(1);
            this.setTransformTimer(0);
            this.isTransforming = true;
            class_1309 class_13092 = this.self;
            if (class_13092 instanceof class_1657) {
                class_1657 player = (class_1657)class_13092;
                if (!this.self.method_37908().field_9236) {
                    this.previousMayFly = ((class_1657)this.self).method_31549().field_7478;
                    this.previousFlying = ((class_1657)this.self).method_31549().field_7479;
                    this.previousInvulnerable = ((class_1657)this.self).method_31549().field_7480;
                    this.abilities = player.method_31549();
                    this.gameMode = ((class_3222)this.self).field_13974.method_14257();
                    if (((class_1657)this.self).method_7337()) {
                        ((class_1657)this.self).method_31549().field_7478 = true;
                        ((class_1657)this.self).method_31549().field_7480 = true;
                    } else if (this.self.method_7325()) {
                        ((class_1657)this.self).method_31549().field_7478 = true;
                        ((class_1657)this.self).method_31549().field_7480 = true;
                    } else {
                        ((class_1657)this.self).method_31549().field_7478 = true;
                        ((class_1657)this.self).method_31549().field_7480 = true;
                    }
                    Roundabout.LOGGER.info("Previous may fly:" + this.previousMayFly);
                    ((class_1657)this.self).method_7355();
                }
                this.animateStand((byte)100);
            }
        }
    }

    public void exitVoidModeAttack() {
        this.insideVoid = false;
        this.setTransformDirection(2);
        this.setTransformTimer(0);
        this.setVoidTime(0);
        this.isTransforming = true;
        if (!this.self.method_37908().field_9236) {
            class_1934 currentMode = ((class_3222)this.self).field_13974.method_14257();
            boolean gameModeSwitched = false;
            if (currentMode != this.gameMode) {
                this.gameMode = currentMode;
                gameModeSwitched = true;
            }
            switch (this.gameMode) {
                case field_9220: 
                case field_9219: {
                    ((class_1657)this.self).method_31549().field_7478 = true;
                    ((class_1657)this.self).method_31549().field_7479 = this.previousFlying;
                    ((class_1657)this.self).method_31549().field_7480 = true;
                    break;
                }
                default: {
                    if (!gameModeSwitched) {
                        ((class_1657)this.self).method_31549().field_7478 = this.previousMayFly;
                        ((class_1657)this.self).method_31549().field_7480 = this.previousInvulnerable;
                    }
                    ((class_1657)this.self).method_31549().field_7479 = false;
                }
            }
            ((class_1657)this.self).method_7355();
        }
        this.animateStand((byte)101);
    }

    public void creamIdleAnimationReset() {
        this.animateStand((byte)0);
    }

    public void creamBallAnimation() {
        this.animateStand((byte)102);
    }

    public void actualVoidAttackDestruction() {
        if (!this.self.method_37908().field_9236 && this.insideVoid) {
            int radius = 2;
            class_2338 playerPos = this.self.method_24515().method_10084();
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        class_2338 pos = playerPos.method_10069(x, y, z);
                        if (this.self.method_37908().method_22347(pos)) continue;
                        class_2680 state = this.self.method_37908().method_8320(pos);
                        float hardness = state.method_26214((class_1922)this.self.method_37908(), pos);
                        if (state.method_27852(class_2246.field_10382)) {
                            this.self.method_37908().method_8652(pos, class_2246.field_10124.method_9564(), 3);
                        }
                        if (!(hardness >= 0.0f) || !(hardness < 50.0f)) continue;
                        this.self.method_37908().method_8651(pos, true, (class_1297)this.self);
                    }
                }
            }
        }
    }

    public void radialDamage() {
        List<class_1297> entityList;
        if (!this.self.method_37908().method_8608() && !(entityList = DamageHandler.genHitbox(this.self, this.self.method_23317(), this.self.method_23318(), this.self.method_23321(), 2.5, 2.5, 2.5)).isEmpty()) {
            for (class_1297 entity : entityList) {
                if (entity == this.self || !entity.method_5863() || !entity.method_5805()) continue;
                class_1282 src = ModDamageTypes.of(this.self.method_37908(), ModDamageTypes.CREAM_VOID_BALL, (class_1297)this.self, (class_1297)this.self);
                entity.method_5643(src, this.getVoidDamage((class_1297)this.self));
            }
        }
    }

    public float getVoidDamage(class_1297 entity) {
        if (this.getReducedDamage(entity)) {
            return this.levelupDamageMod((float)((double)2.7f * ((double)ClientNetworking.getAppropriateConfig().creamSettings.creamAttackMultOnPlayers.intValue() * 0.01)));
        }
        return this.levelupDamageMod((float)(10.0 * ((double)ClientNetworking.getAppropriateConfig().creamSettings.creamAttackMultOnMobs.intValue() * 0.01)));
    }

    @Override
    public void onStandSummon(boolean desummon) {
        if (desummon && (this.insideVoidInt > 0 || this.transformTimer > 0)) {
            this.exitVoidModeAttack();
        }
    }

    @Override
    public void tickPower() {
        class_1309 class_13092;
        super.tickPower();
        if (!this.self.method_37908().field_9236 && this.transformDirection == 2 && this.transformTimer > -1 && this.creamAnimationIntForUnEat >= 20) {
            this.creamAnimationIntForUnEat = 0;
            this.creamIdleAnimationReset();
        }
        if (!this.self.method_37908().field_9236 && this.insideVoidInt > 0) {
            this.radialDamage();
        }
        if (!this.self.method_37908().field_9236 && this.insideVoidInt > 0 && (class_13092 = this.self) instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            if (!((class_1657)this.self).method_31549().field_7479) {
                ((class_1657)this.self).method_31549().field_7479 = true;
                ((class_1657)this.self).method_7355();
            }
        }
        if (this.isTransforming) {
            if (this.getTransformDirection() == 1) {
                if (this.getTransformTimer() < 100) {
                    this.setTransformTimer(this.getTransformTimer() + 1);
                } else {
                    this.setTransformTimer(0);
                    this.insideVoid = true;
                    this.isTransforming = false;
                }
            } else if (this.getTransformDirection() == 2) {
                if (this.getTransformTimer() < 20) {
                    ++this.creamAnimationIntForUnEat;
                    this.setTransformTimer(this.getTransformTimer() + 1);
                } else {
                    this.setTransformTimer(0);
                    this.setVoidTime(0);
                    this.insideVoid = false;
                    this.isTransforming = false;
                    this.setTransformDirection(0);
                }
            }
        }
        if (!this.self.method_37908().field_9236 && this.insideVoid) {
            this.actualVoidAttackDestruction();
            if (this.getVoidTime() < 400) {
                this.creamBallAnimation();
                this.setVoidTime(this.getVoidTime() + 1);
            } else if (this.getVoidTime() >= 400) {
                this.exitVoidModeAttack();
            }
        }
    }

    @Override
    public void renderIcons(class_332 context, int x, int y) {
        this.setSkillIcon(context, x, y, 1, StandIcons.CREAM_VOID_ATTACK, (byte)0);
    }

    @Override
    public List<Byte> getSkinList() {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add((byte)1);
        class_1309 class_13092 = this.getSelf();
        if (class_13092 instanceof class_1657) {
            boolean bypass;
            class_1657 PE = (class_1657)class_13092;
            byte Level = ((IPlayerEntity)PE).roundabout$getStandLevel();
            class_1799 goldDisc = ((StandUser)PE).roundabout$getStandDisc();
            boolean bl = bypass = PE.method_7337() || !goldDisc.method_7960() && goldDisc.method_7909() instanceof MaxStandDiscItem;
            if (Level > 1 || bypass) {
                // empty if block
            }
            if (Level > 2 || bypass) {
                // empty if block
            }
            if (Level > 3 || bypass) {
                // empty if block
            }
            if (Level > 4 || bypass) {
                // empty if block
            }
            if (Level > 5 || bypass) {
                // empty if block
            }
            if (Level > 6 || bypass) {
                // empty if block
            }
            if (((IPlayerEntity)PE).roundabout$getUnlockedBonusSkin() || bypass) {
                // empty if block
            }
        }
        return $$1;
    }

    @Override
    public List<AbilityIconInstance> drawGUIIcons(class_332 context, float delta, int mouseX, int mouseY, int leftPos, int topPos, byte level, boolean bypass) {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 80, 0, "ability.roundabout.void_attack", "instruction.roundabout.press_skill", StandIcons.CREAM_VOID_ATTACK, 1, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 99, 0, "ability.roundabout.heel_plant", "instruction.roundabout.press_skill", StandIcons.GROUND_IMPLANT, 2, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 118, 0, "ability.roundabout.dodge", "instruction.roundabout.press_skill", StandIcons.DODGE, 3, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 80, 0, "ability.roundabout.wall_walk_move", "instruction.roundabout.press_skill", StandIcons.WALL_WALK, 3, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 99, 0, "ability.roundabout.firm_swing", "instruction.roundabout.passive", StandIcons.FIRM_SWING, 0, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 118, 0, "ability.roundabout.fall_disperse", "instruction.roundabout.passive", StandIcons.FALL_ABSORB, 0, level, bypass));
        return $$1;
    }

    @Override
    public class_2561 getSkinName(byte skinId) {
        return PowersCream.getSkinNameT(skinId);
    }

    public static class_2561 getSkinNameT(byte skinId) {
        if (skinId == 1) {
            return class_2561.method_43471((String)"skins.roundabout.the_world.base");
        }
        return class_2561.method_43471((String)"skins.roundabout.the_world.base");
    }

    @Override
    public void levelUp() {
        class_1309 class_13092;
        if (!this.getSelf().method_37908().method_8608() && (class_13092 = this.getSelf()) instanceof class_1657) {
            class_1657 PE = (class_1657)class_13092;
            IPlayerEntity ipe = (IPlayerEntity)PE;
            byte level = ipe.roundabout$getStandLevel();
            if (level == 7) {
                ((class_3222)this.self).method_7353((class_2561)class_2561.method_43471((String)"leveling.roundabout.levelup.max.skins").method_27692(class_124.field_1075), true);
            } else if (level == 2 || level == 3 || level == 4 || level == 6 || level == 5) {
                ((class_3222)this.self).method_7353((class_2561)class_2561.method_43471((String)"leveling.roundabout.levelup.both").method_27692(class_124.field_1075), true);
            }
        }
        super.levelUp();
    }
}

