/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.stand.powers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.AbilityIconInstance;
import net.hydra.jojomod.event.powers.DamageHandler;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.elements.PowerContext;
import net.hydra.jojomod.stand.powers.presets.NewPunchingStand;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_315;
import net.minecraft.class_3218;
import net.minecraft.class_332;
import net.minecraft.class_3414;

public class PowersKillerQueen
extends NewPunchingStand {
    public float standReach = 5.0f;
    public boolean wentForCharge = false;

    @Override
    public void powerActivate(PowerContext context) {
        switch (context) {
            // Empty switch
        }
    }

    @Override
    public List<Byte> getSkinList() {
        return Arrays.asList((byte)0);
    }

    public PowersKillerQueen(class_1309 self) {
        super(self);
    }

    @Override
    public StandPowers generateStandPowers(class_1309 entity) {
        return new PowersKillerQueen(entity);
    }

    @Override
    public int getMaxGuardPoints() {
        return 15;
    }

    @Override
    public void handleStandAttack(class_1657 player, class_1297 target) {
        super.handleStandAttack(player, target);
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        return super.tryPower(move, forced);
    }

    @Override
    public StandEntity getNewStandEntity() {
        return (StandEntity)ModEntities.KILLER_QUEEN.method_5883(this.getSelf().method_37908());
    }

    @Override
    public void tickMobAI(class_1309 attackTarget) {
        if (attackTarget != null && attackTarget.method_5805()) {
            class_1297 targetEntity;
            if (this.getActivePower() == 1 || this.getActivePower() == 5 || attackTarget.method_5739((class_1297)this.getSelf()) <= 5.0f) {
                this.getSelf().method_36457(this.getLookAtEntityPitch((class_1297)this.getSelf(), (class_1297)attackTarget));
                float yrot = this.getLookAtEntityYaw((class_1297)this.getSelf(), (class_1297)attackTarget);
                this.getSelf().method_36456(yrot);
                this.getSelf().method_5847(yrot);
            }
            if ((targetEntity = this.getTargetEntity(this.self, -1.0f)) != null && targetEntity.method_5779((class_1297)attackTarget) && this.attackTimeDuring <= -1) {
                double RNG = Math.random();
                if (RNG < 0.35 && targetEntity instanceof class_1657 && this.activePowerPhase <= 0 && !this.wentForCharge) {
                    this.wentForCharge = true;
                    ((StandUser)this.getSelf()).roundabout$tryPower(4, true);
                } else {
                    Objects.requireNonNull(this);
                    if (this.activePowerPhase < 3 || this.attackTime >= this.attackTimeMax) {
                        this.wentForCharge = false;
                        ((StandUser)this.getSelf()).roundabout$tryPower(1, true);
                    }
                }
            }
        }
    }

    @Override
    public boolean setPowerAttack() {
        if (this.activePowerPhase >= 3) {
            this.activePowerPhase = 1;
        } else {
            this.activePowerPhase = (byte)(this.activePowerPhase + 1);
            this.attackTimeMax = this.activePowerPhase == 3 ? 37 : 27;
        }
        this.attackTimeDuring = 0;
        this.setActivePower((byte)1);
        this.setAttackTime(0);
        this.animateStand(this.activePowerPhase);
        this.poseStand((byte)1);
        return true;
    }

    @Override
    public void punchImpact(class_1297 entity) {
        this.setAttackTimeDuring(-10);
        if (entity != null) {
            float knockbackStrength;
            float pow;
            if (this.getActivePowerPhase() >= this.getActivePowerPhaseMax()) {
                pow = this.getHeavyPunchStrength(entity);
                knockbackStrength = 1.0f;
            } else {
                pow = this.getPunchStrength(entity);
                knockbackStrength = 0.2f;
            }
            if (this.StandDamageEntityAttack(entity, pow, 0.0f, (class_1297)this.self)) {
                this.takeDeterminedKnockback(this.self, entity, knockbackStrength);
            } else {
                Objects.requireNonNull(this);
                if (this.activePowerPhase >= 3) {
                    this.knockShield2(entity, 40);
                }
            }
        } else {
            float distMax = this.getDistanceOut(this.self, this.standReach, false);
            float halfReach = (float)((double)distMax * 0.5);
            class_243 pointVec = DamageHandler.getRayPoint(this.self, halfReach);
            if (!this.self.method_37908().field_9236) {
                ((class_3218)this.self.method_37908()).method_14199((class_2394)class_2398.field_11236, pointVec.field_1352, pointVec.field_1351, pointVec.field_1350, 1, 0.0, 0.0, 0.0, 1.0);
            }
        }
    }

    @Override
    public boolean setPowerBarrageCharge() {
        this.animateStand((byte)11);
        this.attackTimeDuring = 0;
        this.setActivePower((byte)4);
        this.poseStand((byte)1);
        this.clashDone = false;
        this.playBarrageChargeSound();
        return true;
    }

    @Override
    public void setPowerBarrage() {
        this.attackTimeDuring = 0;
        this.setActivePower((byte)5);
        this.poseStand((byte)1);
        this.setAttackTimeMax(this.getBarrageRecoilTime());
        this.setActivePowerPhase(this.getActivePowerPhaseMax());
        this.animateStand((byte)12);
        this.playBarrageCrySound();
    }

    @Override
    public void updateMovesFromPacket(byte activePower) {
        if (activePower == 5) {
            Objects.requireNonNull(this);
            this.setActivePowerPhase((byte)3);
        }
        super.updateMovesFromPacket(activePower);
    }

    @Override
    public byte chooseBarrageSound() {
        return 6;
    }

    @Override
    protected Byte getSummonSound() {
        return (byte)18;
    }

    @Override
    public class_3414 getSoundFromByte(byte soundChoice) {
        Roundabout.LOGGER.info("" + soundChoice);
        switch (soundChoice) {
            case 6: {
                return ModSounds.KILLER_QUEEN_BARRAGE_EVENT;
            }
            case 18: {
                return ModSounds.KILLER_QUEEN_SUMMON_EVENT;
            }
        }
        return super.getSoundFromByte(soundChoice);
    }

    @Override
    public boolean tryBlockPosPower(int move, boolean forced, class_2338 blockPos) {
        if (move == 21) {
            // empty if block
        }
        return true;
    }

    @Override
    public void buttonInput2(boolean KeyIsDown, class_315 options) {
    }

    @Override
    public void renderIcons(class_332 context, int x, int y) {
        if (this.isHoldingSneak()) {
            this.setSkillIcon(context, x, y, 1, StandIcons.LOCKED, (byte)0);
        } else {
            this.setSkillIcon(context, x, y, 1, StandIcons.LOCKED, (byte)-1);
        }
        this.setSkillIcon(context, x, y, 2, StandIcons.LOCKED, (byte)1);
        if (this.isHoldingSneak()) {
            this.setSkillIcon(context, x, y, 3, StandIcons.LOCKED, (byte)0);
        } else {
            this.setSkillIcon(context, x, y, 3, StandIcons.DODGE, (byte)0);
        }
        this.setSkillIcon(context, x, y, 4, StandIcons.LOCKED, (byte)3);
    }

    @Override
    public List<AbilityIconInstance> drawGUIIcons(class_332 context, float delta, int mouseX, int mouseY, int leftPos, int topPos, byte level, boolean bypas) {
        ArrayList $$1 = Lists.newArrayList();
        return $$1;
    }

    @Override
    public void renderAttackHud(class_332 context, class_1657 playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
        StandUser standUser = (StandUser)playerEntity;
        boolean standOn = standUser.roundabout$getActive();
        int j = scaledHeight / 2 - 7 - 4;
        int k = scaledWidth / 2 - 8;
        float attackTimeDuring = standUser.roundabout$getAttackTimeDuring();
        if (standOn && standUser.roundabout$isClashing()) {
            int ClashTime = 15 - Math.round(attackTimeDuring / 60.0f * 15.0f);
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 30, ClashTime, 6);
        } else if (standOn && standUser.roundabout$getStandPowers().isBarrageAttacking() && attackTimeDuring > -1.0f) {
            int ClashTime = 15 - Math.round(attackTimeDuring / (float)standUser.roundabout$getStandPowers().getBarrageLength() * 15.0f);
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 30, ClashTime, 6);
        } else if (standOn && standUser.roundabout$getStandPowers().isBarrageCharging()) {
            int ClashTime = Math.round(attackTimeDuring / (float)standUser.roundabout$getStandPowers().getBarrageWindup() * 15.0f);
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 30, ClashTime, 6);
        } else {
            float attackTime;
            float finalATime;
            int barTexture = 0;
            class_1297 TE = standUser.roundabout$getTargetEntity((class_1309)playerEntity, -1.0f);
            float attackTimeMax = standUser.roundabout$getAttackTimeMax();
            if (attackTimeMax > 0.0f && (finalATime = (attackTime = (float)standUser.roundabout$getAttackTime()) / attackTimeMax) <= 1.0f) {
                barTexture = standUser.roundabout$getActivePowerPhase() == standUser.roundabout$getActivePowerPhaseMax() ? 24 : (TE != null ? 12 : 18);
                context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
                int finalATimeInt = Math.round(finalATime * 15.0f);
                context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, barTexture, finalATimeInt, 6);
            }
            if (standOn && TE != null && barTexture == 0) {
                context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 0, 15, 6);
            }
        }
    }

    @Override
    public boolean isWip() {
        return true;
    }

    @Override
    public class_2561 ifWipListDevStatus() {
        return class_2561.method_43471((String)"roundabout.dev_status.paused").method_27692(class_124.field_1075);
    }

    @Override
    public class_2561 ifWipListDev() {
        return class_2561.method_43470((String)"Ashley").method_27692(class_124.field_1054);
    }

    @Override
    public class_2561 getSkinName(byte skinId) {
        switch (skinId) {
            case 0: {
                return class_2561.method_43471((String)"skins.roundabout.killer_queen.base");
            }
        }
        return class_2561.method_43471((String)"skins.roundabout.killer_queen.base");
    }
}

